/*
 * Decompiled with CFR 0.152.
 */
package progress.message.net.https.client;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import progress.message.net.ISocket;
import progress.message.net.ProgressSocket;
import progress.message.net.ProgressSocketFactory;
import progress.message.net.http.client.tunnel.IHttpProxyConfig;
import progress.message.net.https.Handler;
import progress.message.net.ssl.ProgressSslSocketFactory;
import progress.message.security.cert.X509Certificate;
import progress.message.zclient.SessionConfig;

public final class HTTPSURLConnection
extends URLConnection {
    private static boolean HTTPS_DEBUG = false;
    private static boolean HTTPS_DEBUG_SSL = false;
    private static int __NEWLINE = 10;
    private static int __RETURN = 13;
    private static byte[] __EOL = "\r\n".getBytes();
    private Vector headerFieldIndex = null;
    private Hashtable headerFieldHash = null;
    private Hashtable requestProperties = null;
    private static Vector socketholders = new Vector();
    private SocketHolder m_holder = null;
    private int responseCode = 0;
    private String responseMessage = "";
    private ByteArrayOutputStream cacheOS = null;
    protected InputStream m_in = null;
    protected OutputStream m_out = null;
    private String requestMethod = "POST";
    private static boolean master_properties_initialized = false;
    private static Properties master_connect_properties = System.getProperties();
    private Properties connect_properties = System.getProperties();
    private boolean bUsingProxy = false;
    private static URLStreamHandler s_handler = new Handler();
    private IHttpProxyConfig m_httpProxyConfig;
    private X509Certificate m_peerCertificate = null;
    private X509Certificate[] m_peerCertificateChain = null;
    static String[] m_checks = new String[]{"SSL_CIPHER_SUITES", "SSL_CERTIFICATE_CHAIN", "SSL_PRIVATE_KEY", "SSL_CA_CERTIFICATES_DIR"};

    private void setUsingProxy() {
        String value = null;
        if (this.connect_properties.get("TUNNELING_PROXY_HOST") == null) {
            value = (String)this.connect_properties.get("http.proxyHost");
            if (value != null) {
                this.connect_properties.put("TUNNELING_PROXY_HOST", value);
                value = (String)this.connect_properties.get("http.proxyPort");
                if (value != null) {
                    this.connect_properties.put("TUNNELING_PROXY_PORT", value);
                }
                this.bUsingProxy = true;
            }
            if ((value = (String)this.connect_properties.get("https.proxyHost")) != null) {
                this.connect_properties.put("TUNNELING_PROXY_HOST", value);
                value = (String)this.connect_properties.get("https.proxyPort");
                if (value != null) {
                    this.connect_properties.put("TUNNELING_PROXY_PORT", value);
                }
                this.bUsingProxy = true;
            }
        } else {
            this.bUsingProxy = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void loadMasterProperties() {
        Properties properties = master_connect_properties;
        synchronized (properties) {
            if (master_properties_initialized) {
                return;
            }
            if (SessionConfig.IN_BROKER) {
                try {
                    Class<?> c = Class.forName("progress.message.broker.Config");
                    Class[] argTypes = new Class[]{Hashtable.class};
                    Method method = c.getMethod("getConnectionProperties", argTypes);
                    Object[] argvalues = new Object[]{master_connect_properties};
                    method.invoke(null, argvalues);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                master_properties_initialized = true;
            }
        }
    }

    void setConnectionProperties() {
        HTTPSURLConnection.loadMasterProperties();
        this.connect_properties = (Properties)master_connect_properties.clone();
        this.setUsingProxy();
    }

    public HTTPSURLConnection(URL url) throws IOException {
        super(url);
        if (HTTPS_DEBUG) {
            System.out.println("Creating a new HTTPSURLConnection: url = " + url);
        }
        this.setConnectionProperties();
        this.headerFieldIndex = new Vector();
        this.headerFieldHash = new Hashtable();
        this.requestProperties = new Hashtable();
        String host = url.getHost();
        if (url.getPort() > 0) {
            host = url.getHost() + ":" + url.getPort();
        }
        this.requestProperties.put("Host", host);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void connect() throws IOException {
        ISocket socket = null;
        if (this.m_out == null || this.m_in == null) {
            Vector vector = socketholders;
            synchronized (vector) {
                Enumeration enumeration = socketholders.elements();
                while (enumeration.hasMoreElements()) {
                    SocketHolder holder = (SocketHolder)enumeration.nextElement();
                    if (HTTPS_DEBUG) {
                        System.out.println("HTTPS_DEBUG: HTTPSURLConnection.connect(): checking for existing " + this.url + " socket: available = " + holder.getSocketAvailable() + " holder.URI = " + holder.getURL());
                    }
                    if (!holder.getSocketAvailable() || !holder.match(this)) continue;
                    socket = holder.getSSLSocket();
                    try {
                        socket.getOutputStream().flush();
                        holder.setSocketAvailable(false);
                        if (HTTPS_DEBUG || HTTPS_DEBUG_SSL) {
                            System.out.println("HTTPS_DEBUG: HTTPSURLConnection.connect(): Reusing existing SSLSocket:" + holder.getURL().toExternalForm());
                        }
                        this.m_holder = holder;
                        break;
                    }
                    catch (Exception e) {
                        if (HTTPS_DEBUG || HTTPS_DEBUG_SSL) {
                            System.out.println("HTTPS_DEBUG: HTTPSURLConnection.connect(); Cannot reuse this " + holder.getURL() + " SSLSocket " + e.getMessage());
                        }
                        socket = null;
                        this.m_holder = null;
                    }
                    finally {
                        socketholders.removeElement(holder);
                    }
                }
            }
            if (socket == null) {
                if (HTTPS_DEBUG || HTTPS_DEBUG_SSL) {
                    System.out.println("HTTPS_DEBUG: HTTPSURLConnection.connect(): Creating SSLSocket for " + this.url);
                }
                socket = this.getNewSocket(this.url);
                SocketHolder holder_new = new SocketHolder(socket, this.url, this.connect_properties);
                holder_new.setSocketAvailable(false);
                this.m_holder = holder_new;
            }
            this.m_in = socket.getInputStream();
            this.m_out = new BufferedOutputStream(socket.getOutputStream(), 1024);
            this.connected = true;
        }
    }

    private ISocket getNewSocket(URL url) throws IOException {
        ProgressSslSocketFactory sslFactory = (ProgressSslSocketFactory)ProgressSocketFactory.getFactory(1);
        ProgressSocket socket = sslFactory.createProgressSocket(null, url.getHost(), url.getPort(), this.connect_properties, this.m_httpProxyConfig);
        if (socket != null) {
            if (this.m_peerCertificate == null) {
                this.m_peerCertificate = socket.getPeerCertificate();
            }
            if (this.m_peerCertificateChain == null) {
                this.m_peerCertificateChain = socket.getPeerCertificateChain();
            }
        }
        return socket;
    }

    public X509Certificate getPeerCertificate() {
        return this.m_peerCertificate;
    }

    public X509Certificate[] getPeerCertificateChain() {
        return this.m_peerCertificateChain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        if (!this.connected) {
            return;
        }
        try {
            if (this.m_out != null) {
                this.m_out.close();
            }
            if (this.m_in != null) {
                this.m_in.close();
            }
        }
        catch (IOException anyIOException) {
            // empty catch block
        }
        try {
            if (this.m_holder != null) {
                if (HTTPS_DEBUG_SSL) {
                    System.out.println("HTTPS_DEBUG: closing socket for " + this.m_holder.getURL());
                }
                this.m_holder.getSSLSocket().close();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.m_out = null;
            this.m_in = null;
            this.connected = false;
            this.m_holder = null;
            this.headerFieldIndex.clear();
            this.headerFieldHash.clear();
            this.m_peerCertificate = null;
            this.m_peerCertificateChain = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markSSLSocketAvailable() {
        if (this.m_holder != null) {
            this.m_holder.setSocketAvailable(true);
            Vector vector = socketholders;
            synchronized (vector) {
                socketholders.addElement(this.m_holder);
            }
        }
        this.m_holder = null;
    }

    public boolean usingProxy() {
        return this.bUsingProxy;
    }

    @Override
    public final InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
            this.sendURL();
            this.sendRequestHeaders();
            this.sendAnyData();
            this.readResponseCode();
            this.readResponseHeaders();
            this.handleReDirect();
            this.handleContinue();
        }
        if (this.doInput) {
            return this.m_in;
        }
        return null;
    }

    private void handleContinue() throws IOException {
        if (this.responseCode != 100) {
            return;
        }
        byte[] data = new byte[]{0};
        this.m_out.write(data);
        this.m_out.flush();
        this.readResponseCode();
        this.readResponseHeaders();
    }

    private void handleReDirect() {
        if (this.responseCode < 300 && this.responseCode >= 400) {
            return;
        }
        String location = this.getHeaderField("location");
        if (location == null) {
            return;
        }
        try {
            this.url = location.regionMatches(true, 0, "https", 0, 5) ? new URL(null, location, s_handler) : new URL(location);
        }
        catch (Exception urlException) {
            urlException.printStackTrace();
        }
        try {
            this.m_in.close();
            this.m_out.close();
        }
        catch (IOException ioE) {
            // empty catch block
        }
        this.connected = false;
        this.m_in = null;
        this.m_out = null;
        this.headerFieldIndex.clear();
        this.headerFieldHash.clear();
        try {
            this.getInputStream();
        }
        catch (Exception any) {
            any.printStackTrace();
        }
    }

    @Override
    public final OutputStream getOutputStream() throws IOException {
        if (this.connected) {
            return this.m_out;
        }
        if (this.doOutput) {
            if (!this.getRequestMethod().equals("POST")) {
                this.setRequestMethod("POST");
            }
        } else {
            throw new ProtocolException("Cannot write to a URLConnection if doOutput == false");
        }
        if (this.cacheOS == null) {
            this.cacheOS = new ByteArrayOutputStream(512);
        }
        return this.cacheOS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendURL() throws IOException {
        String uri = this.url.getFile();
        if (uri == null) {
            uri = "/";
        }
        String theURL = this.getRequestMethod() + " " + uri + " HTTP/1.0";
        try {
            this.m_out.write(theURL.getBytes());
            this.m_out.write(__EOL);
        }
        catch (IOException e) {
            if (HTTPS_DEBUG_SSL) {
                System.out.println("HTTPS_DEBUG: Failed to send the http command - " + theURL);
            }
            HTTPSURLConnection hTTPSURLConnection = this;
            synchronized (hTTPSURLConnection) {
                ISocket socket = this.getNewSocket(this.url);
                try {
                    this.m_holder.getSSLSocket().close();
                }
                catch (Exception anye) {
                    // empty catch block
                }
                this.m_holder.setSSLSocket(socket);
                this.m_in = socket.getInputStream();
                this.m_out = new BufferedOutputStream(socket.getOutputStream(), 1024);
                this.m_out.write(theURL.getBytes());
                this.m_out.write(__EOL);
            }
        }
    }

    private void sendRequestHeaders() throws IOException {
        Enumeration keys = this.requestProperties.keys();
        String key = null;
        String outputString = null;
        while (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            outputString = key + ": " + this.requestProperties.get(key);
            this.m_out.write(outputString.getBytes());
            this.m_out.write(__EOL);
        }
        this.m_out.write(__EOL);
    }

    private void sendAnyData() throws IOException {
        if (!this.doOutput || this.cacheOS == null) {
            return;
        }
        this.cacheOS.writeTo(this.m_out);
        this.m_out.flush();
        this.cacheOS.reset();
    }

    private void readResponseCode() throws IOException {
        String responseLine = this.readLine();
        if (HTTPS_DEBUG) {
            System.out.println("HTTPS_DEBUG: in readResponseCode - responseLine = " + responseLine);
        }
        int responseCodeIndex = responseLine.indexOf(" ");
        String responseCodeStr = responseLine.substring(responseCodeIndex + 1, responseCodeIndex + 4);
        try {
            this.responseCode = Integer.parseInt(responseCodeStr);
        }
        catch (NumberFormatException nfe) {
            throw new IOException("Could not read response code: " + nfe.getMessage());
        }
        if (responseLine.length() > responseCodeIndex + 5) {
            this.responseMessage = responseLine.substring(responseCodeIndex + 5).trim();
        }
        if (HTTPS_DEBUG) {
            System.out.println("HTTPS_DEBUG: in readResponseCode - responseCode = " + this.responseCode + " responseMessage = " + this.responseMessage);
        }
    }

    private void readResponseHeaders() throws IOException {
        String line;
        while ((line = this.readLine()) != null) {
            if (HTTPS_DEBUG) {
                System.out.println("HTTPS_DEBUG: in readResponseHeaders - line = " + line);
            }
            int colPos = line.indexOf(":");
            String key = line.substring(0, colPos).toLowerCase();
            String value = line.substring(colPos + 1).trim();
            this.headerFieldIndex.addElement(key);
            this.headerFieldHash.put(key, value.toLowerCase());
        }
    }

    private String readLine() throws IOException {
        int ch;
        StringBuffer line = new StringBuffer();
        while ((ch = this.m_in.read()) != __NEWLINE) {
            if (ch == -1) {
                if (HTTPS_DEBUG || HTTPS_DEBUG_SSL) {
                    System.out.println("HTTPS_DEBUG: Failed to read the response - connection reset by the peer.");
                }
                throw new IOException("Failed to read the response - connection reset by the peer, bytes read = " + line.toString());
            }
            if (ch == __RETURN) continue;
            line.append((char)ch);
        }
        if (line.length() <= 0) {
            return null;
        }
        return line.toString();
    }

    public final void setRequestMethod(String method) throws ProtocolException {
        if (!method.equalsIgnoreCase("POST") && !method.equalsIgnoreCase("GET")) {
            throw new ProtocolException("Invalid HTTP method: " + method);
        }
        this.requestMethod = method;
    }

    @Override
    public final String getHeaderField(String key) {
        if (!this.connected) {
            try {
                this.getInputStream();
            }
            catch (IOException ioE) {
                ioE.printStackTrace();
            }
        }
        return (String)this.headerFieldHash.get(key.toLowerCase());
    }

    @Override
    public final String getHeaderField(int index) {
        String field = null;
        String key = this.getHeaderFieldKey(index);
        if (key != null) {
            field = this.getHeaderField(key);
        }
        return field;
    }

    @Override
    public final String getHeaderFieldKey(int index) {
        String key = null;
        if (index < this.headerFieldIndex.size()) {
            key = (String)this.headerFieldIndex.elementAt(index);
        }
        return key;
    }

    public final long getHeaderFieldDate(int index, long defaultValue) {
        String theDate = this.getHeaderField(index);
        try {
            if (theDate != null) {
                SimpleDateFormat dateParser = new SimpleDateFormat("EEE, d MMM yyyy hh:mm:ss z");
                Date date = dateParser.parse(theDate);
                return date.getTime();
            }
        }
        catch (ParseException pe) {
            // empty catch block
        }
        return defaultValue;
    }

    @Override
    public final long getHeaderFieldDate(String key, long defaultValue) {
        String theDate = this.getHeaderField(key.toLowerCase());
        try {
            if (theDate != null) {
                SimpleDateFormat dateParser = new SimpleDateFormat("EEE, d MMM yyyy hh:mm:ss z");
                Date date = dateParser.parse(theDate);
                return date.getTime();
            }
        }
        catch (ParseException pe) {
            // empty catch block
        }
        return defaultValue;
    }

    public final int getHeaderFieldInt(int index, int defaultValue) {
        int value = defaultValue;
        String field = this.getHeaderField(index);
        if (field != null) {
            try {
                value = Integer.parseInt(field);
            }
            catch (NumberFormatException nfe) {
                value = defaultValue;
            }
        }
        return value;
    }

    @Override
    public final int getHeaderFieldInt(String key, int defaultValue) {
        int value = defaultValue;
        String field = this.getHeaderField(key.toLowerCase());
        if (field != null) {
            try {
                value = Integer.parseInt(field);
            }
            catch (NumberFormatException nfe) {
                value = defaultValue;
            }
        }
        return value;
    }

    @Override
    public final String getContentEncoding() {
        return this.getHeaderField("Content-Encoding");
    }

    @Override
    public final int getContentLength() {
        int contentLength = this.getHeaderFieldInt("Content-Length", -1);
        if (HTTPS_DEBUG) {
            System.out.println("HTTPS_DEBUG: getContentLength returning " + contentLength);
        }
        return contentLength;
    }

    @Override
    public final String getContentType() {
        return this.getHeaderField("Content-Type");
    }

    @Override
    public final long getDate() {
        String theDate = this.getHeaderField("Date");
        try {
            if (theDate != null) {
                SimpleDateFormat dateParser = new SimpleDateFormat("EEE, d MMM yyyy hh:mm:ss z");
                Date date = dateParser.parse(theDate);
                return date.getTime();
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return 0L;
    }

    @Override
    public final long getLastModified() {
        String theDate = this.getHeaderField("Last-Modified");
        try {
            if (theDate != null) {
                SimpleDateFormat dateParser = new SimpleDateFormat("EEE, d MMM yyyy hh:mm:ss z");
                Date date = dateParser.parse(theDate);
                return date.getTime();
            }
        }
        catch (ParseException pe) {
            if (HTTPS_DEBUG) {
                System.out.println("Failed parsing date ((" + theDate + ")).");
            }
            pe.printStackTrace();
        }
        return 0L;
    }

    public final String getRequestMethod() {
        return this.requestMethod;
    }

    public final int getHTTPResponseCode() {
        return this.responseCode;
    }

    public final String getHTTPResponseMessage() {
        return this.responseMessage;
    }

    @Override
    public final void setRequestProperty(String key, String value) {
        if (!this.filterRequestProperty(key, value)) {
            this.requestProperties.put(key, value);
        }
    }

    private boolean filterRequestProperty(String key, String prop) {
        if (!key.toUpperCase().startsWith("X-HTTPS-")) {
            return false;
        }
        if (key.equalsIgnoreCase("X-HTTPS-CipherSuites") || key.equalsIgnoreCase("X-HTTPS-WS-BindingCipherSuite")) {
            this.connect_properties.setProperty("SSL_CIPHER_SUITES", prop);
        } else if (key.equalsIgnoreCase("X-HTTPS-ClientAuthCertificate")) {
            this.connect_properties.setProperty("SSL_CERTIFICATE_CHAIN", prop);
        } else if (key.equalsIgnoreCase("X-HTTPS-ClientAuthCertificateForm")) {
            this.connect_properties.setProperty("SSL_CERTIFICATE_CHAIN_FORM", prop);
        } else if (key.equalsIgnoreCase("X-HTTPS-PrivateKey")) {
            this.connect_properties.setProperty("SSL_PRIVATE_KEY", prop);
        } else if (key.equalsIgnoreCase("X-HTTPS-PrivateKeyPassword")) {
            this.connect_properties.setProperty("SSL_PRIVATE_KEY_PASSWORD", prop);
        } else if (key.equalsIgnoreCase("X-HTTPS-PrivateKeyForm")) {
            this.connect_properties.setProperty("SSL_PRIVATE_KEY_FORM", prop);
        } else if (key.equalsIgnoreCase("X-HTTPS-CACertificatePath")) {
            this.connect_properties.setProperty("SSL_CA_CERTIFICATES_DIR", prop);
        } else if (key.equalsIgnoreCase("X-HTTPS-ClientKeyStoreURL")) {
            this.connect_properties.setProperty("JSSE_KEYSTORE_LOCATION", prop);
        } else if (key.equalsIgnoreCase("X-HTTPS-ClientKeyStoreType")) {
            this.connect_properties.setProperty("JSSE_KEYSTORE_TYPE", prop);
        } else if (key.equalsIgnoreCase("X-HTTPS-ClientKeyStorePassword")) {
            this.connect_properties.setProperty("JSSE_KEYSTORE_PASSWORD", prop);
        } else if (key.equalsIgnoreCase("X-HTTPS-ClientKeyAlias")) {
            this.connect_properties.setProperty("JSSE_KEYSTORE_ALIAS", prop);
        } else if (key.equalsIgnoreCase("X-HTTPS-ClientKeyPassword")) {
            this.connect_properties.setProperty("JSSE_KEYSTORE_KEY_PASSWORD", prop);
        } else if (key.equalsIgnoreCase("X-HTTPS-ClientTrustStoreURL")) {
            this.connect_properties.setProperty("JSSE_TRUSTSTORE_LOCATION", prop);
        } else if (key.equalsIgnoreCase("X-HTTPS-ClientTrustStoreType")) {
            this.connect_properties.setProperty("JSSE_TRUSTSTORE_TYPE", prop);
        } else if (key.equalsIgnoreCase("X-HTTPS-ClientTrustStorePassword")) {
            this.connect_properties.setProperty("JSSE_TRUSTSTORE_PASSWORD", prop);
        }
        return true;
    }

    @Override
    public final String getRequestProperty(String key) {
        return (String)this.requestProperties.get(key);
    }

    public void setProxyConfig(IHttpProxyConfig pConfig) {
        if (pConfig == null || pConfig.getHost() == null || pConfig.getHost().trim().length() == 0 || this.connect_properties == null) {
            return;
        }
        this.connect_properties.put("TUNNELING_PROXY_HOST", pConfig.getHost());
        this.connect_properties.put("TUNNELING_PROXY_PORT", Integer.toString(pConfig.getPort()));
        this.m_httpProxyConfig = pConfig;
        this.bUsingProxy = true;
    }

    private class SocketHolder {
        private URL m_url = null;
        private ISocket m_socket = null;
        private boolean m_available = false;
        private Properties m_properties = null;

        SocketHolder(ISocket socket, URL url, Properties properties) {
            this.m_url = url;
            this.m_socket = socket;
            this.m_properties = properties;
        }

        URL getURL() {
            return this.m_url;
        }

        ISocket getSSLSocket() {
            return this.m_socket;
        }

        void setSSLSocket(ISocket socket) {
            this.m_socket = socket;
        }

        synchronized void setSocketAvailable(boolean value) {
            this.m_available = value;
        }

        synchronized boolean getSocketAvailable() {
            return this.m_available;
        }

        boolean match(HTTPSURLConnection uc) {
            return this.m_url.equals(uc.url) && this.compatableProperties(this.m_properties, uc.connect_properties);
        }

        private boolean compatableProperties(Properties current, Properties candidate) {
            if (current == candidate) {
                return true;
            }
            for (int i = 0; i < m_checks.length; ++i) {
                String name = m_checks[i];
                String p1 = current.getProperty(name);
                String p2 = candidate.getProperty(name);
                if (p1 == null && p2 == null) continue;
                if (p1 == null || p2 == null) {
                    return false;
                }
                if (p1.equals(p2)) continue;
                return false;
            }
            return true;
        }
    }
}

