/*
 * Decompiled with CFR 0.152.
 */
package progress.message.net.https.client.tunnel;

import com.sonicsw.security.ssl.DefaultBasicAuthenticator;
import com.sonicsw.security.ssl.DefaultHostnameVerifier;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import progress.message.net.http.client.tunnel.HttpClientSocket;
import progress.message.net.http.client.tunnel.IHttpProxyConfig;
import progress.message.net.https.Handler;
import progress.message.net.https.IHttpsSocket;
import progress.message.net.https.client.HTTPSURLConnection;
import progress.message.security.cert.X509Certificate;
import progress.message.zclient.SessionConfig;

public final class HttpsClientSocket
extends HttpClientSocket
implements IHttpsSocket {
    public static final String HTTPS_PARAM_PROXY_AUTHENTICATION = "sonic.https.proxyAuthentication";
    public static final String HTTPS_PARAM_PROXY_USERNAME = "sonic.https.proxyUsername";
    public static final String HTTPS_PARAM_PROXY_PASSWORD = "sonic.https.proxyPassword";
    public static final String HTTPS_PARAM_PROXY_AUTHENTICATOR = "sonic.http.authenticator";
    public static final String HTTPS_PARAM_USE_ANY_HOSTNAME_VERIFIER = "sonic.https.useAnyHostnameVerifier";
    public static final String HTTPS_PARAM_HOSTNAME_VERIFIER = "sonic.https.hostnameVerifier";
    private static URLStreamHandler s_handler = new Handler();
    private static HostnameVerifier s_anyHostnameVerifier = new DefaultHostnameVerifier();
    private static String s_anyHostnameVerifierName = s_anyHostnameVerifier.getClass().getName();
    private static boolean s_usePlugin = false;
    private boolean m_useSonicHandler = true;
    private X509Certificate m_peerCertificate = null;
    private X509Certificate[] m_peerCertificateChain = null;

    @Override
    protected void init() {
        this.m_useSonicHandler = true;
        if (s_usePlugin) {
            this.m_useSonicHandler = false;
            return;
        }
        if (SessionConfig.HTTPS_TUNNELING_PROXY_AUTHENTICATION) {
            this.m_useSonicHandler = false;
            this.initProxyAuthentication();
        }
    }

    @Override
    public X509Certificate getPeerCertificate() {
        return this.m_peerCertificate;
    }

    @Override
    public X509Certificate[] getPeerCertificateChain() {
        return this.m_peerCertificateChain;
    }

    public HttpsClientSocket(String host, int port, Object props, IHttpProxyConfig pConfig) throws UnknownHostException, IOException {
        super(host, port, props, pConfig);
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    protected String getProtocol() {
        return "https";
    }

    @Override
    protected URL newURL(String protocol, String host, int port, String file) throws MalformedURLException {
        if (!this.m_useSonicHandler) {
            return new URL(protocol, host, port, file);
        }
        return new URL(protocol, host, port, file, s_handler);
    }

    @Override
    protected URL newURL(URL url, String spec) throws MalformedURLException {
        if (!this.m_useSonicHandler) {
            return new URL(url, spec);
        }
        return new URL(url, spec, s_handler);
    }

    @Override
    protected URLConnection doHTTPConnection(URL url, Hashtable headers) throws IOException {
        if (!this.m_useSonicHandler && !s_usePlugin) {
            headers.remove("Content-Length");
        }
        URLConnection urlConnection = super.doHTTPConnection(url, headers);
        if (this.m_httpProxyConfig != null && urlConnection instanceof HTTPSURLConnection) {
            ((HTTPSURLConnection)urlConnection).setProxyConfig(this.m_httpProxyConfig);
        }
        return urlConnection;
    }

    @Override
    protected void markConnectionAvailable(URLConnection connection) {
        if (connection instanceof HTTPSURLConnection) {
            ((HTTPSURLConnection)connection).markSSLSocketAvailable();
        }
    }

    @Override
    protected void doneInput(InputStream in) throws IOException {
        if (!this.m_useSonicHandler && in != null) {
            while (in.available() > 0) {
                in.skip(in.available());
            }
            in.close();
            return;
        }
    }

    @Override
    protected void doneOutput(OutputStream out) throws IOException {
        if (!this.m_useSonicHandler && out != null) {
            out.close();
        }
    }

    @Override
    protected void clearUnneededDataFromStream(InputStream connIS, int len) throws IOException {
        if (connIS == null) {
            return;
        }
        if (!this.m_useSonicHandler) {
            while (connIS.available() > 0) {
                connIS.skip(connIS.available());
            }
            connIS.close();
            return;
        }
        if (len >= 0) {
            if (connIS.available() > len) {
                len = connIS.available();
            }
            byte[] blackhole = new byte[len];
            while (len > 0) {
                len -= connIS.read(blackhole, 0, len);
            }
            return;
        }
        if (len < 0 && connIS.available() > 0) {
            byte[] buf = new byte[Math.min(connIS.available(), 1024)];
            while (connIS.read(buf) != -1) {
            }
            return;
        }
    }

    @Override
    protected Hashtable getCloseHeader() {
        Hashtable headers = super.getCloseHeader();
        if (!this.m_useSonicHandler) {
            headers.remove("Connection");
        }
        return headers;
    }

    @Override
    protected int getContentLength(URLConnection connection) throws IOException {
        int contentLength;
        if (!connection.getURL().getPath().equals("/SC/ReqData")) {
            contentLength = connection.getContentLength();
        } else {
            byte[] cid = new byte[4];
            connection.getInputStream().read(cid);
            contentLength = cid[0] << 24 | (cid[1] & 0xFF) << 16 | (cid[2] & 0xFF) << 8 | cid[3] & 0xFF;
            if (contentLength == -1) {
                throw new EOFException("Connection closed by the broker.");
            }
        }
        return contentLength;
    }

    @Override
    protected int getResponseCode(URLConnection connection) throws IOException {
        StringTokenizer tokenizer;
        String token;
        if (connection instanceof HTTPSURLConnection) {
            int ret = ((HTTPSURLConnection)connection).getHTTPResponseCode();
            if (this.m_peerCertificate == null) {
                this.m_peerCertificate = ((HTTPSURLConnection)connection).getPeerCertificate();
            }
            if (this.m_peerCertificateChain == null) {
                this.m_peerCertificateChain = ((HTTPSURLConnection)connection).getPeerCertificateChain();
            }
            return ret;
        }
        String header = connection.getHeaderField(0);
        if (header != null && (token = (tokenizer = new StringTokenizer(header = header.toLowerCase())).nextToken()) != null && token.startsWith("http")) {
            String status = tokenizer.nextToken();
            return Integer.parseInt(status);
        }
        return 200;
    }

    @Override
    protected int getConnectionId(URLConnection connection) throws IOException {
        byte[] cid = new byte[4];
        connection.getInputStream().read(cid);
        return cid[0] << 24 | (cid[1] & 0xFF) << 16 | (cid[2] & 0xFF) << 8 | cid[3] & 0xFF;
    }

    @Override
    protected void disconnect(URLConnection connection) {
        if (connection instanceof HTTPSURLConnection) {
            ((HTTPSURLConnection)connection).disconnect();
        }
        this.m_peerCertificate = null;
        this.m_peerCertificateChain = null;
    }

    private void initProxyAuthentication() {
        String proxyHost;
        String hostnameVerifierName = SessionConfig.HTTPS_TUNNELING_HOSTNAME_VERIFIER;
        HostnameVerifier defaultHostnameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
        if (hostnameVerifierName != null && hostnameVerifierName.trim().length() != 0) {
            hostnameVerifierName = hostnameVerifierName.trim();
            if (defaultHostnameVerifier == null || !defaultHostnameVerifier.getClass().getName().equals(hostnameVerifierName)) {
                try {
                    HostnameVerifier hostNameVerifier = (HostnameVerifier)Class.forName(hostnameVerifierName).newInstance();
                    HttpsURLConnection.setDefaultHostnameVerifier(hostNameVerifier);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex.getMessage());
                }
            }
        } else if (SessionConfig.HTTPS_TUNNELING_USE_ANY_HOSTNAME_VERIFIER && (defaultHostnameVerifier == null || !defaultHostnameVerifier.getClass().getName().equals(s_anyHostnameVerifierName))) {
            HttpsURLConnection.setDefaultHostnameVerifier(s_anyHostnameVerifier);
        }
        if ((proxyHost = SessionConfig.HTTPS_TUNNELING_PROXY_HOST) != null && proxyHost.trim().length() != 0) {
            String authenticator = SessionConfig.HTTPS_TUNNELING_PROXY_AUTHENTICATOR;
            if (authenticator == null || authenticator.trim().length() == 0) {
                authenticator = SessionConfig.HTTPS_TUNNELING_PROXY_AUTHENTICATOR_DEPRECATED;
            }
            if ((authenticator = authenticator == null || authenticator.trim().length() == 0 ? "" : authenticator.trim()).length() != 0) {
                try {
                    Authenticator auth = (Authenticator)Class.forName(authenticator).newInstance();
                    Authenticator.setDefault(auth);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex.getMessage());
                }
            } else {
                String username = SessionConfig.HTTPS_TUNNELING_PROXY_USERNAME;
                String password = SessionConfig.HTTPS_TUNNELING_PROXY_PASSWORD;
                if (username != null && username.trim().length() != 0 && password != null && password.trim().length() != 0) {
                    DefaultBasicAuthenticator auth = new DefaultBasicAuthenticator(username.trim(), password.trim());
                    Authenticator.setDefault(auth);
                }
            }
        }
    }

    static {
        SecurityManager manager = System.getSecurityManager();
        if (manager != null && manager.getClass().getName().startsWith("sun.plugin")) {
            s_usePlugin = true;
        }
    }
}

