/*
 * Decompiled with CFR 0.152.
 */
package progress.message.net.https.server;

import java.io.IOException;
import java.security.Principal;
import java.util.Properties;
import progress.message.net.ProgressInetAddress;
import progress.message.net.ProgressServerSocket;
import progress.message.net.ProgressSocket;
import progress.message.net.https.client.ProgressHttpsSocket;
import progress.message.net.https.server.SonicHttpsServer;
import progress.message.net.https.server.tunnel.HttpsConnectionSocket;

class ProgressHttpsServerSocket
extends ProgressServerSocket {
    private SonicHttpsServer server = null;

    ProgressHttpsServerSocket(Principal principal, int port, int backlog, ProgressInetAddress bindAddr) throws IOException {
        this.server = new SonicHttpsServer(bindAddr, port, backlog);
        try {
            this.server.start();
        }
        catch (Exception e) {
            IOException ioe = new IOException();
            ioe.setStackTrace(e.getStackTrace());
            throw ioe;
        }
    }

    ProgressHttpsServerSocket(Principal principal, int port, int backlog, ProgressInetAddress bindAddr, Properties properties) throws IOException {
        this.server = new SonicHttpsServer(bindAddr, port, backlog, properties);
        try {
            this.server.start();
        }
        catch (Exception e) {
            IOException ioe = new IOException();
            ioe.setStackTrace(e.getStackTrace());
            throw ioe;
        }
    }

    @Override
    public final ProgressSocket accept() throws IOException {
        HttpsConnectionSocket s = this.server.acceptHttpsConnection();
        if (s instanceof EOFSocket) {
            throw new IOException("Socket instance of " + EOFSocket.class.getName());
        }
        return new ProgressHttpsSocket(s);
    }

    @Override
    public final void close() throws IOException {
        try {
            if (this.server != null) {
                this.server.stop();
                this.server.addHttpsConnection(new EOFSocket());
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private final class EOFSocket
    extends HttpsConnectionSocket {
        EOFSocket() {
            super(null, -1, null);
        }
    }
}

