/*
 * Decompiled with CFR 0.152.
 */
package progress.message.net.ssl.jsse;

import com.sonicsw.security.ssl.CipherSuiteUtil;
import com.sonicsw.security.ssl.JSSEConfigManager;
import com.sonicsw.security.ssl.KeyStoreHelper;
import java.io.ByteArrayInputStream;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Vector;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import progress.message.net.ESocketConfigException;
import progress.message.net.ssl.ISSLControl;
import progress.message.net.ssl.jsse.prAccessor;

public class jsseSSLControl
implements ISSLControl {
    private boolean m_debugEnabled = false;
    public static final String KEYSTORE_ALIAS = "sonic";
    private SSLContext m_context = null;
    private String[] m_enabledCiphers = null;
    private KeyStore m_keyStoreFromPKCS = null;
    private KeyStore m_trustStoreFromCADir = null;
    private String m_keyStoreFromPKCSPassword = null;
    private String DEFAULT_KS_PASSWORD = "password";
    private String DEFAULT_KEY_ENTRY = "sonic";
    private String DEFAULT_KE_PASSWORD = "password";
    private static byte[] DEFAULT_KEYSTORE = new byte[]{-2, -19, -2, -19, 0, 0, 0, 2, 0, 0, 0, 1, 0, 0, 0, 1, 0, 5, 115, 111, 110, 105, 99, 0, 0, 0, -24, -20, -2, -103, -72, 0, 0, 2, -68, 48, -126, 2, -72, 48, 14, 6, 10, 43, 6, 1, 4, 1, 42, 2, 17, 1, 1, 5, 0, 4, -126, 2, -92, 84, 51, 4, -45, -82, -106, 66, -84, 56, -7, 43, -118, 93, -24, -97, 52, 8, 57, 89, 64, 87, 70, 30, -16, 3, -103, -33, 74, -69, -104, 31, 46, 54, 61, 2, 113, 53, 84, 120, 102, -84, 43, -55, -107, 61, 65, -35, -41, -98, 9, -93, -52, 126, 52, 5, -119, 58, 30, 116, -37, -1, 103, 101, 52, 13, 25, -95, -101, -53, 18, -122, 0, -126, -54, -11, -93, -126, 97, 78, -75, -120, 42, 17, 69, 119, 13, -104, -1, 35, -8, -53, -77, -76, 69, -47, 26, -54, 82, 6, -29, -96, 12, -118, 81, -6, 22, -43, 115, 47, 41, -1, -38, 84, 119, 114, 99, 54, 96, 121, -10, -78, -105, 77, 103, -90, -4, 23, 104, 91, -77, 120, 16, 34, -34, 121, -18, 36, -115, -50, 25, 22, -4, -106, 29, -72, -66, 51, -38, -92, 80, 33, 87, -124, -97, 30, 26, -58, -91, -49, 112, -56, -19, -24, -58, -93, 20, 101, -92, 38, -94, -127, -15, 66, 12, 72, -109, 94, -43, -56, -27, -36, 81, -91, 46, -51, 8, -48, 71, -17, 44, 25, 104, 21, -36, -87, 97, -13, -94, 41, -106, -20, 78, -120, -9, 59, -3, 31, -86, -117, 126, 63, 57, -118, 117, 34, -87, -70, -14, -7, -23, -53, 103, -62, 52, -12, -95, 30, 102, -47, -128, 111, 20, -89, -47, -119, -5, 21, -108, -55, 12, -118, 72, -70, 52, 101, 47, -82, -110, 58, -98, -27, -96, -100, -88, 69, -34, 105, 79, -69, 95, 57, -125, 124, 81, -102, -33, 26, 71, -3, 34, 19, -5, 82, -125, -107, 36, -24, -5, 106, 3, 109, -35, -112, -118, -84, 91, -97, 30, -128, -65, 15, 102, -96, -21, -103, 70, -59, 11, -18, -110, -90, -19, 25, -78, 6, 35, 12, 54, -4, -73, -113, 95, 105, -85, 44, 81, 65, 115, 90, -33, -59, 89, -11, 92, -2, -30, -70, -80, -4, -21, -99, 123, 80, -101, -11, -69, 78, 55, -23, 104, 33, 27, 37, 72, 107, -122, -46, 65, -108, -18, -127, -45, 27, 86, 12, 38, -94, -45, 85, 19, -23, 70, -56, 26, -28, -71, 115, 7, 44, -103, -31, 45, -113, -85, -107, -42, 99, -41, -83, 102, 43, 99, -53, 75, 116, -60, -33, -88, 72, -26, 52, 38, 26, 66, -84, 124, 36, 21, 73, 51, -30, -92, 7, -125, -74, -73, -64, 19, -40, -10, 22, -47, -86, -88, -111, -87, -6, -85, 115, 9, -26, -32, 45, -77, -52, -51, -25, 122, -106, 126, 23, -80, 96, -81, -44, 97, 69, 36, -82, -121, -98, 17, -21, -54, -70, -83, -61, -24, -16, 15, 112, -30, 10, -120, 50, 88, -20, 114, 90, -30, 100, -16, 39, -89, 0, 48, 46, 77, 76, 47, -104, 23, -28, 68, -95, -71, -64, -8, 122, 15, -11, 111, 126, 55, 5, 14, 113, 49, 123, -55, 125, -56, 118, -107, 112, 76, 71, -95, -62, -78, -34, -28, -109, -76, 69, 119, -114, 48, -109, -98, -14, -86, -45, -20, 117, -3, -15, 125, -128, -59, 92, 67, -107, -39, 53, 73, -37, 54, 89, -64, 51, -124, 66, -84, 53, -45, 101, -85, 117, 97, 89, 36, 82, 13, -59, -53, -21, -121, 107, 60, -110, 27, 110, 119, -31, 82, 105, -110, 77, 86, -4, 85, -23, -49, -112, -25, 33, -94, 26, 102, 49, 73, -92, 46, 64, -75, 51, -110, -48, -85, -6, 122, 55, -45, 31, 104, 5, -127, 15, 10, -106, -16, 96, -8, -82, 116, -29, 3, -17, -80, -113, -92, 26, 82, 93, -65, -72, -98, 70, -126, 4, 31, -67, 73, 116, -75, 80, 123, -40, -121, 99, 40, 44, -67, -111, -101, 96, -1, 30, -11, -26, 83, 41, -76, 8, -76, 7, 122, 120, -127, -91, 56, -88, -51, -101, 52, -82, 32, 30, -77, -55, 101, -89, -68, -121, -105, -115, 78, 30, -26, 119, 9, -76, 19, -9, -110, -111, -12, 122, 77, 59, 40, 21, -10, 90, 81, 0, 0, 0, 1, 0, 5, 88, 46, 53, 48, 57, 0, 0, 2, -92, 48, -126, 2, -96, 48, -126, 2, 9, 2, 4, 59, -95, 5, -65, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 4, 5, 0, 48, -127, -106, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 22, 48, 20, 6, 3, 85, 4, 8, 19, 13, 77, 97, 115, 115, 97, 99, 104, 117, 115, 101, 116, 116, 115, 49, 16, 48, 14, 6, 3, 85, 4, 7, 19, 7, 66, 101, 100, 102, 111, 114, 100, 49, 34, 48, 32, 6, 3, 85, 4, 10, 19, 25, 80, 114, 111, 103, 114, 101, 115, 115, 32, 83, 111, 102, 116, 119, 97, 114, 101, 32, 67, 111, 109, 112, 97, 110, 121, 49, 29, 48, 27, 6, 3, 85, 4, 11, 19, 20, 83, 111, 110, 105, 99, 32, 83, 111, 102, 116, 119, 97, 114, 101, 32, 67, 111, 114, 112, 46, 49, 26, 48, 24, 6, 3, 85, 4, 3, 19, 17, 83, 111, 110, 105, 99, 32, 84, 101, 115, 116, 32, 83, 101, 114, 118, 101, 114, 48, 30, 23, 13, 48, 49, 48, 57, 49, 51, 49, 57, 49, 53, 49, 49, 90, 23, 13, 48, 57, 49, 49, 51, 48, 49, 57, 49, 53, 49, 49, 90, 48, -127, -106, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 22, 48, 20, 6, 3, 85, 4, 8, 19, 13, 77, 97, 115, 115, 97, 99, 104, 117, 115, 101, 116, 116, 115, 49, 16, 48, 14, 6, 3, 85, 4, 7, 19, 7, 66, 101, 100, 102, 111, 114, 100, 49, 34, 48, 32, 6, 3, 85, 4, 10, 19, 25, 80, 114, 111, 103, 114, 101, 115, 115, 32, 83, 111, 102, 116, 119, 97, 114, 101, 32, 67, 111, 109, 112, 97, 110, 121, 49, 29, 48, 27, 6, 3, 85, 4, 11, 19, 20, 83, 111, 110, 105, 99, 32, 83, 111, 102, 116, 119, 97, 114, 101, 32, 67, 111, 114, 112, 46, 49, 26, 48, 24, 6, 3, 85, 4, 3, 19, 17, 83, 111, 110, 105, 99, 32, 84, 101, 115, 116, 32, 83, 101, 114, 118, 101, 114, 48, -127, -97, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, -115, 0, 48, -127, -119, 2, -127, -127, 0, -62, -84, -109, -79, 86, 10, -118, -46, 104, -103, -35, 54, -96, -80, 69, -43, 105, -61, -74, 16, -102, -53, -32, 16, -57, -79, -103, -5, 9, 58, -3, 68, 113, 36, -7, 75, 100, -22, -69, -40, -74, 10, 105, 98, 101, -14, 73, -54, 40, -29, 99, 42, 19, 124, -45, 11, -39, 75, -80, -8, 16, -91, 36, 22, -73, 73, -28, 79, -5, -73, 3, 104, 24, -77, 14, -46, -75, 87, 95, -52, 21, 22, -94, 94, 17, -124, -108, -51, -81, -92, 4, -93, -4, -16, -12, -24, 72, 93, -95, 32, 57, -71, -75, 5, -90, 80, 38, -86, 30, 99, 110, 36, -15, -19, 121, -7, 25, 30, 37, 53, -70, 35, 58, -106, -17, -45, -40, -63, 2, 3, 1, 0, 1, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 4, 5, 0, 3, -127, -127, 0, 59, 32, 35, 47, 43, 54, 46, -96, 53, 68, -118, -26, -40, -127, -7, 36, -72, 11, 20, -81, -81, 3, 22, -4, 62, -108, -18, -54, 72, -35, 124, 13, 37, -86, 34, -29, 83, 114, 18, 77, -103, 51, -98, -83, -110, -101, 79, 70, 96, -42, -82, 22, 32, 108, 86, 82, 83, -67, 79, 20, -89, -114, 15, -91, 87, -31, 72, -72, 55, 21, 120, 35, 105, 52, -68, -96, 91, -106, 116, 100, 2, -29, -65, 12, 10, 49, 48, 46, -45, 20, 62, 14, -127, 8, 115, -99, 27, -67, -22, 1, 32, -49, -85, -2, 49, -75, -85, -104, -20, -100, -74, -50, 47, 71, 100, -60, 45, -118, -114, 47, -40, 70, 24, -128, 14, -66, 60, -121, -41, 66, -32, 119, 91, -19, 23, -80, 89, -58, 25, -10, -12, 19, 28, 87, 89, 107, 99, 88};

    public jsseSSLControl(boolean debugEnabled) throws ESocketConfigException {
        this.m_debugEnabled = debugEnabled;
        try {
            this.m_context = SSLContext.getInstance("TLS");
            this.debug("JSSE provider is " + this.m_context.getProvider());
        }
        catch (Exception ex) {
            if (this.m_debugEnabled) {
                ex.printStackTrace();
            }
            ESocketConfigException sce = new ESocketConfigException(ex.getMessage(), ex);
            sce.fillInStackTrace();
            throw sce;
        }
    }

    @Override
    public Object getContext() {
        return this.m_context;
    }

    public KeyStore getKeyStore() {
        return this.m_keyStoreFromPKCS;
    }

    public String getKeyStorePassword() {
        return this.m_keyStoreFromPKCSPassword;
    }

    public String getKeyStoreAlias() {
        return KEYSTORE_ALIAS;
    }

    public KeyStore getTrustStore() {
        return this.m_trustStoreFromCADir;
    }

    @Override
    public boolean configureKeyAndCertificate(String certificates, String certForm, String key, String keyForm, String password) {
        block8: {
            if (certificates == null || password == null) {
                return false;
            }
            if (certForm.equalsIgnoreCase("PKCS7")) {
                try {
                    this.m_keyStoreFromPKCS = KeyStoreHelper.keyStoreFromPKCS7AndEncryptedPKCS8(certificates, key, password, KEYSTORE_ALIAS);
                    this.m_keyStoreFromPKCSPassword = password;
                }
                catch (Exception ex) {
                    if (this.m_debugEnabled) {
                        System.out.println("Unable to populate PKCS7 & PKCS8 into a key store:" + ex.getMessage());
                    }
                    break block8;
                }
            }
            if (certForm.equalsIgnoreCase("PKCS12")) {
                try {
                    this.m_keyStoreFromPKCS = KeyStoreHelper.keyStoreFromPKCS12(certificates, password, KEYSTORE_ALIAS);
                    this.m_keyStoreFromPKCSPassword = password;
                }
                catch (Exception ex) {
                    if (!this.m_debugEnabled) break block8;
                    System.out.println("Unable to populate PKCS12 into a key store:" + ex.getMessage());
                }
            }
        }
        return true;
    }

    public String[] getEnabledCipherSuites() {
        return this.m_enabledCiphers;
    }

    @Override
    public boolean configureCipherSuites(Vector ciphers) {
        if (ciphers != null && ciphers.size() != 0) {
            this.m_enabledCiphers = new String[ciphers.size()];
            Enumeration csNames = ciphers.elements();
            int i = 0;
            while (csNames.hasMoreElements()) {
                String cipher = (String)csNames.nextElement();
                String jsseCipher = CipherSuiteUtil.getJSSECipherSuiteFromRSA(cipher);
                if (jsseCipher != null) {
                    this.m_enabledCiphers[i++] = jsseCipher;
                    if (!this.m_debugEnabled) continue;
                    System.out.println("replacing RSA cipher " + cipher + " with JSSE cipher " + jsseCipher);
                    continue;
                }
                this.m_enabledCiphers[i++] = cipher;
            }
        }
        return true;
    }

    @Override
    public boolean configureTrustDecider(String caDirectory, String trustDecider) throws ESocketConfigException {
        try {
            X509Certificate[] caCerts = KeyStoreHelper.loadCertificatesFromDirectory(caDirectory);
            this.m_trustStoreFromCADir = KeyStoreHelper.trustStoreFromCertificates(caCerts, null);
        }
        catch (Exception ex) {
            ESocketConfigException se = new ESocketConfigException(ex.getMessage(), ex);
            se.fillInStackTrace();
            throw se;
        }
        return true;
    }

    public String toString() {
        return new String("jsseSSLClientControl");
    }

    protected final void debug(String msg) {
        if (this.m_debugEnabled) {
            System.out.println("jsse SSL: " + msg);
        }
    }

    @Override
    public void setDebug(boolean on) {
        this.m_debugEnabled = on;
    }

    public SSLContext getSSLContext(JSSEConfigManager configManager) {
        block8: {
            if (configManager != null) {
                try {
                    if (this.m_context != null) {
                        this.m_context.init(configManager.getKeyManagers(), configManager.getTrustManagers(), null);
                    }
                }
                catch (KeyManagementException e) {
                    this.m_context = null;
                    if (this.m_debugEnabled) {
                        e.printStackTrace();
                    }
                }
                catch (SecurityException e) {
                    this.m_context = null;
                    if (this.m_debugEnabled) {
                        e.printStackTrace();
                    }
                }
                catch (Exception e) {
                    this.m_context = null;
                    if (!this.m_debugEnabled) break block8;
                    e.printStackTrace();
                }
            }
        }
        return this.m_context;
    }

    private class EmbeddedKeyManager
    implements X509KeyManager {
        String CLIENT;
        String SERVER;
        KeyStore ks;

        EmbeddedKeyManager() {
            block5: {
                this.CLIENT = "client";
                this.SERVER = "server";
                this.ks = null;
                try {
                    this.ks = KeyStore.getInstance("JKS");
                    jsseSSLControl.this.debug(prAccessor.getString("DBG_KSLOAD"));
                    this.ks.load(new ByteArrayInputStream(DEFAULT_KEYSTORE), jsseSSLControl.this.DEFAULT_KS_PASSWORD.toCharArray());
                    if (!jsseSSLControl.this.m_debugEnabled) break block5;
                    try {
                        Enumeration<String> list = this.ks.aliases();
                        System.out.println(prAccessor.getString("DBG_KSENTRIES"));
                        while (list.hasMoreElements()) {
                            System.out.println((Object)list.nextElement());
                        }
                    }
                    catch (Exception ex) {
                        String msg = prAccessor.getString("KE_READ");
                        Object[] objs = new Object[]{ex + ": " + ex.getMessage()};
                        System.out.println(MessageFormat.format(msg, objs));
                    }
                }
                catch (Exception ex) {
                    String msg = prAccessor.getString("KS_LOAD");
                    Object[] objs = new Object[]{ex + ": " + ex.getMessage()};
                    System.out.println(MessageFormat.format(msg, objs));
                    if (!jsseSSLControl.this.m_debugEnabled) break block5;
                    ex.printStackTrace();
                }
            }
        }

        @Override
        public String chooseClientAlias(String[] keyTypes, Principal[] issuers, Socket s) {
            return this.CLIENT;
        }

        @Override
        public String chooseServerAlias(String keyType, Principal[] issuers, Socket s) {
            return this.SERVER;
        }

        @Override
        public String[] getClientAliases(String keyType, Principal[] issuers) {
            String[] ret = new String[]{this.CLIENT};
            return ret;
        }

        @Override
        public String[] getServerAliases(String keyType, Principal[] issuers) {
            String[] ret = new String[]{this.SERVER};
            return ret;
        }

        @Override
        public X509Certificate[] getCertificateChain(String alias) {
            X509Certificate[] chain;
            block8: {
                chain = null;
                try {
                    Certificate[] certs;
                    if (jsseSSLControl.this.m_debugEnabled) {
                        String msg = prAccessor.getString("DBG_CHAIN");
                        Object[] objs = new Object[]{jsseSSLControl.this.DEFAULT_KEY_ENTRY};
                        System.out.println(MessageFormat.format(msg, objs));
                    }
                    if ((certs = this.ks.getCertificateChain(jsseSSLControl.this.DEFAULT_KEY_ENTRY)) != null && certs.length > 0) {
                        chain = new X509Certificate[certs.length];
                        for (int i = 0; i < certs.length; ++i) {
                            chain[i] = (X509Certificate)certs[i];
                        }
                    }
                    if (jsseSSLControl.this.m_debugEnabled) {
                        if (chain != null) {
                            String msg = prAccessor.getString("DBG_DN");
                            Object[] objs = new Object[]{chain[0].getSubjectDN()};
                            System.out.println(MessageFormat.format(msg, objs));
                        } else {
                            System.out.println("Failed");
                        }
                    }
                }
                catch (Exception ex) {
                    if (!jsseSSLControl.this.m_debugEnabled) break block8;
                    ex.printStackTrace();
                }
            }
            return chain;
        }

        @Override
        public PrivateKey getPrivateKey(String alias) {
            PrivateKey key;
            block4: {
                key = null;
                try {
                    if (jsseSSLControl.this.m_debugEnabled) {
                        String msg = prAccessor.getString("DBG_KEY");
                        Object[] objs = new Object[]{jsseSSLControl.this.DEFAULT_KEY_ENTRY};
                        System.out.println(MessageFormat.format(msg, objs));
                    }
                    key = (PrivateKey)this.ks.getKey(jsseSSLControl.this.DEFAULT_KEY_ENTRY, jsseSSLControl.this.DEFAULT_KE_PASSWORD.toCharArray());
                    if (jsseSSLControl.this.m_debugEnabled) {
                        System.out.println(key == null ? "Failed" : "OK");
                    }
                }
                catch (Exception ex) {
                    if (!jsseSSLControl.this.m_debugEnabled) break block4;
                    ex.printStackTrace();
                }
            }
            return key;
        }
    }

    private class AlwaysTrustManager
    implements X509TrustManager {
        private AlwaysTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }
    }
}

