/*
 * Decompiled with CFR 0.152.
 */
package progress.message.net.ssl.jsse;

import com.sonicsw.security.ssl.JSSEConfigManager;
import com.sonicsw.security.ssl.SSLUtil;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Vector;
import javax.jms.JMSSecurityException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.security.cert.X509Certificate;
import progress.message.net.ESocketConfigException;
import progress.message.net.ProgressInetAddress;
import progress.message.net.TCPProxy;
import progress.message.net.http.client.tunnel.IHttpProxyConfig;
import progress.message.net.ssl.ISSLControl;
import progress.message.net.ssl.ISSLImpl;
import progress.message.net.ssl.ISSLServerSocket;
import progress.message.net.ssl.ISSLSocket;
import progress.message.net.ssl.jsse.jsseSSLControl;
import progress.message.net.ssl.jsse.jsseX509Certificate;
import progress.message.net.ssl.jsse.prAccessor;
import progress.message.zclient.SessionConfig;

public final class jsseSSLImpl
implements ISSLImpl {
    private static boolean DEBUG = false;
    private static boolean DEBUG_CLIENT_CIPHER = false;
    private static final String TLS_PROTOCOLS_DELIM = ",";
    private static final String TLS_PROTOCOLS_SYSTEM_PROPERTY = "sonicsw.tls.preferred.protocols";

    @Override
    public ISSLControl createSSLClientControl() throws ESocketConfigException {
        return this.createSSLControl();
    }

    @Override
    public ISSLControl createSSLServerControl() throws ESocketConfigException {
        return this.createSSLControl();
    }

    private ISSLControl createSSLControl() throws ESocketConfigException {
        return new jsseSSLControl(DEBUG);
    }

    @Override
    public ISSLSocket createSSLSocket(String host, int port, ISSLControl control, Object properties) throws UnknownHostException, IOException {
        return this.createSSLSocket(host, port, control, null, -1, properties, null);
    }

    @Override
    public ISSLSocket createSSLSocket(String host, int port, ISSLControl control, String proxyHost, int proxyPort, Object properties, IHttpProxyConfig pConfig) throws UnknownHostException, IOException {
        Socket socket = null;
        try {
            boolean autoClose;
            Socket tunnelingSocket;
            SSLContext ctx = this.getSSLContext(control, properties, false);
            SSLSocketFactory sslFact = ctx.getSocketFactory();
            if (pConfig != null && pConfig.getHost() != null && pConfig.getHost().trim().length() > 0 && pConfig.getPort() != -1) {
                tunnelingSocket = TCPProxy.connectProxy(host, port, proxyHost, proxyPort, pConfig);
                autoClose = true;
                socket = (SSLSocket)sslFact.createSocket(tunnelingSocket, host, port, autoClose);
            } else if (proxyHost != null && proxyPort != -1) {
                tunnelingSocket = TCPProxy.connectProxy(host, port, proxyHost, proxyPort, null);
                autoClose = true;
                socket = (SSLSocket)sslFact.createSocket(tunnelingSocket, host, port, autoClose);
            } else {
                socket = (SSLSocket)sslFact.createSocket(host, port);
            }
            String[] enabledProtocols = this.getEnabledProtocols(((SSLSocket)socket).getSupportedProtocols(), properties);
            ((SSLSocket)socket).setEnabledProtocols(enabledProtocols);
            if (DEBUG) {
                String msg = prAccessor.getString("DBG_ENABLED_PROTOCOLS");
                Object[] obj = new Object[]{Arrays.toString(((SSLSocket)socket).getEnabledProtocols())};
                System.out.println(MessageFormat.format(msg, obj));
            }
            String[] ciphers = ((jsseSSLControl)control).getEnabledCipherSuites();
            String[] enabledCiphers = jsseSSLImpl.getEnabledCipherSuites(ciphers, ((SSLSocket)socket).getSupportedCipherSuites(), false);
            ((SSLSocket)socket).setEnabledCipherSuites(enabledCiphers);
            if (DEBUG) {
                System.out.println(prAccessor.getString("DBG_CIPHERS"));
                for (int i = 0; i < enabledCiphers.length; ++i) {
                    System.out.println(enabledCiphers[i]);
                }
            }
            ((SSLSocket)socket).startHandshake();
            if (DEBUG_CLIENT_CIPHER && socket != null) {
                System.out.println("Cipher suite: " + ((SSLSocket)socket).getSession().getCipherSuite());
            }
            if (DEBUG) {
                System.out.println("Connection info:");
                System.out.println("Cipher suite:  " + ((SSLSocket)socket).getSession().getCipherSuite());
            }
        }
        catch (IOException ex) {
            if (socket != null) {
                socket.close();
            }
            throw ex;
        }
        catch (Exception ex) {
            if (socket != null) {
                socket.close();
            }
            IOException e = new IOException(ex.getMessage(), ex);
            throw e;
        }
        return new jsseSSLSocket((SSLSocket)socket, true);
    }

    @Override
    public ISSLServerSocket createSSLServerSocket(InetAddress bindAddr, int port, int backlog, ISSLControl serverControl, Object properties) throws IOException {
        ISSLServerSocket ssocket = this.createSSLServerSocket(bindAddr == null ? null : new ProgressInetAddress(bindAddr), port, backlog, serverControl, properties);
        return ssocket;
    }

    @Override
    public ISSLServerSocket createSSLServerSocket(ProgressInetAddress bindAddr, int port, int backlog, ISSLControl control, Object properties) throws IOException {
        SSLServerSocket serverSocket = null;
        try {
            SSLContext ctx = this.getSSLContext(control, properties, true);
            SSLServerSocketFactory sslSrvFact = ctx.getServerSocketFactory();
            serverSocket = (SSLServerSocket)sslSrvFact.createServerSocket(port, backlog, bindAddr == null ? null : bindAddr.getDelegateInetAddress());
            String[] enabledProtocols = this.getEnabledProtocols(serverSocket.getSupportedProtocols(), properties);
            serverSocket.setEnabledProtocols(enabledProtocols);
            if (DEBUG) {
                String msg = prAccessor.getString("DBG_ENABLED_PROTOCOLS");
                Object[] obj = new Object[]{Arrays.toString(serverSocket.getEnabledProtocols())};
                System.out.println(MessageFormat.format(msg, obj));
            }
            Boolean b = SSLUtil.getBooleanProperty(properties, "SSL_CLIENT_AUTHENTICATION", Boolean.FALSE);
            serverSocket.setNeedClientAuth(b);
            if (DEBUG) {
                System.out.println((b != false ? "Enable" : "Disable") + " client authentication.");
            }
            String[] ciphers = ((jsseSSLControl)control).getEnabledCipherSuites();
            String[] enabledCiphers = jsseSSLImpl.getEnabledCipherSuites(ciphers, serverSocket.getSupportedCipherSuites(), true);
            serverSocket.setEnabledCipherSuites(enabledCiphers);
            if (DEBUG) {
                System.out.println(prAccessor.getString("DBG_CIPHERS"));
                for (int i = 0; i < enabledCiphers.length; ++i) {
                    System.out.println(enabledCiphers[i]);
                }
            }
        }
        catch (IOException ex) {
            System.out.println(prAccessor.getString("STR007") + ex + ex.getMessage());
            throw ex;
        }
        class JsseSSLServerSocket
        implements ISSLServerSocket {
            SSLServerSocket m_impl = null;

            JsseSSLServerSocket(SSLServerSocket s) {
                this.m_impl = s;
            }

            @Override
            public ServerSocket getImpl() {
                return this.m_impl;
            }

            @Override
            public ISSLSocket accept() throws IOException {
                SSLSocket s = null;
                boolean closeSocket = false;
                try {
                    s = (SSLSocket)this.m_impl.accept();
                }
                catch (IOException ioe) {
                    closeSocket = true;
                    throw new IOException(ioe.getMessage() + ". " + prAccessor.getString("ACCEPT_FAIL"), ioe);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    closeSocket = true;
                    throw new ESocketConfigException(ex.getMessage() + ". " + prAccessor.getString("ACCEPT_FAIL"), ex);
                }
                finally {
                    if (closeSocket && s != null) {
                        try {
                            s.close();
                        }
                        catch (Exception e) {}
                    }
                }
                if (s == null) {
                    throw new IOException(". " + prAccessor.getString("ACCEPT_FAIL"));
                }
                return new jsseSSLSocket(s, false);
            }

            @Override
            public void setSoTimeout(int timeout) throws IOException {
                this.m_impl.setSoTimeout(timeout);
            }
        }
        return new JsseSSLServerSocket(serverSocket);
    }

    @Override
    public progress.message.security.cert.X509Certificate loadCertificate(File file) {
        return null;
    }

    @Override
    public progress.message.security.cert.X509Certificate loadCertificate(String file) {
        return null;
    }

    @Override
    public void setDebug(boolean on) {
        DEBUG = on;
        if (DEBUG) {
            DEBUG_CLIENT_CIPHER = true;
        }
    }

    private SSLContext getSSLContext(ISSLControl control, Object properties, boolean isSSLServerSocket) throws IOException {
        try {
            jsseSSLControl jsseControl = (jsseSSLControl)control;
            JSSEConfigManager configManager = new JSSEConfigManager(properties, isSSLServerSocket, DEBUG, jsseControl);
            return jsseControl.getSSLContext(configManager);
        }
        catch (ClassCastException e) {
            IOException ex = new IOException(e.getMessage());
            System.out.println(prAccessor.getString("STR007") + ex + ex.getMessage());
            throw ex;
        }
        catch (JMSSecurityException e) {
            IOException ex = new IOException(e.getMessage());
            ex.fillInStackTrace();
            throw ex;
        }
    }

    private static String[] getEnabledCipherSuites(String[] selectedCiphers, String[] supportedCiphers, boolean reportInvalidCipher) throws ESocketConfigException {
        if (selectedCiphers == null || selectedCiphers.length == 0) {
            return supportedCiphers;
        }
        Object[] enabledCiphers = null;
        Vector<String> cipherList = new Vector<String>();
        for (int i = 0; i < selectedCiphers.length; ++i) {
            boolean isSupported = false;
            for (int j = 0; j < supportedCiphers.length; ++j) {
                if (!selectedCiphers[i].equals(supportedCiphers[j])) continue;
                isSupported = true;
                break;
            }
            if (isSupported) {
                cipherList.add(selectedCiphers[i]);
                continue;
            }
            if (!reportInvalidCipher) continue;
            SessionConfig.logMessage("Cipher suite " + selectedCiphers[i] + " not supported.", SessionConfig.getLevelWarning());
        }
        if (cipherList.size() == 0) {
            throw new ESocketConfigException("None of configured cipher suite(s) supported.");
        }
        if (cipherList.size() == selectedCiphers.length) {
            enabledCiphers = selectedCiphers;
        } else {
            enabledCiphers = new String[cipherList.size()];
            cipherList.copyInto(enabledCiphers);
        }
        return enabledCiphers;
    }

    private String[] getEnabledProtocols(String[] supportedProtocols, Object properties) {
        if (DEBUG) {
            String msg = prAccessor.getString("DBG_SUPPORTED_PROTOCOLS");
            Object[] obj1 = new Object[]{Arrays.toString(supportedProtocols)};
            System.out.println(MessageFormat.format(msg, obj1));
        }
        String[] enabledProtocols = null;
        String preferredProtocols = System.getProperty(TLS_PROTOCOLS_SYSTEM_PROPERTY);
        String acceptorPreferredProtocols = SSLUtil.getProperty(properties, "SSL_TLS_PREFERRED_PROTOCOLS", null);
        if (acceptorPreferredProtocols != null && !acceptorPreferredProtocols.trim().isEmpty()) {
            preferredProtocols = acceptorPreferredProtocols;
        }
        if (preferredProtocols != null && !preferredProtocols.trim().isEmpty()) {
            enabledProtocols = preferredProtocols.split(TLS_PROTOCOLS_DELIM);
            for (int i = 0; i < enabledProtocols.length; ++i) {
                enabledProtocols[i] = enabledProtocols[i].trim();
            }
            return enabledProtocols;
        }
        boolean tlsV1Only = SSLUtil.getBooleanProperty(properties, "ENABLE_TLSV1_ONLY", Boolean.FALSE);
        boolean sslV3Only = SSLUtil.getBooleanProperty(properties, "ENABLE_SSLV3_ONLY", Boolean.FALSE);
        HashSet<String> set = new HashSet<String>();
        if (!sslV3Only && !tlsV1Only || sslV3Only && tlsV1Only) {
            enabledProtocols = supportedProtocols;
        } else if (sslV3Only) {
            for (String s : supportedProtocols) {
                if (!s.equalsIgnoreCase("SSLv3") && !s.equals("SSLv2Hello")) continue;
                set.add(s);
            }
            enabledProtocols = set.toArray(new String[0]);
        } else if (tlsV1Only) {
            for (String s : supportedProtocols) {
                if (s.equals("SSLv3")) continue;
                set.add(s);
            }
            enabledProtocols = set.toArray(new String[0]);
        }
        return enabledProtocols;
    }

    static {
        Boolean b = SSLUtil.getBooleanProperty(null, "SSL_DEBUG.CLIENT_CIPHER", Boolean.FALSE);
        if (b != null && b.booleanValue()) {
            DEBUG_CLIENT_CIPHER = true;
        }
    }

    class jsseSSLSocket
    implements ISSLSocket {
        SSLSocket m_impl = null;
        boolean m_handshakeDone = false;

        jsseSSLSocket(SSLSocket s, boolean handshakeDone) {
            this.m_impl = s;
            this.m_handshakeDone = handshakeDone;
        }

        @Override
        public void setSoTimeout(int timeout) throws IOException {
            this.m_impl.setSoTimeout(timeout);
        }

        @Override
        public void startHandshake() throws IOException {
            if (DEBUG) {
                System.out.println(Thread.currentThread() + " starting ssl handshake ...");
            }
            this.m_handshakeDone = true;
            try {
                this.m_impl.startHandshake();
                if (DEBUG_CLIENT_CIPHER && this.m_impl != null) {
                    System.out.println("Cipher suite: " + this.m_impl.getSession().getCipherSuite());
                }
                if (DEBUG && this.m_impl != null) {
                    System.out.println("Connection info:");
                    System.out.println("Cipher suite:  " + this.m_impl.getSession().getCipherSuite());
                }
            }
            catch (IOException ex) {
                if (DEBUG) {
                    ex.printStackTrace();
                }
                try {
                    this.m_impl.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw ex;
            }
        }

        @Override
        public Socket getImpl() {
            return this.m_impl;
        }

        @Override
        public progress.message.security.cert.X509Certificate getPeerCertificate() {
            progress.message.security.cert.X509Certificate[] x509Certs = this.getPeerCertificateChain();
            if (x509Certs != null && x509Certs.length != 0) {
                return x509Certs[0];
            }
            return null;
        }

        @Override
        public InetAddress getInetAddress() {
            return this.m_impl.getInetAddress();
        }

        @Override
        public String getCipherSuite() {
            return this.m_impl.getSession().getCipherSuite();
        }

        @Override
        public progress.message.security.cert.X509Certificate[] getPeerCertificateChain() {
            if (!this.m_handshakeDone) {
                try {
                    this.startHandshake();
                }
                catch (SSLPeerUnverifiedException e) {
                    if (DEBUG) {
                        System.out.println("Caught exception " + e + " - the client authentication may not be enabled!");
                    }
                    return null;
                }
                catch (SSLHandshakeException e) {
                    if (DEBUG) {
                        e.printStackTrace();
                    }
                    return null;
                }
                catch (IOException ex) {
                    if (DEBUG) {
                        ex.printStackTrace();
                    }
                    return null;
                }
            }
            try {
                X509Certificate[] certs = this.m_impl.getSession().getPeerCertificateChain();
                if (certs != null && certs.length != 0) {
                    progress.message.security.cert.X509Certificate[] x509certs = new progress.message.security.cert.X509Certificate[certs.length];
                    for (int i = 0; i < certs.length; ++i) {
                        x509certs[i] = new jsseX509Certificate(certs[i]);
                    }
                    return x509certs;
                }
                return null;
            }
            catch (SSLPeerUnverifiedException e) {
                if (DEBUG) {
                    System.out.println("Caught exception " + e + " - the client authentication may not be enabled!");
                }
                return null;
            }
        }
    }
}

