/*
 * Decompiled with CFR 0.152.
 */
package progress.message.security;

import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.security.pass.broker.ConnectionException;
import com.sonicsw.security.pass.broker.IAuthentication;
import com.sonicsw.security.pass.client.IPasswordUser;
import java.security.Principal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.RoutingUserAclEntry;
import progress.message.broker.SubjectAclEntry;
import progress.message.client.ESecuritySemanticsViolation;
import progress.message.client.EUnknownPrincipal;
import progress.message.db.EDatabaseException;
import progress.message.resources.prMessageFormat;
import progress.message.security.AddGroupMemberEvent;
import progress.message.security.DelAclEntryEvent;
import progress.message.security.DelPrincipalEvent;
import progress.message.security.DelQOPEvent;
import progress.message.security.DelRoutingUserAclEntryEvent;
import progress.message.security.EPrincipalConflict;
import progress.message.security.EPrincipalExists;
import progress.message.security.NewAclEntryEvent;
import progress.message.security.NewGroupEvent;
import progress.message.security.NewRoutingUserAclEntryEvent;
import progress.message.security.NewUserEvent;
import progress.message.security.RemoveGroupMemberEvent;
import progress.message.security.SecDBReinitEvent;
import progress.message.security.SecurityBean;
import progress.message.security.SecurityEvent;
import progress.message.security.SetQOPEvent;
import progress.message.security.UpdateAclEntryEvent;
import progress.message.security.UpdateUserEvent;
import progress.message.security.prAccessor;
import progress.message.util.EAssertFailure;
import progress.message.zclient.ISecurityCache;
import progress.message.zclient.ProgressGroup;
import progress.message.zclient.ProgressPasswordUser;
import progress.message.zclient.ProgressPrincipal;
import progress.message.zclient.QOP;

public final class SecurityCache
implements ISecurityCache {
    private Hashtable<String, ProgressPrincipal> m_principals;
    private Hashtable<String, Vector<SubjectAclEntry>> m_subjectACLEntries;
    private Hashtable<String, Vector<RoutingUserAclEntry>> m_routingUserACLEntries;
    private Hashtable<String, QOP> m_qops;
    private transient SecurityBean m_parent;
    private long m_startTime;
    private int m_vtime;
    private ISecurityCache m_delegate;

    public SecurityCache(Hashtable<String, ProgressPrincipal> principals, Hashtable<String, Vector<SubjectAclEntry>> subjectACLs, Hashtable<String, Vector<RoutingUserAclEntry>> routingUserACLs, Hashtable<String, QOP> qops) {
        this.m_principals = principals != null ? principals : new Hashtable();
        this.m_qops = qops != null ? qops : new Hashtable();
        this.m_subjectACLEntries = subjectACLs != null ? subjectACLs : new Hashtable();
        this.addInternalACLs(this.m_principals, this.m_subjectACLEntries);
        this.m_routingUserACLEntries = routingUserACLs != null ? routingUserACLs : new Hashtable();
    }

    public ISecurityCache getSecurityCacheDelegate() {
        if (this.m_delegate == null) {
            this.m_delegate = new ISecurityCache(){

                public boolean updateExternalUsers(String[] uids) throws ConnectionException {
                    return SecurityCache.this.updateExternalUsers(uids);
                }

                public String[] getExternalUsers() throws ConnectionException {
                    return SecurityCache.this.getExternalUsers();
                }
            };
        }
        return this.m_delegate;
    }

    private final void setPermission(String subject, ProgressPrincipal principal, byte perm) throws ESecuritySemanticsViolation {
        Vector<SubjectAclEntry> acls = this.m_subjectACLEntries.get(subject);
        SubjectAclEntry newEntry = new SubjectAclEntry(principal);
        SubjectAclEntry oldEntry = null;
        if (acls == null) {
            acls = new Vector();
            this.m_subjectACLEntries.put(subject, acls);
        } else if (acls.indexOf(newEntry) != -1) {
            oldEntry = acls.elementAt(acls.indexOf(newEntry));
        }
        if (oldEntry == null) {
            newEntry.addPermission(perm);
            ((ProgressPrincipal)newEntry.getPrincipal()).addAclSubject(subject);
            acls.addElement(newEntry);
        } else {
            oldEntry.addPermission(perm);
        }
    }

    private final void addInternalACLs(Hashtable<String, ProgressPrincipal> principals, Hashtable<String, Vector<SubjectAclEntry>> subjectACLEntries) {
        String subject = null;
        Vector<SubjectAclEntry> acls = null;
        SubjectAclEntry sae = null;
        ProgressGroup pub = (ProgressGroup)principals.get("PUBLIC");
        ProgressGroup admins = (ProgressGroup)principals.get("Administrators");
        ProgressGroup brokers = (ProgressGroup)principals.get("$ISYS-BROKERS");
        try {
            subject = "$ISYS.USERS.reply";
            this.setPermission(subject, pub, (byte)1);
            this.setPermission("#", admins, (byte)1);
            this.setPermission("#", admins, (byte)2);
            this.setPermission("#", admins, (byte)4);
            this.setPermission("#", brokers, (byte)1);
            this.setPermission("#", brokers, (byte)2);
            this.setPermission("#", brokers, (byte)4);
            this.setPermission("$SYS", pub, (byte)1);
            this.setPermission("$SYS", pub, (byte)2);
            this.setPermission("$SYS", pub, (byte)4);
            this.setPermission("$ISYS", pub, (byte)1);
            this.setPermission("$ISYS", pub, (byte)2);
            this.setPermission("$ISYS", pub, (byte)4);
            this.setPermission("$QSYS", pub, (byte)1);
            this.setPermission("$QSYS", pub, (byte)2);
            this.setPermission("$QSYS", pub, (byte)4);
            this.setPermission("$SonicMQ-Root-Subject", admins, (byte)1);
            this.setPermission("$SonicMQ-Root-Subject", admins, (byte)2);
            this.setPermission("$SonicMQ-Root-Subject", admins, (byte)4);
            this.setPermission("$SonicMQ-Root-Subject", brokers, (byte)1);
            this.setPermission("$SonicMQ-Root-Subject", brokers, (byte)2);
            this.setPermission("$SonicMQ-Root-Subject", brokers, (byte)4);
        }
        catch (ESecuritySemanticsViolation e) {
            String mf287 = prAccessor.getString("STR105");
            Object[] ob287 = new Object[]{pub.getName(), e};
            throw new EAssertFailure(MessageFormat.format(mf287, ob287), e);
        }
        Enumeration<ProgressPrincipal> allUsers = principals.elements();
        while (allUsers.hasMoreElements()) {
            ProgressPrincipal user = allUsers.nextElement();
            if (user instanceof ProgressGroup) continue;
            try {
                subject = "$ISYS.admin." + user.getName();
                acls = this.m_subjectACLEntries.get(subject);
                if (acls == null) {
                    acls = new Vector();
                    this.m_subjectACLEntries.put(subject, acls);
                }
                sae = new SubjectAclEntry(user);
                sae.addPermission((byte)1);
                ((ProgressPrincipal)sae.getPrincipal()).addAclSubject(subject);
                acls.addElement(sae);
                subject = "$ISYS.USERS.*." + user.getName();
                acls = this.m_subjectACLEntries.get(subject);
                if (acls == null) {
                    acls = new Vector();
                    this.m_subjectACLEntries.put(subject, acls);
                }
                sae = new SubjectAclEntry(user);
                sae.addPermission((byte)2);
                ((ProgressPrincipal)sae.getPrincipal()).addAclSubject(subject);
                acls.addElement(sae);
            }
            catch (ESecuritySemanticsViolation e) {
                String mf287 = prAccessor.getString("STR105");
                Object[] ob287 = new Object[]{user.getName(), e};
                throw new EAssertFailure(MessageFormat.format(mf287, ob287), e);
            }
        }
    }

    public final void setParent(SecurityBean parent) {
        this.m_parent = parent;
    }

    public final void setStartTime(long startTime) {
        this.m_startTime = startTime;
    }

    public final void addUser(ProgressPasswordUser user) {
        this.m_principals.put(user.getName(), user);
    }

    public final void addGroup(ProgressGroup group) {
        this.m_principals.put(group.getName(), group);
    }

    public final void setACLHashtable() {
        if (this.m_subjectACLEntries == null) {
            this.m_subjectACLEntries = this.m_principals != null ? new Hashtable(2 * this.m_principals.size()) : new Hashtable();
        }
    }

    final Vector<String> getSecureSubjects() {
        Vector<String> ret = new Vector<String>(this.m_subjectACLEntries.size() + this.m_qops.size(), 1);
        Enumeration<String> enu = this.m_subjectACLEntries.keys();
        while (enu.hasMoreElements()) {
            ret.addElement(enu.nextElement());
        }
        enu = this.m_qops.keys();
        while (enu.hasMoreElements()) {
            String sub = enu.nextElement();
            if (this.m_subjectACLEntries.containsKey(sub)) continue;
            ret.addElement(sub);
        }
        return ret;
    }

    final QOP getQOP(String subject) {
        return this.m_qops.get(subject);
    }

    final Vector<SubjectAclEntry> getAclEntries(String subject) {
        Vector ret = this.m_subjectACLEntries.get(subject);
        return ret == null ? new Vector() : ret;
    }

    final Vector<RoutingUserAclEntry> getRoutingUserACLs(String node) {
        Vector<RoutingUserAclEntry> v;
        Vector retv = null;
        if (this.m_routingUserACLEntries != null && (v = this.m_routingUserACLEntries.get(node)) != null) {
            retv = (Vector)v.clone();
        }
        return retv;
    }

    public final boolean isRoutingUserAuthorized(String node, Principal principal) {
        Vector<RoutingUserAclEntry> acls = this.m_routingUserACLEntries.get(node);
        if (acls == null) {
            return false;
        }
        Enumeration<RoutingUserAclEntry> entries = acls.elements();
        boolean authenticate = false;
        while (entries.hasMoreElements()) {
            RoutingUserAclEntry ruae = entries.nextElement();
            if (!ruae.getPrincipal().getName().equals(principal.getName())) continue;
            authenticate = ruae.checkPermission();
            break;
        }
        return authenticate;
    }

    public final void removeRoutingUserACL(String node, Principal principal) {
        Vector<RoutingUserAclEntry> acls = this.m_routingUserACLEntries.get(node);
        if (acls == null) {
            return;
        }
        Enumeration<RoutingUserAclEntry> entries = acls.elements();
        RoutingUserAclEntry ruae = null;
        boolean match = false;
        while (entries.hasMoreElements()) {
            ruae = entries.nextElement();
            if (!ruae.getPrincipal().getName().equals(principal.getName())) continue;
            match = true;
            break;
        }
        if (ruae != null && match) {
            acls.remove(ruae);
        }
    }

    public final void removeRoutingUserACLs(Principal principal) {
        if (principal == null || this.m_routingUserACLEntries.isEmpty()) {
            return;
        }
        Enumeration<Vector<RoutingUserAclEntry>> nodes = this.m_routingUserACLEntries.elements();
        Vector<RoutingUserAclEntry> acls = null;
        while (nodes.hasMoreElements()) {
            acls = nodes.nextElement();
            if (acls == null) continue;
            Enumeration<RoutingUserAclEntry> entries = acls.elements();
            RoutingUserAclEntry ruae = null;
            boolean match = false;
            while (entries.hasMoreElements()) {
                ruae = entries.nextElement();
                if (!ruae.getPrincipal().getName().equals(principal.getName())) continue;
                match = true;
                break;
            }
            if (ruae == null || !match) continue;
            acls.remove(ruae);
        }
    }

    public final void removeRoutingUserACLs(String node) {
        Vector<RoutingUserAclEntry> acls = this.m_routingUserACLEntries.get(node);
        if (acls == null) {
            return;
        }
        this.m_routingUserACLEntries.remove(node);
        acls.clear();
    }

    public final Enumeration<ProgressPrincipal> getPrincipals() {
        return this.m_principals.elements();
    }

    public final ProgressPrincipal getPrincipal(String name) {
        return this.m_principals.get(name);
    }

    final long getStartTime() {
        return this.m_startTime;
    }

    final SetQOPEvent prepareSetQOPEvent(String subject, QOP qop) {
        return new SetQOPEvent(this.m_parent, this.m_startTime, this.m_vtime + 1, subject, qop);
    }

    final void processSetQOPEvent(SetQOPEvent evt) {
        this.m_qops.put(evt.getSubject(), evt.getQOP());
        if (evt.getSubject().equals("#")) {
            this.m_qops.put("$SonicMQ-Root-Subject", evt.getQOP());
        }
    }

    final DelQOPEvent prepareDelQOPEvent(String subject) {
        QOP q = this.m_qops.get(subject);
        if (q == null) {
            return null;
        }
        return new DelQOPEvent(this.m_parent, this.m_startTime, this.m_vtime + 1, subject, q);
    }

    final void processDelQOPEvent(DelQOPEvent evt) {
        this.m_qops.remove(evt.getSubject());
        if (evt.getSubject().equals("#")) {
            QOP qOP = this.m_qops.remove("$SonicMQ-Root-Subject");
        }
    }

    final SecurityEvent prepareSetRoutingUserAclEntryEvent(String nodeName, RoutingUserAclEntry newEntry) throws EUnknownPrincipal {
        String principalName = newEntry.getPrincipal().getName();
        if (principalName == null) {
            throw new EUnknownPrincipal("Invalid principal");
        }
        Vector<RoutingUserAclEntry> acls = this.m_routingUserACLEntries.get(nodeName);
        if (acls != null) {
            int len = acls.size();
            RoutingUserAclEntry ruae = null;
            boolean match = false;
            int i = 0;
            for (i = 0; i < len; ++i) {
                ruae = acls.elementAt(i);
                if (!ruae.getPrincipal().getName().equalsIgnoreCase(principalName)) continue;
                match = true;
                break;
            }
            if (match && ruae != null) {
                acls.removeElementAt(i);
                ruae = null;
            }
        }
        return new NewRoutingUserAclEntryEvent(this.m_parent, this.m_startTime, this.m_vtime + 1, nodeName, newEntry);
    }

    final void processNewRoutingUserAclEntryEvent(NewRoutingUserAclEntryEvent evt) {
        String nodeName = evt.getSubject();
        Vector<RoutingUserAclEntry> acls = this.m_routingUserACLEntries.get(nodeName);
        if (acls == null) {
            acls = new Vector();
            this.m_routingUserACLEntries.put(nodeName, acls);
        }
        RoutingUserAclEntry ruae = evt.getAcl();
        acls.addElement(ruae);
    }

    final SecurityEvent prepareSetAclEntryEvent(String subject, SubjectAclEntry newEntry) throws EUnknownPrincipal {
        ProgressPrincipal p = null;
        String principalName = newEntry.getPrincipal().getName();
        Principal p1 = newEntry.getPrincipal();
        if (p1 instanceof ProgressPrincipal) {
            p = (ProgressPrincipal)p1;
        }
        if (p == null) {
            p = this.m_principals.get(principalName);
        }
        if (p == null) {
            throw new EUnknownPrincipal(principalName);
        }
        newEntry = newEntry.copyForPrincipal(p);
        Vector<SubjectAclEntry> acls = this.m_subjectACLEntries.get(subject);
        if (acls != null && acls.contains(newEntry)) {
            return new UpdateAclEntryEvent(this.m_parent, this.m_startTime, this.m_vtime + 1, subject, acls.elementAt(acls.indexOf(newEntry)), newEntry);
        }
        return new NewAclEntryEvent(this.m_parent, this.m_startTime, this.m_vtime + 1, subject, newEntry);
    }

    final void processNewAclEntryEvent(NewAclEntryEvent evt) {
        String subject = evt.getSubject();
        Vector<SubjectAclEntry> acls = this.m_subjectACLEntries.get(subject);
        if (acls == null) {
            acls = new Vector();
            this.m_subjectACLEntries.put(subject, acls);
        }
        SubjectAclEntry sae = evt.getAclEntry();
        ((ProgressPrincipal)sae.getPrincipal()).addAclSubject(subject);
        acls.addElement(sae);
    }

    final void processUpdateAclEntryEvent(UpdateAclEntryEvent evt) {
        SubjectAclEntry newEntry = evt.getNewEntry();
        String principalName = newEntry.getPrincipal().getName();
        byte pos = newEntry.getPosPermissions();
        byte neg = newEntry.getNegPermissions();
        try {
            if (pos != 0) {
                evt.getAclEntry().addPermission(pos, true);
            } else {
                evt.getAclEntry().addPermission(neg, true);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String msg = prAccessor.getString("STR141");
            Object[] ob = new Object[]{principalName, ex};
            throw new EAssertFailure(MessageFormat.format(msg, ob), ex);
        }
    }

    final DelAclEntryEvent prepareDelAclEntryEvent(String subject, Principal principal) {
        SubjectAclEntry dummyAcl;
        Vector<SubjectAclEntry> acls;
        SubjectAclEntry sae = null;
        String principalName = principal.getName();
        ProgressPrincipal p = null;
        if (principal instanceof ProgressPrincipal) {
            p = (ProgressPrincipal)principal;
        }
        if (p == null) {
            p = this.m_principals.get(principalName);
        }
        if (p != null && (acls = this.m_subjectACLEntries.get(subject)) != null && acls.contains(dummyAcl = new SubjectAclEntry(p))) {
            sae = acls.elementAt(acls.indexOf(dummyAcl));
        }
        if (sae != null) {
            return new DelAclEntryEvent(this.m_parent, this.m_startTime, this.m_vtime + 1, subject, sae, null);
        }
        return null;
    }

    final DelAclEntryEvent prepareDelAclEntryEvent(String subject, SubjectAclEntry delEntry) throws EUnknownPrincipal {
        Object sae = null;
        ProgressPrincipal p = null;
        String principalName = delEntry.getPrincipal().getName();
        Principal p1 = delEntry.getPrincipal();
        if (p1 instanceof ProgressPrincipal) {
            p = (ProgressPrincipal)p1;
        }
        if (p == null) {
            p = this.m_principals.get(principalName);
        }
        if (p == null) {
            throw new EUnknownPrincipal(principalName);
        }
        delEntry = delEntry.copyForPrincipal(p);
        Vector<SubjectAclEntry> acls = this.m_subjectACLEntries.get(subject);
        if (acls != null && acls.contains(delEntry)) {
            return new DelAclEntryEvent(this.m_parent, this.m_startTime, this.m_vtime + 1, subject, acls.elementAt(acls.indexOf(delEntry)), delEntry);
        }
        return null;
    }

    final void processDelAclEntryEvent(DelAclEntryEvent evt) {
        SubjectAclEntry delEntry = evt.getDelEntry();
        if (delEntry != null) {
            String principalName = delEntry.getPrincipal().getName();
            byte pos = delEntry.getPosPermissions();
            byte neg = delEntry.getNegPermissions();
            try {
                if (pos != 0) {
                    evt.getAclEntry().removePermission(pos);
                } else {
                    evt.getAclEntry().removePermission(neg);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                String msg = prAccessor.getString("STR141");
                Object[] ob = new Object[]{principalName, ex};
                throw new EAssertFailure(MessageFormat.format(msg, ob), ex);
            }
        }
        if (delEntry == null || evt.getAclEntry().isEmpty()) {
            String subject = evt.getSubject();
            ProgressPrincipal p = (ProgressPrincipal)evt.getAclEntry().getPrincipal();
            Vector<SubjectAclEntry> acls = this.m_subjectACLEntries.get(subject);
            acls.removeElement(evt.getAclEntry());
            if (acls.isEmpty()) {
                this.m_subjectACLEntries.remove(subject);
            }
            p.removeAclSubject(subject);
        }
    }

    final DelRoutingUserAclEntryEvent prepareDelRoutingUserAclEntryEvent(String nodeName, Principal principal) {
        String principalName = principal.getName();
        Vector<RoutingUserAclEntry> acls = this.m_routingUserACLEntries.get(nodeName);
        if (acls != null) {
            int len = acls.size();
            RoutingUserAclEntry ruae = null;
            boolean match = false;
            int i = 0;
            for (i = 0; i < len; ++i) {
                ruae = acls.elementAt(i);
                if (!ruae.getPrincipal().getName().equals(principalName)) continue;
                match = true;
                break;
            }
            if (match && ruae != null) {
                return new DelRoutingUserAclEntryEvent(this.m_parent, this.m_startTime, this.m_vtime + 1, nodeName, ruae);
            }
        }
        return null;
    }

    final void processDelRoutingUserAclEntryEvent(DelRoutingUserAclEntryEvent evt) {
        Vector<RoutingUserAclEntry> acls;
        String nodeName = evt.getSubject();
        ProgressPrincipal p = (ProgressPrincipal)evt.getAcl().getPrincipal();
        if (p != null && (acls = this.m_routingUserACLEntries.get(nodeName)) != null) {
            int len = acls.size();
            RoutingUserAclEntry ruae = null;
            boolean match = false;
            int i = 0;
            for (i = 0; i < len; ++i) {
                ruae = acls.elementAt(i);
                if (!ruae.getPrincipal().getName().equalsIgnoreCase(p.getName())) continue;
                match = true;
                break;
            }
            if (match && ruae != null) {
                acls.removeElementAt(i);
                if (acls.isEmpty()) {
                    this.m_routingUserACLEntries.remove(nodeName);
                }
            }
        }
    }

    final SecurityEvent prepareSetUserEvent(ProgressPasswordUser user) throws EPrincipalExists, EPrincipalConflict, EDatabaseException {
        ProgressPrincipal p = this.m_principals.get(user.getName());
        if (p instanceof ProgressGroup) {
            throw new EPrincipalExists(user.getName());
        }
        if (p == null) {
            String userName = user.getName();
            if (this.m_parent.isUserConflict(userName)) {
                throw new EPrincipalConflict(userName);
            }
            SecurityEvent[] subevts = new SecurityEvent[3];
            subevts[0] = new AddGroupMemberEvent(this.m_parent, this.m_startTime, this.m_vtime + 1, (ProgressGroup)this.getPrincipal("PUBLIC"), user);
            try {
                SubjectAclEntry sae = new SubjectAclEntry(user);
                sae.addPermission((byte)1);
                subevts[1] = new NewAclEntryEvent(this.m_parent, this.m_startTime, this.m_vtime + 1, "$ISYS.admin." + user.getName(), sae);
                sae = new SubjectAclEntry(user);
                sae.addPermission((byte)2);
                subevts[2] = new NewAclEntryEvent(this.m_parent, this.m_startTime, this.m_vtime + 1, "$ISYS.USERS.*." + user.getName(), sae);
            }
            catch (ESecuritySemanticsViolation e) {
                String mf287 = prAccessor.getString("STR105");
                Object[] ob287 = new Object[]{userName, e};
                throw new EAssertFailure(MessageFormat.format(mf287, ob287), e);
            }
            return new NewUserEvent(this.m_parent, this.m_startTime, this.m_vtime + 1, user, subevts);
        }
        return new UpdateUserEvent(this.m_parent, this.m_startTime, this.m_vtime + 1, (ProgressPasswordUser)p, user);
    }

    final void processNewUserEvent(NewUserEvent evt) {
        ProgressPasswordUser u = evt.getUser();
        this.m_principals.put(u.getName(), u);
        SecurityEvent[] subevts = evt.getSubevents();
        for (int i = 0; i < subevts.length; ++i) {
            subevts[i].callProcessMethod(this);
        }
    }

    final void processUpdateUserEvent(UpdateUserEvent evt) {
        evt.getUser().setPasswordHash(evt.getNewUser().getTestPattern());
        evt.getUser().setRoutingNodeName(evt.getNewUser().getRoutingNodeName());
    }

    final NewGroupEvent prepareNewGroupEvent(String name) throws EPrincipalExists {
        if (this.m_principals.get(name) != null) {
            throw new EPrincipalExists(name);
        }
        return new NewGroupEvent(this.m_parent, this.m_startTime, this.m_vtime + 1, new ProgressGroup(name));
    }

    final void processNewGroupEvent(NewGroupEvent evt) {
        ProgressGroup g = evt.getGroup();
        this.m_principals.put(g.getName(), g);
    }

    final DelPrincipalEvent prepareDelPrincipalEvent(String name) {
        ProgressPrincipal p = this.m_principals.get(name);
        if (p == null) {
            return null;
        }
        return new DelPrincipalEvent(this.m_parent, this.m_startTime, this.m_vtime + 1, p, (Vector)p.getAclSubjects().clone());
    }

    final void processDelPrincipalEvent(DelPrincipalEvent evt) {
        ProgressPrincipal p = evt.getPrincipal();
        Vector aclsubs = evt.getDeletedAclSubjects();
        int numsubs = aclsubs.size();
        for (int i = 0; i < numsubs; ++i) {
            DelAclEntryEvent daee = this.prepareDelAclEntryEvent((String)aclsubs.elementAt(i), p);
            if (daee == null) continue;
            daee.callProcessMethod(this);
        }
        if (p instanceof ProgressPasswordUser) {
            ProgressPasswordUser u = (ProgressPasswordUser)p;
            Vector groups = (Vector)u.getGroups().clone();
            for (int i = groups.size() - 1; i >= 0; --i) {
                try {
                    RemoveGroupMemberEvent rgme = this.prepareRemoveGroupMemberEvent(((ProgressGroup)groups.elementAt(i)).getName(), u.getName());
                    rgme.callProcessMethod(this);
                    continue;
                }
                catch (EUnknownPrincipal e) {
                    BrokerComponent.getComponentContext().logMessage(prAccessor.getString("STR106") + u.getName() + prAccessor.getString("STR107") + ((ProgressGroup)groups.elementAt(i)).getName() + ": " + e.getMessage(), (Throwable)e, 2);
                }
            }
        } else if (p instanceof ProgressGroup) {
            ProgressGroup g = (ProgressGroup)p;
            Enumeration users = g.members();
            while (users.hasMoreElements()) {
                ((ProgressPasswordUser)users.nextElement()).getGroups().removeElement(g);
            }
        }
        this.m_principals.remove(p.getName());
    }

    final AddGroupMemberEvent prepareAddGroupMemberEvent(String groupname, String username) throws EUnknownPrincipal {
        ProgressGroup g = null;
        ProgressPasswordUser u = null;
        try {
            g = (ProgressGroup)this.m_principals.get(groupname);
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        if (g == null) {
            String mf403 = prAccessor.getString("STR108");
            Object[] ob403 = new Object[]{groupname};
            throw new EUnknownPrincipal(MessageFormat.format(mf403, ob403));
        }
        try {
            u = (ProgressPasswordUser)this.m_principals.get(username);
            if (u == null && username.indexOf(".") != -1) {
                String s = username.replace('.', '$');
                u = (ProgressPasswordUser)this.m_principals.get(s);
            }
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        if (u == null) {
            if ((BrokerComponent.getBrokerComponent().getTraceMask() & 0x80) > 0) {
                Object[] obj = new Object[]{username.replace('$', '.'), groupname};
                String s = prMessageFormat.format(progress.message.broker.prAccessor.getString("STR358"), obj);
                BrokerComponent.getComponentContext().logMessage(s, 7);
            }
            u = new ProgressPasswordUser(username, "");
            u.setInternalPrincipal(false);
            u.setExternalGroups(null);
        }
        if (u == null) {
            String mf409 = prAccessor.getString("STR109");
            Object[] ob409 = new Object[]{username};
            String error = MessageFormat.format(mf409, ob409);
            throw new EUnknownPrincipal(error);
        }
        return new AddGroupMemberEvent(this.m_parent, this.m_startTime, this.m_vtime + 1, g, u);
    }

    final void processAddGroupMemberEvent(AddGroupMemberEvent evt) {
        ProgressGroup g = evt.getGroup();
        ProgressPasswordUser u = evt.getUser();
        g.addMember(u);
        u.addGroup(g);
    }

    final RemoveGroupMemberEvent prepareRemoveGroupMemberEvent(String groupname, String username) throws EUnknownPrincipal {
        ProgressGroup g = null;
        ProgressPasswordUser u = null;
        try {
            g = (ProgressGroup)this.m_principals.get(groupname);
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        if (g == null) {
            String mf434 = prAccessor.getString("STR110");
            Object[] ob434 = new Object[]{groupname};
            throw new EUnknownPrincipal(MessageFormat.format(mf434, ob434));
        }
        try {
            u = (ProgressPasswordUser)this.m_principals.get(username);
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        if (u == null) {
            u = new ProgressPasswordUser(username, "");
            u.setInternalPrincipal(false);
            u.setCreatedDueToACLEntry(true);
            u.setExternalGroups(null);
            if (!g.isMember(u)) {
                u = null;
            }
        }
        if (u == null) {
            String mf440 = prAccessor.getString("STR111");
            Object[] ob440 = new Object[]{username};
            throw new EUnknownPrincipal(MessageFormat.format(mf440, ob440));
        }
        return new RemoveGroupMemberEvent(this.m_parent, this.m_startTime, this.m_vtime + 1, g, u);
    }

    final void processRemoveGroupMemberEvent(RemoveGroupMemberEvent evt) {
        ProgressGroup g = evt.getGroup();
        ProgressPasswordUser u = evt.getUser();
        g.removeMember(u);
        u.removeGroup(g);
    }

    final SecDBReinitEvent prepareSecDBReinitEvent() {
        return new SecDBReinitEvent(null, 0L, 0, this.m_subjectACLEntries, this.m_qops);
    }

    final boolean processEvent(SecurityEvent evt) {
        if (evt.getStartTime() != this.m_startTime) {
            return false;
        }
        int evttime = evt.getVTime();
        if (evttime <= this.m_vtime) {
            return false;
        }
        if (evttime > this.m_vtime + 1) {
            BrokerComponent.getComponentContext().logMessage(prAccessor.getString("STR112") + evttime + " (expected " + (this.m_vtime + 1) + ")", 2);
        }
        this.m_vtime = evttime;
        evt.callProcessMethod(this);
        return true;
    }

    public final Hashtable<String, Vector<SubjectAclEntry>> getSubjectACLEntries() {
        return this.m_subjectACLEntries;
    }

    public final Hashtable<String, Vector<RoutingUserAclEntry>> getRoutingUserACLEntries() {
        return this.m_routingUserACLEntries;
    }

    public boolean updateExternalUsers(String[] uids) throws ConnectionException {
        try {
            IAuthentication aspi = AgentRegistrar.getAuthenticationSPI();
            if (aspi == null) {
                return false;
            }
            if (uids == null || uids.length == 0) {
                uids = this.getExternalUsers();
            }
            for (int i = 0; i < uids.length; ++i) {
                uids[i] = uids[i].replace('$', '.');
            }
            IPasswordUser[] users = aspi.updateUserInfo(uids);
            if (users != null) {
                for (int i = 0; i < users.length; ++i) {
                    IPasswordUser user = users[i];
                    if (user == null) continue;
                    ProgressPasswordUser p = new ProgressPasswordUser(user.getName().replace('.', '$'), user.getPassword());
                    p.setInternalPrincipal(false);
                    String[] externalGroup = user.getGroups();
                    if (externalGroup != null) {
                        ArrayList<String> g = new ArrayList<String>();
                        for (int j = 0; j < externalGroup.length; ++j) {
                            g.add(externalGroup[j]);
                        }
                        p.setExternalGroups(g);
                    }
                    AgentRegistrar.getAgentRegistrar().processExternalUsersAndGroupMap(p);
                }
            }
            return true;
        }
        catch (ConnectionException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ConnectionException(e.getMessage());
        }
    }

    public String[] getExternalUsers() throws ConnectionException {
        ArrayList<String> externalUsers = new ArrayList<String>();
        Enumeration<ProgressPrincipal> entries = this.m_principals.elements();
        if (entries != null) {
            while (entries.hasMoreElements()) {
                ProgressPasswordUser p;
                ProgressPrincipal element = entries.nextElement();
                if (element == null || !(element instanceof ProgressPasswordUser) || (p = (ProgressPasswordUser)element).isInternalPrincipal()) continue;
                externalUsers.add(p.getName());
            }
        }
        String[] users = new String[externalUsers.size()];
        externalUsers.toArray(users);
        return users;
    }
}

