/*
 * Decompiled with CFR 0.152.
 */
package progress.message.strm;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import progress.message.net.ISocket;
import progress.message.strm.StrmCommon;
import progress.message.strm.util.BufferedStrmInputStream;
import progress.message.strm.util.BufferedStrmOutputStream;
import progress.message.strm.v1.StreamSegment;
import progress.message.util.EAssertFailure;

public class StreamFactory {
    public static InputStream getListenerInputStream(ISocket socket, int maxBufSize, int minBufSize, int initialBufSize, boolean configureForSegments) throws IOException {
        if (!configureForSegments) {
            return socket.getInputStream(maxBufSize, minBufSize, initialBufSize);
        }
        return new BufferedStrmInputStream(socket.getInputStream(), maxBufSize);
    }

    public static OutputStream getSenderOutputStream(ISocket socket, int maxBufSize, int minBufSize, int initialBufSize, boolean configureForSegments) throws IOException {
        if (!configureForSegments) {
            return socket.getOutputStream(maxBufSize, minBufSize, initialBufSize);
        }
        return new BufferedStrmOutputStream(socket.getOutputStream(), maxBufSize);
    }

    public static InputStream setupSegmentedStream(InputStream is, byte streamVersion, byte streamFlags, ISocket socket, int maxBufSize, int minBufSize, int initialBufSize) throws IOException {
        if (streamVersion == 0) {
            if (is instanceof BufferedStrmInputStream) {
                BufferedStrmInputStream bis = (BufferedStrmInputStream)is;
                byte bisVersion = bis.getStreamVersion();
                if (bisVersion == 0) {
                    return bis.convertToUnsegmentedStream(socket, maxBufSize, minBufSize, initialBufSize);
                }
                throw new EAssertFailure("Can't convert Stream to version 0; stream version= " + bisVersion);
            }
            return is;
        }
        if (streamVersion == 1) {
            if (!(is instanceof BufferedStrmInputStream)) {
                throw new EAssertFailure("Can't convert " + is.getClass().getName() + " to SegmentedStream ");
            }
            BufferedStrmInputStream bis = (BufferedStrmInputStream)is;
            byte bisVersion = bis.getStreamVersion();
            if (bisVersion == 1) {
                return is;
            }
            if (bisVersion != 0) {
                throw new EAssertFailure("Can't convert Stream to version 1; stream version= " + bisVersion);
            }
            StreamSegment segi = new StreamSegment(streamFlags);
            int crctype = StrmCommon.getCRCType(streamFlags);
            if (crctype == 2) {
                throw new EAssertFailure("Unsupported crctype " + crctype);
            }
            bis.convertToSegmentedStream(segi);
            return is;
        }
        throw new EAssertFailure("Unsupported version " + streamVersion);
    }

    public static OutputStream setupSegmentedStream(OutputStream os, byte streamVersion, byte streamFlags, ISocket socket, int maxBufSize, int minBufSize, int initialBufSize) throws IOException {
        if (streamVersion == 0) {
            if (os instanceof BufferedStrmOutputStream) {
                BufferedStrmOutputStream bos = (BufferedStrmOutputStream)os;
                byte bosVersion = bos.getStreamVersion();
                if (bosVersion == 0) {
                    return bos.convertToUnsegmentedStream(socket, maxBufSize, minBufSize, initialBufSize);
                }
                throw new EAssertFailure("Can't convert Stream to version 0; stream version= " + bosVersion);
            }
            return os;
        }
        if (streamVersion == 1) {
            if (!(os instanceof BufferedStrmOutputStream)) {
                throw new EAssertFailure("Can't convert " + os.getClass().getName() + " to SegmentedStream ");
            }
            BufferedStrmOutputStream bos = (BufferedStrmOutputStream)os;
            byte bosVersion = bos.getStreamVersion();
            if (bosVersion == 1) {
                return os;
            }
            if (bosVersion != 0) {
                throw new EAssertFailure("Can't convert Stream to version 1; stream version= " + bosVersion);
            }
            StreamSegment sego = new StreamSegment(streamFlags);
            int crctype = StrmCommon.getCRCType(streamFlags);
            if (crctype == 2) {
                throw new EAssertFailure("Unsupported crctype " + crctype);
            }
            bos.convertToSegmentedStream(sego);
            return os;
        }
        throw new EAssertFailure("Unsupported version " + streamVersion);
    }

    public static boolean supportsStream(byte streamVersion, byte streamFlags) {
        if (streamVersion <= 1) {
            int crctype = StrmCommon.getCRCType(streamFlags);
            return crctype == 0 || crctype == 1;
        }
        return false;
    }
}

