/*
 * Decompiled with CFR 0.152.
 */
package progress.message.util;

import java.io.IOException;
import java.io.OutputStream;
import progress.message.util.EAssertFailure;

public final class ArrayUtil {
    private static final int ZEROES_LEN = 500;
    private static byte[] zeroes = new byte[500];

    private ArrayUtil() {
    }

    public static void clear(byte[] buf) {
        ArrayUtil.clear(buf, 0, buf.length);
    }

    public static void clear(byte[] buf, int offset, int length) {
        if (length <= 500) {
            System.arraycopy(zeroes, 0, buf, offset, length);
        } else {
            System.arraycopy(zeroes, 0, buf, offset, 500);
            int halflength = length / 2;
            for (int i = 500; i < length; i += i) {
                System.arraycopy(buf, offset, buf, offset + i, i <= halflength ? i : length - i);
            }
        }
    }

    public static final double readDouble(byte[] b, int offset) {
        return Double.longBitsToDouble(ArrayUtil.readLong(b, offset));
    }

    public static final float readFloat(byte[] b, int offset) {
        return Float.intBitsToFloat(ArrayUtil.readInt(b, offset));
    }

    public static final long readLong(byte[] b, int offset) {
        long retValue = ((long)b[offset++] & 0xFFL) << 56;
        retValue |= ((long)b[offset++] & 0xFFL) << 48;
        retValue |= ((long)b[offset++] & 0xFFL) << 40;
        retValue |= ((long)b[offset++] & 0xFFL) << 32;
        retValue |= ((long)b[offset++] & 0xFFL) << 24;
        retValue |= ((long)b[offset++] & 0xFFL) << 16;
        retValue |= ((long)b[offset++] & 0xFFL) << 8;
        return retValue |= (long)b[offset] & 0xFFL;
    }

    public static void writeLong(byte[] b, int offset, long value) {
        b[offset++] = (byte)(value >>> 56);
        b[offset++] = (byte)(value >>> 48);
        b[offset++] = (byte)(value >>> 40);
        b[offset++] = (byte)(value >>> 32);
        b[offset++] = (byte)(value >>> 24);
        b[offset++] = (byte)(value >>> 16);
        b[offset++] = (byte)(value >>> 8);
        b[offset] = (byte)value;
    }

    public static final int readInt(byte[] b, int offset) {
        int retValue = (b[offset] & 0xFF) << 24;
        retValue |= (b[++offset] & 0xFF) << 16;
        retValue |= (b[++offset] & 0xFF) << 8;
        return retValue |= b[++offset] & 0xFF;
    }

    public static void writeInt(byte[] b, int offset, int value) {
        b[offset++] = (byte)(value >>> 24);
        b[offset++] = (byte)(value >>> 16);
        b[offset++] = (byte)(value >>> 8);
        b[offset] = (byte)value;
    }

    public static final char readChar(byte[] b, int offset) {
        byte ch1 = b[offset++];
        byte ch2 = b[offset];
        return (char)((ch1 << 8) + (ch2 << 0));
    }

    public static final long read6ByteLong(byte[] b, int offset) {
        long retValue = ((long)b[offset++] & 0xFFL) << 40;
        retValue |= ((long)b[offset++] & 0xFFL) << 32;
        retValue |= ((long)b[offset++] & 0xFFL) << 24;
        retValue |= ((long)b[offset++] & 0xFFL) << 16;
        retValue |= ((long)b[offset++] & 0xFFL) << 8;
        return retValue |= (long)b[offset] & 0xFFL;
    }

    public static final int getUTFStringLength(byte[] buffer, int offset) {
        int len = (buffer[offset++] & 0xFF) << 8 | buffer[offset++] & 0xFF;
        return len + 2;
    }

    public static int getObjectSize(byte[] buffer, int offset) {
        byte type = buffer[offset];
        ++offset;
        int result = 1;
        switch (type) {
            case 0: {
                ++result;
                break;
            }
            case 1: {
                ++result;
                break;
            }
            case 9: {
                int length = ArrayUtil.readInt(buffer, offset);
                result += length + 4;
                break;
            }
            case 3: {
                ++result;
                break;
            }
            case 7: {
                result += 8;
                break;
            }
            case 6: {
                result += 4;
                break;
            }
            case 4: {
                result += 4;
                break;
            }
            case 5: {
                result += 8;
                break;
            }
            case 2: {
                result += 2;
                break;
            }
            case 8: {
                result += ArrayUtil.getUTFStringLength(buffer, offset);
                break;
            }
            case 10: 
            case 11: {
                result += 0;
                break;
            }
            default: {
                throw new EAssertFailure("Unexpected type code found in stream");
            }
        }
        return result;
    }

    public static Object readObject(byte[] buffer, int offset) {
        byte type = buffer[offset];
        ++offset;
        switch (type) {
            case 0: {
                return new Boolean(buffer[offset] != 0);
            }
            case 1: {
                return new Byte(buffer[offset]);
            }
            case 9: {
                int length = ArrayUtil.readInt(buffer, offset);
                byte[] value = new byte[length];
                System.arraycopy(buffer, offset += 4, value, 0, length);
                return value;
            }
            case 3: {
                return new Character(ArrayUtil.readChar(buffer, offset));
            }
            case 7: {
                return new Double(ArrayUtil.readDouble(buffer, offset));
            }
            case 6: {
                return new Float(ArrayUtil.readFloat(buffer, offset));
            }
            case 4: {
                return new Integer(ArrayUtil.readInt(buffer, offset));
            }
            case 5: {
                return new Long(ArrayUtil.readLong(buffer, offset));
            }
            case 2: {
                return new Short(ArrayUtil.readShort(buffer, offset));
            }
            case 8: {
                return ArrayUtil.getUTFString(buffer, offset);
            }
            case 10: 
            case 11: {
                return "";
            }
        }
        throw new EAssertFailure("Unexpected type code found in stream");
    }

    public static void write6ByteLong(byte[] b, int offset, long value) {
        b[offset++] = (byte)(value >>> 40);
        b[offset++] = (byte)(value >>> 32);
        b[offset++] = (byte)(value >>> 24);
        b[offset++] = (byte)(value >>> 16);
        b[offset++] = (byte)(value >>> 8);
        b[offset] = (byte)value;
    }

    public static short readShort(byte[] b, int offset) {
        int retValue = b[offset++] << 8;
        return (short)(retValue |= b[offset] & 0xFF);
    }

    public static void writeShort(byte[] b, int offset, short value) {
        b[offset++] = (byte)(value >>> 8);
        b[offset] = (byte)value;
    }

    public static String getString(byte[] b, int offset) {
        int len = (b[offset++] & 0xFF) << 8 | b[offset] & 0xFF;
        return new String(b, offset + 1, len);
    }

    public static String getUTFString(byte[] b, int offset) {
        int utflen = (b[offset++] & 0xFF) << 8 | b[offset] & 0xFF;
        int pos = offset + 1;
        char[] str = new char[utflen];
        int count = 0;
        int strlen = 0;
        block5: while (count < utflen) {
            int c = b[pos++] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    str[strlen++] = (char)c;
                    continue block5;
                }
                case 12: 
                case 13: {
                    int char2;
                    if ((count += 2) > utflen) {
                        throw new EAssertFailure("Unexpected UTF format found in stream");
                    }
                    if (((char2 = b[pos++] & 0xFF) & 0xC0) != 128) {
                        throw new EAssertFailure("Unexpected UTF format found in stream");
                    }
                    str[strlen++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    continue block5;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new EAssertFailure("Unexpected UTF format found in stream");
                    }
                    int char2 = b[pos++] & 0xFF;
                    int char3 = b[pos++] & 0xFF;
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new EAssertFailure("Unexpected UTF format found in stream");
                    }
                    str[strlen++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    continue block5;
                }
            }
            throw new EAssertFailure("Unexpected UTF found in stream");
        }
        return new String(str, 0, strlen);
    }

    public static String getHexString(byte[] b) {
        if (b == null) {
            return null;
        }
        String ret = "";
        for (int i = 0; i < b.length; ++i) {
            ret = ret + ArrayUtil.getHexChar(b[i]) + " ";
        }
        return ret;
    }

    public static String getHexString(int[] array) {
        if (array == null) {
            return null;
        }
        String ret = "";
        for (int i = 0; i < array.length; ++i) {
            ret = ret + Integer.toHexString(array[i]) + " ";
        }
        return ret;
    }

    public static String getHexChar(byte b) {
        return ArrayUtil.getHexCharInternal((byte)(b >> 4)) + ArrayUtil.getHexCharInternal(b);
    }

    private static String getHexCharInternal(byte b) {
        switch (b & 0xF) {
            case 0: {
                return "0";
            }
            case 1: {
                return "1";
            }
            case 2: {
                return "2";
            }
            case 3: {
                return "3";
            }
            case 4: {
                return "4";
            }
            case 5: {
                return "5";
            }
            case 6: {
                return "6";
            }
            case 7: {
                return "7";
            }
            case 8: {
                return "8";
            }
            case 9: {
                return "9";
            }
            case 10: {
                return "A";
            }
            case 11: {
                return "B";
            }
            case 12: {
                return "C";
            }
            case 13: {
                return "D";
            }
            case 14: {
                return "E";
            }
            case 15: {
                return "F";
            }
        }
        return "?";
    }

    public static int toInt(short s0, short s1) {
        return s0 & 0xFFFF | s1 << 16;
    }

    public static byte[] IntToByte(int[] addr) {
        byte[] RetAddr = new byte[4 * addr.length + 2];
        ArrayUtil.writeShort(RetAddr, 0, (short)addr.length);
        for (int i = 0; i < addr.length; ++i) {
            ArrayUtil.writeInt(RetAddr, i * 4 + 2, addr[i]);
        }
        return RetAddr;
    }

    public static short toShort(byte b0, byte b1) {
        return (short)(b0 & 0xFF | b1 << 8);
    }

    public static byte[] toBytes(int n) {
        byte[] buf = new byte[4];
        ArrayUtil.writeInt(buf, 0, n);
        return buf;
    }

    public static byte[] toBytes(short[] array, int offset, int length) {
        byte[] buf = new byte[2 * length];
        int j = 0;
        for (int i = offset; i < offset + length; ++i) {
            buf[j++] = (byte)(array[i] >>> 8 & 0xFF);
            buf[j++] = (byte)(array[i] & 0xFF);
        }
        return buf;
    }

    public static byte[] toBytes(short[] array) {
        return ArrayUtil.toBytes(array, 0, array.length);
    }

    public static short[] toShorts(byte[] array, int offset, int length) {
        short[] buf = new short[length / 2];
        int j = 0;
        for (int i = offset; i < offset + length - 1; i += 2) {
            buf[j++] = (short)((array[i] & 0xFF) << 8 | array[i + 1] & 0xFF);
        }
        return buf;
    }

    public static short[] toShorts(byte[] array) {
        return ArrayUtil.toShorts(array, 0, array.length);
    }

    public static boolean areEqual(byte[] a, byte[] b) {
        int aLength = a.length;
        if (aLength != b.length) {
            return false;
        }
        for (int i = 0; i < aLength; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean areEqual(int[] a, int[] b) {
        int aLength = a.length;
        if (aLength != b.length) {
            return false;
        }
        for (int i = 0; i < aLength; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public static int compared(byte[] a, byte[] b, boolean msbFirst) {
        int aLength = a.length;
        if (aLength < b.length) {
            return -1;
        }
        if (aLength > b.length) {
            return 1;
        }
        if (msbFirst) {
            for (int i = aLength - 1; i >= 0; --i) {
                int b1 = a[i] & 0xFF;
                int b2 = b[i] & 0xFF;
                if (b1 < b2) {
                    return -1;
                }
                if (b1 <= b2) continue;
                return 1;
            }
        } else {
            for (int i = 0; i < aLength; ++i) {
                int b1 = a[i] & 0xFF;
                int b2 = b[i] & 0xFF;
                if (b1 < b2) {
                    return -1;
                }
                if (b1 <= b2) continue;
                return 1;
            }
        }
        return 0;
    }

    public static boolean isText(byte[] buffer) {
        int len = buffer.length;
        if (len == 0) {
            return false;
        }
        block3: for (int i = 0; i < len; ++i) {
            int c = buffer[i] & 0xFF;
            if (c >= 32 && c <= 127) continue;
            switch (c) {
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 26: 
                case 27: 
                case 155: {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public static final ArrayUtilOutputStream getOutputStream(byte[] array, int offset) {
        return new ArrayUtilOutputStream(array, offset);
    }

    public static final class ArrayUtilOutputStream
    extends OutputStream {
        private int m_offset = 0;
        private int m_count = 0;
        private byte[] m_array = null;

        public ArrayUtilOutputStream(byte[] array, int offset) {
            this.m_array = array;
            this.m_offset = offset;
        }

        @Override
        public final void write(int data) throws IOException {
            try {
                this.m_array[this.m_offset + this.m_count] = (byte)data;
            }
            catch (Exception ex) {
                throw new IOException(ex.getMessage());
            }
            ++this.m_count;
        }

        @Override
        public final void write(byte[] source) throws IOException {
            try {
                System.arraycopy(source, 0, this.m_array, this.m_offset + this.m_count, source.length);
            }
            catch (Exception ex) {
                throw new IOException(ex.getMessage());
            }
            this.m_count += source.length;
        }

        @Override
        public final void write(byte[] source, int offset, int length) throws IOException {
            try {
                System.arraycopy(source, offset, this.m_array, this.m_offset + this.m_count, length);
            }
            catch (Exception ex) {
                throw new IOException(ex.getMessage());
            }
            this.m_count += length;
        }

        public final int getCount() {
            return this.m_count;
        }

        @Override
        public final void flush() throws IOException {
        }

        @Override
        public final void close() throws IOException {
        }
    }
}

