/*
 * Decompiled with CFR 0.152.
 */
package progress.message.util;

import java.util.StringTokenizer;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.SubjectUtil;

public abstract class QueueUtil {
    public static final String QROOT = "$Q.";
    public static final String SYS_QUEUE_PREFIX = "SonicMQ.";
    public static final String TEMP_QUEUE_QUALIFIER = "TemporaryQueues";
    public static final String TEMP_QUEUE_PREFIX = "$ISYS.USERS.TemporaryQueues.";
    public static final String SETQUEUE = ".setQueue";
    public static final String DELQUEUE = ".delQueue";
    public static final String GETQUEUES = ".getQueues";
    public static final String CLEARQUEUE = ".clearQueue";
    public static final String SETQRETRIEVETHRESHOLD = ".setQueueRetrieveThreshold";
    public static final String SETQSAVETHRESHOLD = ".setQueueSaveThreshold";
    public static final String SETMAXQUEUESIZE = ".setMaxQueueSize";
    public static final String PREFIX = SessionConfig.getAdminPrefix("*", "*");
    public static final String OPENRECEIVER = ".openReceiver";
    public static final String CLOSERECEIVER = ".closeReceiver";
    public static final String OPENBROWSER = ".openBrowser";
    public static final String CLOSEBROWSER = ".closeBrowser";
    public static final String OPENSENDER = ".openSender";
    public static final String SETTEMPQUEUE = ".setTempQueue";
    public static final String DELTEMPQUEUE = ".delTempQueue";
    public static final short RECEIVE_TYPE = 1;
    public static final short RCVNOWAIT_TYPE = 2;
    public static final short BROWSE_TYPE = 3;
    public static final int SYSTEM_QUEUE_TYPE = 0;
    public static final int ADMIN_CREATED_QUEUE_TYPE = 1;
    public static final int TEMPORARY_QUEUE_TYPE = 2;
    public static final String QUEUE_TYPE = "queueType";
    public static final String WRITE_ONLY = "writeOnly";
    public static final String WRITE_EXCLUSIVE = "writeExclusive";
    public static final String READ_ONLY = "readOnly";
    public static final String READ_EXCLUSIVE = "readExclusive";
    public static final String SAVE_THRESHOLD = "saveThreshold";
    public static final String RETRIEVE_THRESHOLD = "retrieveThreshold";
    public static final String MAX_QUEUE_SIZE = "maxQueueSize";
    public static final String GLOBAL_QUEUE = "global";
    public static final String CLUSTERED_QUEUE = "clustered";
    public static final String DEAD_MESSAGE_QUEUE_NAME = "SonicMQ.deadMessage";
    public static final String ROUTING_QUEUE_NAME = "SonicMQ.routingQueue";
    public static final String PENDING_QUEUE_NAME_PREFIX = "SonicMQ.routingQueue$";
    public static final String PENDING_QUEUE_BROWSER_SELECTOR_PREFIX = "SonicMQ.pendingQueue=";
    public static final String PENDING_QUEUE_BROWSER_PREFIX = "$PQBR$";
    public static final int ERRCODE_GENERIC = 0;
    public static final int ERRCODE_INVALID_SELECTOR = 1;
    public static final int ERRCODE_UNAUTHORIZED_CLIENT = 2;
    public static final int ERRCODE_EXCLUSIVE_QUEUE_ALREADY_OPEN = 3;
    private static final String s_queueMessageGroupSubjectPrefix = "$QSYS.messageGroup.";

    public static int[] queueNameToMatchVector(String queueName) {
        return SubjectUtil.computeMatchVector(QROOT + queueName);
    }

    public static String queueNameToSecSubject(String queueName) {
        return QROOT + queueName;
    }

    public static final String createRoutingQueueBrowserSelector(String messageSelector, String pendingQueueName) {
        String selector = messageSelector;
        if (pendingQueueName != null) {
            String pendingQueueSelector = PENDING_QUEUE_BROWSER_SELECTOR_PREFIX + pendingQueueName;
            selector = selector == null ? pendingQueueSelector : selector + " AND " + pendingQueueSelector;
        }
        return selector;
    }

    public static final String getBrowserPendingQueueName(String selector) {
        return selector.substring(selector.lastIndexOf(PENDING_QUEUE_BROWSER_SELECTOR_PREFIX) + PENDING_QUEUE_BROWSER_SELECTOR_PREFIX.length());
    }

    public static final String getBrowserMessageSelector(String selector) {
        if (selector.startsWith(PENDING_QUEUE_BROWSER_SELECTOR_PREFIX)) {
            return null;
        }
        int endIndex = selector.lastIndexOf(" AND SonicMQ.pendingQueue=");
        return selector.substring(0, endIndex);
    }

    public static String getQueueClientPrefix(String uid, String appid) {
        return "$QSYS.client." + uid + "." + appid;
    }

    public static String getQueueClientSubject(String uid, String appid, String subject) {
        return QueueUtil.getQueueClientPrefix(uid, appid) + "." + subject;
    }

    public static String getQueueMessageGroupPrefix() {
        return s_queueMessageGroupSubjectPrefix;
    }

    public static String getQueueMessageGroupSubject(String queueName, String groupName) {
        return QueueUtil.getQueueMessageGroupPrefix() + queueName + "." + groupName;
    }

    public static boolean isQueueMessageGroupSubject(String subject) {
        return subject.startsWith(s_queueMessageGroupSubjectPrefix);
    }

    public static String getQueueNameFromMessageGroupSubject(String subject) {
        String queueName = null;
        StringTokenizer tk = new StringTokenizer(subject, ".");
        if (tk.countTokens() > 2) {
            int index = 0;
            while (tk.hasMoreTokens()) {
                String token = tk.nextToken();
                if (++index != 3) continue;
                queueName = token;
                break;
            }
        }
        return queueName;
    }

    public static String getGroupNameFromMessageGroupSubject(String subject) {
        String groupName = "";
        StringTokenizer tk = new StringTokenizer(subject, ".");
        if (tk.countTokens() > 3) {
            int index = 0;
            while (tk.hasMoreTokens()) {
                String token = tk.nextToken();
                if (++index != 4) continue;
                groupName = token;
                break;
            }
        }
        return groupName;
    }
}

