/*
 * Decompiled with CFR 0.152.
 */
package progress.message.util.server;

public final class EpochClock
implements Runnable {
    private static EpochClock s_clock;
    private static boolean s_ignore;
    private Thread m_thread = new Thread("Dummy Epoch");
    private long m_julian_date;
    private long m_interval;
    private boolean m_continue = false;

    private EpochClock() {
        this(15000L);
    }

    private EpochClock(long milliseconds) {
        this.m_interval = milliseconds;
        this.m_thread.start();
        this.startEvent();
    }

    public static long getTime() {
        if (!EpochClock.s_clock.m_continue) {
            EpochClock.clockStart();
        }
        return EpochClock.s_clock.m_julian_date;
    }

    public static long getEpoch() {
        if (!EpochClock.s_clock.m_continue) {
            EpochClock.clockStart();
        }
        return EpochClock.s_clock.m_interval;
    }

    public static void setEpoch(long milliseconds) {
        if (!EpochClock.s_clock.m_continue) {
            EpochClock.clockStart();
        }
        if (EpochClock.s_clock.m_interval > 0L) {
            EpochClock.s_clock.m_interval = milliseconds;
            EpochClock.s_clock.m_thread.interrupt();
        }
    }

    public static void ignoreStopCommand(boolean ignore) {
        s_ignore = ignore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clockStop() {
        if (!s_ignore) {
            EpochClock epochClock = s_clock;
            synchronized (epochClock) {
                s_clock.stopEvent();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clockStart() {
        EpochClock epochClock = s_clock;
        synchronized (epochClock) {
            s_clock.startEvent();
        }
    }

    @Override
    public void run() {
        while (this.m_continue) {
            try {
                Thread.sleep(this.m_interval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.m_julian_date = System.currentTimeMillis();
        }
    }

    private void stopEvent() {
        this.m_continue = false;
        this.m_thread.interrupt();
    }

    private void startEvent() {
        if (this.m_continue) {
            return;
        }
        if (this.m_thread.isAlive()) {
            this.m_thread.interrupt();
        }
        this.m_thread = new Thread((Runnable)this, "Epoch");
        this.m_continue = true;
        this.m_julian_date = System.currentTimeMillis();
        this.m_thread.setDaemon(true);
        try {
            this.m_thread.start();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            // empty catch block
        }
    }

    static {
        s_ignore = false;
        s_clock = new EpochClock();
    }
}

