/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import com.sonicsw.security.pcs.AbstractCipherSuite;
import com.sonicsw.security.pcs.EInvalidCipherSuiteException;
import com.sonicsw.security.pcs.IPluggableCipherSuite;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.PrintStream;
import java.io.UTFDataFormatException;
import java.net.SocketTimeoutException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import progress.message.client.EChecksumValidationFailed;
import progress.message.client.EInauthenticBroker;
import progress.message.client.EInauthenticClient;
import progress.message.client.EIntegrityCompromised;
import progress.message.client.ESecurityGeneralException;
import progress.message.client.EUnsupportedMgramException;
import progress.message.msg.IMgram;
import progress.message.msg.IMgramConverter;
import progress.message.msg.MgramConstants;
import progress.message.msg.MgramFactory;
import progress.message.net.ISocket;
import progress.message.strm.StreamFactory;
import progress.message.util.ArrayUtil;
import progress.message.util.AutoVec;
import progress.message.util.DebugState;
import progress.message.util.EAssertFailure;
import progress.message.util.ICompressionFactory;
import progress.message.util.IDumpable;
import progress.message.util.InputStreamWrapper;
import progress.message.util.capture.CaptureBuffer;
import progress.message.util.capture.CaptureInputStream;
import progress.message.zclient.BrokerConnectParms;
import progress.message.zclient.ClientConnectHandshaker;
import progress.message.zclient.ClientConnectParms;
import progress.message.zclient.ClientData;
import progress.message.zclient.ClientSecurityContext;
import progress.message.zclient.ClientSender;
import progress.message.zclient.ConnectData;
import progress.message.zclient.Connection;
import progress.message.zclient.ConnectionContext;
import progress.message.zclient.ConnectionFailoverStateManager;
import progress.message.zclient.ConnectionFailoverStatus;
import progress.message.zclient.EClientErrorMgramReceived;
import progress.message.zclient.EMgramFormatError;
import progress.message.zclient.EMgramVersionMismatch;
import progress.message.zclient.EUnexpectedMgram;
import progress.message.zclient.Envelope;
import progress.message.zclient.FailoverRedirectData;
import progress.message.zclient.IErrorCodes;
import progress.message.zclient.IMessageProtection;
import progress.message.zclient.IPTPFlowControlHandler;
import progress.message.zclient.ISecureInputStream;
import progress.message.zclient.Job;
import progress.message.zclient.Listener;
import progress.message.zclient.MessageSorter;
import progress.message.zclient.Publication;
import progress.message.zclient.RedirectData;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.prAccessor;
import progress.message.zclient.xonce.MgramTrace;

public final class ClientListener
extends Listener
implements IErrorCodes {
    private static final String THREAD_NAME_PREFIX = "ClientListener";
    private boolean m_pingStarted = false;
    private ClientConnectHandshaker m_handshaker = null;
    private ConnectionContext m_context = null;
    private AutoVec m_connections = new AutoVec();
    private AutoVec m_msgSorters = new AutoVec();
    private IMessageProtection m_mp;
    private IPluggableCipherSuite m_pluggableCipherSuite;
    byte[] m_sessionKey;
    byte[] m_digestKey;
    private final Connection m_parentConnection;
    private byte m_brokerSessionVer = (byte)32;
    private InputStream m_is = null;
    private InputStream m_socketStream;
    private InputStreamWrapper m_compressionStreamWrapper = null;
    private ISecureInputStream m_sis = null;
    private final boolean DIAG_MGRAM_HISTORY;
    private CaptureBuffer m_cb;
    private IMgram m_mgram;
    private IMgramConverter m_converter;
    private Envelope m_tempEnv = null;

    ClientListener(Connection con) throws IOException {
        super(THREAD_NAME_PREFIX, con);
        if (this.DEBUG) {
            this.debug("constructing");
        }
        this.DIAG_MGRAM_HISTORY = (SessionConfig.DIAG_MGRAM_HISTORY || this.checkDebugFlags(8192)) && con != Connection.getAdminConnection() && SessionConfig.matchCaptureFilterToUidAppid(con.getEffectiveUid(), con.getApplicationId());
        this.m_connections.setElementAt(con, 0);
        this.m_msgSorters.setElementAt(con.getMsgSorter(), 0);
        if (this.DEBUG) {
            this.debug("constructor completed");
        }
        this.m_parentConnection = con;
        this.m_mgram = null;
    }

    public void newChannel(Connection con, int channel) {
        this.m_connections.setElementAt(con, channel);
        this.m_msgSorters.setElementAt(con.getMsgSorter(), channel);
    }

    void removeChannel(int channel) {
        this.m_connections.setElementAt(null, channel);
        this.m_msgSorters.setElementAt(null, channel);
    }

    public byte getBrokerSessionVer() {
        return this.m_brokerSessionVer;
    }

    public void setConnectionContext(ConnectionContext context) {
        this.m_context = context;
    }

    @Override
    public void threadMain() throws Exception {
        this.listenerLoop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void listenerLoop() throws Exception {
        boolean stopped = false;
        Connection connection = this.m_parentConnection;
        ISocket socket = this.m_context.getSocket();
        if (this.DEBUG) {
            this.debug("Listener thread starting ");
        }
        try {
            IMgram hello;
            IMgram m;
            int socketConnectTimeout = (int)connection.getSocketConnectTimeout();
            if (socketConnectTimeout == 0) {
                socketConnectTimeout = SessionConfig.CONNECT_RESPONSE_TIMEOUT;
            }
            socket.setSoTimeout(socketConnectTimeout);
            boolean isJMSConnection = connection.getApplicationId().indexOf("$CONNECTION$") >= 0;
            this.m_is = this.m_socketStream = StreamFactory.getListenerInputStream(socket, connection.getMaxRcvBufferSize(), connection.getMinRcvBufferSize(), connection.getInitialRcvBufferSize(), isJMSConnection);
            ICompressionFactory cf = null;
            if (isJMSConnection && (cf = connection.getCompressionFactory()) != null) {
                this.m_compressionStreamWrapper = new InputStreamWrapper(this.m_socketStream);
                this.m_is = this.m_compressionStreamWrapper;
            }
            if (this.DIAG_MGRAM_HISTORY) {
                CaptureInputStream cis = new CaptureInputStream(this.m_is, SessionConfig.LISTENER_CAPTURE_BUFFER_SIZE);
                this.m_is = cis;
                this.m_cb = cis.getCaptureBuffer();
            }
            if (isJMSConnection) {
                m = MgramFactory.getMgramFactory().buildVersionMgram(0);
                byte streamVersion = 1;
                byte streamFlags = 1;
                m.setStreamVersion(streamVersion);
                m.setStreamFlags(streamFlags);
                if (cf != null) {
                    m.setCompressionEnabled(true);
                    m.setCompressionId(cf.getCompressionID());
                    if (this.DEBUG) {
                        this.debug("Requesting compression for the connection, compression cf = " + cf.getClass().getName() + ", compression id = " + cf.getCompressionID());
                    }
                }
                m.writeMgramToStream(this.m_context.getClientSender().m_out);
                this.m_context.getClientSender().m_out.flush();
                if (this.DEBUG) {
                    this.debug("ClientListener: Sent version mgram for jms appid appid= " + connection.getApplicationId() + " " + this.m_is + " streamVersion= " + streamVersion + " streamFlags= " + streamFlags);
                }
            } else {
                this.m_context.getClientSender().send(MgramFactory.getMgramFactory().buildVersionMgram(0));
                if (this.DEBUG) {
                    this.debug("ClientListener: Sent version mgram for non jms appid= " + connection.getApplicationId() + " " + this.m_is);
                }
            }
            try {
                m = MgramFactory.getMgramFactory().createMgram(this.m_is);
                if (this.CALLBACK) {
                    this.callback(THREAD_NAME_PREFIX, 0, new Object[]{connection, m});
                }
                try {
                    this.handleVersion(m);
                }
                catch (EMgramVersionMismatch e) {
                    this.cleanup(connection);
                    connection.connectFailure(-15, m.getVersion(), socket, e);
                    return;
                }
                byte incomingVer = m.getSessionVersion();
                if (connection.isFaultToleranceEnabled() && incomingVer < 27) {
                    this.cleanup(connection);
                    connection.connectFailure(-36, 0, socket, null);
                    return;
                }
                if (this.DEBUG) {
                    this.debug("Incoming sessionVer = " + incomingVer);
                }
                this.m_brokerSessionVer = !SessionConfig.isClientSessionVersionSupported(incomingVer) ? SessionConfig.getLatestSupportedClientSessionVers() : connection.selectSessionVer(incomingVer, incomingVer);
                this.m_context.getClientSender().setSessionVer(this.m_brokerSessionVer);
                if (this.DEBUG) {
                    this.debug("Proposed sessionVer = " + this.m_brokerSessionVer);
                }
                if (cf != null && m.isCompressionEnabled()) {
                    InputStream cis = cf.getInflaterInputStream(this.m_compressionStreamWrapper.getInputStream(), connection);
                    InputStream old = this.m_compressionStreamWrapper.setInputStream(cis);
                    if (this.DEBUG) {
                        this.debug("Setting up compression for the listener - replacing " + old.getClass().getName() + " with " + cis.getClass().getName());
                    }
                } else {
                    connection.resetCompressionFactory();
                    cf = null;
                }
                if (m.hasStreamVersion()) {
                    byte streamVersion = m.getStreamVersion();
                    byte streamFlags = m.getStreamFlags();
                    if (this.DEBUG) {
                        this.debug("ClientListener: Have version response: hasStreamVersion  streamVersion= " + streamVersion + " streamFlags= " + streamFlags);
                    }
                    StreamFactory.setupSegmentedStream(this.m_socketStream, streamVersion, streamFlags, this.m_context.getSocket(), connection.getMaxRcvBufferSize(), connection.getMinRcvBufferSize(), connection.getInitialRcvBufferSize());
                    this.m_context.getClientSender().convertStream(streamVersion, streamFlags, cf);
                    if (this.DEBUG) {
                        this.debug("ClientListener: Converted to segmented stream  streamVersion= " + streamVersion + " streamFlags= " + streamFlags);
                    }
                } else {
                    StreamFactory.setupSegmentedStream(this.m_socketStream, (byte)0, (byte)0, this.m_context.getSocket(), connection.getMaxRcvBufferSize(), connection.getMinRcvBufferSize(), connection.getInitialRcvBufferSize());
                    this.m_context.getClientSender().convertStream((byte)0, (byte)0, cf);
                }
            }
            catch (EMgramVersionMismatch e) {
                if (this.DEBUG) {
                    this.debug("received garbage from the broker");
                }
                this.cleanup(connection);
                connection.connectFailure(-5, 0, socket, e);
                return;
            }
            boolean lb = connection.isLoadBalancingEnabled() && !connection.inRecoveryState();
            boolean ft = connection.isFaultToleranceEnabled();
            boolean resumed = connection.inRecoveryState();
            if (lb || ft || resumed) {
                String cpref = null;
                ClientData cdata = connection.getClientData();
                ClientConnectParms cparms = null;
                if (this.m_brokerSessionVer >= 27) {
                    cparms = (ClientConnectParms)connection.getClientConnectParms().clone();
                    if (resumed) {
                        cparms.setResumeSocketId(connection.getLastSocketId());
                        cparms.setClientResumeSeqNr(0L);
                    }
                    if (this.m_brokerSessionVer < 31) {
                        cparms.setVersion((short)1);
                    }
                }
                if (lb && cdata != null) {
                    cpref = cdata.getClientPreferences();
                }
                hello = ClientConnectHandshaker.buildClientHello(this.m_brokerSessionVer, ft, lb, resumed, cpref, cparms);
            } else if (this.m_brokerSessionVer >= 31) {
                ClientConnectParms cparms = null;
                cparms = (ClientConnectParms)connection.getClientConnectParms().clone();
                hello = ClientConnectHandshaker.buildClientHello(this.m_brokerSessionVer, false, false, false, null, cparms);
            } else {
                hello = ClientConnectHandshaker.buildClientHello(this.m_brokerSessionVer);
            }
            this.m_context.getClientSender().send(hello);
            Object o = this.connectLoop();
            this.m_pluggableCipherSuite = this.m_handshaker.getClientSideCipherSuiteInfo();
            if (o instanceof FailoverRedirectData) {
                FailoverRedirectData frd = (FailoverRedirectData)o;
                this.cleanup(connection);
                connection.setRedirectedHost(frd.getNewBrokerURL());
                connection.connectFailure(-37, 0, socket, null);
                return;
            }
            if (o instanceof RedirectData) {
                RedirectData rd = (RedirectData)o;
                this.cleanup(connection);
                connection.setRedirectedHost(rd.getNewBrokerURL());
                connection.connectFailure(-34, 0, socket, null);
                return;
            }
            ConnectData cd = (ConnectData)o;
            ClientSecurityContext csc = cd.getSecurityContext();
            connection.setSocketId(cd.getSocketId());
            connection.setLastSocketId(cd.getSocketId());
            if (csc.isSecurityEnabled() && this.m_pluggableCipherSuite == null) {
                EInvalidCipherSuiteException ex = new EInvalidCipherSuiteException("Unable to get client side cipher suite information");
                throw ex;
            }
            if (csc.isQopSecurityEnabled()) {
                try {
                    this.m_mp = AbstractCipherSuite.getNewMessageProtectionInstance(this.m_pluggableCipherSuite);
                    byte[] masterSecret = this.m_handshaker.m_masterSecret;
                    this.m_sessionKey = this.m_mp.generateSessionKey(masterSecret, this.m_handshaker.m_keyBits);
                    this.m_digestKey = this.m_mp.generateDigestKey(masterSecret);
                    csc.setSessionKey(this.m_sessionKey);
                    csc.setDigestKey(this.m_digestKey);
                    this.m_mp.init(2, this.m_sessionKey);
                    if (this.m_pluggableCipherSuite == null) {
                        throw new NullPointerException("m_pluggableCipherSuite is null at " + ClientListener.class.getName() + ".listenerLoop()");
                    }
                    if (this.m_pluggableCipherSuite.isSonicCipherSuite()) {
                        this.m_context.getClientSender().setupSecurity(AbstractCipherSuite.getNewMessageProtectionInstance(), this.m_sessionKey);
                    } else {
                        this.m_context.getClientSender().setupSecurity(AbstractCipherSuite.getNewMessageProtectionInstance(this.m_pluggableCipherSuite), this.m_sessionKey);
                    }
                    byte[] buffer = this.m_mp.isSonicCipherSuite() ? new byte[SessionConfig.IO_SECURITY_BUFFER_SIZE] : null;
                    Class<?> sisClass = Class.forName(this.m_mp.isSonicCipherSuite() ? "progress.message.crypto.SecureInputStream" : "com.sonicsw.security.pcs.PluggableSecureInputStream");
                    this.m_sis = (ISecureInputStream)sisClass.newInstance();
                    this.m_sis.initSecureInputStream(this.m_is, this.m_mp, buffer);
                }
                catch (Exception e) {
                    throw new EAssertFailure(e);
                }
            }
            m = this.createMgram();
            if (this.CALLBACK) {
                this.callback(THREAD_NAME_PREFIX, 0, new Object[]{connection, m});
            }
            if ((this.debugFlags & 1) > 0) {
                PrintStream log;
                PrintStream printStream = log = SessionConfig.getLog();
                synchronized (printStream) {
                    this.debug("RECEIVED Mgram:");
                    m.dump();
                }
            }
            if (m.getType() != 0 || !m.isRequest()) {
                throw new EUnexpectedMgram(m);
            }
            socket.setSoTimeout(0);
            connection.connectSuccess(csc);
            this.m_handshaker = null;
        }
        catch (EClientErrorMgramReceived e) {
            IMgram m = e.getMgram();
            this.cleanup(connection);
            connection.connectFailure(m.getErrorHandle().getErrCode(), m.getErrorHandle().getErrInfo(), socket, e);
            return;
        }
        catch (EInauthenticBroker e) {
            this.cleanup(connection);
            connection.connectFailure(-26, 0, socket, e);
            return;
        }
        catch (EInauthenticClient e) {
            this.cleanup(connection);
            connection.connectFailure(-25, 0, socket, e);
            return;
        }
        catch (EMgramVersionMismatch e) {
            if (this.DEBUG) {
                this.debug("got mgram version mismatch");
            }
            this.cleanup(connection);
            connection.connectFailure(-15, e.getVersion(), socket, e);
            return;
        }
        catch (EUnexpectedMgram e) {
            if (this.DEBUG) {
                this.debug("got unexpected mgram");
            }
            this.cleanup(connection);
            connection.connectFailure(-19, 0, socket, e);
            return;
        }
        catch (EMgramFormatError e) {
            if (this.DEBUG) {
                this.debug("got mgram format error");
            }
            this.cleanup(connection);
            connection.connectFailure(-20, 0, socket, e);
            return;
        }
        catch (EChecksumValidationFailed e) {
            if (this.DEBUG) {
                this.debug("got ChecksumValidationFailed " + e);
            }
            this.cleanup(connection);
            connection.connectFailure(-5, 0, socket, e);
            return;
        }
        catch (SocketTimeoutException soex) {
            this.cleanup(connection);
            connection.connectFailure(-44, 0, socket, soex);
            return;
        }
        catch (IOException e) {
            this.cleanup(connection);
            connection.connectFailure(-5, 0, socket, e);
            return;
        }
        catch (Exception e) {
            SessionConfig.logMessage(e, SessionConfig.getLevelWarning());
            this.cleanup(connection);
            connection.connectFailure(-22, 0, socket, e);
            throw e;
        }
        catch (Error e) {
            this.cleanup(connection);
            connection.connectFailure(-22, 0, socket, e);
            throw e;
        }
        try {
            this.mainLoop();
        }
        catch (IOException e) {
            if (this.DEBUG) {
                SessionConfig.logMessage("caught " + e, SessionConfig.getLevelWarning());
            }
            this.cleanupAll(true, e);
            if (this.DEBUG) {
                SessionConfig.logMessage("cleanup done, thread exiting", SessionConfig.getLevelInfo());
            }
            return;
        }
        catch (InterruptedException e) {
            if (this.DEBUG) {
                SessionConfig.logMessage("interrupted ", e, SessionConfig.getLevelWarning());
            }
            this.cleanupAll(true, e);
            return;
        }
        catch (Exception e) {
            if (this.DEBUG) {
                SessionConfig.logMessage(e, SessionConfig.getLevelWarning());
            }
            this.cleanupAll(true, e);
            throw e;
        }
        catch (Error e) {
            if (this.DEBUG) {
                SessionConfig.logMessage(e, SessionConfig.getLevelWarning());
            }
            if (e instanceof ThreadDeath) {
                stopped = true;
            } else {
                this.cleanupAll(true, e);
            }
            throw e;
        }
        finally {
            if (!stopped) {
                this.cleanupAll(false, null);
            }
        }
    }

    private void initializeConverter(byte version) throws EUnsupportedMgramException {
        this.m_converter = MgramFactory.getMgramConverter(version);
        this.m_context.getClientSender().setMgramVersion(version);
    }

    private void handleVersion(IMgram m) throws EMgramVersionMismatch {
        byte version = m.getVersion();
        if (version == 26 && m.getSessionVersion() == 25) {
            version = 25;
        }
        if (!SessionConfig.IN_BROKER && version != 26) {
            throw new EMgramVersionMismatch(version);
        }
        if (version >= 24) {
            try {
                this.initializeConverter(version);
            }
            catch (EUnsupportedMgramException e) {
                throw new EMgramVersionMismatch(version);
            }
        } else {
            throw new EMgramVersionMismatch(version);
        }
    }

    private synchronized boolean cleanup(Connection connection) {
        return this.cleanup(connection, false);
    }

    private synchronized boolean cleanup(Connection connection, boolean fromErrorThatCausesReconnect) {
        int channel = connection.getChannel();
        boolean stillAlive = this.m_context.getClientSender().kill(false, channel, fromErrorThatCausesReconnect);
        this.removeChannel(channel);
        if (!stillAlive) {
            try {
                this.m_context.getSocket().close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return stillAlive;
    }

    private void cleanupAll(boolean dropAll, Throwable cause) {
        this.cleanupAll(dropAll, -5, 0, cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupAll(boolean dropAll, int errCode, int errInfo, Throwable cause) {
        AutoVec autoVec = this.m_connections;
        synchronized (autoVec) {
            AutoVec cloned = new AutoVec();
            for (int i = 0; i < this.m_connections.size(); ++i) {
                Object o = this.m_connections.elementAt(i);
                if (o == null) continue;
                cloned.setElementAt(o, i);
            }
            Enumeration enu = cloned.elements();
            Connection parent = (Connection)this.m_connections.elementAt(0);
            while (enu.hasMoreElements()) {
                Connection con = (Connection)enu.nextElement();
                if (con == null) continue;
                this.cleanup(con, dropAll && parent != null);
            }
            if (dropAll && parent != null) {
                parent.socketDropped(errCode, errInfo, this.m_context, cause);
            }
        }
    }

    private Object connectLoop() throws EClientErrorMgramReceived, EInauthenticClient, EIntegrityCompromised, EMgramVersionMismatch, EUnexpectedMgram, EMgramFormatError, IOException {
        IMgram m;
        IMgram m2;
        boolean expectsFailoverNotification;
        Connection connection = this.m_parentConnection;
        this.m_handshaker = new ClientConnectHandshaker(connection);
        this.m_handshaker.setAuthenticationSPIEnabled(connection.isAuthenticationSPIEnabled());
        boolean bl = expectsFailoverNotification = this.m_brokerSessionVer >= 25 && connection != Connection.getAdminConnection();
        if (expectsFailoverNotification) {
            boolean gotFailoverNotification = false;
            while (!gotFailoverNotification) {
                m2 = this.createMgram();
                if (this.CALLBACK) {
                    this.callback(THREAD_NAME_PREFIX, 0, new Object[]{connection, m2});
                }
                switch (m2.getType()) {
                    case 0: {
                        this.handlePing(m2, connection);
                        break;
                    }
                    case 21: {
                        ConnectionFailoverStateManager fsh = connection.getConnectionFailoverStateManager();
                        fsh.update(m2.getFailoverStatusNotificationHandle());
                        ConnectionFailoverStatus fs = fsh.getConnectionFailoverStatus();
                        if (!connection.standbyBrokerConnectAllowed() && fs.getLocalState() != 2 && fs.getLocalState() != 3 && fs.getLocalState() != 1) {
                            String[] standbyChoices = fs.getStandbyURLs();
                            return new FailoverRedirectData(standbyChoices[0]);
                        }
                        gotFailoverNotification = true;
                        break;
                    }
                    case -1: {
                        throw new EClientErrorMgramReceived(m2);
                    }
                }
            }
        }
        if (connection.isLoadBalancingEnabled()) {
            boolean gotLBResponse = false;
            while (!gotLBResponse) {
                m2 = this.createMgram();
                if (this.CALLBACK) {
                    this.callback(THREAD_NAME_PREFIX, 0, new Object[]{connection, m2});
                }
                switch (m2.getType()) {
                    case 0: {
                        this.handlePing(m2, connection);
                        break;
                    }
                    case 1: {
                        this.m_handshaker.handleConnectMgram(m2);
                        String newBrokerURL = this.m_handshaker.m_newBrokerURL;
                        if (newBrokerURL != null) {
                            return new RedirectData(newBrokerURL);
                        }
                        gotLBResponse = true;
                    }
                }
            }
        }
        this.m_handshaker.connectClient(true, false);
        block16: while (true) {
            m = this.createMgram();
            if (this.CALLBACK) {
                this.callback(THREAD_NAME_PREFIX, 0, new Object[]{connection, m});
            }
            switch (m.getType()) {
                case 0: {
                    this.handlePing(m, connection);
                    continue block16;
                }
                case 1: {
                    if (!this.m_handshaker.isDone()) {
                        this.m_handshaker.handleConnectMgram(m);
                        continue block16;
                    }
                    if (ClientConnectHandshaker.isConnectSuccessMgram(m)) {
                        ConnectData cd = this.m_handshaker.decodeSuccessMgram(m, this.m_brokerSessionVer);
                        BrokerConnectParms bcp = this.m_handshaker.getBrokerConnectParms();
                        connection.setBrokerConnectParms(bcp);
                        connection.setPartnerProductVersion(bcp.getProductVersion());
                        return cd;
                    }
                    throw new EUnexpectedMgram(m);
                }
                case -1: {
                    throw new EClientErrorMgramReceived(m);
                }
            }
            break;
        }
        throw new EUnexpectedMgram(m);
    }

    private final IMgram createMgram() throws EMgramVersionMismatch, IOException, EMgramFormatError {
        IMgram m = this.m_converter.createMgram(this.m_is);
        if (this.m_cb != null) {
            this.m_cb.annotate(MgramTrace.diagnosticString("", (Connection)this.m_connections.elementAt(0), m));
        }
        return m;
    }

    private void mainLoop() throws IOException, InterruptedException, EMgramFormatError {
        ClientSecurityContext csc;
        boolean stay_in_loop = true;
        Connection connection = null;
        Hashtable<String, Object> mgramProperties = new Hashtable<String, Object>();
        if (this.m_sis != null) {
            mgramProperties.put(MgramConstants.SECURE_INPUT_STREAM, this.m_sis);
        }
        if (this.m_mp != null) {
            mgramProperties.put(MgramConstants.MESSAGE_PROTECTION, this.m_mp);
        }
        if ((csc = this.m_parentConnection.getSecurityContext()) != null) {
            mgramProperties.put(MgramConstants.CLIENT_SECURITY_CONTEXT, csc);
        }
        mgramProperties.put(MgramConstants.TTE_TTL_CONVERT, new Boolean(true));
        this.m_converter.initializeConverter(mgramProperties);
        block25: while (stay_in_loop) {
            try {
                this.m_mgram = null;
                this.m_mgram = this.createMgram();
                connection = (Connection)this.m_connections.elementAt(this.m_mgram.getChannel());
                if (connection == null) continue;
                if (this.m_pingStarted) {
                    connection.getClientSender().clearPing();
                }
                if (this.CALLBACK) {
                    this.callback(THREAD_NAME_PREFIX, 0, new Object[]{connection, this.m_mgram});
                }
                switch (this.m_mgram.getType()) {
                    case 2: 
                    case 12: {
                        this.handleNormal(this.m_mgram, connection);
                        this.m_mgram = null;
                        continue block25;
                    }
                    case 25: {
                        this.handleOperation(this.m_mgram, connection);
                        this.m_mgram = null;
                        continue block25;
                    }
                    case 23: {
                        connection.idrReceived(this.m_mgram);
                        continue block25;
                    }
                    case 32: {
                        connection.connectionSyncReceived(this.m_mgram);
                        continue block25;
                    }
                    case 8: {
                        if (!this.m_mgram.isReply()) {
                            throw new EUnexpectedMgram(this.m_mgram);
                        }
                        connection.txnReplyReceived(this.m_mgram);
                        continue block25;
                    }
                    case 3: 
                    case 14: 
                    case 20: {
                        connection.ackReceived(this.m_mgram);
                        continue block25;
                    }
                    case 33: {
                        connection.windowAckReceived(this.m_mgram);
                        continue block25;
                    }
                    case 6: {
                        connection.flowControlMgramReceived(this.m_mgram);
                        continue block25;
                    }
                    case 19: {
                        IPTPFlowControlHandler fch = connection.getConnectionInfo().getPTPFlowControlHandler();
                        fch.handlePTPFlowControlMgram(this.m_mgram);
                        continue block25;
                    }
                    case 18: {
                        IPTPFlowControlHandler fch = connection.getConnectionInfo().getPTPFlowControlHandler();
                        fch.handlePTPFlowControlMgram(this.m_mgram);
                        continue block25;
                    }
                    case 37: {
                        IPTPFlowControlHandler fch = connection.getConnectionInfo().getPTPFlowControlHandler();
                        fch.handlePTPFlowControlMgram(this.m_mgram);
                        continue block25;
                    }
                    case 5: 
                    case 16: 
                    case 22: {
                        connection.pauseIfMark();
                        continue block25;
                    }
                    case 0: {
                        this.handlePing(this.m_mgram, connection);
                        continue block25;
                    }
                    case -1: {
                        if (this.DIAG_MGRAM_HISTORY) {
                            this.dumpSenderHistory();
                        }
                        throw new EClientErrorMgramReceived(this.m_mgram);
                    }
                    case 1: {
                        throw new EUnexpectedMgram(this.m_mgram);
                    }
                    case 7: {
                        if (!this.m_mgram.isReply()) {
                            throw new EUnexpectedMgram(this.m_mgram);
                        }
                        connection.disconnectReply();
                        continue block25;
                    }
                    case 27: {
                        this.handleBatch(this.m_mgram);
                        continue block25;
                    }
                }
                throw new EUnexpectedMgram(this.m_mgram);
            }
            catch (EIntegrityCompromised ic) {
                if (this.DEBUG) {
                    SessionConfig.logMessage(ic, SessionConfig.getLevelWarning());
                }
                this.handleMgramCorruption(false);
                if (connection == null) {
                    throw new NullPointerException("'Connection connection' is null at " + ClientListener.class.getName() + ".mainLoop()");
                }
                connection.getClientSender().send(MgramFactory.getMgramFactory().buildErrorMgram(-3, 0, null, connection.getChannel()));
                stay_in_loop = this.cleanup(connection);
                connection.connectionDropped(-3, 0);
            }
            catch (EMgramFormatError e) {
                this.handleMgramCorruption(true);
                throw e;
            }
            catch (EClientErrorMgramReceived e) {
                if (this.DEBUG) {
                    SessionConfig.logMessage(e, SessionConfig.getLevelWarning());
                }
                if (connection == null) {
                    throw new NullPointerException("'Connection connection' is null at " + ClientListener.class.getName() + ".mainLoop()");
                }
                if (connection.getChannel() == 0) {
                    int errCode = e.getMgram().getErrorHandle().getErrCode();
                    if (errCode == -19 || errCode == -20) {
                        errCode = -5;
                    }
                    this.cleanupAll(true, errCode, 0, e);
                    stay_in_loop = false;
                    continue;
                }
                stay_in_loop = this.cleanup(connection);
                connection.connectionDropped(-20, 0);
            }
            catch (EUnexpectedMgram e) {
                if (this.DEBUG) {
                    SessionConfig.logMessage(e, SessionConfig.getLevelWarning());
                }
                this.handleMgramCorruption(true);
                stay_in_loop = this.cleanup(connection);
                if (connection == null) {
                    throw new NullPointerException("'Connection connection' is null at " + ClientListener.class.getName() + ".mainLoop()");
                }
                connection.connectionDropped(-20, 0);
            }
            catch (EChecksumValidationFailed ex) {
                if (this.DEBUG) {
                    SessionConfig.logMessage(ex, SessionConfig.getLevelWarning());
                }
                this.handleMgramCorruption(true);
                this.cleanupAll(true, -5, 0, ex);
                stay_in_loop = false;
                if (!this.DEBUG) continue;
                this.debug("ERR_CHECKSUM_VALIDATION_FAILED; exiting");
            }
        }
    }

    private void handleNormal(IMgram mgram, Connection connection) throws EMgramFormatError, InterruptedException, ESecurityGeneralException {
        MessageSorter msgSorter = (MessageSorter)this.m_msgSorters.elementAt(mgram.getChannel());
        try {
            this.m_tempEnv = new Envelope(mgram, true, connection, this.m_mp);
            this.m_tempEnv.setAckCommitListener(connection.getConnectionInfo());
            msgSorter.dispatchRemoteEnv(this.m_tempEnv);
            this.m_tempEnv = null;
        }
        catch (UTFDataFormatException e) {
            throw new EMgramFormatError(prAccessor.getString("STR002"));
        }
    }

    private void handleBatch(IMgram m) throws EMgramFormatError, InterruptedException, IOException {
        if (this.CALLBACK) {
            this.callback("Batch received", 1, null);
        }
        m.getBatchHandle().syncBatch();
        LinkedList mgrams = m.getOperationHandle().getMgramList();
        boolean isAtomic = m.getBatchHandle().isAtomic();
        if (mgrams == null || mgrams.isEmpty()) {
            return;
        }
        IMgram lastMgram = (IMgram)mgrams.getLast();
        int totalSize = 0;
        Connection connection = (Connection)this.m_connections.elementAt(m.getChannel());
        MessageSorter msgSorter = (MessageSorter)this.m_msgSorters.elementAt(m.getChannel());
        String senderID = null;
        if (m.hasSidebandData()) {
            senderID = (String)m.getSidebandData().getProperties().get("JMSXUserID");
        }
        for (IMgram subMgram : mgrams) {
            Envelope subEnv;
            if (senderID != null) {
                this.copyJMSXUserIDIfNecessary(senderID, m, subMgram);
            }
            if (subMgram != lastMgram) {
                if (isAtomic) {
                    subMgram.setReliable();
                }
                subEnv = new Envelope(subMgram, true, connection, this.m_mp, 0);
                totalSize += subEnv.trueLength();
                subEnv.setAckCommitListener(connection.getConnectionInfo());
                msgSorter.dispatchRemoteEnv(subEnv);
                continue;
            }
            if (isAtomic && m.isGuarenteed()) {
                subMgram.setGuarenteed(m.getGuarenteedTrackingNum());
            }
            subEnv = new Envelope(subMgram, true, connection, this.m_mp);
            subEnv.overrideLength(totalSize += subEnv.length());
            subEnv.setAckCommitListener(connection.getConnectionInfo());
            msgSorter.dispatchRemoteEnv(subEnv);
        }
        this.m_mgram = null;
    }

    private void copyJMSXUserIDIfNecessary(String senderID, IMgram batchMgram, IMgram subMgram) {
        if (senderID == null) {
            return;
        }
        subMgram.createSidebandDataIfNeeded();
        Hashtable table = subMgram.getSidebandData().getProperties();
        table.put("JMSXUserID", senderID);
        subMgram.getSidebandData().setProperties(table);
        if (this.DEBUG) {
            this.debug("copyJMSXUserIDIfNecessary: copy userID for SubMgram, subject = " + batchMgram.getSubject() + " userid= " + senderID);
        }
    }

    private void handleOperation(IMgram opMgram, Connection connection) throws EMgramFormatError, InterruptedException, ESecurityGeneralException {
        block2 : switch (opMgram.getOperationHandle().getOperationType()) {
            case 25: {
                IMgram mgram = (IMgram)opMgram.getOperationHandle().getMgramList().getFirst();
                if (mgram != null) {
                    if (opMgram.isGuarenteed()) {
                        mgram.setGuarenteed(opMgram.getGuarenteedTrackingNum());
                    } else {
                        mgram.setReliable();
                    }
                    this.handleNormal(mgram, connection);
                    break;
                }
                throw new EAssertFailure("Missing embedded mgram in WRAPPED_GUAR_FORMAT_MGRAM");
            }
            case 26: {
                Connection c = (Connection)this.m_connections.elementAt(opMgram.getChannel());
                if (c == null) break;
                c.getQopCache().handleUpdate(opMgram);
                break;
            }
            case 30: {
                try {
                    Connection c = (Connection)this.m_connections.elementAt(opMgram.getChannel());
                    if (c == null) break;
                    Envelope e = new Envelope((IMgram)opMgram.getOperationHandle().getMgramList().getFirst(), true, connection, this.m_mp);
                    ObjectInput di = opMgram.getPayloadInputStreamHandle();
                    String errorMsg = "";
                    if (di.readBoolean()) {
                        errorMsg = di.readUTF();
                    }
                    int errorCode = di.readInt();
                    c.handleRejection(e, errorCode, errorMsg);
                    break;
                }
                catch (UTFDataFormatException e) {
                    throw new EMgramFormatError(prAccessor.getString("STR002"));
                }
                catch (IOException ioe) {
                    EMgramFormatError e = new EMgramFormatError(prAccessor.getString("STR074"));
                    e.initCause(ioe);
                    throw e;
                }
            }
            case 31: {
                ObjectInput di = opMgram.getPayloadInputStreamHandle();
                int type = -1;
                try {
                    type = di.readShort();
                }
                catch (IOException ioe) {
                    EMgramFormatError e = new EMgramFormatError(prAccessor.getString("STR074"));
                    e.initCause(ioe);
                    throw e;
                }
                switch (type) {
                    case 0: {
                        String appid = this.m_parentConnection.getApplicationId();
                        SessionConfig.logMessage("Received request to dump sender mgram history for " + appid, SessionConfig.WARNING);
                        this.dumpSenderHistory();
                        break block2;
                    }
                }
                SessionConfig.logMessage("Received unrecognized diagnositc mgram operation: " + type, SessionConfig.WARNING);
                break;
            }
            default: {
                throw new EAssertFailure("Unknown Operation Type: " + opMgram.getOperationHandle().getOperationType());
            }
        }
    }

    private void handlePing(IMgram m, Connection connection) throws EUnexpectedMgram {
        if (m.isRequest()) {
            connection.getClientSender().send(MgramFactory.getMgramFactory().buildPingReply(m));
        } else if (m.isReply()) {
            Job j;
            long tracking = ArrayUtil.readLong(m.getRawBody(), 0);
            if (this.DEBUG) {
                this.debug("ping response tracking number is " + tracking);
            }
            if ((j = connection.removeJob(tracking)) == null) {
                return;
            }
            if (!(j instanceof Publication)) {
                connection.addJob(tracking, j);
                return;
            }
            j.setStatus(0);
        } else {
            throw new EUnexpectedMgram(m);
        }
    }

    public void setupSecurity(ClientSecurityContext csc, int channel) {
        try {
            csc.setSessionKey(this.m_sessionKey);
            csc.setDigestKey(this.m_digestKey);
        }
        catch (Exception e) {
            throw new EAssertFailure(e);
        }
    }

    public void setPingState(boolean newState) {
        this.m_pingStarted = newState;
    }

    public void setThreadName() {
        String brokerUrl = "url unavailable";
        try {
            brokerUrl = this.m_parentConnection.getBrokerURL();
        }
        catch (Throwable t) {
            // empty catch block
        }
        String threadName = "ClientListener " + this.m_parentConnection;
        if (this.m_parentConnection != Connection.getAdminConnection()) {
            threadName = threadName + " (" + brokerUrl + ")";
        }
        if (DebugState.GLOBAL_DEBUG_ON) {
            this.debugName(threadName);
        }
        try {
            this.setName(threadName);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private final void handleMgramCorruption(boolean requestPeerDump) {
        if (this.DIAG_MGRAM_HISTORY) {
            Connection c;
            this.dumpMgramHistory();
            if (requestPeerDump && (c = (Connection)this.m_connections.elementAt(0)) != null && this.m_brokerSessionVer >= 30) {
                c.getClientSender().send(MgramFactory.getMgramFactory().buildDiagnosticOpMgram((short)0, 0));
                try {
                    Thread.currentThread();
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private final void dumpMgramHistory() {
        if (this.m_is instanceof IDumpable) {
            StringBuffer buf = new StringBuffer();
            buf.append("Listener History Dump\n");
            ClientSecurityContext csc = this.m_parentConnection.getSecurityContext();
            if (csc != null) {
                csc.dump(buf);
            }
            ((IDumpable)((Object)this.m_is)).dump(buf);
            SessionConfig.logMessage(buf.toString(), SessionConfig.SEVERE);
        } else {
            SessionConfig.logMessage("Listener input stream is not dumpable: " + this.m_is, SessionConfig.SEVERE);
        }
    }

    private final void dumpSenderHistory() {
        ClientSender sender = this.m_context.getClientSender();
        if (sender != null) {
            sender.dumpMgramHistory();
        }
    }
}

