/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import progress.message.msg.IMgram;
import progress.message.util.DebugState;
import progress.message.util.IndexedList;
import progress.message.util.PriorityQueue;
import progress.message.zclient.BlockedDestList;
import progress.message.zclient.DebugObject;
import progress.message.zclient.IExpireCheck;
import progress.message.zclient.IFlowControllableOutputQueue;
import progress.message.zclient.INackable;
import progress.message.zclient.IPTPFlowControlHandler;
import progress.message.zclient.ISubject;
import progress.message.zclient.PrioQueueLimiter;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.xonce.IOutboundContext;

public class PTPFlowControlHandlerP27
extends DebugObject
implements IPTPFlowControlHandler {
    IFlowControllableOutputQueue m_queue;
    IOutboundContext m_outboundContext;
    PriorityQueue m_outQueue;
    PrioQueueLimiter m_outLimiter;
    IndexedList m_pendingQueue;
    Hashtable m_ptpBlocked = new Hashtable();

    public PTPFlowControlHandlerP27(IFlowControllableOutputQueue queue, IOutboundContext outboundContext) {
        super(DebugState.GLOBAL_DEBUG_ON ? "PTPFlowControlHandler" : null);
        this.m_queue = queue;
        this.m_outboundContext = outboundContext;
        this.m_outQueue = queue.getOutputQueue();
        this.m_outLimiter = queue.getOutputQueueLimiter();
        this.m_pendingQueue = queue.getQueueMsgPendingQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handlePTPFlowControlMgram(IMgram m) {
        switch (m.getType()) {
            case 18: {
                String dest = m.getQueueFlowControlHandle().getFlowDestination();
                if (dest == null) {
                    return;
                }
                boolean forRoutingQueue = m.getQueueFlowControlHandle().getFlowRoutingBit();
                Object object = this.m_outboundContext.getSyncObj();
                synchronized (object) {
                    this.onBlock(dest, forRoutingQueue);
                }
                this.m_outboundContext.notifyPTPFlowControlRelease();
                break;
            }
            case 19: {
                if (m.isRequest()) {
                    String dest = m.getQueueFlowControlHandle().getFlowDestination();
                    boolean forRoutingQueue = m.getQueueFlowControlHandle().getFlowRoutingBit();
                    m.setRequestReplyReply();
                    this.m_outboundContext.sendThrough(m);
                    if (dest == null) {
                        return;
                    }
                    Object object = this.m_outboundContext.getSyncObj();
                    synchronized (object) {
                        this.onResumeBegin(dest, forRoutingQueue);
                        this.m_outboundContext.notifyPTPResumed(dest);
                    }
                    this.m_outboundContext.notifyMsgEnqueued();
                    break;
                }
                String dest = m.getQueueFlowControlHandle().getFlowDestination();
                boolean forRoutingQueue = m.getQueueFlowControlHandle().getFlowRoutingBit();
                if (dest == null) {
                    return;
                }
                Object object = this.m_outboundContext.getSyncObj();
                synchronized (object) {
                    this.onResumeComplete(dest, forRoutingQueue);
                }
                this.m_outboundContext.notifyMsgEnqueued();
                break;
            }
            default: {
                SessionConfig.logMessage("Unexpected FlowControl received.", SessionConfig.SEVERE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public INackable handleNack(IMgram nack) {
        long tracking = nack.getAckHandle().getTrackingNumber();
        Object object = this.m_outboundContext.getSyncObj();
        synchronized (object) {
            return this.onNack(tracking);
        }
    }

    @Override
    public final boolean interceptBlocked(INackable nackable) {
        String fcDest = this.buildFullDestinationName(nackable);
        if (fcDest != null && this.m_ptpBlocked.containsKey(fcDest)) {
            if (this.DEBUG) {
                this.debug(this.m_queue.getFlowControlName() + ": Handling blocked on: " + fcDest + " trk: " + nackable.getGuarenteedTrackingNum());
            }
            if (nackable.isDiscardable()) {
                return true;
            }
            BlockedDestList bdl = (BlockedDestList)this.m_ptpBlocked.get(fcDest);
            bdl.addUnsent(nackable);
            return true;
        }
        return false;
    }

    @Override
    public final boolean hasBlocked() {
        return !this.m_ptpBlocked.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final INackable onNack(long tracking) {
        INackable nackable = (INackable)this.m_pendingQueue.get(tracking);
        if (nackable == null) {
            return nackable;
        }
        String blockedDest = this.buildFullDestinationName(nackable);
        boolean notify = false;
        BlockedDestList bdl = (BlockedDestList)this.m_ptpBlocked.get(blockedDest);
        if (this.DEBUG) {
            this.debug(this.m_queue.getFlowControlName() + ": Handling Nack for " + blockedDest + " trk: " + nackable.getGuarenteedTrackingNum());
        }
        if (bdl != null) {
            BlockedDestList blockedDestList = bdl;
            synchronized (blockedDestList) {
                if (bdl.isResuming()) {
                    if (this.DEBUG) {
                        this.debug(this.m_queue.getFlowControlName() + ": Putting Nack on OQ for " + blockedDest + blockedDest + " trk: " + nackable.getGuarenteedTrackingNum());
                    }
                    this.m_outQueue.enqueue(nackable, nackable.getPriority());
                    this.m_outLimiter.add(nackable.getLimiterSize(), nackable.getPriority());
                    notify = true;
                } else {
                    if (this.DEBUG) {
                        this.debug(this.m_queue.getFlowControlName() + ": Putting Nack on block list for " + blockedDest + " trk: " + nackable.getGuarenteedTrackingNum());
                    }
                    bdl.addNacked(nackable);
                    this.m_outLimiter.add(nackable.getLimiterSize(), nackable.getPriority());
                }
            }
        } else {
            if (this.DEBUG) {
                this.debug(this.m_queue.getFlowControlName() + ": Reenqueuing Nack on block list for " + blockedDest + " trk: " + nackable.getGuarenteedTrackingNum());
            }
            this.m_outQueue.enqueue(nackable, nackable.getPriority());
            this.m_outLimiter.add(nackable.getLimiterSize(), nackable.getPriority());
            notify = true;
        }
        if (notify) {
            this.m_outboundContext.notifyPTPFlowControlRelease();
        }
        return nackable;
    }

    private final String buildFullDestinationName(INackable nackable) {
        if (nackable == null || nackable.getSubject() == null || !nackable.getSubject().isSubjectSet()) {
            return null;
        }
        return this.buildFullDestinationName(nackable.getRouting(), nackable.getSubject(), nackable.isPubSub());
    }

    private final String buildFullDestinationName(String routing, ISubject subject, boolean isPubSub) {
        if (subject == null || !subject.isSubjectSet() || subject.isMultiSubject()) {
            return null;
        }
        String dest = null;
        dest = routing != null && !isPubSub ? (routing.equals("") ? "::" + subject.getSubjectString() : routing + "::" + subject.getSubjectString()) : subject.getSubjectString();
        return dest;
    }

    private final void onBlock(String blockedDest, boolean forRoutingQueue) {
        BlockedDestList bdl;
        if (this.DEBUG) {
            this.debug(this.m_queue.getFlowControlName() + ": Removing blocked messages from outqueue - dest = " + blockedDest + ", rt = " + forRoutingQueue);
        }
        if ((bdl = (BlockedDestList)this.m_ptpBlocked.get(blockedDest)) == null) {
            bdl = new BlockedDestList(blockedDest);
            this.m_ptpBlocked.put(blockedDest, bdl);
        }
        if (forRoutingQueue) {
            bdl.setForRoutingQueue();
        }
        PriorityQueue tempPQ = new PriorityQueue(this.m_outQueue.getNumPriorities());
        String dest = null;
        INackable nackable = null;
        while (!this.m_outQueue.isEmpty()) {
            nackable = (INackable)this.m_outQueue.dequeue();
            dest = this.buildFullDestinationName(nackable);
            if (dest != null && dest.equals(blockedDest)) {
                if (nackable.isDiscardable()) continue;
                if (this.DEBUG) {
                    this.debug(this.m_queue.getFlowControlName() + ": Adding to blocked for dest: " + blockedDest + " trk: " + nackable.getGuarenteedTrackingNum());
                }
                bdl.addUnsent(nackable);
                continue;
            }
            tempPQ.enqueue(nackable, nackable.getPriority());
        }
        nackable = null;
        while (!tempPQ.isEmpty()) {
            nackable = (INackable)tempPQ.dequeue();
            this.m_outQueue.enqueue(nackable, nackable.getPriority());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onResumeBegin(String dest, boolean forRoutingQueue) {
        BlockedDestList bdl = (BlockedDestList)this.m_ptpBlocked.get(dest);
        if (this.DEBUG) {
            this.debug(this.m_queue.getFlowControlName() + ": Handling Resume begin on " + dest);
        }
        if (bdl != null) {
            BlockedDestList blockedDestList = bdl;
            synchronized (blockedDestList) {
                bdl.setResuming(true);
                Stack nacked = bdl.buildOrderedNackStack();
                while (!nacked.isEmpty()) {
                    INackable nackable = (INackable)nacked.pop();
                    if (this.DEBUG) {
                        this.debug(this.m_queue.getFlowControlName() + ": Reenqueuing on Resume begin on " + dest + " trk: " + nackable.getGuarenteedTrackingNum());
                    }
                    this.m_outQueue.enqueue(nackable, nackable.getPriority());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onResumeComplete(String dest, boolean forRoutingQueue) {
        BlockedDestList bdl = (BlockedDestList)this.m_ptpBlocked.remove(dest);
        if (this.DEBUG) {
            this.debug(this.m_queue.getFlowControlName() + ": Handling resume complete for: " + dest);
        }
        if (bdl != null) {
            BlockedDestList blockedDestList = bdl;
            synchronized (blockedDestList) {
                bdl.setResuming(false);
                Stack unsent = bdl.buildOrderedUnsentStack();
                while (!unsent.isEmpty()) {
                    INackable nackable = (INackable)unsent.pop();
                    this.m_outQueue.enqueue(nackable, nackable.getPriority());
                    if (!this.DEBUG) continue;
                    this.debug(this.m_queue.getFlowControlName() + ": Reenqueuing for: " + dest + " trk: " + nackable.getGuarenteedTrackingNum());
                }
            }
        }
    }

    @Override
    public final boolean isDestinationBlocked(String routing, ISubject subject, boolean isPubSub) {
        String fcDest = this.buildFullDestinationName(routing, subject, isPubSub);
        return fcDest != null && this.m_ptpBlocked.containsKey(fcDest);
    }

    @Override
    public final void dropBlocked() {
        if (!this.m_ptpBlocked.isEmpty()) {
            Enumeration enu = this.m_ptpBlocked.keys();
            Object dest = null;
            BlockedDestList bdl = null;
            while (enu.hasMoreElements()) {
                dest = enu.nextElement();
                bdl = (BlockedDestList)this.m_ptpBlocked.remove(dest);
                bdl.emptyBlockedList();
            }
        }
    }

    @Override
    public final void releaseAll() {
        for (BlockedDestList bdl : this.m_ptpBlocked.values()) {
            Stack msgs = bdl.buildOrderedStack();
            while (!msgs.isEmpty()) {
                INackable nackable = (INackable)msgs.pop();
                if (this.DEBUG) {
                    this.debug(this.m_queue.getFlowControlName() + ": Reenqueuing on releaseAll on " + this.buildFullDestinationName(nackable) + " trk: " + nackable.getGuarenteedTrackingNum());
                }
                this.m_outQueue.enqueue(nackable, nackable.getPriority());
            }
        }
        this.m_ptpBlocked.clear();
        this.m_outboundContext.notifyPTPFlowControlRelease();
    }

    @Override
    public final String[] getBlockedDestinations() {
        int count = this.m_ptpBlocked.size();
        String[] list = new String[count];
        int index = 0;
        Enumeration enu = this.m_ptpBlocked.keys();
        while (enu.hasMoreElements()) {
            list[index++] = (String)enu.nextElement();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeExpired(IExpireCheck expChecker, Vector resultContainer) {
        if (!this.m_ptpBlocked.isEmpty()) {
            Hashtable hashtable = this.m_ptpBlocked;
            synchronized (hashtable) {
                BlockedDestList bdl = null;
                Stack unsent = null;
                Stack nacked = null;
                INackable nackable = null;
                Enumeration enu = this.m_ptpBlocked.elements();
                while (enu.hasMoreElements()) {
                    BlockedDestList blockedDestList = bdl = (BlockedDestList)enu.nextElement();
                    synchronized (blockedDestList) {
                        nacked = bdl.buildOrderedNackStack();
                        while (!nacked.isEmpty()) {
                            nackable = (INackable)nacked.pop();
                            if (expChecker.isMsgExpired(nackable)) {
                                this.m_outLimiter.add(-nackable.getLimiterSize(), nackable.getPriority());
                                if (resultContainer == null) {
                                    resultContainer = new Vector<INackable>();
                                }
                                resultContainer.addElement(nackable);
                                continue;
                            }
                            bdl.addNacked(nackable);
                        }
                        unsent = bdl.buildOrderedUnsentStack();
                        while (!unsent.isEmpty()) {
                            nackable = (INackable)unsent.pop();
                            if (expChecker.isMsgExpired(nackable)) {
                                this.m_outLimiter.add(-nackable.getLimiterSize(), nackable.getPriority());
                                if (resultContainer == null) {
                                    resultContainer = new Vector();
                                }
                                resultContainer.addElement(nackable);
                                continue;
                            }
                            bdl.addUnsent(nackable);
                        }
                    }
                }
            }
        }
    }
}

