/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import java.io.IOException;
import java.util.Date;
import progress.message.client.EGeneralException;
import progress.message.client.EInterrupted;
import progress.message.client.EInvalidSelectorException;
import progress.message.client.EInvalidSubjectSyntax;
import progress.message.client.EInvalidTTLException;
import progress.message.client.ENetworkFailure;
import progress.message.client.ENoSubscribersFound;
import progress.message.client.ENotImplemented;
import progress.message.client.ESecurityGeneralException;
import progress.message.client.ESecurityPolicyViolation;
import progress.message.client.EUnauthorizedClient;
import progress.message.zclient.Connection;
import progress.message.zclient.IJobResolver;
import progress.message.zclient.ISubject;
import progress.message.zclient.Job;
import progress.message.zclient.Label;
import progress.message.zclient.Message;
import progress.message.zclient.SecurityConfig;
import progress.message.zclient.Session;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.prAccessor;

public class Subscription
extends Job {
    private ISubject m_subject;
    private int m_count;
    private Label m_deliveryLabel;
    private Connection m_connection;
    private String m_messageSelector;
    private boolean m_isSelectorAtBroker;
    private boolean m_enforceDurableStrictMessageOrder = false;
    private int m_flowToDisk = 0;
    private boolean m_JMSDurable = false;
    private IJobResolver m_resolver;
    private String m_name;

    Subscription() {
        this(null, null);
    }

    Subscription(Connection connection, ISubject subject) {
        this.debugName("Subscription");
        this.m_subject = subject;
        this.m_count = 1;
        this.m_connection = connection;
        this.m_status = 3;
        this.m_messageSelector = null;
        this.m_isSelectorAtBroker = false;
        this.m_name = null;
        this.m_resolver = null;
    }

    @Override
    public void resolve() {
        if (this.m_resolver != null) {
            this.m_resolver.resolveJob(this);
            if (this.DEBUG) {
                this.debug("Resolving Subscription: " + this);
            }
        } else if (this.DEBUG) {
            this.debug("Not resolving Subscription: " + this);
        }
    }

    public ISubject getSubject() {
        return this.m_subject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDeliveryLabel(Label label) throws EInvalidSubjectSyntax, ENetworkFailure, EInvalidTTLException, ESecurityPolicyViolation, EGeneralException {
        Object object = this.m_connection.getSubscriptionMutex();
        synchronized (object) {
            Label oldlabel = this.m_deliveryLabel;
            this.m_deliveryLabel = label;
            if (this.m_status > 0) {
                try {
                    this.sendSubscribeRequest();
                }
                catch (EGeneralException e) {
                    this.m_deliveryLabel = oldlabel;
                    throw e;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Label getDeliveryLabel() {
        Object object = this.m_connection.getSubscriptionMutex();
        synchronized (object) {
            return this.m_deliveryLabel;
        }
    }

    public Label getDeliveryLabelNoLock() {
        return this.m_deliveryLabel;
    }

    void setDurableStrictMessageOrder(boolean enforceDurableStrictMessageOrder) {
        this.m_enforceDurableStrictMessageOrder = enforceDurableStrictMessageOrder;
    }

    public boolean getDurableStrictMessageOrder() {
        return this.m_enforceDurableStrictMessageOrder;
    }

    public void setJMSDurable(boolean val) {
        this.m_JMSDurable = val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExpiration(Date expirationDate) throws EInvalidSubjectSyntax, ENetworkFailure, ESecurityPolicyViolation, EInvalidTTLException, EGeneralException {
        Object object = this.m_connection.getSubscriptionMutex();
        synchronized (object) {
            Date oldDate = this.m_deliveryLabel.getExpiration();
            this.m_deliveryLabel.setExpiration(expirationDate);
            if (this.m_status > 0) {
                try {
                    this.sendSubscribeRequest();
                }
                catch (EGeneralException e) {
                    this.m_deliveryLabel.setExpiration(oldDate);
                    throw e;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getExpiration() {
        Object object = this.m_connection.getSubscriptionMutex();
        synchronized (object) {
            return this.m_deliveryLabel.getExpiration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancel(boolean forceCancel) throws ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        Object object = this.m_connection.getSubscriptionMutex();
        synchronized (object) {
            try {
                if (forceCancel) {
                    this.m_count = 1;
                }
                --this.m_count;
                Session ssn = this.m_connection.getInternalSession();
                Message req = ssn.buildUnsubscribeRequest(this.m_subject);
                Connection subscribeRequestResolver = this.m_connection;
                ssn.request(req, -1, (IJobResolver)subscribeRequestResolver);
                this.m_connection.removeSubscription(this.m_subject);
                this.setStatus(0);
            }
            catch (ENoSubscribersFound e) {
                throw new ENetworkFailure(176, SessionConfig.ADMIN_CLIENT_DEAD);
            }
            catch (EGeneralException e) {
                throw e;
            }
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void suspend() {
        throw new ENotImplemented("Subscription.suspend()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() throws ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        Object object = this.m_connection.getSubscriptionMutex();
        synchronized (object) {
            try {
                this.m_connection.removeSubscription(this.m_subject);
                if (this.m_count < 1) {
                    Session ssn = this.m_connection.getInternalSession();
                    Message req = ssn.buildUnsubscribeRequest(this.m_subject);
                    Connection subscribeRequestResolver = this.m_connection;
                    ssn.request(req, -1, (IJobResolver)subscribeRequestResolver);
                }
                this.setStatus(0);
            }
            catch (ENoSubscribersFound e) {
                throw new ENetworkFailure(176, SessionConfig.ADMIN_CLIENT_DEAD);
            }
            catch (EGeneralException e) {
                throw e;
            }
        }
    }

    synchronized int incrementCount() {
        return ++this.m_count;
    }

    synchronized int decrementCount() {
        return --this.m_count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDeliveryLabelInternal(Label label) {
        Object object = this.m_connection.getSubscriptionMutex();
        synchronized (object) {
            this.m_deliveryLabel = label;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendSubscribeRequest() throws EInvalidSubjectSyntax, EInvalidSelectorException, EInvalidTTLException, EInterrupted, EGeneralException, ENetworkFailure, ESecurityPolicyViolation {
        Object object = this.m_connection.getSubscriptionMutex();
        synchronized (object) {
            this.sendSubscribeRequestNoLock();
        }
    }

    public void sendSubscribeRequestNoLock() throws EInvalidSubjectSyntax, EInvalidSelectorException, EInvalidTTLException, EInterrupted, EGeneralException, ENetworkFailure, ESecurityPolicyViolation {
        try {
            Session ssn = this.m_connection.getInternalSession();
            Message req = ssn.buildSubscribeRequest(this.m_subject, this.m_deliveryLabel, this.m_messageSelector, this.m_isSelectorAtBroker, this.m_enforceDurableStrictMessageOrder, this.m_flowToDisk, this.m_JMSDurable);
            Connection subscribeRequestResolver = this.m_connection;
            Message reply = ssn.request(req, -1, (IJobResolver)subscribeRequestResolver);
            switch (reply.readInt()) {
                case -1: {
                    throw new EInvalidSubjectSyntax(prAccessor.getString("STR176"));
                }
                case -7: {
                    if (this.m_connection.getApplicationId().indexOf("$QB$") > -1) {
                        throw new EUnauthorizedClient(SecurityConfig.ERRMSG_NO_BROWSE_PERM + this.m_subject.getSubjectString());
                    }
                    throw new EUnauthorizedClient(SecurityConfig.ERRMSG_NO_SUBSCRIBE_PERM + this.m_subject.getSubjectString());
                }
                case -8: {
                    throw new EUnauthorizedClient(SecurityConfig.ERRMSG_NO_GUARANTEE_PERM + this.m_subject.getSubjectString());
                }
                case -10: {
                    throw new ESecurityGeneralException(SecurityConfig.ERRMSG_GENERAL_ERROR);
                }
                case -24: {
                    throw new EInvalidTTLException(this.m_deliveryLabel.getExpiration().getTime());
                }
                case -22: {
                    throw new EInvalidSelectorException(prAccessor.getString("STR191"));
                }
                case -40: {
                    throw new EGeneralException(1408, prAccessor.getString("ERROR_BROKER_EXCEPTION"));
                }
            }
        }
        catch (ENoSubscribersFound e) {
            throw new ENetworkFailure(176, SessionConfig.ADMIN_CLIENT_DEAD);
        }
        catch (EGeneralException e) {
            throw e;
        }
        catch (IOException e) {
            throw new ENetworkFailure(177, SessionConfig.SUB_REQ_ERROR + ": " + e);
        }
    }

    void setMessageSelector(String selector) {
        this.m_messageSelector = selector;
    }

    void setSelectorAtBroker(boolean isSelectorAtBroker) {
        this.m_isSelectorAtBroker = isSelectorAtBroker;
    }

    void setSubscriptionName(String name) {
        this.m_name = name;
    }

    public String getMessageSelector() {
        return this.m_messageSelector;
    }

    public boolean getSelectorAtBroker() {
        return this.m_isSelectorAtBroker;
    }

    public String getSubscriptionName() {
        return this.m_name;
    }

    public int getFlowToDisk() {
        return this.m_flowToDisk;
    }

    public void setFlowToDisk(int setting) {
        this.m_flowToDisk = setting;
    }

    @Override
    protected String getDiagnosticThreadInfo() {
        StringBuilder sb = new StringBuilder("Subscription: dest ");
        try {
            this.m_subject.appendSubjectString(sb, 2);
        }
        catch (Throwable t) {
            sb.append("<unknown>");
        }
        sb.append(", conn ");
        sb.append(this.m_connection != null ? this.m_connection.getApplicationId() : "<unknown>");
        return sb.toString();
    }
}

