/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mq.common.runtime.impl;

import com.sonicsw.mq.common.runtime.IQueueData;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class QueueData
implements IQueueData,
Serializable {
    private static final long serialVersionUID = 0L;
    private static final short CURRENT_VERSION = 1;
    private static final short VERSION_TOTALSIZE = 1;
    public static final int SYSTEM_QUEUE_TYPE = 1;
    public static final int TEMPORARY_QUEUE_TYPE = 2;
    public static final int CLUSTERED_QUEUE_TYPE = 4;
    public static final int GLOBAL_QUEUE_TYPE = 8;
    public static final int PENDING_QUEUE_TYPE = 16;
    public static final int EXCLUSIVE_QUEUE_TYPE = 32;
    private short m_version;
    private String m_queueName;
    private int m_queueTypeMask;
    private int m_messageCount;
    private long m_messagesSize;

    public QueueData() {
    }

    public QueueData(String queueName, int queueTypeMask, int messageCount, long messagesSize) {
        this.m_version = 1;
        this.m_queueName = queueName;
        this.m_queueTypeMask = queueTypeMask;
        this.m_messageCount = messageCount;
        this.m_messagesSize = messagesSize;
    }

    @Override
    public String getQueueName() {
        return this.m_queueName;
    }

    @Override
    public boolean isSystemQueue() {
        return (this.m_queueTypeMask & 1) > 0;
    }

    @Override
    public boolean isTemporaryQueue() {
        return (this.m_queueTypeMask & 2) > 0;
    }

    @Override
    public boolean isClusteredQueue() {
        return (this.m_queueTypeMask & 4) > 0;
    }

    @Override
    public boolean isGlobalQueue() {
        return (this.m_queueTypeMask & 8) > 0;
    }

    @Override
    public boolean isExclusiveQueue() {
        return (this.m_queueTypeMask & 0x20) > 0;
    }

    @Override
    public int getMessageCount() {
        return this.m_messageCount;
    }

    @Override
    public long getTotalMessageSize() {
        return this.m_messagesSize;
    }

    @Override
    public boolean hasTotalMessageSize() {
        return this.m_version >= 1;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeShort(this.m_version);
        stream.writeUTF(this.m_queueName);
        stream.writeInt(this.m_queueTypeMask);
        stream.writeInt(this.m_messageCount);
        if (this.hasTotalMessageSize()) {
            stream.writeLong(this.m_messagesSize);
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.m_version = stream.readShort();
        this.m_queueName = stream.readUTF();
        this.m_queueTypeMask = stream.readInt();
        this.m_messageCount = stream.readInt();
        if (this.hasTotalMessageSize()) {
            this.m_messagesSize = stream.readLong();
        }
    }
}

