/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.net.http;

import com.sonicsw.net.http.HttpConstants;
import com.sonicsw.net.http.HttpHelper;
import com.sonicsw.net.http.HttpResponseInfo;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import progress.message.net.https.client.HTTPSURLConnection;
import progress.message.zclient.DebugThread;

public class TimedUrlConnection {
    private static int m_responseInfoThreadId = 0;
    private HttpResponseInfo m_responseInfo = new HttpResponseInfo(408);
    private Exception m_responseException = null;
    private boolean m_updateReceived = false;

    public HttpResponseInfo getResponseInfoWithExceptions(URLConnection connection, int time, ITimedUrlConnectionUserHandle clientThread) throws Exception {
        HttpResponseInfo result = this.getResponseInfo(connection, time, clientThread);
        if (this.m_responseException != null) {
            throw this.m_responseException;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponseInfo getResponseInfo(URLConnection connection, int time, ITimedUrlConnectionUserHandle threadHolder) {
        ResponseInfoThread responseThread = threadHolder.getResponseThread();
        if (responseThread == null || responseThread.isGetttingResponse() || !responseThread.isAlive()) {
            if (responseThread != null) {
                responseThread.cancel();
            }
            responseThread = new ResponseInfoThread(++m_responseInfoThreadId, threadHolder.getThreadId());
            threadHolder.setResponseThread(responseThread);
            responseThread.start();
        }
        connection.setReadTimeout(time + 5000);
        responseThread.receiveResponse(connection, this);
        try {
            TimedUrlConnection timedUrlConnection = this;
            synchronized (timedUrlConnection) {
                long startTime = System.currentTimeMillis();
                long remainingTime = time;
                while (remainingTime >= 0L && !this.m_updateReceived) {
                    this.wait(remainingTime);
                    remainingTime = (long)time - (System.currentTimeMillis() - startTime);
                    if (remainingTime > 0L) continue;
                    this.notifyAll();
                    break;
                }
            }
        }
        catch (InterruptedException i) {
            this.m_responseInfo = new HttpResponseInfo(610);
        }
        finally {
            responseThread = null;
        }
        return this.m_responseInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(HttpResponseInfo arg, Throwable t) {
        TimedUrlConnection timedUrlConnection = this;
        synchronized (timedUrlConnection) {
            this.m_responseInfo = arg;
            if (t != null && t instanceof Exception) {
                this.m_responseException = (Exception)t;
            }
            this.m_updateReceived = true;
            this.notifyAll();
        }
    }

    public static interface ITimedUrlConnectionUserHandle {
        public ResponseInfoThread getResponseThread();

        public void setResponseThread(ResponseInfoThread var1);

        public int getThreadId();
    }

    public class ResponseInfoThread
    extends DebugThread {
        private URLConnection connection;
        private int code;
        private String message;
        private TimedUrlConnection observer;
        private boolean canceled;
        private boolean receiveResponse;
        private boolean gettingResponse;

        ResponseInfoThread(int threadId, int dispatchThreadId) {
            super("HttpDirectResponseInfoThread " + threadId + " for dispatch thread " + dispatchThreadId);
            this.code = 610;
            this.message = null;
            this.observer = null;
            this.canceled = false;
            this.receiveResponse = false;
            this.gettingResponse = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void receiveResponse(URLConnection connection, TimedUrlConnection observer) {
            ResponseInfoThread responseInfoThread = this;
            synchronized (responseInfoThread) {
                this.connection = connection;
                this.observer = observer;
                this.receiveResponse = true;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            ResponseInfoThread responseInfoThread = this;
            synchronized (responseInfoThread) {
                this.canceled = true;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isGetttingResponse() {
            ResponseInfoThread responseInfoThread = this;
            synchronized (responseInfoThread) {
                return this.gettingResponse;
            }
        }

        private void retrieveResponse() throws IOException {
            block4: {
                try {
                    this.connection.getInputStream();
                }
                catch (IOException e) {
                    if (!HttpHelper.isHttps(this.connection)) break block4;
                    throw e;
                }
            }
            if (HttpHelper.isHttps(this.connection)) {
                this.code = ((HTTPSURLConnection)this.connection).getHTTPResponseCode();
                this.message = ((HTTPSURLConnection)this.connection).getHTTPResponseMessage();
            } else {
                this.code = ((HttpURLConnection)this.connection).getResponseCode();
                this.message = ((HttpURLConnection)this.connection).getResponseMessage();
            }
            HttpConstants.DEBUG("OutboundHandler got response from remote : code =  " + this.code + " message = " + this.message, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void threadMain() {
            HttpConstants.DEBUG("Thread " + this.m_name + " is starting", 0);
            while (!Thread.interrupted()) {
                ResponseInfoThread responseInfoThread;
                ResponseInfoThread responseInfoThread2 = this;
                synchronized (responseInfoThread2) {
                    this.gettingResponse = false;
                    while (!this.canceled && !this.receiveResponse) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException ex) {
                            HttpConstants.DEBUG("Thread " + this.m_name + " is exiting after interruption", 0);
                            return;
                        }
                    }
                    if (this.canceled) {
                        HttpConstants.DEBUG("Thread " + this.m_name + " is exiting after cancel", 0);
                        return;
                    }
                    this.receiveResponse = false;
                    this.gettingResponse = true;
                }
                try {
                    HttpConstants.DEBUG("Initiating Http Direct route request to " + this.connection.getURL().toString(), 1);
                    this.retrieveResponse();
                    HttpConstants.DEBUG("Http Direct route request returned successfully with code " + this.code, 1);
                    responseInfoThread2 = this;
                    synchronized (responseInfoThread2) {
                        this.gettingResponse = false;
                        this.observer.update(new HttpResponseInfo(this.code, this.message, this.connection), null);
                    }
                }
                catch (FileNotFoundException e) {
                    HttpConstants.DEBUG("Http Direct route request failed with error: " + e.getMessage(), 0);
                    responseInfoThread = this;
                    synchronized (responseInfoThread) {
                        this.gettingResponse = false;
                        this.observer.update(new HttpResponseInfo(404, e.getMessage(), this.connection), e);
                    }
                }
                catch (IOException e) {
                    HttpConstants.DEBUG("Http Direct route request failed with error: " + e.getMessage(), 0);
                    HttpConstants.DEBUG(e, 1);
                    responseInfoThread = this;
                    synchronized (responseInfoThread) {
                        this.gettingResponse = false;
                        this.observer.update(new HttpResponseInfo(610, e.getMessage(), this.connection), e);
                    }
                }
                catch (Throwable e) {
                    HttpConstants.DEBUG("Http Direct route request failed with error: " + e.getMessage(), 0);
                    HttpConstants.DEBUG(e, 1);
                    responseInfoThread = this;
                    synchronized (responseInfoThread) {
                        this.gettingResponse = false;
                        this.observer.update(new HttpResponseInfo(610, e.getMessage(), this.connection), e);
                    }
                }
            }
        }
    }
}

