/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.axis.handlers;

import com.sonicsw.ws.axis.DebugObjects;
import com.sonicsw.ws.axis.handlers.UniversalHandler;
import com.sonicsw.ws.rm.policy.RMPolicy;
import com.sonicsw.ws.rm.policy.WSRMPUtils;
import com.sonicsw.ws.security.policy.Assertion;
import com.sonicsw.ws.security.policy.SecurityPolicyAlternative;
import com.sonicsw.ws.security.policy.WSSPUtils;
import com.sonicsw.wsp.OperationContext;
import com.sonicsw.wsp.PolicyException;
import com.sonicsw.wsp.SecurityPolicy2002Exception;
import com.sonicsw.wsp.WSPUtils;
import java.util.Iterator;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.ws.policy.Policy;
import org.apache.xmlbeans.XmlObject;
import org.xmlsoap.schemas.ws.x2004.x09.policy.OperatorContentType;
import org.xmlsoap.schemas.ws.x2004.x09.policy.PolicyDocument;
import progress.message.msg.IMgram;

public class PolicyFromJMSHandler
extends UniversalHandler {
    @Override
    public void handleClientRequest(MessageContext mc) throws AxisFault {
        this.debug("PolicyFromJMSHandler:handleClientRequest", mc);
        IMgram mg = (IMgram)mc.getProperty("progress.message.msg.IMgram");
        if (mg == null) {
            return;
        }
        try {
            String inPolicy = (String)mg.getSidebandDataReadOnly().getProperty("X-WS-MessagePolicy");
            String outPolicy = (String)mg.getSidebandDataReadOnly().getProperty("X-WS-MessagePolicy-Out");
            String faultPolicy = (String)mg.getSidebandDataReadOnly().getProperty("X-WS-MessagePolicy-Fault");
            if (outPolicy != null && inPolicy != null) {
                DebugObjects.getPolicyDebug().debug("PolicyFromJMSHandler: establishing operation context with reply policy\n" + outPolicy);
                OperationContext oc = new OperationContext(null, outPolicy);
                mc.setProperty("COM_SONIC_WS_OPERATION_CONTEXT", (Object)oc);
            }
            String policyProp = inPolicy;
            String desc = "input";
            if (inPolicy == null) {
                if (outPolicy == null && faultPolicy != null) {
                    desc = "fault";
                    policyProp = faultPolicy;
                } else {
                    desc = "output";
                    policyProp = outPolicy;
                }
            }
            DebugObjects.getPolicyDebug().debug("PolicyFromJMSHandler: MEP " + desc + " policy doc from JMS property -\n" + policyProp);
            if (policyProp == null || policyProp.length() == 0) {
                mc.setProperty("com.sonicsw.ws.rm.policy.RMPolicy", (Object)new RMPolicy());
                mc.setProperty("com.sonicsw.ws.security.policy.SecurityPolicyAlternative", (Object)new SecurityPolicyAlternative());
                return;
            }
            this.apply(mc, policyProp);
        }
        catch (Exception e) {
            throw AxisFault.makeFault((Exception)e);
        }
    }

    @Override
    public void handleClientResponse(MessageContext mc) throws AxisFault {
        this.debug("PolicyFromJMSHandler:handleClientResponse", mc);
    }

    @Override
    public void handleServerRequest(MessageContext mc) throws AxisFault {
        this.debug("PolicyFromJMSHandler:handleServerRequest", mc);
    }

    @Override
    public void handleServerResponse(MessageContext mc) throws AxisFault {
        this.debug("PolicyFromJMSHandler:handleServerResponse", mc);
        IMgram mg = (IMgram)mc.getProperty("COM_SONIC_RESPONSEMGRAM");
        if (mg == null) {
            return;
        }
        try {
            boolean MEPfault = false;
            String policyProp = (String)mg.getSidebandDataReadOnly().getProperty("X-WS-MessagePolicy-Out");
            if (policyProp == null) {
                policyProp = (String)mg.getSidebandDataReadOnly().getProperty("X-WS-MessagePolicy-Fault");
                MEPfault = policyProp != null;
            }
            Object pdoc = null;
            DebugObjects.getPolicyDebug().debug("PolicyFromJMSHandler: MEP " + (MEPfault ? "fault" : "output") + " policy doc from JMS property -\n" + policyProp);
            SecurityPolicyAlternative sp = (SecurityPolicyAlternative)mc.getProperty("com.sonicsw.ws.security.policy.SecurityPolicyAlternative");
            RMPolicy rmp = (RMPolicy)mc.getProperty("com.sonicsw.ws.rm.policy.RMPolicy");
            if (policyProp == null || policyProp.length() == 0) {
                if (sp == null) {
                    mc.setProperty("com.sonicsw.ws.security.policy.SecurityPolicyAlternative", (Object)new SecurityPolicyAlternative());
                } else {
                    DebugObjects.getPolicyDebug().debug("PolicyFromJMSHandler: using the WSS output policy from WSDL for the service response");
                }
                if (rmp == null) {
                    mc.setProperty("com.sonicsw.ws.rm.policy.RMPolicy", (Object)new RMPolicy());
                } else {
                    DebugObjects.getPolicyDebug().debug("PolicyFromJMSHandler: using the WSRM output policy from WSDL for the service response");
                }
                return;
            }
            this.apply(mc, policyProp);
        }
        catch (Exception e) {
            throw AxisFault.makeFault((Exception)e);
        }
    }

    private void apply(MessageContext mc, String policyProp) throws Exception {
        Policy policy = null;
        try {
            policy = WSPUtils.getPolicy(policyProp);
            this.setWSRMPolicyContext(mc, policy);
            this.setWSSEPolicyContext(mc, policy);
        }
        catch (SecurityPolicy2002Exception e) {
            PolicyDocument pdoc = WSPUtils.getPolicyDocument(policyProp);
            this.setWSRMPolicyContext(mc, pdoc);
            this.setWSSEPolicyContext(mc, pdoc);
        }
    }

    @Override
    public void onFault(MessageContext mc) {
        DebugObjects.getHandlerDebug().debug("PolicyFromJMSHandler:onFault:" + mc.hashCode());
    }

    private void setWSRMPolicyContext(MessageContext mc, Policy policy) {
        mc.setProperty("com.sonicsw.ws.rm.policy.RMPolicy", (Object)WSRMPUtils.convertRMPolicy(policy));
    }

    private void setWSSEPolicyContext(MessageContext mc, Policy policy) throws AxisFault, PolicyException {
        SecurityPolicyAlternative sp = (SecurityPolicyAlternative)mc.getProperty("com.sonicsw.ws.security.policy.SecurityPolicyAlternative");
        if (sp != null) {
            DebugObjects.getPolicyDebug().debug("PolicyFromJMSHandler: overriding the policy from WSDL.");
        }
        sp = new SecurityPolicyAlternative();
        mc.setProperty("com.sonicsw.ws.security.policy.SecurityPolicyAlternative", (Object)sp);
        WSSPUtils.buildActions(policy, sp);
    }

    private void setWSRMPolicyContext(MessageContext mc, PolicyDocument policy) {
        RMPolicy rmp = (RMPolicy)mc.getProperty("com.sonicsw.ws.rm.policy.RMPolicy");
        if (rmp != null) {
            DebugObjects.getPolicyDebug().debug("PolicyFromJMSHandler: overriding the RM policy from WSDL.");
        }
        XmlObject rma = WSRMPUtils.getRMAssertion(policy);
        mc.setProperty("com.sonicsw.ws.rm.policy.RMPolicy", (Object)WSRMPUtils.convertRMPolicy(rma));
    }

    private void setWSSEPolicyContext(MessageContext mc, PolicyDocument policy) throws AxisFault, PolicyException {
        if (!WSPUtils.isNormalized(policy)) {
            throw new AxisFault("Policy must be normalized");
        }
        SecurityPolicyAlternative sp = (SecurityPolicyAlternative)mc.getProperty("com.sonicsw.ws.security.policy.SecurityPolicyAlternative");
        if (sp != null) {
            DebugObjects.getPolicyDebug().debug("PolicyFromJMSHandler: overriding the WSS policy from WSDL.");
        }
        sp = new SecurityPolicyAlternative();
        mc.setProperty("com.sonicsw.ws.security.policy.SecurityPolicyAlternative", (Object)sp);
        String soapEnvNSUri = mc.getSOAPConstants().getEnvelopeURI();
        Iterator alls = WSPUtils.getNormalizedAllIterator(policy);
        if (alls.hasNext()) {
            OperatorContentType all = (OperatorContentType)alls.next();
            XmlObject[] xmlobjs = WSSPUtils.getAllSecurityAssertions(all);
            for (int i = 0; i < xmlobjs.length; ++i) {
                Assertion a = WSSPUtils.createAssertionObject(soapEnvNSUri, xmlobjs[i]);
                DebugObjects.getHandlerDebug().debug("PolicyFromJMSHandler: populating security assertion -\n" + a);
                sp.addAction(a);
            }
        }
    }
}

