/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.rm.policy;

import com.sonicsw.ws.axis.DebugObjects;
import com.sonicsw.ws.rm.policy.RMPolicy;
import com.sonicsw.ws.rm.policy.RMPolicyToken;
import com.sonicsw.ws.rm.policy.RMProcessorContext;
import com.sonicsw.ws.rm.policy.processors.AcknowledgementIntervalProcessor;
import com.sonicsw.ws.rm.policy.processors.BaseRetransmissionItervalProcessor;
import com.sonicsw.ws.rm.policy.processors.ExponentialBackoffProcessor;
import com.sonicsw.ws.rm.policy.processors.InactivityTimeoutProcessor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import org.apache.ws.policy.AndCompositeAssertion;
import org.apache.ws.policy.Assertion;
import org.apache.ws.policy.Policy;
import org.apache.ws.policy.PrimitiveAssertion;
import org.apache.ws.policy.XorCompositeAssertion;
import org.apache.ws.policy.util.PolicyFactory;
import org.apache.ws.policy.util.PolicyReader;

public class RMPolicyProcessor {
    RMPolicyToken topLevel = new RMPolicyToken("_TopLevel_", 1, null);
    RMProcessorContext rmProcessorContext = null;

    public boolean setup() {
        RMPolicyToken rpt = null;
        try {
            BaseRetransmissionItervalProcessor rip = new BaseRetransmissionItervalProcessor();
            rpt = RMPolicy.baseRetransmissionIterval.copy();
            rpt.setProcessTokenMethod(rip);
            this.topLevel.setChildToken(rpt);
            AcknowledgementIntervalProcessor aip = new AcknowledgementIntervalProcessor();
            rpt = RMPolicy.acknowledgementInterval.copy();
            rpt.setProcessTokenMethod(aip);
            this.topLevel.setChildToken(rpt);
            ExponentialBackoffProcessor ebp = new ExponentialBackoffProcessor();
            rpt = RMPolicy.exponentialBackoff.copy();
            rpt.setProcessTokenMethod(ebp);
            this.topLevel.setChildToken(rpt);
            InactivityTimeoutProcessor itp = new InactivityTimeoutProcessor();
            rpt = RMPolicy.inactiveTimeout.copy();
            rpt.setProcessTokenMethod(itp);
            this.topLevel.setChildToken(rpt);
        }
        catch (NoSuchMethodException ex) {
            ex.printStackTrace();
        }
        RMPolicy ped = new RMPolicy();
        this.rmProcessorContext = new RMProcessorContext();
        this.rmProcessorContext.pushRMToken(this.topLevel);
        this.rmProcessorContext.pushRMPolicy(ped);
        return true;
    }

    public boolean processPolicy(Policy policy) {
        if (!policy.isNormalized()) {
            throw new RuntimeException("Policy is not in normalized format");
        }
        XorCompositeAssertion xor = (XorCompositeAssertion)policy.getTerms().get(0);
        List listOfPolicyAlternatives = xor.getTerms();
        boolean success = false;
        int numberOfAlternatives = listOfPolicyAlternatives.size();
        for (int i = 0; !success && i < numberOfAlternatives; ++i) {
            AndCompositeAssertion aPolicyAlternative = (AndCompositeAssertion)listOfPolicyAlternatives.get(i);
            List listOfAssertions = aPolicyAlternative.getTerms();
            Iterator iterator = listOfAssertions.iterator();
            boolean all = true;
            while (all && iterator.hasNext()) {
                Assertion assertion = (Assertion)iterator.next();
                if (!(assertion instanceof PrimitiveAssertion)) {
                    DebugObjects.getPolicyDebug().debug("RMPolicyProcessor got an unexpected assertion type: " + assertion.getClass().getName());
                    continue;
                }
                PrimitiveAssertion pa = (PrimitiveAssertion)assertion;
                if (!pa.getName().getLocalPart().equals("RMAssertion")) {
                    DebugObjects.getPolicyDebug().debug("RMPolicyProcessor skipping non-RM assertion: " + pa.getName().getLocalPart());
                    continue;
                }
                DebugObjects.getPolicyDebug().debug("Processing RM assertion, namespace = " + pa.getName().getNamespaceURI());
                all = this.processRMAssertion((PrimitiveAssertion)assertion);
            }
            success = all;
        }
        return success;
    }

    boolean processRMAssertion(PrimitiveAssertion pa) {
        this.rmProcessorContext.readCurrentRMPolicy().setRMPolicyRequired(true);
        boolean commit = true;
        List terms = pa.getTerms();
        if (!terms.isEmpty()) {
            for (int i = 0; commit && i < terms.size(); ++i) {
                Assertion assertion = (Assertion)pa.getTerms().get(i);
                if (assertion instanceof Policy) {
                    commit = this.processPolicy((Policy)assertion);
                    continue;
                }
                if (!(assertion instanceof PrimitiveAssertion)) continue;
                commit = this.processPrimitiveAssertion((PrimitiveAssertion)assertion);
            }
        }
        return commit;
    }

    boolean processPrimitiveAssertion(PrimitiveAssertion pa) {
        boolean commit = true;
        commit = this.startPolicyTransaction(pa);
        List terms = pa.getTerms();
        if (commit && !terms.isEmpty()) {
            for (int i = 0; commit && i < terms.size(); ++i) {
                Assertion assertion = (Assertion)pa.getTerms().get(i);
                if (assertion instanceof Policy) {
                    commit = this.processPolicy((Policy)assertion);
                    continue;
                }
                if (!(assertion instanceof PrimitiveAssertion)) continue;
                commit = this.processPrimitiveAssertion((PrimitiveAssertion)assertion);
            }
        }
        if (commit) {
            this.commitPolicyTransaction(pa);
        } else {
            this.abortPolicyTransaction(pa);
        }
        return commit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startPolicyTransaction(PrimitiveAssertion pa) {
        String tokenName = pa.getName().getLocalPart();
        RMPolicyToken rmpt = null;
        RMPolicyToken currentToken = this.rmProcessorContext.readCurrentPolicyToken();
        if (currentToken == null) {
            DebugObjects.getPolicyDebug().debug("Internal error on token stack - No current token");
            throw new RuntimeException("Internal error on token stack - No current token");
        }
        rmpt = currentToken.getChildToken(tokenName);
        this.rmProcessorContext.pushRMToken(rmpt);
        this.rmProcessorContext.setAssertion(pa);
        this.rmProcessorContext.setAction(1);
        RMPolicy ped = this.rmProcessorContext.readCurrentRMPolicy();
        ped = ped.copy();
        this.rmProcessorContext.pushRMPolicy(ped);
        if (rmpt == null) {
            DebugObjects.getPolicyDebug().debug("RM token: '" + tokenName + "' unknown in context of '" + currentToken.getTokenName());
            return false;
        }
        boolean ret = false;
        try {
            ret = rmpt.invokeProcessTokenMethod(this.rmProcessorContext);
        }
        catch (Exception ex) {
            DebugObjects.getPolicyDebug().debug("Exception occured when invoking processTokenMethod: " + ex);
        }
        finally {
            this.rmProcessorContext.setAction(0);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortPolicyTransaction(PrimitiveAssertion pa) {
        RMPolicyToken currentToken = this.rmProcessorContext.readCurrentPolicyToken();
        if (currentToken == null) {
            DebugObjects.getPolicyDebug().debug("Abort transaction because of unknown token: '" + pa.getName().getLocalPart() + "'");
            this.rmProcessorContext.popRMToken();
            return;
        }
        this.rmProcessorContext.setAssertion(pa);
        this.rmProcessorContext.setAction(3);
        try {
            currentToken.invokeProcessTokenMethod(this.rmProcessorContext);
        }
        catch (Exception ex) {
            DebugObjects.getPolicyDebug().debug("Exception occured when invoking processTokenMethod: " + ex);
        }
        finally {
            this.rmProcessorContext.setAction(0);
            this.rmProcessorContext.popRMToken();
            this.rmProcessorContext.popRMPolicy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitPolicyTransaction(PrimitiveAssertion pa) {
        RMPolicyToken currentToken = this.rmProcessorContext.readCurrentPolicyToken();
        if (currentToken == null) {
            String err = "Internal error on token stack - Commiting an unknown token: " + pa.getName().getLocalPart() + "'";
            DebugObjects.getPolicyDebug().debug(err);
            throw new RuntimeException(err);
        }
        this.rmProcessorContext.setAssertion(pa);
        this.rmProcessorContext.setAction(2);
        try {
            currentToken.invokeProcessTokenMethod(this.rmProcessorContext);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        finally {
            this.rmProcessorContext.setAction(0);
            this.rmProcessorContext.popRMToken();
            this.rmProcessorContext.commitRMPolicy();
        }
    }

    public RMProcessorContext getContext() {
        return this.rmProcessorContext;
    }

    public void setContext(RMProcessorContext rmProcessorContext) {
        this.rmProcessorContext = rmProcessorContext;
    }

    public static void main(String[] args) throws Exception {
        String[] files = new String[]{"C:/Views/pyin_view_MQAruba/vobs_migtest/src/qa/sonicsw/wsp/RMPolicy.xml"};
        Policy merged = null;
        PolicyReader prdr = PolicyFactory.getPolicyReader((int)3);
        for (int i = 0; i < files.length; ++i) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(files[i]);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            Policy newPolicy = prdr.readPolicy((InputStream)fis);
            newPolicy = (Policy)newPolicy.normalize();
            merged = merged == null ? newPolicy : (Policy)merged.merge((Assertion)newPolicy);
            try {
                if (fis == null) continue;
                fis.close();
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        RMPolicyProcessor processor = new RMPolicyProcessor();
        if (merged != null && processor.setup() && processor.processPolicy(merged)) {
            System.out.println("RM policy:\n" + processor.rmProcessorContext.readCurrentRMPolicy());
        } else {
            System.out.println("FAILED.");
        }
    }
}

