/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.security.processingresult;

import com.sonicsw.ws.axis.DebugObjects;
import com.sonicsw.ws.security.action.Encryption;
import com.sonicsw.ws.security.processingresult.EncryptionSignatureResult;
import com.sonicsw.ws.security.processingresult.ValidationStatus;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.cert.X509Certificate;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.axis.MessageContext;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EncryptionResult
extends EncryptionSignatureResult {
    private X509Certificate m_encryptedKeyCert = null;
    private URI m_algEncryptionURI = null;
    private URI m_algAsymmetricKeyTransportURI = null;
    private Vector m_encryptedElements = new Vector();
    private boolean allRequiredPartsEncrypted = true;

    public void setEncryptedKeyCert(X509Certificate cert) {
        this.m_encryptedKeyCert = cert;
    }

    public void setAsymmetricKeyTransportURI(String alg) {
        this.m_algAsymmetricKeyTransportURI = URI.create(alg);
    }

    public void setEncryptionURI(String alg) {
        this.m_algEncryptionURI = URI.create(alg);
    }

    public void addPart(QName part) {
        this.m_encryptedElements.add(part);
    }

    public EncryptionResult(Element xencEncryptedKey) {
        this.m_element = xencEncryptedKey;
    }

    public EncryptionResult(Element xencEncryptedKey, X509Certificate certificate) {
        this.m_element = xencEncryptedKey;
        this.m_encryptedKeyCert = certificate;
        Document doc = xencEncryptedKey.getOwnerDocument();
        Element encKeyMethod = (Element)WSSecurityUtil.getDirectChild((Node)xencEncryptedKey, (String)"EncryptionMethod", (String)"http://www.w3.org/2001/04/xmlenc#");
        if (encKeyMethod != null && encKeyMethod.getAttribute("Algorithm") != null) {
            this.m_algAsymmetricKeyTransportURI = URI.create(encKeyMethod.getAttribute("Algorithm"));
        }
        String dataRefURI = null;
        Element refList = (Element)WSSecurityUtil.getDirectChild((Node)xencEncryptedKey, (String)"ReferenceList", (String)"http://www.w3.org/2001/04/xmlenc#");
        Node tmpE = null;
        if (refList != null) {
            for (tmpE = refList.getFirstChild(); tmpE != null; tmpE = tmpE.getNextSibling()) {
                Element encMethod;
                if (tmpE.getNodeType() != 1 || !tmpE.getNamespaceURI().equals("http://www.w3.org/2001/04/xmlenc#") || !tmpE.getLocalName().equals("DataReference")) continue;
                dataRefURI = ((Element)tmpE).getAttribute("URI");
                Node encBodyData = null;
                if (dataRefURI != null) {
                    DebugObjects.getPolicyDebug().debug("EncryptionResult.init: data ref found = " + dataRefURI);
                    String id = dataRefURI.trim();
                    if (id.length() != 0 && id.charAt(0) == '#') {
                        id = id.substring(1);
                    }
                    if ((encBodyData = WSSecurityUtil.findElementById((Node)doc.getDocumentElement(), (String)id, (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd")) == null) {
                        encBodyData = WSSecurityUtil.getElementByGenId((Document)doc, (String)dataRefURI);
                    }
                }
                if (this.m_encryptedElements == null) {
                    this.m_encryptedElements = new Vector();
                }
                if (encBodyData == null) {
                    throw new NullPointerException("Element encBodyData is null in " + this.getClass().getName());
                }
                encBodyData = (Element)encBodyData.getParentNode();
                QName encPartQname = new QName(encBodyData.getNamespaceURI(), encBodyData.getLocalName());
                DebugObjects.getPolicyDebug().debug("EncryptionResult.init: encrypted part = " + encPartQname);
                this.m_encryptedElements.add(encPartQname);
                if (this.m_algEncryptionURI != null || (encMethod = (Element)WSSecurityUtil.findElement((Node)encBodyData, (String)"EncryptionMethod", (String)"http://www.w3.org/2001/04/xmlenc#")) == null) continue;
                String symEncAlgo = encMethod.getAttribute("Algorithm");
                DebugObjects.getPolicyDebug().debug("EncryptionResult.init: encryption algorithm = " + symEncAlgo);
                this.m_algEncryptionURI = URI.create(symEncAlgo);
            }
        }
    }

    public X509Certificate getCertificate() {
        return this.m_encryptedKeyCert;
    }

    private void setError(String err) {
        if (this.m_status != null) {
            this.m_status.setError(err);
        }
        this.allRequiredPartsEncrypted = false;
    }

    private void addEncryptedPart(QName part) {
        if (this.m_status != null) {
            this.m_status.addMessagePart(part);
        }
    }

    public boolean validate(Encryption enc, MessageContext mc, ValidationStatus status) {
        this.m_status = status;
        String policyAlg = null;
        URI policyAlgURI = null;
        policyAlg = enc.getKeyEncryptionAlgorithm();
        if (policyAlg != null) {
            DebugObjects.getPolicyDebug().debug("validating key transport alg against policy, expected " + policyAlg);
            try {
                policyAlgURI = new URI(policyAlg);
            }
            catch (URISyntaxException ex) {
                ex.printStackTrace();
                return false;
            }
            if (this.m_algAsymmetricKeyTransportURI == null || !this.m_algAsymmetricKeyTransportURI.equals(policyAlgURI)) {
                this.setError("key transport algorithm not matched, expected " + policyAlgURI + ", found " + this.m_algAsymmetricKeyTransportURI);
                DebugObjects.getPolicyDebug().debug("Validation of key transport algorithm failed, found " + this.m_algAsymmetricKeyTransportURI);
                return false;
            }
        }
        policyAlgURI = null;
        policyAlg = enc.getAlgEncryption();
        if (policyAlg != null) {
            DebugObjects.getPolicyDebug().debug("validating Encryption alg against policy, expected " + policyAlg);
            try {
                policyAlgURI = new URI(policyAlg);
            }
            catch (URISyntaxException ex) {
                ex.printStackTrace();
                return false;
            }
            if (this.m_algEncryptionURI == null || !this.m_algEncryptionURI.equals(policyAlgURI)) {
                DebugObjects.getPolicyDebug().debug("Validation of Encryption alg failed, found " + this.m_algEncryptionURI);
                this.setError("encryption algorithm not matched, expected " + policyAlgURI + ", found " + this.m_algEncryptionURI);
                return false;
            }
        }
        if (!this.validateTokenReference(enc, mc)) {
            return false;
        }
        DebugObjects.getPolicyDebug().debug("EncryptionResult: validating all required message part(s) are encrypted...");
        QName[] requiredParts = enc.getPartsAsQNames();
        if (requiredParts != null) {
            for (int i = 0; i < requiredParts.length; ++i) {
                QName requiredPart = requiredParts[i];
                DebugObjects.getPolicyDebug().debug("EncryptionResult: required encrypted part " + requiredPart);
                boolean found = false;
                for (int j = 0; j < this.m_encryptedElements.size(); ++j) {
                    QName encryptedPart = (QName)this.m_encryptedElements.get(j);
                    DebugObjects.getPolicyDebug().debug("EncryptionResult: found encrypted part " + encryptedPart);
                    found = requiredPart.equals(encryptedPart);
                    if (!found) continue;
                    this.addEncryptedPart(requiredPart);
                    break;
                }
                if (!found) {
                    if (enc.isSP2002()) {
                        String err = "required message part not encrypted: " + requiredPart;
                        this.setError(err);
                        DebugObjects.getPolicyDebug().debug("EncryptionResult:" + err);
                        return false;
                    }
                    NodeList nodes = this.m_element.getOwnerDocument().getElementsByTagNameNS(requiredPart.getNamespaceURI(), requiredPart.getLocalPart());
                    if (nodes.getLength() != 0) {
                        String err = "required message part found in message but not encrypted: " + requiredPart;
                        this.setError(err);
                        DebugObjects.getPolicyDebug().debug("EncryptionResult:" + err);
                        continue;
                    }
                    this.addEncryptedPart(requiredPart);
                    DebugObjects.getPolicyDebug().debug("EncryptionResult: required message part not encrypted: " + requiredPart);
                    continue;
                }
                DebugObjects.getPolicyDebug().debug("EncryptionResult: required message part encrypted: " + requiredPart);
            }
        }
        return this.allRequiredPartsEncrypted;
    }
}

