/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.security.wss4j;

import com.sonicsw.net.http.ws.WSHttpInRequest;
import com.sonicsw.net.http.ws.WSHttpOutRequest;
import com.sonicsw.security.cert.BrokerCertificateStore;
import com.sonicsw.security.cert.BrokerKeyStore;
import com.sonicsw.security.cert.BrokerTrustStore;
import com.sonicsw.security.cert.TrustStore;
import com.sonicsw.ws.axis.DebugObjects;
import com.sonicsw.ws.axis.handlers.PolicyFromWSDLHandler;
import com.sonicsw.ws.security.action.Action;
import com.sonicsw.ws.security.action.Encryption;
import com.sonicsw.ws.security.action.MessagePart;
import com.sonicsw.ws.security.action.Signature;
import com.sonicsw.ws.security.action.SupportingToken;
import com.sonicsw.ws.security.action.Timestamp;
import com.sonicsw.ws.security.action.TransportBindingAction;
import com.sonicsw.ws.security.policy.SecurityPolicyAlternative;
import com.sonicsw.ws.security.policy.WSSPConstants;
import com.sonicsw.ws.security.processingresult.EncryptionResult;
import com.sonicsw.ws.security.processingresult.ProcessingResult;
import com.sonicsw.ws.security.processingresult.SignatureResult;
import com.sonicsw.ws.security.processingresult.SupportingTokenResult;
import com.sonicsw.ws.security.processingresult.TimestampResult;
import com.sonicsw.ws.security.processingresult.TransportBindingResult;
import com.sonicsw.ws.security.processingresult.ValidationStatus;
import com.sonicsw.ws.security.wss4j.SonicWSSecurityEngine;
import com.sonicsw.wsp.OperationContext;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.SOAPPart;
import org.apache.axis.utils.XMLUtils;
import org.apache.ws.security.SOAPConstants;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.Merlin;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WSSInboundHandler {
    private SonicWSSecurityEngine secEngine = (SonicWSSecurityEngine)SonicWSSecurityEngine.getInstance();

    private String getActor(MessageContext mc) {
        String actor = null;
        WSHttpInRequest req = (WSHttpInRequest)mc.getProperty("com.sonicsw.net.http.HttpInRequest");
        if (req != null) {
            actor = req.getSoapActor();
        }
        return actor;
    }

    private Vector getAction(SecurityPolicyAlternative policy, int actionType) {
        if (policy == null || policy.getActions().length == 0) {
            return null;
        }
        Action[] actions = policy.getActions();
        Vector<Action> actionsByType = new Vector<Action>();
        for (int i = 0; i < actions.length; ++i) {
            if (actions[i].getType() != actionType) continue;
            DebugObjects.getHandlerDebug().debug("WSSInboundHandler: required action:\n" + actions[i]);
            actionsByType.add(actions[i]);
        }
        return actionsByType;
    }

    public void handleServerRequest(MessageContext msgContext) throws AxisFault {
        this.handleInboundMessage(msgContext);
    }

    public void handleClientResponse(MessageContext msgContext) throws AxisFault {
        this.handleInboundMessage(msgContext);
    }

    private void handleInboundMessage(MessageContext msgContext) throws AxisFault {
        Message sm = null;
        Document doc = null;
        DebugObjects.getHandlerDebug().debug("WSSInboundHandler: processing " + (msgContext.isClient() ? "service response" : "client request"));
        sm = msgContext.getCurrentMessage();
        if (sm == null) {
            return;
        }
        try {
            doc = sm.getSOAPEnvelope().getAsDocument();
        }
        catch (Exception ex) {
            DebugObjects.getHandlerDebug().debug("WSSInboundHandler: Empty soap envelope or failure to convert the soap envelope into document:" + ex.getMessage());
            return;
        }
        DebugObjects.getHandlerDebug().debug("WSSInboundHandler: SOAP message received:\n" + XMLUtils.PrettyDocumentToString((Document)doc));
        RequestContext reqData = new RequestContext();
        reqData.msgContext = msgContext;
        msgContext.setProperty("com.sonicsw.ws.security.wss4j.InboundProcessor$RequestData", (Object)reqData);
        try {
            AxisFault fault;
            AxisFault fault2;
            this.loadSignatureCrypto(reqData);
            this.loadDecryptionCrypto(reqData);
            Element securityHeader = null;
            Vector wsResult = null;
            String actor = this.getActor(msgContext);
            try {
                SOAPConstants sc;
                if (actor == null) {
                    actor = "";
                }
                if ((securityHeader = WSSecurityUtil.getSecurityHeader((Document)doc, (String)actor, (SOAPConstants)(sc = WSSecurityUtil.getSOAPConstants((Element)doc.getDocumentElement())))) == null) {
                    if (actor.equalsIgnoreCase("http://www.w3.org/2003/05/soap-envelope/role/ultimateReceiver")) {
                        actor = "";
                        securityHeader = WSSecurityUtil.getSecurityHeader((Document)doc, (String)actor, (SOAPConstants)sc);
                        if (securityHeader == null && (securityHeader = WSSecurityUtil.getSecurityHeader((Document)doc, (String)(actor = "http://www.w3.org/2003/05/soap-envelope/role/next"), (SOAPConstants)sc)) == null) {
                            actor = "http://schemas.xmlsoap.org/soap/actor/next";
                            securityHeader = WSSecurityUtil.getSecurityHeader((Document)doc, (String)actor, (SOAPConstants)sc);
                        }
                    } else if (securityHeader == null && (securityHeader = WSSecurityUtil.getSecurityHeader((Document)doc, (String)(actor = "http://www.w3.org/2003/05/soap-envelope/role/next"), (SOAPConstants)sc)) == null) {
                        actor = "http://schemas.xmlsoap.org/soap/actor/next";
                        securityHeader = WSSecurityUtil.getSecurityHeader((Document)doc, (String)actor, (SOAPConstants)sc);
                    }
                }
                if (securityHeader != null) {
                    DebugObjects.getHandlerDebug().debug("WSSInboundHandler: Processing WS-Security header for '" + actor + "' actor.");
                    wsResult = this.secEngine.processSecurityHeader(securityHeader, new PasswordCallbackHandler(reqData.msgContext), (Crypto)this.loadCertCrypto(), reqData.decCrypto);
                }
            }
            catch (WSSecurityException ex) {
                AxisFault fault3 = new AxisFault(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "InvalidSecurity"), "An error was discovered processing the wsse:Security header.", actor, (Element[])null);
                fault3.clearFaultDetails();
                fault3.addFaultDetailString(ex.getMessage());
                fault3.setStackTrace(ex.getStackTrace());
                throw fault3;
            }
            if (securityHeader != null) {
                ArrayList<QName> processedHeaders = new ArrayList<QName>();
                for (org.apache.axis.message.SOAPHeaderElement tempHeader : sm.getSOAPEnvelope().getHeaders()) {
                    if (!tempHeader.isProcessed()) continue;
                    processedHeaders.add(tempHeader.getQName());
                }
                SOAPPart sPart = (SOAPPart)sm.getSOAPPart();
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                org.apache.xml.security.utils.XMLUtils.outputDOM((Node)doc, (OutputStream)os, (boolean)true);
                sPart.setCurrentMessage((Object)os.toByteArray(), 4);
                for (QName qname : processedHeaders) {
                    Enumeration headersByName = sm.getSOAPEnvelope().getHeadersByName(qname.getNamespaceURI(), qname.getLocalPart());
                    while (headersByName.hasMoreElements()) {
                        org.apache.axis.message.SOAPHeaderElement tempHeader = (org.apache.axis.message.SOAPHeaderElement)headersByName.nextElement();
                        tempHeader.setProcessed(true);
                    }
                }
                SOAPHeader sHeader = null;
                try {
                    sHeader = sm.getSOAPEnvelope().getHeader();
                }
                catch (Exception ex) {
                    fault2 = new AxisFault(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "InvalidSecurity"), "An error was discovered processing the wsse:Security header.", actor, (Element[])null);
                    fault2.clearFaultDetails();
                    fault2.addFaultDetailString("Error retrieving the SOAP header after security processing");
                    fault2.setStackTrace(ex.getStackTrace());
                    throw fault2;
                }
                SOAPHeaderElement headerElement = null;
                Iterator headers = sHeader.examineHeaderElements(actor);
                while (headers.hasNext()) {
                    SOAPHeaderElement hE = (SOAPHeaderElement)headers.next();
                    if (!hE.getLocalName().equals("Security") || !hE.getNamespaceURI().equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd")) continue;
                    headerElement = hE;
                    ((org.apache.axis.message.SOAPHeaderElement)headerElement).setProcessed(true);
                    break;
                }
                if (headerElement == null) {
                    fault = new AxisFault(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "InvalidSecurity"), "An error was discovered processing the wsse:Security header.", actor, (Element[])null);
                    fault.clearFaultDetails();
                    fault.addFaultDetailString("Error retrieving the SOAP header after security processing");
                    throw fault;
                }
                DebugObjects.getHandlerDebug().debug("WSSInboundHandler: removing the processed security header - \n" + headerElement);
                headerElement.detachNode();
                sm.getSOAPEnvelope().setRecorder(null);
                DebugObjects.getHandlerDebug().debug("WSSInboundHandler: Post-processing SOAP message");
                DebugObjects.getHandlerDebug().debug(XMLUtils.PrettyDocumentToString((Document)sm.getSOAPEnvelope().getAsDocument()));
            }
            Object[] timestampResults = this.fetchActionResult(wsResult, 32);
            Object[] supportingTokenResults = this.fetchActionResult(wsResult, 1);
            Object[] signatureResults = this.fetchActionResult(wsResult, 2);
            Object[] encryptionResults = this.fetchActionResult(wsResult, 4);
            if (supportingTokenResults != null) {
                for (int i = 0; i < supportingTokenResults.length; ++i) {
                    SupportingTokenResult ut = (SupportingTokenResult)supportingTokenResults[i];
                    if (this.authenticate(ut)) continue;
                    fault2 = new AxisFault(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "FailedAuthentication"), "The security token could not be authenticated or authorized", actor, (Element[])null);
                    fault2.clearFaultDetails();
                    fault2.addFaultDetailString("Failed to authenticate Username token, uid = " + ut.getUsername());
                    throw fault2;
                }
            }
            if (signatureResults != null) {
                for (int i = 0; i < signatureResults.length; ++i) {
                    SignatureResult sigInfo = (SignatureResult)signatureResults[i];
                    X509Certificate returnCert = sigInfo.getCertificate();
                    if (returnCert == null) continue;
                    if (!this.verifyTrust(returnCert, (SignatureCrypto)reqData.sigCrypto)) {
                        fault = new AxisFault(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "FailedAuthentication"), "The security token could not be authenticated or authorized", null, (Element[])null);
                        fault.clearFaultDetails();
                        fault.addFaultDetailString("Signing certificate not trusted, subject DN = " + returnCert.getSubjectDN().getName());
                        throw fault;
                    }
                    if (msgContext.isClient()) continue;
                    WSHttpInRequest request = (WSHttpInRequest)msgContext.getProperty("com.sonicsw.net.http.HttpInRequest");
                    request.setSigningCertificate(returnCert);
                    DebugObjects.getHandlerDebug().debug("WSSInboundHandler: saving the signing cert to encrypt the response, cert info:\n" + returnCert);
                }
            }
            SecurityPolicyAlternative[] policyAlternatives = null;
            if (msgContext.isClient()) {
                policyAlternatives = (SecurityPolicyAlternative[])msgContext.getProperty("com.sonicsw.ws.security.policy.InboundPolicy");
            } else {
                if (msgContext.getProperty("com.sonicsw.ws.security.policy.InboundPolicy") == null) {
                    PolicyFromWSDLHandler handler = (PolicyFromWSDLHandler)((Object)msgContext.getProperty("com.sonicsw.ws.axis.handlers.PolicyFromWSDLHandler"));
                    handler.getPolicy(msgContext);
                }
                policyAlternatives = (SecurityPolicyAlternative[])msgContext.getProperty("com.sonicsw.ws.security.policy.InboundPolicy");
            }
            if (policyAlternatives != null) {
                DebugObjects.getHandlerDebug().debug("WSSInboundHandler: policy alternative count = " + policyAlternatives.length);
                int actionCount = 0;
                Vector supportingTokenActions = null;
                Vector timestampActions = null;
                Vector signatureActions = null;
                Vector encryptionActions = null;
                Vector transportBindingActions = null;
                AxisFault fault4 = null;
                for (int pa = 0; pa < policyAlternatives.length; ++pa) {
                    String faultDetail;
                    int i;
                    ValidationStatus status;
                    int count;
                    int i2;
                    actionCount = 0;
                    supportingTokenActions = this.getAction(policyAlternatives[pa], 4);
                    if (supportingTokenActions != null) {
                        actionCount += supportingTokenActions.size();
                    }
                    if ((timestampActions = this.getAction(policyAlternatives[pa], 3)) != null) {
                        actionCount += timestampActions.size();
                    }
                    if ((signatureActions = this.getAction(policyAlternatives[pa], 1)) != null) {
                        actionCount += signatureActions.size();
                    }
                    if ((encryptionActions = this.getAction(policyAlternatives[pa], 2)) != null) {
                        actionCount += encryptionActions.size();
                    }
                    if ((transportBindingActions = this.getAction(policyAlternatives[pa], 5)) != null) {
                        DebugObjects.getHandlerDebug().debug("WSSInboundHandler: processing " + transportBindingActions.size() + " TransportBinding Actions");
                    }
                    DebugObjects.getHandlerDebug().debug("WSSInboundHandler: security assertion count of policy alternative " + pa + " = " + actionCount);
                    if (actionCount == 0) {
                        DebugObjects.getHandlerDebug().debug("WSSInboundHandler: no security required.");
                        fault4 = null;
                        break;
                    }
                    if (wsResult == null || actionCount > wsResult.size() && policyAlternatives[pa].isPolicy2002()) {
                        DebugObjects.getHandlerDebug().debug("WSSInboundHandler: Missing security header element(s), expected = " + actionCount + ", found = " + (wsResult == null ? 0 : wsResult.size()));
                        fault4 = WSSInboundHandler.initFault(actor);
                        fault4.addFaultDetailString("Message has no required security header");
                        continue;
                    }
                    boolean timestampRequired = false;
                    if (timestampActions != null && !timestampActions.isEmpty()) {
                        timestampRequired = true;
                        DebugObjects.getHandlerDebug().debug("WSSInboundHandler: timestamp is required by the policy.");
                    }
                    if (timestampRequired && timestampResults == null) {
                        fault4 = WSSInboundHandler.initFault(actor);
                        fault4.addFaultDetailString("Message has no required timestamp");
                        continue;
                    }
                    Timestamp maa = null;
                    if (timestampRequired) {
                        maa = (Timestamp)timestampActions.get(0);
                    }
                    if (timestampResults != null) {
                        for (int i3 = 0; i3 < timestampResults.length; ++i3) {
                            TimestampResult timestamp = (TimestampResult)timestampResults[i3];
                            if (timestamp.validate(maa)) continue;
                            fault4 = WSSInboundHandler.initFault(actor);
                            fault4.addFaultDetailString("Message has expired");
                        }
                    }
                    boolean userNameTokenRequired = false;
                    SupportingToken sta = null;
                    if (supportingTokenActions != null && !supportingTokenActions.isEmpty()) {
                        for (int i4 = 0; i4 < supportingTokenActions.size(); ++i4) {
                            sta = (SupportingToken)supportingTokenActions.get(i4);
                            if (!sta.getTokenType().equals(WSSPConstants.QN_TOKENTYPE_USERNAME)) continue;
                            userNameTokenRequired = true;
                            DebugObjects.getHandlerDebug().debug("WSSInboundHandler: security (username) token is required for " + sta);
                            break;
                        }
                    }
                    if (userNameTokenRequired) {
                        boolean utFound = false;
                        if (supportingTokenResults != null) {
                            for (i2 = 0; i2 < supportingTokenResults.length; ++i2) {
                                SupportingTokenResult ut = (SupportingTokenResult)supportingTokenResults[i2];
                                if (utFound || !(utFound = ut.validate(sta))) continue;
                                DebugObjects.getHandlerDebug().debug("WSSInboundHandler: Required security (username) token found.");
                            }
                        }
                        if (!utFound) {
                            fault4 = WSSInboundHandler.initFault(actor);
                            fault4.addFaultDetailString("Message has no required username token");
                            continue;
                        }
                    }
                    if (signatureActions != null && !signatureActions.isEmpty()) {
                        DebugObjects.getHandlerDebug().debug("WSSInboundHandler: signature is required by the policy alternative.");
                        int n = count = signatureResults == null ? 0 : signatureResults.length;
                        if (count == 0 || count < signatureActions.size() && policyAlternatives[pa].isPolicy2002()) {
                            DebugObjects.getHandlerDebug().debug("WSSInboundHandler: required signature NOT found.");
                            fault4 = WSSInboundHandler.initFault(actor);
                            String err = "Message has no required signature";
                            this.appendErrorAndFaultDetailString(policyAlternatives, pa, err, signatureActions, count, fault4);
                            continue;
                        }
                        boolean sigFound = false;
                        status = new ValidationStatus();
                        for (i = 0; i < signatureActions.size(); ++i) {
                            Signature ia = (Signature)signatureActions.get(i);
                            sigFound = policyAlternatives[pa].isPolicy2002() ? this.validateIntegrityAssertion(ia, signatureResults, msgContext, status) : this.validateSignedParts(ia, signatureResults, msgContext, status);
                            if (sigFound) continue;
                            faultDetail = "Message has no required signature";
                            fault4 = WSSInboundHandler.returnErrorWithDetail(actor, count, faultDetail, status);
                            break;
                        }
                        if (!sigFound) continue;
                        DebugObjects.getHandlerDebug().debug("WSSInboundHandler: required signature(s) found.");
                    }
                    if (encryptionActions != null && !encryptionActions.isEmpty()) {
                        DebugObjects.getHandlerDebug().debug("WSSInboundHandler: encryption is required by the policy alternative.");
                        int n = count = encryptionResults == null ? 0 : encryptionResults.length;
                        if (count == 0 || count < encryptionActions.size() && policyAlternatives[pa].isPolicy2002()) {
                            DebugObjects.getHandlerDebug().debug("WSSInboundHandler: required encryption NOT found.");
                            fault4 = WSSInboundHandler.initFault(actor);
                            String err = "Message has no required encryption";
                            this.appendErrorAndFaultDetailString(policyAlternatives, pa, err, encryptionActions, count, fault4);
                            continue;
                        }
                        boolean encFound = false;
                        status = new ValidationStatus();
                        for (i = 0; i < encryptionActions.size(); ++i) {
                            Encryption ca = (Encryption)encryptionActions.get(i);
                            encFound = policyAlternatives[pa].isPolicy2002() ? this.validateConfidentialityAssertion(ca, encryptionResults, msgContext, status) : this.validateEncryptedParts(ca, encryptionResults, msgContext, status);
                            if (encFound) continue;
                            faultDetail = "Message has no required encryption";
                            fault4 = WSSInboundHandler.returnErrorWithDetail(actor, count, faultDetail, status);
                            break;
                        }
                        if (!encFound) continue;
                        DebugObjects.getHandlerDebug().debug("WSSInboundHandler: required encryption(s) found.");
                    }
                    boolean tbReqsSatisfied = false;
                    for (i2 = 0; i2 < transportBindingActions.size(); ++i2) {
                        TransportBindingAction tba = (TransportBindingAction)transportBindingActions.get(i2);
                        tbReqsSatisfied = false;
                        TransportBindingResult result = new TransportBindingResult(msgContext);
                        if (tbReqsSatisfied |= result.validate(tba)) continue;
                        DebugObjects.getHandlerDebug().debug("WSSInboundHandler: " + result.getStatus());
                        fault4 = new AxisFault(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", result.getStatus()), "An error was discovered processing the wsse:Security header.", actor, (Element[])null);
                        fault4.clearFaultDetails();
                        fault4.addFaultDetailString(result.getStatus());
                        break;
                    }
                    fault4 = null;
                    break;
                }
                if (fault4 != null) {
                    throw fault4;
                }
            }
            Vector<ProcessingResult> results = null;
            results = (Vector<ProcessingResult>)msgContext.getProperty("RECV_RESULTS");
            if (results == null) {
                results = new Vector<ProcessingResult>();
                msgContext.setProperty("RECV_RESULTS", results);
            }
            ProcessingResult rResult = new ProcessingResult(actor, wsResult);
            results.add(0, rResult);
            DebugObjects.getHandlerDebug().debug("WSSInboundHandler: exit invoke()");
        }
        catch (AxisFault af) {
            DebugObjects.getHandlerDebug().debug("WSSInboundHandler: Axis fault, fault code = " + af.getFaultCode() + ", fault string = " + af.getFaultString());
            throw af;
        }
        catch (Exception ex) {
            if (DebugObjects.getHandlerDebug().getDebug()) {
                ex.printStackTrace();
            }
            AxisFault fault = new AxisFault(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "InvalidSecurity"), "An error was discovered processing the wsse:Security header.", null, (Element[])null);
            fault.clearFaultDetails();
            fault.addFaultDetailString("Server Error: " + ex.getMessage());
            fault.setStackTrace(ex.getStackTrace());
            throw fault;
        }
        finally {
            reqData.clear();
            reqData = null;
        }
    }

    private void appendErrorAndFaultDetailString(SecurityPolicyAlternative[] policyAlternatives, int pa, String errParam, Vector encryptionActions, int count, AxisFault fault) {
        String err = errParam;
        if (policyAlternatives[pa].isPolicy2002()) {
            err = err + "; expected " + encryptionActions.size() + ", found " + count;
        }
        fault.addFaultDetailString(err);
    }

    private static AxisFault returnErrorWithDetail(String actor, int count, String faultDetailParam, ValidationStatus status) {
        String faultDetail = faultDetailParam;
        if (count == 1 && status.getError() != null) {
            faultDetail = faultDetail + "; possible error: " + status.getError();
        }
        DebugObjects.getHandlerDebug().debug("WSSInboundHandler: " + faultDetail);
        AxisFault fault = WSSInboundHandler.initFault(actor);
        fault.addFaultDetailString(faultDetail);
        return fault;
    }

    private static AxisFault initFault(String actor) {
        AxisFault fault = new AxisFault(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "InvalidSecurity"), "An error was discovered processing the wsse:Security header.", actor, (Element[])null);
        fault.clearFaultDetails();
        return fault;
    }

    private void loadSignatureCrypto(RequestContext reqData) throws AxisFault {
        TrustStore ts = null;
        boolean cert2uid = true;
        if (reqData.msgContext.isClient()) {
            cert2uid = false;
            ts = BrokerTrustStore.getInstance("JKS");
        } else {
            ts = ((WSHttpInRequest)reqData.msgContext.getProperty("com.sonicsw.net.http.HttpInRequest")).getTrustStore();
            cert2uid = ((WSHttpInRequest)reqData.msgContext.getProperty("com.sonicsw.net.http.HttpInRequest")).isCertificateToUidEnabled();
            if (ts == null) {
                ts = BrokerTrustStore.getInstance("JKS");
            }
        }
        try {
            if (ts != null) {
                DebugObjects.getHandlerDebug().debug("WSSInboundHandler: loading per-service trust store for trust verification");
                KeyStore trustStore = ts.getTrustStore();
                reqData.sigCrypto = new SignatureCrypto(trustStore, cert2uid);
            }
        }
        catch (Exception ex) {
            if (DebugObjects.getHandlerDebug().getDebug()) {
                ex.printStackTrace();
            }
            AxisFault fault = new AxisFault(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "InvalidSecurity"), "An error was discovered processing the wsse:Security header.", null, (Element[])null);
            fault.clearFaultDetails();
            fault.addFaultDetailString("Error loading the trust store for signature verification : " + ex.getMessage());
            throw fault;
        }
    }

    private void loadDecryptionCrypto(RequestContext reqData) throws AxisFault {
        try {
            KeyStore keyStore = BrokerKeyStore.getInstance("JKS").getKeyStore();
            if (keyStore != null) {
                DebugObjects.getHandlerDebug().debug("WSSInboundHandler: loading the broker key store for decryption.");
            }
            reqData.decCrypto = new DecryptionCrypto(keyStore);
        }
        catch (Exception ex) {
            AxisFault fault = new AxisFault(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "InvalidSecurity"), "An error was discovered processing the wsse:Security header.", null, (Element[])null);
            fault.clearFaultDetails();
            fault.addFaultDetailString("Error loading the key store for message decryption : " + ex.getMessage());
            throw fault;
        }
    }

    private CertCrypto loadCertCrypto() throws AxisFault {
        try {
            KeyStore keyStore = BrokerCertificateStore.getInstance().getKeyStore();
            if (keyStore != null) {
                DebugObjects.getHandlerDebug().debug("WSSInboundHandler: loading the broker cert store.");
            }
            return new CertCrypto(keyStore);
        }
        catch (Exception ex) {
            AxisFault fault = new AxisFault(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "InvalidSecurity"), "An error was discovered processing the wsse:Security header.", null, (Element[])null);
            fault.clearFaultDetails();
            fault.addFaultDetailString("Error loading the cert store for signature processing : " + ex.getMessage());
            throw fault;
        }
    }

    private boolean authenticate(SupportingTokenResult ut) {
        String user = ut.getUsername();
        String password = ut.getPassword();
        String nonce = ut.getNonce();
        String createdTime = ut.getCreatedTime();
        boolean isHashed = ut.isPasswordDigest();
        DebugObjects.getHandlerDebug().debug("WSSInboundHandler: Authenticating user " + user + ", hashed password = " + isHashed);
        Principal authenticatedUser = null;
        authenticatedUser = isHashed ? this.secEngine.getPasswordTrustManager().authenticate(user, password, nonce, createdTime) : this.secEngine.getPasswordTrustManager().authenticate(user, password);
        if (authenticatedUser == null) {
            DebugObjects.getHandlerDebug().debug("WSSInboundHandler: User \"" + user + "\" authentication FAILED.");
            return false;
        }
        DebugObjects.getHandlerDebug().debug("WSSInboundHandler: User \"" + user + "\" authentication SUCCEEDED.");
        ut.setUsername(authenticatedUser.getName());
        ut.setPassword(null);
        return true;
    }

    private boolean verifyTrust(X509Certificate cert, SignatureCrypto sigCrypto) throws AxisFault {
        DebugObjects.getHandlerDebug().debug("WSSInboundHandler: Verifying siigning certificate " + cert.getSubjectDN().getName());
        if (sigCrypto == null || sigCrypto.getKeyStore() == null) {
            AxisFault fault = new AxisFault(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "FailedAuthentication"), "The security token could not be authenticated or authorized", null, (Element[])null);
            fault.clearFaultDetails();
            fault.addFaultDetailString("Signing certificate not trusted (trust store not available), subject DN = " + cert.getSubjectDN().getName());
            throw fault;
        }
        boolean ok = this.secEngine.getX509TrustManager().isTrusted(cert, sigCrypto.getKeyStore());
        DebugObjects.getHandlerDebug().debug("WSSInboundHandler: signing certificate " + (ok ? "is trusted." : "is NOT trusted."));
        Principal internalUser = null;
        if (sigCrypto.m_cert2uid) {
            DebugObjects.getHandlerDebug().debug("WSSInboundHandler: Mapping certificate to internal user...");
            internalUser = this.secEngine.getDomainTrustManager().isTrusted(cert);
            DebugObjects.getHandlerDebug().debug("WSSInboundHandler: Mapped internal user " + internalUser);
            if (internalUser == null) {
                AxisFault fault = new AxisFault(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "FailedAuthentication"), "The security token could not be authenticated or authorized", null, (Element[])null);
                fault.clearFaultDetails();
                fault.addFaultDetailString("Signer not a valid user, subject DN = " + cert.getSubjectDN().getName());
                throw fault;
            }
        }
        return ok;
    }

    private Object[] fetchActionResult(Vector results, int action) {
        if (results == null || results.isEmpty()) {
            return null;
        }
        Vector temp = new Vector();
        for (int i = 0; i < results.size(); ++i) {
            Object r = results.get(i);
            if (action == 2 && results.get(i) instanceof SignatureResult) {
                temp.add(r);
                continue;
            }
            if (action == 32 && results.get(i) instanceof TimestampResult) {
                temp.add(r);
                continue;
            }
            if (action == 1 && results.get(i) instanceof SupportingTokenResult) {
                temp.add(r);
                continue;
            }
            if (action != 4 || !(results.get(i) instanceof EncryptionResult)) continue;
            temp.add(r);
        }
        if (temp.isEmpty()) {
            return null;
        }
        Object[] resultSet = new Object[temp.size()];
        temp.copyInto(resultSet);
        return resultSet;
    }

    private boolean validateIntegrityAssertion(Signature sig, Object[] signatureResults, MessageContext mc, ValidationStatus status) {
        boolean sigFound = false;
        SignatureResult result = null;
        for (int j = 0; j < signatureResults.length && !(sigFound = (result = (SignatureResult)signatureResults[j]).validate(sig, mc, status)); ++j) {
        }
        return sigFound;
    }

    private boolean validateConfidentialityAssertion(Encryption enc, Object[] encryptionResults, MessageContext mc, ValidationStatus status) {
        boolean encFound = false;
        EncryptionResult result = null;
        for (int k = 0; k < encryptionResults.length && !(encFound = (result = (EncryptionResult)encryptionResults[k]).validate(enc, mc, status)); ++k) {
        }
        return encFound;
    }

    private boolean validateSignedParts(Signature sig, Object[] signatureResults, MessageContext mc, ValidationStatus status) {
        boolean sigFound = false;
        SignatureResult result = null;
        for (int j = 0; j < signatureResults.length && !(sigFound = (result = (SignatureResult)signatureResults[j]).validate(sig, mc, status)); ++j) {
            Vector signedParts = status.getMessageParts();
            if (signedParts == null || signedParts.isEmpty()) continue;
            for (QName part : signedParts) {
                sig.getParts().removePart(new MessagePart(part.getNamespaceURI(), part.getLocalPart()));
            }
        }
        return sigFound;
    }

    private boolean validateEncryptedParts(Encryption enc, Object[] signatureResults, MessageContext mc, ValidationStatus status) {
        boolean encFound = false;
        EncryptionResult result = null;
        for (int j = 0; j < signatureResults.length && !(encFound = (result = (EncryptionResult)signatureResults[j]).validate(enc, mc, status)); ++j) {
            Vector encryptedParts = status.getMessageParts();
            if (encryptedParts == null || encryptedParts.isEmpty()) continue;
            for (QName part : encryptedParts) {
                enc.getParts().removePart(new MessagePart(part.getNamespaceURI(), part.getLocalPart()));
            }
        }
        return encFound;
    }

    private class RequestContext {
        MessageContext msgContext = null;
        Crypto sigCrypto = null;
        Crypto decCrypto = null;
        int timeToLive = 300;

        private RequestContext() {
        }

        void clear() {
            this.decCrypto = null;
            this.msgContext = null;
            this.sigCrypto = null;
        }
    }

    private class PasswordCallbackHandler
    implements CallbackHandler {
        private String m_x509Alias = null;
        private char[] m_x509Pwd = null;

        PasswordCallbackHandler(MessageContext mc) {
            if (mc.isClient()) {
                WSHttpOutRequest request = (WSHttpOutRequest)mc.getProperty("com.sonicsw.net.http.HttpOutRequest");
                this.m_x509Alias = request.getSigningCertAlias();
                this.m_x509Pwd = request.getSigningCertPrivateKeyPwd();
                DebugObjects.getHandlerDebug().debug("WSSInboundHandler: keystore alias for the request signer = " + this.m_x509Alias);
            } else {
                OperationContext oc = (OperationContext)mc.getProperty("COM_SONIC_WS_OPERATION_CONTEXT");
                if (oc != null) {
                    this.m_x509Alias = oc.getSigningCertAlias();
                    this.m_x509Pwd = oc.getSigningCertPassword().toCharArray();
                }
                if (this.m_x509Alias == null || this.m_x509Pwd == null) {
                    this.m_x509Alias = ((WSHttpInRequest)mc.getProperty("com.sonicsw.net.http.HttpInRequest")).getServiceAlias();
                    this.m_x509Pwd = ((WSHttpInRequest)mc.getProperty("com.sonicsw.net.http.HttpInRequest")).getServicePrivateKeyPwd();
                }
                DebugObjects.getHandlerDebug().debug("WSSInboundHandler: keystore alias for the service = " + this.m_x509Alias);
            }
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (int i = 0; i < callbacks.length; ++i) {
                if (callbacks[i] instanceof WSPasswordCallback) {
                    WSPasswordCallback pc = (WSPasswordCallback)callbacks[i];
                    if (pc.getUsage() != 1) continue;
                    if (this.m_x509Alias != null && pc.getIdentifer().equals(this.m_x509Alias)) {
                        DebugObjects.getHandlerDebug().debug("WSSInboundHandler: Retrieving private key password for " + pc.getIdentifer());
                        pc.setPassword(new String(this.m_x509Pwd));
                        continue;
                    }
                    DebugObjects.getHandlerDebug().debug("WSSInboundHandler: Unable to retrieve private key password for " + pc.getIdentifer() + ", expected alias = " + this.m_x509Alias);
                    continue;
                }
                throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
            }
        }
    }

    private class CertCrypto
    extends Merlin {
        CertCrypto(KeyStore keyStore) throws Exception {
            super(null);
            this.keystore = keyStore;
        }
    }

    private class SignatureCrypto
    extends Merlin {
        private boolean m_cert2uid;

        SignatureCrypto(KeyStore trustStore, boolean cert2uid) throws Exception {
            super(null);
            this.keystore = trustStore;
            this.m_cert2uid = cert2uid;
        }
    }

    private class DecryptionCrypto
    extends Merlin {
        DecryptionCrypto(KeyStore keyStore) throws Exception {
            super(null);
            this.keystore = keyStore;
        }
    }
}

