/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.wsdl;

import com.sonicsw.wsdl.SOAPDispatchContext;
import com.sonicsw.wsdl.SOAPUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;

public class WSDLUtils {
    private static final String SOAP_STYLE_RPC = "rpc";
    private static final String SOAP_STYLE_DOCUMENT = "document";

    public static Port[] getPorts(String url, Definition def) {
        ArrayList<Port> list = new ArrayList<Port>();
        Map servicesMap = def.getServices();
        for (QName serviceName : servicesMap.keySet()) {
            Service svc = (Service)servicesMap.get(serviceName);
            Map portsMap = svc.getPorts();
            for (String portName : portsMap.keySet()) {
                Port port = (Port)portsMap.get(portName);
                SOAPAddress soapAddress = WSDLUtils.getSOAPAddress(port);
                if (soapAddress == null || !WSDLUtils.compareLocationURI(soapAddress.getLocationURI(), url)) continue;
                list.add(port);
            }
        }
        Port[] result = new Port[list.size()];
        list.toArray(result);
        return result;
    }

    private static boolean compareLocationURI(String requestUrl, String locationUri) {
        try {
            URL request = new URL(requestUrl);
            URL location = new URL(locationUri);
            return request.getPath().equals(location.getPath());
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public static void setDispatchContext(SOAPDispatchContext dctx, String locationUrl, String actionUrl, SOAPMessage soapm) throws WSDLException, SOAPException {
        Port[] ports = WSDLUtils.getPorts(locationUrl, dctx.getDefinition());
        if (ports.length > 1) {
            throw new WSDLException("", "Port location URL not unique");
        }
        Port port = ports[0];
        SOAPBodyElement[] bodyElements = SOAPUtils.getSOAPBodyElements(soapm.getSOAPBody());
    }

    public static boolean isEqual(Name n, QName q) {
        if (!WSDLUtils.equivalentURIs(n.getURI(), q.getNamespaceURI())) {
            return false;
        }
        return n.getLocalName().equals(q.getLocalPart());
    }

    public static boolean equivalentURIs(String s1, String s2) {
        String norm1 = s1;
        String norm2 = s2;
        if (norm1 == null || norm1.equals("\"\"")) {
            norm1 = "";
        }
        if (norm2 == null || norm2.equals("\"\"")) {
            norm2 = "";
        }
        return norm1.equals(norm2);
    }

    public static boolean comparePartElement(Part part, SOAPBodyElement bodyElement) {
        QName partElementName = part.getElementName();
        if (partElementName != null) {
            return WSDLUtils.isEqual(bodyElement.getElementName(), partElementName);
        }
        return false;
    }

    public static QName getRPCElementName(BindingOperation bindingOp, BindingInput bin) {
        return new QName(WSDLUtils.getSOAPBody(bin).getNamespaceURI(), bindingOp.getName());
    }

    public static QName getRPCElementName(BindingOperation bindingOp, BindingOutput bout) {
        String opName = bindingOp.getName() + "Response";
        return new QName(WSDLUtils.getSOAPBody(bout).getNamespaceURI(), opName);
    }

    public static QName getFaultRPCElementName(BindingOperation bindingOp) {
        return new QName(WSDLUtils.getSOAPBody(bindingOp.getBindingInput()).getNamespaceURI(), bindingOp.getName());
    }

    public static SOAPBody getSOAPBody(BindingInput bin) {
        for (ExtensibilityElement extEl : bin.getExtensibilityElements()) {
            if (!(extEl instanceof SOAPBody)) continue;
            return (SOAPBody)extEl;
        }
        return null;
    }

    public static SOAPBody getSOAPBody(BindingOutput bout) {
        for (ExtensibilityElement extEl : bout.getExtensibilityElements()) {
            if (!(extEl instanceof SOAPBody)) continue;
            return (SOAPBody)extEl;
        }
        return null;
    }

    public static SOAPBody getSOAPBody(BindingFault bfault) {
        for (ExtensibilityElement extEl : bfault.getExtensibilityElements()) {
            if (!(extEl instanceof SOAPBody)) continue;
            return (SOAPBody)extEl;
        }
        return null;
    }

    public static List getPartsBoundToSOAPBody(Message message, SOAPBody soapBody) {
        List soapBodyPartList = soapBody.getParts();
        return message.getOrderedParts(soapBodyPartList);
    }

    public static boolean isRPCStyle(String soapStyle) {
        return SOAP_STYLE_RPC.equals(soapStyle);
    }

    private static boolean isDocumentStyle(String soapStyle) {
        return SOAP_STYLE_DOCUMENT.equals(soapStyle);
    }

    public static String getSoapStyle(SOAPBinding soapBinding, SOAPOperation soapOp) {
        String opStyle;
        String bindingStyle;
        String style = SOAP_STYLE_DOCUMENT;
        if (soapBinding != null && (bindingStyle = soapBinding.getStyle()) != null) {
            style = bindingStyle;
        }
        if (soapOp != null && (opStyle = soapOp.getStyle()) != null) {
            style = opStyle;
        }
        return style;
    }

    public static SOAPBinding getSOAPBinding(Binding binding) {
        SOAPBinding soapBinding = null;
        for (ExtensibilityElement extEl : binding.getExtensibilityElements()) {
            if (!(extEl instanceof SOAPBinding)) continue;
            soapBinding = (SOAPBinding)extEl;
            break;
        }
        return soapBinding;
    }

    public static SOAPAddress getSOAPAddress(Port port) {
        SOAPAddress soapAddress = null;
        for (ExtensibilityElement extEl : port.getExtensibilityElements()) {
            if (!(extEl instanceof SOAPAddress)) continue;
            soapAddress = (SOAPAddress)extEl;
            break;
        }
        return soapAddress;
    }

    public static SOAPOperation getSOAPOperation(BindingOperation bindingOp) {
        SOAPOperation soapBindingOp = null;
        for (ExtensibilityElement extEl : bindingOp.getExtensibilityElements()) {
            if (!(extEl instanceof SOAPOperation)) continue;
            soapBindingOp = (SOAPOperation)extEl;
            break;
        }
        return soapBindingOp;
    }
}

