/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import progress.message.broker.AddrUtil;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.broker.EInvalidAdminAddress;
import progress.message.broker.ETxnAccessViolation;
import progress.message.broker.ETxnNotFound;
import progress.message.broker.ETxnSequenceError;
import progress.message.client.EGeneralException;
import progress.message.zclient.Envelope;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.ISubject;
import progress.message.zclient.Message;
import progress.message.zclient.Session;

public final class AbortTransaction
implements IMessageHandler {
    private AgentRegistrar m_reg;

    AbortTransaction(AgentRegistrar reg) {
        this.m_reg = reg;
    }

    @Override
    public void handleMessage(Session s, Envelope env) {
        block14: {
            boolean abortSuccess = false;
            int tid = 0;
            try {
                Message rep = new Message();
                int uid = AddrUtil.getUidFromAdmin(env.getSubject());
                tid = env.getMessage().readInt();
                boolean startTx = env.getMessage().readBoolean();
                try {
                    this.m_reg.getTransactionMgr().abort(tid, uid);
                    rep.writeShort(0);
                    abortSuccess = true;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
                catch (ETxnNotFound e) {
                    rep.writeShort(2);
                }
                catch (ETxnSequenceError e) {
                    rep.writeShort(3);
                }
                catch (ETxnAccessViolation e) {
                    rep.writeShort(6);
                }
                catch (EGeneralException e) {
                    rep.writeShort(5);
                }
                catch (IOException e) {
                    rep.writeShort(1);
                }
                if (abortSuccess && startTx) {
                    int newTx = 0;
                    ISubject subj = env.getMessage().getSubject();
                    String suid = subj.extractSubjectLevel(2);
                    String appid = subj.extractSubjectLevel(3);
                    newTx = this.m_reg.getTransactionMgr().beginTxn(tid, suid, appid);
                    rep.writeInt(newTx);
                }
                s.reply(rep, env);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            catch (EInvalidAdminAddress e) {
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
            catch (EGeneralException e) {
                if (!Broker.isInShutdown()) {
                    BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                }
            }
            catch (IOException e) {
                if (Broker.isInShutdown()) break block14;
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
        }
    }
}

