/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mf.common.metrics.IMetricIdentity;
import com.sonicsw.mf.common.metrics.IMetricInfo;
import com.sonicsw.mf.common.metrics.MetricsFactory;
import com.sonicsw.mf.common.metrics.manager.IMetricsRegistrar;
import com.sonicsw.mf.common.metrics.manager.ISampledStatistic;
import com.sonicsw.mf.common.metrics.manager.IStatistic;
import com.sonicsw.mf.common.metrics.manager.IStatisticProvider;
import com.sonicsw.mf.common.metrics.manager.StatisticsFactory;
import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import progress.message.broker.AgentListener;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.AgentSender;
import progress.message.broker.Broker;
import progress.message.broker.BrokerLicenseMgr;
import progress.message.broker.Config;
import progress.message.broker.ConnectionCountTracker;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.EIPAddressLimitExceeded;
import progress.message.broker.IAcceptor;
import progress.message.broker.IBrokerConnection;
import progress.message.broker.IClientContext;
import progress.message.broker.ProvisionMonitor;
import progress.message.broker.prAccessor;
import progress.message.client.EConnectionLimitExceeded;
import progress.message.msg.IMgram;
import progress.message.net.ISocket;
import progress.message.net.ProgressInetAddress;
import progress.message.net.ProgressSocket;
import progress.message.util.AutoVec;
import progress.message.util.DebugState;
import progress.message.util.IMetricsListener;
import progress.message.util.LongHashTable;
import progress.message.util.VersionData;
import progress.message.zclient.BaseConnection;
import progress.message.zclient.BrokerConnectHandshaker;
import progress.message.zclient.ClientConnectParms;
import progress.message.zclient.ClientSecurityContext;
import progress.message.zclient.Listener;
import progress.message.zclient.NegotiatedConnectParms;
import progress.message.zclient.ProgressGroup;
import progress.message.zclient.Sender;
import progress.message.zclient.SessionConfig;

public class AgentConnection
extends BaseConnection
implements IMetricsListener,
IBrokerConnection {
    private AgentSender m_sender;
    private AgentListener m_listener;
    private volatile long m_socketId;
    private String m_ipAddressStr;
    private boolean m_isAdminConnection = false;
    private IAcceptor m_acceptor;
    private AutoVec m_cscs = new AutoVec();
    private AutoVec m_ids = new AutoVec();
    private long m_chan0id = -1L;
    private boolean m_timedOut = false;
    private LongHashTable m_cscsById = new LongHashTable();
    private LongHashTable m_deliveryStartedById = new LongHashTable();
    private LongHashTable m_channels = new LongHashTable();
    private static ConnectionCountTracker s_connectionCountTracker = new ConnectionCountTracker();
    private static final long DEFAULT_USER_CONNECTION_LIMIT_WARNING_INTERVAL = TimeUnit.MINUTES.toMillis(2L);
    private static long m_mostRecentClientConnectTime = -1L;
    private static Long s_userConnectionLimitWarningInterval;
    private static Object synchvar;
    private static IMetricsRegistrar m_metricsRegistrar;
    public static final IMetricIdentity BROKER_CONNECTIONS_COUNT_METRIC;
    private static IStatistic m_connectionsCountStatistic;
    private static IStatisticProvider m_statisticProvider;
    public static final IMetricIdentity CONNECTION_MSGS_RECEIVEDPERSECOND_METRIC;
    private IStatistic m_connMsgsRecvdPerSecStat;
    public static final IMetricIdentity CONNECTION_MSGS_DELIVEREDPERSECOND_METRIC;
    private IStatistic m_connMsgsDelvdPerSecStat;
    public static final IMetricIdentity CONNECTION_MSGS_RECEIVED_METRIC;
    private IStatistic m_connMsgsRecvdStat;
    public static final IMetricIdentity CONNECTION_MSGS_DELIVERED_METRIC;
    private IStatistic m_connMsgsDelvdStat;
    public static final IMetricIdentity CONNECTION_BYTES_RECEIVEDPERSECOND_METRIC;
    private IStatistic m_connBytesRecvdPerSecStat;
    public static final IMetricIdentity CONNECTION_BYTES_DELIVEREDPERSECOND_METRIC;
    private IStatistic m_connBytesDelvdPerSecStat;
    public static final IMetricIdentity CONNECTION_BYTES_RECEIVED_METRIC;
    private IStatistic m_connBytesRecvdStat;
    public static final IMetricIdentity CONNECTION_BYTES_DELIVERED_METRIC;
    private IStatistic m_connBytesDelvdStat;
    private boolean m_hasEnabledBytesRecvdMetrics = false;
    private boolean m_hasEnabledBytesDelvdMetrics = false;
    private boolean m_hasEnabledMsgsRecvdMetrics = false;
    private boolean m_hasEnabledMsgsDelvdMetrics = false;
    private int m_idleTimeout = 0;
    private boolean m_remoteBrokerIdSet = false;
    private long m_remoteBrokerId = 0L;
    private int m_maxSendBufferSize = Config.MAX_SEND_IO_BUFFER_SIZE;
    private int m_maxRcvBufferSize = Config.MAX_RCV_IO_BUFFER_SIZE;
    private int m_minSendBufferSize = Config.MIN_SEND_IO_BUFFER_SIZE;
    private int m_minRcvBufferSize = Config.MIN_RCV_IO_BUFFER_SIZE;
    private int m_initialSendBufferSize = Config.INITIAL_SEND_IO_BUFFER_SIZE;
    private int m_initialRcvBufferSize = Config.INITIAL_RCV_IO_BUFFER_SIZE;
    private boolean m_isLGInstrumented = false;
    private int m_downStreamLGNodeType = -1;
    private VersionData m_partnerProductVersion;
    private volatile boolean m_resumed = false;
    private boolean m_faultTolerant = false;
    private ClientConnectParms m_clientConnectParms = null;
    private NegotiatedConnectParms m_negotiatedConnectParms = null;

    void setLGSetting(boolean isInstrumented, int downStreamNodeType) {
        this.m_isLGInstrumented = isInstrumented;
        this.m_downStreamLGNodeType = downStreamNodeType;
    }

    public boolean getLGInstrumentationEnabled() {
        return this.m_isLGInstrumented;
    }

    public int getLGDownStreamNodeType() {
        return this.m_downStreamLGNodeType;
    }

    public void setRemoteBroker(long remoteBrokerId) {
        this.m_remoteBrokerId = remoteBrokerId;
        this.m_remoteBrokerIdSet = true;
    }

    public void unsetRemoteBroker(long remoteBrokerId) {
        this.m_remoteBrokerId = 0L;
        this.m_remoteBrokerIdSet = false;
    }

    public String getAcceptorName() {
        return this.m_acceptor != null ? this.m_acceptor.getAcceptorName() : null;
    }

    public String getAcceptorUrl() {
        return this.m_acceptor != null ? this.m_acceptor.getURL() : null;
    }

    public AgentConnection(ISocket socket, long socketId) throws IOException {
        this(socket, socketId, true);
    }

    protected AgentConnection(ISocket socket, long socketId, boolean createThreads) throws IOException {
        if (DebugState.GLOBAL_DEBUG_ON) {
            this.debugName("AgentConnection " + socketId);
        }
        this.m_socket = socket;
        this.m_socketId = socketId;
        if (createThreads) {
            this.m_sender = new AgentSender(this);
            this.m_listener = new AgentListener(this);
        }
        if (this.m_socket != null) {
            this.m_ipAddressStr = this.getIPAddr(this.m_socket);
            if (this.m_socket instanceof ProgressSocket) {
                this.m_acceptor = ((ProgressSocket)this.m_socket).getAcceptor();
                if (this.m_acceptor != null) {
                    this.m_acceptor.addConnection(this);
                }
            }
        }
    }

    boolean isAdminConnection() {
        return this.m_isAdminConnection;
    }

    public void setAdminConnection(boolean isAdminConnection) {
        this.m_isAdminConnection = isAdminConnection;
    }

    public static List getMetricsInfo() {
        if (Config.DEBUG) {
            BrokerComponent.getComponentContext().logMessage("AgentConnection - getMetricsInfo ", 3);
        }
        ArrayList<IMetricInfo> infos = new ArrayList<IMetricInfo>();
        infos.add(MetricsFactory.createMetricInfo((IMetricIdentity)BROKER_CONNECTIONS_COUNT_METRIC, (short)0, (String)"Inbound connection count to broker.", null, (boolean)false, (boolean)true, (boolean)true, (boolean)false, (String)"connections"));
        infos.add(MetricsFactory.createMetricInfo((IMetricIdentity)CONNECTION_MSGS_RECEIVEDPERSECOND_METRIC, (short)8, (String)"Messages received by a connection per second (excludes internal/management messages).", null, (boolean)true, (boolean)true, (boolean)true, (boolean)true, (String)"messages per second"));
        infos.add(MetricsFactory.createMetricInfo((IMetricIdentity)CONNECTION_MSGS_DELIVEREDPERSECOND_METRIC, (short)8, (String)"Messages delivered to a connection/sec (excludes internal/management messages).", null, (boolean)true, (boolean)true, (boolean)true, (boolean)true, (String)"messages per second"));
        infos.add(MetricsFactory.createMetricInfo((IMetricIdentity)CONNECTION_MSGS_RECEIVED_METRIC, (short)0, (String)"Messages received by a connection (excludes internal/management messages).", null, (boolean)true, (boolean)true, (boolean)false, (boolean)false, (String)"messages"));
        infos.add(MetricsFactory.createMetricInfo((IMetricIdentity)CONNECTION_MSGS_DELIVERED_METRIC, (short)0, (String)"Messages delivered to a connection (excludes internal/management messages).", null, (boolean)true, (boolean)true, (boolean)false, (boolean)false, (String)"messages"));
        infos.add(MetricsFactory.createMetricInfo((IMetricIdentity)CONNECTION_BYTES_RECEIVEDPERSECOND_METRIC, (short)8, (String)"Bytes received by a connection per second (includes internal/management messages).", null, (boolean)true, (boolean)true, (boolean)true, (boolean)true, (String)"bytes per second"));
        infos.add(MetricsFactory.createMetricInfo((IMetricIdentity)CONNECTION_BYTES_DELIVEREDPERSECOND_METRIC, (short)8, (String)"Bytes delivered to a connection/sec (includes internal/management messages).", null, (boolean)true, (boolean)true, (boolean)true, (boolean)true, (String)"bytes per second"));
        infos.add(MetricsFactory.createMetricInfo((IMetricIdentity)CONNECTION_BYTES_RECEIVED_METRIC, (short)0, (String)"Bytes received by a connection (includes internal/management messages).", null, (boolean)true, (boolean)true, (boolean)false, (boolean)false, (String)"bytes"));
        infos.add(MetricsFactory.createMetricInfo((IMetricIdentity)CONNECTION_BYTES_DELIVERED_METRIC, (short)0, (String)"Bytes delivered to a connection (includes internal/management messages).", null, (boolean)true, (boolean)true, (boolean)false, (boolean)false, (String)"bytes"));
        return infos;
    }

    public static boolean isConnectionInstanceReceivedMetric(IMetricIdentity id) {
        return AgentConnection.checkIsInstanceDeleivered(id, CONNECTION_MSGS_RECEIVEDPERSECOND_METRIC, CONNECTION_MSGS_RECEIVED_METRIC, CONNECTION_BYTES_RECEIVEDPERSECOND_METRIC, CONNECTION_BYTES_RECEIVED_METRIC);
    }

    public static boolean isConnectionInstanceDeliveredMetric(IMetricIdentity id) {
        return AgentConnection.checkIsInstanceDeleivered(id, CONNECTION_MSGS_DELIVEREDPERSECOND_METRIC, CONNECTION_MSGS_DELIVERED_METRIC, CONNECTION_BYTES_DELIVEREDPERSECOND_METRIC, CONNECTION_BYTES_DELIVERED_METRIC);
    }

    private static boolean checkIsInstanceDeleivered(IMetricIdentity id, IMetricIdentity CONNECTION_MSGS_DELIVEREDPERSECOND_METRIC, IMetricIdentity CONNECTION_MSGS_DELIVERED_METRIC, IMetricIdentity CONNECTION_BYTES_DELIVEREDPERSECOND_METRIC, IMetricIdentity CONNECTION_BYTES_DELIVERED_METRIC) {
        return id.equals((Object)CONNECTION_MSGS_DELIVEREDPERSECOND_METRIC) || id.equals((Object)CONNECTION_MSGS_DELIVERED_METRIC) || id.equals((Object)CONNECTION_BYTES_DELIVEREDPERSECOND_METRIC) || id.equals((Object)CONNECTION_BYTES_DELIVERED_METRIC);
    }

    public static synchronized void enableMetrics(IMetricsRegistrar metricsRegistrar, IMetricIdentity[] ids) {
        if (Config.DEBUG) {
            String s;
            if (ids == null || ids.length == 0) {
                s = "NONE";
            } else {
                s = "";
                IMetricIdentity[] iMetricIdentityArray = ids;
                int n = iMetricIdentityArray.length;
                for (int i = 0; i < n; ++i) {
                    IMetricIdentity iMetricIdentity = iMetricIdentityArray[i];
                    s = s + "\n - " + iMetricIdentity.getName();
                }
            }
            BrokerComponent.getComponentContext().logMessage("AgentConnection - enableMetrics : " + s, 3);
        }
        m_metricsRegistrar = metricsRegistrar;
        if (ids != null) {
            for (IMetricIdentity iMetricIdentity : ids) {
                if (iMetricIdentity.equals((Object)BROKER_CONNECTIONS_COUNT_METRIC)) {
                    if (m_statisticProvider == null) {
                        m_statisticProvider = new IStatisticProvider(){

                            public void updateStatistic(ISampledStatistic statistic) {
                                if (statistic == m_connectionsCountStatistic) {
                                    statistic.updateValue((long)s_connectionCountTracker.getConnectionCount());
                                }
                            }

                            public void resetStatistic(ISampledStatistic statistic) {
                            }
                        };
                    }
                    m_connectionsCountStatistic = StatisticsFactory.createStatistic((short)0, (boolean)false, (IStatisticProvider[])new IStatisticProvider[]{m_statisticProvider}, (short)0);
                    metricsRegistrar.registerMetric(BROKER_CONNECTIONS_COUNT_METRIC, m_connectionsCountStatistic);
                }
                AgentConnection.trackInstanceMetrics(iMetricIdentity);
            }
        }
    }

    public static synchronized void disableMetrics(IMetricsRegistrar metricsRegistrar, IMetricIdentity[] ids) {
        if (Config.DEBUG) {
            String s;
            if (ids == null || ids.length == 0) {
                s = "NONE";
            } else {
                s = "";
                for (int i = 0; i < ids.length; ++i) {
                    s = s + "\n - " + ids[i];
                }
            }
            BrokerComponent.getComponentContext().logMessage("AgentConnection - disabling metrics = " + s, 3);
        }
        m_metricsRegistrar = metricsRegistrar;
        if (ids != null) {
            for (IMetricIdentity iMetricIdentity : ids) {
                if (iMetricIdentity.equals((Object)BROKER_CONNECTIONS_COUNT_METRIC)) {
                    metricsRegistrar.unregisterMetric(iMetricIdentity);
                    m_connectionsCountStatistic = null;
                }
                AgentConnection.trackInstanceMetrics(iMetricIdentity);
            }
        }
    }

    private static void trackInstanceMetrics(IMetricIdentity iMetricIdentity) {
        if (AgentConnection.isConnectionInstanceReceivedMetric(iMetricIdentity) || AgentConnection.isConnectionInstanceDeliveredMetric(iMetricIdentity)) {
            AgentConnection.refreshInstanceMetrics(iMetricIdentity);
        }
    }

    public static String[] getInstanceMetricNames(IMetricIdentity id) {
        ArrayList<String> names = new ArrayList<String>();
        Set clients = AgentRegistrar.getAgentRegistrar().getAllConnectionClients(true);
        for (IClientContext cc : clients) {
            String instanceName;
            if (!cc.isConnected() || cc.getConnection() == null || (instanceName = AgentConnection.getInstanceMetricName(cc)) == null) continue;
            names.add(instanceName);
        }
        return names.toArray(new String[names.size()]);
    }

    public AgentSender getAgentSender() {
        return this.m_sender;
    }

    public AgentListener getAgentListener() {
        return this.m_listener;
    }

    protected final void setAgentSender(AgentSender sender) {
        this.m_sender = sender;
    }

    protected final void setAgentListener(AgentListener listener) {
        this.m_listener = listener;
    }

    @Override
    public Sender getSender() {
        return this.m_sender;
    }

    @Override
    public Listener getListener() {
        return this.m_listener;
    }

    public long getSocketId() {
        return this.m_socketId;
    }

    public void setSocketId(long id) {
        this.m_socketId = id;
    }

    public int getIdleTimeout() {
        return this.m_idleTimeout;
    }

    public boolean getResumed() {
        return this.m_resumed;
    }

    public void setResumed(boolean b) {
        this.m_resumed = b;
    }

    public boolean getFaultTolerant() {
        return this.m_faultTolerant;
    }

    public void setFaultTolerant(boolean b) {
        this.m_faultTolerant = b;
    }

    public ClientConnectParms getClientConnectParms() {
        return this.m_clientConnectParms;
    }

    public void setClientConnectParms(ClientConnectParms p) {
        this.m_clientConnectParms = p;
    }

    public void setIdleTimeout(int idleTimeout) {
        if (idleTimeout != this.m_idleTimeout) {
            this.m_idleTimeout = idleTimeout;
            if (this.DEBUG) {
                this.debug("Idle connection timeout is set to " + idleTimeout + " seconds");
            }
            this.m_sender.notifySender();
        }
    }

    public ClientSecurityContext getSecurityContext(int channel) {
        return (ClientSecurityContext)this.m_cscs.elementAt(channel);
    }

    public long getClientId(int channel) {
        Long l = (Long)this.m_ids.elementAt(channel);
        if (l == null) {
            return -1L;
        }
        return l;
    }

    public ClientSecurityContext getSecurityContextFromId(long clientId) {
        return (ClientSecurityContext)this.m_cscsById.get(clientId);
    }

    public boolean getDeliveryStartedFromId(long clientId) {
        Boolean b = (Boolean)this.m_deliveryStartedById.get(clientId);
        return b != null && b != false;
    }

    public void setDeliveryStartedFromId(long clientId, boolean b) {
        this.m_deliveryStartedById.put(clientId, new Boolean(b));
    }

    @Override
    public void setMaxSendBufferSize(int size) {
        this.m_maxSendBufferSize = size;
    }

    @Override
    public void setMaxRcvBufferSize(int size) {
        this.m_maxRcvBufferSize = size;
    }

    @Override
    public void setMinSendBufferSize(int size) {
        this.m_minSendBufferSize = size;
    }

    @Override
    public void setMinRcvBufferSize(int size) {
        this.m_minRcvBufferSize = size;
    }

    @Override
    public void setInitialSendBufferSize(int size) {
        this.m_initialSendBufferSize = size;
    }

    @Override
    public void setInitialRcvBufferSize(int size) {
        this.m_initialRcvBufferSize = size;
    }

    @Override
    public int getMaxSendBufferSize() {
        return this.m_maxSendBufferSize;
    }

    @Override
    public int getMinSendBufferSize() {
        return this.m_minSendBufferSize;
    }

    @Override
    public int getMaxRcvBufferSize() {
        return this.m_maxRcvBufferSize;
    }

    @Override
    public int getMinRcvBufferSize() {
        return this.m_minRcvBufferSize;
    }

    @Override
    public int getInitialSendBufferSize() {
        return this.m_initialSendBufferSize;
    }

    @Override
    public int getInitialRcvBufferSize() {
        return this.m_initialRcvBufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkLimits(int channel, String appid, ClientSecurityContext csc) throws EConnectionLimitExceeded {
        if (channel == 0) {
            if (appid.equals("FailoverBroker connect")) {
                return;
            }
            Object object = synchvar;
            synchronized (object) {
                long cid = csc.getClientId();
                if (!s_connectionCountTracker.isAlreadyCounted(cid)) {
                    this.checkConnectLimit(appid);
                    this.checkIPAddressLimit(appid);
                    this.checkDeprovisioning(csc, appid);
                    if (s_connectionCountTracker.isPerUserConnectionLimitEnabled()) {
                        this.checkUserConnectLimit(cid, csc.getPrincipal().getName());
                    }
                }
                s_connectionCountTracker.addPrimaryConnection(cid, appid, this);
            }
        }
    }

    private void checkDeprovisioning(ClientSecurityContext csc, String appID) throws EConnectionLimitExceeded {
        if (ProvisionMonitor.DEBUG) {
            System.out.println("#### checkDeprovisioning. isProvisioning = " + ProvisionMonitor.isProvisioning() + "; AppID=" + appID + "; UID=" + csc.getUid() + "; isAdminGroupMember=" + this.isAdminGroupMember(csc) + "; isResumedConnection = " + this.getResumed());
        }
        if (ProvisionMonitor.isProvisioning()) {
            if (ProvisionMonitor.DEBUG) {
                System.out.println("#### return because isProvisioning is true");
            }
            return;
        }
        if (appID.indexOf("$CONNECTION$") < 0) {
            if (ProvisionMonitor.DEBUG) {
                System.out.println("#### return because appID.indexOf(SessionConfig.JMS_CONNECTION_APPID_SUFFIX) = " + appID.indexOf("$CONNECTION$"));
            }
            return;
        }
        if (this.isAdminGroupMember(csc)) {
            if (ProvisionMonitor.DEBUG) {
                System.out.println("#### return because this connection in admin group");
            }
            return;
        }
        if (this.getResumed()) {
            if (ProvisionMonitor.DEBUG) {
                System.out.println("#### return because this is a resumed connection ");
            }
            return;
        }
        if (ProvisionMonitor.DEBUG) {
            System.out.println("#### Block connection " + appID);
        }
        throw new EConnectionLimitExceeded(prAccessor.getString("STR291"));
    }

    boolean isAdminGroupMember(ClientSecurityContext csc) {
        if (csc == null || !Config.ENABLE_SECURITY) {
            return false;
        }
        AgentRegistrar reg = AgentRegistrar.getAgentRegistrar();
        ProgressGroup adminGroup = reg.getSecurityBean().getGroup("Administrators");
        if (adminGroup == null) {
            return false;
        }
        return adminGroup.isMember(csc.getPrincipal());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void connectSuccess(int channel, ClientSecurityContext csc, long clientId) {
        this.m_cscs.setElementAt(csc, channel);
        this.m_ids.setElementAt(new Long(clientId), channel);
        this.m_channels.put(clientId, new Integer(channel));
        this.m_cscsById.put(clientId, csc);
        Object object = synchvar;
        synchronized (object) {
            if (channel == 0) {
                this.m_chan0id = clientId;
                s_connectionCountTracker.addPrimaryConnection(clientId, csc.getAppid(), this);
            } else {
                s_connectionCountTracker.addSubResource(clientId, csc.getAppid(), this);
            }
        }
    }

    public synchronized void initMetricsOnConnect(long clientId) {
        String instanceName;
        int channel = this.getChannel(clientId);
        ClientSecurityContext csc = this.getSecurityContext(channel);
        if (channel == 0 && csc != null && !csc.getUid().equals(Config.BROKER_UID) && (instanceName = this.getInstanceMetricName()) != null) {
            if (AgentConnection.checkInstanceMetricEnabled(CONNECTION_MSGS_RECEIVEDPERSECOND_METRIC, instanceName)) {
                this.registerInstanceMetric(CONNECTION_MSGS_RECEIVEDPERSECOND_METRIC);
            }
            if (AgentConnection.checkInstanceMetricEnabled(CONNECTION_MSGS_DELIVEREDPERSECOND_METRIC, instanceName)) {
                this.registerInstanceMetric(CONNECTION_MSGS_DELIVEREDPERSECOND_METRIC);
            }
            if (AgentConnection.checkInstanceMetricEnabled(CONNECTION_MSGS_RECEIVED_METRIC, instanceName)) {
                this.registerInstanceMetric(CONNECTION_MSGS_RECEIVED_METRIC);
            }
            if (AgentConnection.checkInstanceMetricEnabled(CONNECTION_MSGS_DELIVERED_METRIC, instanceName)) {
                this.registerInstanceMetric(CONNECTION_MSGS_DELIVERED_METRIC);
            }
            if (AgentConnection.checkInstanceMetricEnabled(CONNECTION_BYTES_RECEIVEDPERSECOND_METRIC, instanceName)) {
                this.registerInstanceMetric(CONNECTION_BYTES_RECEIVEDPERSECOND_METRIC);
            }
            if (AgentConnection.checkInstanceMetricEnabled(CONNECTION_BYTES_DELIVEREDPERSECOND_METRIC, instanceName)) {
                this.registerInstanceMetric(CONNECTION_BYTES_DELIVEREDPERSECOND_METRIC);
            }
            if (AgentConnection.checkInstanceMetricEnabled(CONNECTION_BYTES_RECEIVED_METRIC, instanceName)) {
                this.registerInstanceMetric(CONNECTION_BYTES_RECEIVED_METRIC);
            }
            if (AgentConnection.checkInstanceMetricEnabled(CONNECTION_BYTES_DELIVERED_METRIC, instanceName)) {
                this.registerInstanceMetric(CONNECTION_BYTES_DELIVERED_METRIC);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void prepareDisconnect(int reason) {
        AgentRegistrar reg = AgentRegistrar.getAgentRegistrar();
        int size = this.m_ids.size();
        for (int i = 0; i < size; ++i) {
            Long cid = (Long)this.m_ids.elementAt(i);
            if (cid == null) continue;
            try {
                reg.prepareDisconnect(cid, reason);
                Object object = synchvar;
                synchronized (object) {
                    if (i == 0) {
                        s_connectionCountTracker.removePrimaryConnection(cid, this);
                    } else {
                        s_connectionCountTracker.removeSubResource(cid, this);
                    }
                    continue;
                }
            }
            catch (EClientNotRegistered e) {
                // empty catch block
            }
        }
    }

    public synchronized void close(int channel) {
        this.closeInternal(channel);
        if (this.m_ids.numElements() == 0) {
            this.close();
        }
    }

    public synchronized void kill(int channel) {
        this.closeInternal(channel);
        if (this.m_ids.numElements() == 0) {
            this.kill();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeInternal(int channel) {
        if (this.DEBUG) {
            this.debug("close channel " + channel);
        }
        if (channel == 0) {
            this.cleanupInstanceStats();
        }
        if (this.m_cscs.elementAt(channel) != null) {
            this.m_cscs.setElementAt(null, channel);
            Long ClientId = (Long)this.m_ids.elementAt(channel);
            this.m_ids.setElementAt(null, channel);
            long clientId = ClientId;
            this.m_channels.remove(clientId);
            this.m_cscsById.remove(clientId);
            this.m_deliveryStartedById.remove(clientId);
            Object object = synchvar;
            synchronized (object) {
                if (channel == 0) {
                    s_connectionCountTracker.removePrimaryConnection(clientId, this);
                } else {
                    s_connectionCountTracker.removeSubResource(clientId, this);
                }
            }
        }
    }

    private void checkConnectLimit(String appid) throws EConnectionLimitExceeded {
        if (!ConnectionCountTracker.isClientConnection(appid)) {
            return;
        }
        if (!BrokerLicenseMgr.checkConnectionLimit(s_connectionCountTracker.getClientConnectionCount() + 1, s_connectionCountTracker.getMFConnectionCount() + (ConnectionCountTracker.isMFConnection(appid) ? 1 : 0))) {
            throw new EConnectionLimitExceeded(prAccessor.getString("STR291"));
        }
    }

    private void checkUserConnectLimit(long cid, String user) throws EConnectionLimitExceeded {
        s_connectionCountTracker.setupPerUserConnectionLimits();
        ConnectionCountTracker.UserConnectionLimit connectionLimit = s_connectionCountTracker.getUserConnectionLimits().get(user);
        if (connectionLimit == null) {
            return;
        }
        if (connectionLimit.maxConnections < connectionLimit.currentConnections.size() + 1) {
            long now = System.currentTimeMillis();
            if (connectionLimit.lastWarning + this.getUserConnectionLimitWarningInterval() < now) {
                connectionLimit.lastWarning = now;
                BrokerComponent.getComponentContext().logMessage("User '" + user + "' reached by connection limit (" + connectionLimit.maxConnections + "), no longer accepting connections for this user", 2);
            }
            throw new EConnectionLimitExceeded(prAccessor.getString("STR291a"));
        }
        connectionLimit.currentConnections.add(cid);
    }

    private long getUserConnectionLimitWarningInterval() {
        if (s_userConnectionLimitWarningInterval != null) {
            return s_userConnectionLimitWarningInterval;
        }
        String value = Config.MAX_CONNECTIONS_PER_USER_WARN_INTERVAL;
        if (value != null && value.matches("\\d+")) {
            s_userConnectionLimitWarningInterval = Long.parseLong(value);
            return s_userConnectionLimitWarningInterval;
        }
        s_userConnectionLimitWarningInterval = DEFAULT_USER_CONNECTION_LIMIT_WARNING_INTERVAL;
        return s_userConnectionLimitWarningInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int getClientConnectionCount() {
        Object object = synchvar;
        synchronized (object) {
            return s_connectionCountTracker.getClientConnectionCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int getJMSSessionCount() {
        Object object = synchvar;
        synchronized (object) {
            return s_connectionCountTracker.getJMSSessionCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int getJMSSessionCount(long cid) {
        Object object = synchvar;
        synchronized (object) {
            return s_connectionCountTracker.getJMSSessionCount(cid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int getNonDurableTopicSubscriberCount() {
        Object object = synchvar;
        synchronized (object) {
            return s_connectionCountTracker.getNonDurableTopicSubscriberCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int getDurableTopicSubscriberCount() {
        Object object = synchvar;
        synchronized (object) {
            return s_connectionCountTracker.getDurableTopicSubscriberCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int getQueueReceiverCount() {
        Object object = synchvar;
        synchronized (object) {
            return s_connectionCountTracker.getQueueReceiverCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int getQueueBrowserCount() {
        Object object = synchvar;
        synchronized (object) {
            return s_connectionCountTracker.getQueueBrowserCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int getQueueBrowserCount(long cid) {
        Object object = synchvar;
        synchronized (object) {
            return s_connectionCountTracker.getQueueBrowserCount(cid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void setMostRecentClientConnectTime() {
        Object object = synchvar;
        synchronized (object) {
            m_mostRecentClientConnectTime = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final long getMostRecentClientConnectTime() {
        Object object = synchvar;
        synchronized (object) {
            return m_mostRecentClientConnectTime;
        }
    }

    public long getChan0Id() {
        return this.m_chan0id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseConnectionCounts(long cid, AgentConnection expiredConnection) {
        Object object = synchvar;
        synchronized (object) {
            s_connectionCountTracker.removePrimaryConnection(cid, null);
            s_connectionCountTracker.removePrimaryConnection(cid, expiredConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void reserveConnectionCounts(long cid, String appid, String ipAddress) {
        Object object = synchvar;
        synchronized (object) {
            int plen;
            int nextDollarSign;
            s_connectionCountTracker.addPrimaryConnection(cid, appid, null);
            if (appid.startsWith(SessionConfig.TMP_APPID_PREFIX) && (nextDollarSign = appid.indexOf(36, plen = SessionConfig.TMP_APPID_PREFIX.length())) > 0) {
                String ID = appid.substring(plen, nextDollarSign);
                try {
                    long id = Long.parseLong(ID);
                    BrokerConnectHandshaker.notifyRecoveredTemporaryAppid(id);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (ipAddress != null) {
                Broker.getBroker().getBrokerLicenseMgr().registerIPAddressInUse(ipAddress);
            }
        }
    }

    public String getHostIpAddrStr() {
        ISocket socket;
        String ipAddressStr = this.m_ipAddressStr;
        if (ipAddressStr == null && (socket = this.m_socket) != null) {
            ipAddressStr = this.getIPAddr(socket);
        }
        return ipAddressStr == null ? "" : ipAddressStr;
    }

    private String getIPAddr(ISocket socket) {
        ProgressInetAddress paddress = socket.getInetAddress();
        if (paddress == null || paddress.isLoopbackAddress()) {
            try {
                paddress = ProgressInetAddress.getLocalHost();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (paddress == null) {
            throw new NullPointerException("Unable to determine the address of the local host.");
        }
        String hostaddress = paddress.getHostAddress(false);
        return hostaddress;
    }

    private void checkIPAddressLimit(String appid) throws EIPAddressLimitExceeded {
        if (!ConnectionCountTracker.isClientConnection(appid)) {
            return;
        }
        if (!Broker.getBroker().getBrokerLicenseMgr().checkIPAddressLimit(this.getHostIpAddrStr())) {
            throw new EIPAddressLimitExceeded(prAccessor.getString("IPAddressLimitExceeded"));
        }
    }

    boolean hasTimedOut() {
        return this.m_timedOut;
    }

    void setTimedOut() {
        this.m_timedOut = true;
    }

    void cancelTimeOut() {
        this.m_timedOut = false;
        this.m_sender.notifySender();
    }

    @Override
    public void close() {
        this.closeInternal();
        super.close();
    }

    public void kill() {
        this.closeInternal();
        if (this.getAgentSender() != null) {
            this.getAgentSender().shutdown();
        }
        if (this.getAgentListener() != null) {
            this.getAgentListener().shutdown();
        }
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeInternal() {
        if (this.m_remoteBrokerIdSet) {
            this.m_remoteBrokerIdSet = false;
            AgentRegistrar.getAgentRegistrar().getRouterManager().removeConnectingBroker(this.m_remoteBrokerId);
        }
        this.cleanupAcceptorConnection();
        this.cleanupInstanceStats();
        if (this.m_sender != null && !this.m_sender.isStarted()) {
            this.m_sender.setAbort();
            try {
                this.m_sender.startIfNotStartedOrShutdown();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                // empty catch block
            }
        }
        if (this.m_sender != null) {
            this.m_sender.close();
        }
        if (this.m_listener != null) {
            this.m_listener.shutdown(false);
        }
        Object object = synchvar;
        synchronized (object) {
            s_connectionCountTracker.removePrimaryConnection(this.m_chan0id, this);
        }
    }

    public void cleanupAcceptorConnection() {
        IAcceptor acceptor;
        if (this.m_socket instanceof ProgressSocket && (acceptor = ((ProgressSocket)this.m_socket).getAcceptor()) != null) {
            acceptor.removeConnection(this);
        }
    }

    private static void refreshInstanceMetrics(IMetricIdentity id) {
        AgentRegistrar reg = AgentRegistrar.getAgentRegistrar();
        if (reg == null) {
            return;
        }
        Set clients = reg.getAllConnectionClients(true);
        if (clients == null) {
            return;
        }
        for (IClientContext cc : clients) {
            AgentConnection con;
            String instanceName;
            if (!cc.isConnected() || (instanceName = AgentConnection.getInstanceMetricName(cc)) == null || (con = cc.getConnection()) == null) continue;
            boolean enabled = AgentConnection.checkInstanceMetricEnabled(id, instanceName);
            if (Config.DEBUG) {
                BrokerComponent.getComponentContext().logMessage("AgentConnection - refreshing Instance metric = " + id.getName() + " instanceName = " + instanceName + " enabled = " + enabled, 3);
            }
            if (enabled) {
                con.registerInstanceMetric(id);
                continue;
            }
            con.unregisterInstanceMetric(id);
        }
    }

    private static boolean checkInstanceMetricEnabled(IMetricIdentity id, String child) {
        if (m_metricsRegistrar == null || child == null) {
            return false;
        }
        return m_metricsRegistrar.isInstanceEnabled(AgentConnection.buildInstanceMetricIdentity(id, child));
    }

    private void registerInstanceMetric(IMetricIdentity id) {
        String instanceName = this.getInstanceMetricName();
        if (this.DEBUG) {
            this.debug("Registering instance metric " + id.getName() + " for " + instanceName);
        }
        if (instanceName == null) {
            return;
        }
        IMetricIdentity instanceMetricId = AgentConnection.buildInstanceMetricIdentity(id, instanceName);
        if (m_metricsRegistrar != null) {
            if (id.equals((Object)CONNECTION_MSGS_RECEIVEDPERSECOND_METRIC) && this.m_connMsgsRecvdPerSecStat == null) {
                this.m_connMsgsRecvdPerSecStat = StatisticsFactory.createStatistic((short)2, (boolean)true, null, (short)1);
                m_metricsRegistrar.registerMetric(instanceMetricId, this.m_connMsgsRecvdPerSecStat);
            }
            if (id.equals((Object)CONNECTION_MSGS_DELIVEREDPERSECOND_METRIC) && this.m_connMsgsDelvdPerSecStat == null) {
                this.m_connMsgsDelvdPerSecStat = StatisticsFactory.createStatistic((short)2, (boolean)true, null, (short)1);
                m_metricsRegistrar.registerMetric(instanceMetricId, this.m_connMsgsDelvdPerSecStat);
            }
            if (id.equals((Object)CONNECTION_MSGS_RECEIVED_METRIC) && this.m_connMsgsRecvdStat == null) {
                this.m_connMsgsRecvdStat = StatisticsFactory.createStatistic((short)2, (boolean)false, null, (short)0);
                m_metricsRegistrar.registerMetric(instanceMetricId, this.m_connMsgsRecvdStat);
            }
            if (id.equals((Object)CONNECTION_MSGS_DELIVERED_METRIC) && this.m_connMsgsDelvdStat == null) {
                this.m_connMsgsDelvdStat = StatisticsFactory.createStatistic((short)2, (boolean)false, null, (short)0);
                m_metricsRegistrar.registerMetric(instanceMetricId, this.m_connMsgsDelvdStat);
            }
            if (id.equals((Object)CONNECTION_BYTES_RECEIVEDPERSECOND_METRIC) && this.m_connBytesRecvdPerSecStat == null) {
                this.m_connBytesRecvdPerSecStat = StatisticsFactory.createStatistic((short)2, (boolean)true, null, (short)1);
                m_metricsRegistrar.registerMetric(instanceMetricId, this.m_connBytesRecvdPerSecStat);
            }
            if (id.equals((Object)CONNECTION_BYTES_DELIVEREDPERSECOND_METRIC) && this.m_connBytesDelvdPerSecStat == null) {
                this.m_connBytesDelvdPerSecStat = StatisticsFactory.createStatistic((short)2, (boolean)true, null, (short)1);
                m_metricsRegistrar.registerMetric(instanceMetricId, this.m_connBytesDelvdPerSecStat);
            }
            if (id.equals((Object)CONNECTION_BYTES_RECEIVED_METRIC) && this.m_connBytesRecvdStat == null) {
                this.m_connBytesRecvdStat = StatisticsFactory.createStatistic((short)2, (boolean)false, null, (short)0);
                m_metricsRegistrar.registerMetric(instanceMetricId, this.m_connBytesRecvdStat);
            }
            if (id.equals((Object)CONNECTION_BYTES_DELIVERED_METRIC) && this.m_connBytesDelvdStat == null) {
                this.m_connBytesDelvdStat = StatisticsFactory.createStatistic((short)2, (boolean)false, null, (short)0);
                m_metricsRegistrar.registerMetric(instanceMetricId, this.m_connBytesDelvdStat);
            }
        }
        if (this.m_connBytesRecvdPerSecStat != null || this.m_connBytesRecvdStat != null) {
            this.m_hasEnabledBytesRecvdMetrics = true;
        }
        if (this.m_connBytesDelvdPerSecStat != null || this.m_connBytesDelvdStat != null) {
            this.m_hasEnabledBytesDelvdMetrics = true;
        }
        if (this.m_connMsgsRecvdPerSecStat != null || this.m_connMsgsRecvdStat != null) {
            this.m_hasEnabledMsgsRecvdMetrics = true;
        }
        if (this.m_connMsgsDelvdPerSecStat != null || this.m_connMsgsDelvdStat != null) {
            this.m_hasEnabledMsgsDelvdMetrics = true;
        }
    }

    void unregisterInstanceMetric(IMetricIdentity id) {
        String instanceName = this.getInstanceMetricName();
        if (this.DEBUG) {
            this.debug("Unregistering instance metric " + id.getName() + " for " + instanceName);
        }
        if (instanceName == null) {
            return;
        }
        IMetricIdentity instanceMetricId = AgentConnection.buildInstanceMetricIdentity(id, instanceName);
        IStatistic unregisterStat = null;
        if (id.equals((Object)CONNECTION_MSGS_RECEIVEDPERSECOND_METRIC) && this.m_connMsgsRecvdPerSecStat != null) {
            unregisterStat = this.m_connMsgsRecvdPerSecStat;
            this.m_connMsgsRecvdPerSecStat = null;
        }
        if (id.equals((Object)CONNECTION_MSGS_DELIVEREDPERSECOND_METRIC) && this.m_connMsgsDelvdPerSecStat != null) {
            unregisterStat = this.m_connMsgsDelvdPerSecStat;
            this.m_connMsgsDelvdPerSecStat = null;
        }
        if (id.equals((Object)CONNECTION_MSGS_RECEIVED_METRIC) && this.m_connMsgsRecvdStat != null) {
            unregisterStat = this.m_connMsgsRecvdStat;
            this.m_connMsgsRecvdStat = null;
        }
        if (id.equals((Object)CONNECTION_MSGS_DELIVERED_METRIC) && this.m_connMsgsDelvdStat != null) {
            unregisterStat = this.m_connMsgsDelvdStat;
            this.m_connMsgsDelvdStat = null;
        }
        if (id.equals((Object)CONNECTION_BYTES_RECEIVEDPERSECOND_METRIC) && this.m_connBytesRecvdPerSecStat != null) {
            unregisterStat = this.m_connBytesRecvdPerSecStat;
            this.m_connBytesRecvdPerSecStat = null;
        }
        if (id.equals((Object)CONNECTION_BYTES_DELIVEREDPERSECOND_METRIC) && this.m_connBytesDelvdPerSecStat != null) {
            unregisterStat = this.m_connBytesDelvdPerSecStat;
            this.m_connBytesDelvdPerSecStat = null;
        }
        if (id.equals((Object)CONNECTION_BYTES_RECEIVED_METRIC) && this.m_connBytesRecvdStat != null) {
            unregisterStat = this.m_connBytesRecvdStat;
            this.m_connBytesRecvdStat = null;
        }
        if (id.equals((Object)CONNECTION_BYTES_DELIVERED_METRIC) && this.m_connBytesDelvdStat != null) {
            unregisterStat = this.m_connBytesDelvdStat;
            this.m_connBytesDelvdStat = null;
        }
        if (unregisterStat != null && m_metricsRegistrar != null) {
            m_metricsRegistrar.unregisterMetric(instanceMetricId, unregisterStat);
        }
        if (this.m_connBytesRecvdPerSecStat == null && this.m_connBytesRecvdStat == null) {
            this.m_hasEnabledBytesRecvdMetrics = false;
        }
        if (this.m_connBytesDelvdPerSecStat == null && this.m_connBytesDelvdStat == null) {
            this.m_hasEnabledBytesDelvdMetrics = false;
        }
        if (this.m_connMsgsRecvdPerSecStat == null && this.m_connMsgsRecvdStat == null) {
            this.m_hasEnabledMsgsRecvdMetrics = false;
        }
        if (this.m_connMsgsDelvdPerSecStat == null && this.m_connMsgsDelvdStat == null) {
            this.m_hasEnabledMsgsDelvdMetrics = false;
        }
    }

    private static IMetricIdentity buildInstanceMetricIdentity(IMetricIdentity id, String child) {
        if (child == null) {
            return null;
        }
        IMetricIdentity childId = MetricsFactory.createMetricIdentity((IMetricIdentity)id, (String)child);
        return childId;
    }

    public boolean hasEnabledBytesRecvdMetrics() {
        return this.m_hasEnabledBytesRecvdMetrics;
    }

    public boolean hasEnabledBytesDelvdMetrics() {
        return this.m_hasEnabledBytesDelvdMetrics;
    }

    public boolean hasEnabledMsgsRecvdMetrics() {
        return this.m_hasEnabledMsgsRecvdMetrics;
    }

    public boolean hasEnabledMsgsDelvdMetrics() {
        return this.m_hasEnabledMsgsDelvdMetrics;
    }

    public void updateMsgsRcvdStats(long value) {
        this.updateValues(this.m_connMsgsRecvdPerSecStat, value, this.m_connMsgsRecvdStat);
    }

    public void updateMsgsDelvdStats(long value) {
        this.updateValues(this.m_connMsgsDelvdPerSecStat, value, this.m_connMsgsDelvdStat);
    }

    @Override
    public void updateBytesRcvdStats(long value) {
        this.updateValues(this.m_connBytesRecvdPerSecStat, value, this.m_connBytesRecvdStat);
    }

    @Override
    public void updateBytesDelvdStats(long value) {
        this.updateValues(this.m_connBytesDelvdPerSecStat, value, this.m_connBytesDelvdStat);
    }

    private void updateValues(IStatistic m_connMsgsDelvdPerSecStat, long value, IStatistic m_connMsgsDelvdStat) {
        if (m_connMsgsDelvdPerSecStat != null) {
            m_connMsgsDelvdPerSecStat.updateValue(value);
        }
        if (m_connMsgsDelvdStat != null) {
            m_connMsgsDelvdStat.updateValue(value);
        }
    }

    public void cleanupInstanceStats() {
        if (this.m_connMsgsRecvdPerSecStat != null) {
            this.unregisterInstanceMetric(CONNECTION_MSGS_RECEIVEDPERSECOND_METRIC);
        }
        if (this.m_connMsgsDelvdPerSecStat != null) {
            this.unregisterInstanceMetric(CONNECTION_MSGS_DELIVEREDPERSECOND_METRIC);
        }
        if (this.m_connMsgsRecvdStat != null) {
            this.unregisterInstanceMetric(CONNECTION_MSGS_RECEIVED_METRIC);
        }
        if (this.m_connMsgsDelvdStat != null) {
            this.unregisterInstanceMetric(CONNECTION_MSGS_DELIVERED_METRIC);
        }
        if (this.m_connBytesRecvdPerSecStat != null) {
            this.unregisterInstanceMetric(CONNECTION_BYTES_RECEIVEDPERSECOND_METRIC);
        }
        if (this.m_connBytesDelvdPerSecStat != null) {
            this.unregisterInstanceMetric(CONNECTION_BYTES_DELIVEREDPERSECOND_METRIC);
        }
        if (this.m_connBytesRecvdStat != null) {
            this.unregisterInstanceMetric(CONNECTION_BYTES_RECEIVED_METRIC);
        }
        if (this.m_connBytesDelvdStat != null) {
            this.unregisterInstanceMetric(CONNECTION_BYTES_DELIVERED_METRIC);
        }
    }

    private static String getConnectId(IClientContext cc) {
        String connectId = null;
        if (cc != null) {
            connectId = AgentConnection.trimConnectId(cc.getAppid());
        }
        return connectId;
    }

    private static String getInstanceMetricName(IClientContext cc) {
        AgentConnection conn;
        String instanceName = null;
        if (cc != null && (conn = cc.getConnection()) != null) {
            instanceName = conn.getInstanceMetricName();
        }
        return instanceName;
    }

    private static String trimConnectId(String appid) {
        if (appid != null && appid.endsWith("$CONNECTION$")) {
            return appid.substring(0, appid.lastIndexOf("$CONNECTION$"));
        }
        return null;
    }

    private String getConnectId() {
        String appid = null;
        ClientSecurityContext csc = (ClientSecurityContext)this.m_cscs.elementAt(0);
        if (csc != null) {
            appid = csc.getAppid();
        }
        return AgentConnection.trimConnectId(appid);
    }

    protected String getInstanceMetricName() {
        ClientSecurityContext csc = (ClientSecurityContext)this.m_cscs.elementAt(0);
        if (csc == null) {
            return null;
        }
        String appid = csc.getAppid();
        if (appid == null) {
            return null;
        }
        String instanceName = null;
        if (appid.endsWith("$CONNECTION$")) {
            instanceName = csc.getDisplayInfo().getName();
        }
        return instanceName;
    }

    public int getChannel(long clientId) {
        Integer Channel2 = (Integer)this.m_channels.get(clientId);
        if (Channel2 == null) {
            return -1;
        }
        return Channel2;
    }

    @Override
    public String toString() {
        return "AgentConnection " + this.m_socketId;
    }

    public void flowControlMgramReceived(IMgram m) {
        if (SessionConfig.FLOW_DEBUG) {
            int channel = m.getChannel();
            ClientSecurityContext csc = this.getSecurityContext(channel);
            System.out.println("Client " + csc.getUid() + "/" + csc.getAppid() + " got flow control mgram, prio " + m.getFlowControlHandle().getMinPriority());
        }
        this.getSender().setMinSendPriority(m.getFlowControlHandle().getMinPriority(), m.getChannel());
    }

    public final boolean isAuthenticated() {
        return this.getSecurityContext(0) != null;
    }

    byte getClientSessionVer() {
        return this.m_listener == null ? (byte)32 : this.m_listener.getClientSessionVer();
    }

    public void setPartnerProductVersion(VersionData dat) {
        this.m_partnerProductVersion = dat;
    }

    public VersionData getPartnerProductVersion() {
        return this.m_partnerProductVersion;
    }

    public void appendConnectionMemberProperties(Map properties) {
        ClientSecurityContext csc = (ClientSecurityContext)this.m_cscs.elementAt(0);
        String localSocketInfo = null;
        String remoteSocketInfo = null;
        if (this.m_socket != null) {
            int port;
            String ip;
            String hostname;
            ProgressInetAddress addr = this.m_socket.getLocalInetAddress();
            if (addr != null) {
                hostname = addr.getCanonicalHostName();
                ip = addr.getHostAddress(true);
                port = this.m_socket.getLocalPort();
                localSocketInfo = this.retrieveSocketInfo(hostname, addr, ip, port);
            }
            if ((addr = this.m_socket.getInetAddress()) != null) {
                hostname = addr.getCanonicalHostName();
                ip = addr.getHostAddress(true);
                port = this.m_socket.getPort();
                remoteSocketInfo = this.retrieveSocketInfo(hostname, addr, ip, port);
            }
        }
        if (this.getAcceptorName() != null) {
            properties.put("AcceptorName", this.getAcceptorName());
        }
        if (this.getAcceptorUrl() != null) {
            properties.put("AcceptorUrl", this.getAcceptorUrl());
        }
        if (localSocketInfo != null) {
            properties.put("LocalSocket", localSocketInfo);
        }
        if (remoteSocketInfo != null) {
            properties.put("RemoteSocket", remoteSocketInfo);
        }
        if (csc != null) {
            properties.put("User", csc.getUid());
        }
        properties.put("FaultTolerant", Boolean.toString(this.m_faultTolerant));
        if (this.m_listener != null) {
            properties.put("Compression", Boolean.toString(this.m_listener.getCompressionFactory() != null));
        }
        if (this.m_negotiatedConnectParms != null && this.m_negotiatedConnectParms.getClientFCMonitorInterval() >= 0) {
            properties.put("MonitorInterval", Integer.toString(this.m_negotiatedConnectParms.getClientFCMonitorInterval()));
        }
        properties.put("Protocol", "P" + this.getClientSessionVer());
        VersionData ver = this.getPartnerProductVersion();
        if (ver != null) {
            properties.put("Version", ver.getName() + " " + ver.getReleaseString() + " b" + ver.getBuildNumber());
        } else {
            properties.put("Version", "Legacy (P" + this.getClientSessionVer() + ")");
        }
        int sessions = AgentConnection.getJMSSessionCount(this.m_chan0id);
        int browsers = AgentConnection.getQueueBrowserCount(this.m_chan0id);
        int consumers = sessions == -1 || browsers == -1 ? -1 : this.m_channels.size() - sessions - browsers - 1;
        properties.put("SessionCount", Integer.toString(sessions));
        properties.put("ConsumerCount", Integer.toString(consumers));
        properties.put("ConnectionType", "Application");
    }

    private String retrieveSocketInfo(String hostname, ProgressInetAddress addr, String ip, int port) {
        String remoteSocketInfo = null;
        remoteSocketInfo = hostname == null || hostname.equals(addr.getHostAddress(false)) ? ip + ":" + port : hostname + "(" + ip + "):" + port;
        return remoteSocketInfo;
    }

    public NegotiatedConnectParms getNegotiatedConnectParms() {
        return this.m_negotiatedConnectParms;
    }

    public void setNegotiatedConnectParms(NegotiatedConnectParms p) {
        this.m_negotiatedConnectParms = p;
    }

    public void setAcceptor(IAcceptor acceptor) {
        this.m_acceptor = acceptor;
    }

    @Override
    public IAcceptor getAcceptor() {
        return this.m_acceptor;
    }

    @Override
    public void fatalError() {
        if (this.m_listener != null) {
            this.m_listener.fatalError(null);
        }
    }

    static {
        synchvar = new Object();
        BROKER_CONNECTIONS_COUNT_METRIC = MetricsFactory.createMetricIdentity((String[])new String[]{"broker", "connections", "Count"});
        CONNECTION_MSGS_RECEIVEDPERSECOND_METRIC = MetricsFactory.createMetricIdentity((String[])new String[]{"connection", "messages", "ReceivedPerSecond"});
        CONNECTION_MSGS_DELIVEREDPERSECOND_METRIC = MetricsFactory.createMetricIdentity((String[])new String[]{"connection", "messages", "DeliveredPerSecond"});
        CONNECTION_MSGS_RECEIVED_METRIC = MetricsFactory.createMetricIdentity((String[])new String[]{"connection", "messages", "Received"});
        CONNECTION_MSGS_DELIVERED_METRIC = MetricsFactory.createMetricIdentity((String[])new String[]{"connection", "messages", "Delivered"});
        CONNECTION_BYTES_RECEIVEDPERSECOND_METRIC = MetricsFactory.createMetricIdentity((String[])new String[]{"connection", "bytes", "ReceivedPerSecond"});
        CONNECTION_BYTES_DELIVEREDPERSECOND_METRIC = MetricsFactory.createMetricIdentity((String[])new String[]{"connection", "bytes", "DeliveredPerSecond"});
        CONNECTION_BYTES_RECEIVED_METRIC = MetricsFactory.createMetricIdentity((String[])new String[]{"connection", "bytes", "Received"});
        CONNECTION_BYTES_DELIVERED_METRIC = MetricsFactory.createMetricIdentity((String[])new String[]{"connection", "bytes", "Delivered"});
    }
}

