/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import progress.message.broker.AMPScratchPad;
import progress.message.broker.AgentGuarMsgTracker;
import progress.message.broker.AgentQueueMsgTracker;
import progress.message.broker.AgentQueueProcessor;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.AgentRoutingQueue;
import progress.message.broker.Authorize;
import progress.message.broker.BaseClientContext;
import progress.message.broker.BatchSplitEvt;
import progress.message.broker.BrokerLicenseMgr;
import progress.message.broker.BrokerSearchResults;
import progress.message.broker.BrokerSubscription;
import progress.message.broker.Config;
import progress.message.broker.DeliveryListEvt;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.EStartupFailure;
import progress.message.broker.ETrackingNumNotFound;
import progress.message.broker.ETxnNotFound;
import progress.message.broker.ETxnSequenceError;
import progress.message.broker.FlowToDiskMemoryManager;
import progress.message.broker.GroupSubscription;
import progress.message.broker.GroupSubscriptionClientContext;
import progress.message.broker.GroupSubscriptions;
import progress.message.broker.GuarMsgEvt;
import progress.message.broker.IAMPHandle;
import progress.message.broker.IAgentQueue;
import progress.message.broker.IClientContext;
import progress.message.broker.IFlowController;
import progress.message.broker.InterbrokerHook;
import progress.message.broker.LBSTrackingInfo;
import progress.message.broker.LogManager;
import progress.message.broker.MgramURLHelper;
import progress.message.broker.MsgSaver;
import progress.message.broker.PublishLimiter;
import progress.message.broker.RecipientVector;
import progress.message.broker.RecipientWrap;
import progress.message.broker.RoutingSubjectResolver;
import progress.message.broker.SendBatchEvt;
import progress.message.broker.StatsManager;
import progress.message.broker.StatsMetrics;
import progress.message.broker.TransactionMgr;
import progress.message.broker.TxMsgPubSub;
import progress.message.broker.interceptor.InterceptorManager;
import progress.message.broker.prAccessor;
import progress.message.broker.stats.LTotStatsObj;
import progress.message.client.EIntegrityCompromised;
import progress.message.client.ESecurityGeneralException;
import progress.message.msg.IBatchHandle;
import progress.message.msg.IMgram;
import progress.message.msg.IRoutingHandle;
import progress.message.msg.MgramFactory;
import progress.message.resources.prMessageFormat;
import progress.message.util.DebugState;
import progress.message.util.DestinationInfo;
import progress.message.util.DraDestUtil;
import progress.message.util.EAssertFailure;
import progress.message.util.EDuplicateKey;
import progress.message.util.LongHashTable;
import progress.message.util.WrappedDataOutputStream;
import progress.message.util.server.EpochClock;
import progress.message.zclient.ClientSecurityContext;
import progress.message.zclient.DebugObject;
import progress.message.zclient.ESecurityInvalidLogistics;
import progress.message.zclient.FastVector;
import progress.message.zclient.IMessageProtection;
import progress.message.zclient.IQop;
import progress.message.zclient.ISidebandData;
import progress.message.zclient.ISubject;
import progress.message.zclient.ISubjectFilter;
import progress.message.zclient.ISubjectMatchObject;
import progress.message.zclient.Label;
import progress.message.zclient.SecurityLogic;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.Subject;
import progress.message.zclient.xonce.IXOnceHandle;
import progress.message.zclient.xonce.MgramTrace;

public final class AgentMessageProcessor
extends DebugObject {
    private AgentRegistrar m_reg;
    private LogManager m_logmgr;
    private MsgSaver m_msgSaver;
    private TransactionMgr m_txnmgr;
    private StatsManager m_statsMgr;
    private AgentQueueProcessor m_qproc;
    private Object m_pubDispatchLock;
    private int m_pendingDispatchCount = 0;
    private int m_dispatchLockCount = 0;
    private long s_AdminClientId = 0L;
    private LTotStatsObj pubsubPubMsgs;
    private LTotStatsObj ptpPubMsgs;
    private LTotStatsObj ptpFrwrdMsgs;
    private LTotStatsObj pubsubDelivMsgs;
    private LTotStatsObj pubsubDelDiscMsgs;
    private LTotStatsObj ptpDelivMsgs;
    private LTotStatsObj msgsRecd;
    private LTotStatsObj msgsDeliv;
    private LTotStatsObj bytesRecd;
    private long m_dispatchId = 0L;
    private static final boolean DEBUG_SECURITY = false;

    private boolean isAdminClientId(long id) {
        if (this.s_AdminClientId == 0L) {
            this.s_AdminClientId = this.m_reg.getAdminConnection().getClientId();
        }
        return this.s_AdminClientId == id;
    }

    public AgentMessageProcessor(AgentRegistrar reg) throws EStartupFailure {
        super(DebugState.GLOBAL_DEBUG_ON ? "AgentMessageProcessor" : null);
        this.m_reg = reg;
        this.m_logmgr = reg.getLogManager();
        this.m_txnmgr = reg.getTransactionMgr();
        this.m_msgSaver = reg.getMsgSaver();
        this.m_statsMgr = reg.getStatsManager();
        this.m_pubDispatchLock = new Object();
        this.m_qproc = reg.getQueueProc();
        if (StatsMetrics.areStatsEnabled(4)) {
            this.pubsubPubMsgs = new LTotStatsObj(4, 1025, 1);
            this.pubsubPubMsgs.outputStatistic(1026, 6);
            this.m_statsMgr.registerStat(this.pubsubPubMsgs);
            this.pubsubDelivMsgs = new LTotStatsObj(4, 1027, 1);
            this.pubsubDelivMsgs.outputStatistic(1028, 6);
            this.m_statsMgr.registerStat(this.pubsubDelivMsgs);
            this.pubsubDelDiscMsgs = new LTotStatsObj(4, 2, 1);
            this.m_statsMgr.registerStat(this.pubsubDelDiscMsgs);
        }
        if (StatsMetrics.areStatsEnabled(5)) {
            this.ptpFrwrdMsgs = new LTotStatsObj(5, 1285, 1);
            this.ptpFrwrdMsgs.outputStatistic(1286, 6);
            this.m_statsMgr.registerStat(this.ptpFrwrdMsgs);
            this.ptpPubMsgs = new LTotStatsObj(5, 1281, 1);
            this.ptpPubMsgs.outputStatistic(1282, 6);
            this.m_statsMgr.registerStat(this.ptpPubMsgs);
            this.ptpDelivMsgs = new LTotStatsObj(5, 1283, 1);
            this.ptpDelivMsgs.outputStatistic(1284, 6);
            this.m_statsMgr.registerStat(this.ptpDelivMsgs);
        }
        if (StatsMetrics.areStatsEnabled(1)) {
            this.msgsRecd = new LTotStatsObj(1, 260, 1);
            this.msgsRecd.outputStatistic(261, 6);
            this.m_statsMgr.registerStat(this.msgsRecd);
            this.bytesRecd = new LTotStatsObj(1, 262, 6);
            this.m_statsMgr.registerStat(this.bytesRecd);
            this.msgsDeliv = new LTotStatsObj(1, 263, 1);
            this.msgsDeliv.outputStatistic(264, 6);
            this.m_statsMgr.registerStat(this.msgsDeliv);
        }
    }

    void start() {
        if (this.DEBUG) {
            this.debug("starting");
        }
    }

    public void newMgram(IMgram m, AMPScratchPad scratch) throws InterruptedException {
        this.newMgram(m, scratch, null);
    }

    public void newMgram(IMgram m, AMPScratchPad scratch, HashSet targetClients) throws InterruptedException {
        Hashtable props;
        ISidebandData sd;
        String remoteNode;
        ISubject s;
        if (scratch == null) {
            return;
        }
        if (this.DEBUG) {
            this.debug("processing message to " + MgramTrace.diagnosticString(m));
        }
        if (scratch.m_publisher != null && scratch.m_publisher.getClientSessionVer() < 25 && m.isPubSub()) {
            String subject = null;
            int routingNodeNamePos = -1;
            subject = m.getSubject().getSubjectString();
            if (subject != null) {
                routingNodeNamePos = subject.lastIndexOf("::");
            }
            if (routingNodeNamePos != -1) {
                String routingNodeName = subject.substring(0, routingNodeNamePos);
                if (routingNodeName.equals(Config.ROUTING_NODE_NAME)) {
                    Subject newSubject = new Subject(subject.substring(routingNodeNamePos + 2));
                    m.setSubject(newSubject, m.getSubjectFormat());
                } else {
                    if (m.isGuarenteed() || m.isRejectable()) {
                        scratch.m_publisher.sendErrorAck(m, (short)-6, false);
                    }
                    return;
                }
            }
        }
        if (m.hasSubject() && !m.getBrokerHandle().isTxnPublishFromLog() && !(s = m.getSubject()).isReply() && s.hasSubjectTracking()) {
            m.setSubject(s.clearSubjectTracking(), m.getSubjectFormat());
        }
        boolean permissionOK = true;
        if (scratch.m_publisher != null && m.isPubSub() && !(permissionOK = this.m_reg.getGSManager().checkGlobalSubscribe(m, scratch.m_publisher))) {
            if (m.isGuarenteed() || m.isRejectable()) {
                scratch.m_publisher.sendErrorAck(m, (short)-7, true);
                if (this.DEBUG) {
                    this.debug("Acknowledging subscribe permission failure from RemoteBroker: origTracking=" + m.getGuarenteedTrackingNum() + " Sender: " + scratch.m_publisher.getId());
                }
            }
            return;
        }
        int deliveryDelay = this.doJMSDeliveryDelaySupport(m, scratch);
        if (deliveryDelay < 0) {
            return;
        }
        boolean hasDeliveryDelay = deliveryDelay > 0;
        String string = remoteNode = m.forRemoteNode(Config.ROUTING_NODE_NAME) ? m.getRouting() : null;
        if (remoteNode != null) {
            ISubject subject = m.getSubject();
            if (remoteNode.equalsIgnoreCase(SessionConfig.SONIC_HTTP) && DraDestUtil.isSubjectURL(subject)) {
                String effectiveRoutingNode = null;
                effectiveRoutingNode = MgramURLHelper.routingNodeReverseLookup(subject.getJMSName());
                if (effectiveRoutingNode != null) {
                    m.getRoutingHandle().setRouting(effectiveRoutingNode);
                }
            }
            if (!MgramURLHelper.isValidNodeForURLDestination(subject, remoteNode)) {
                if (m.isGuarenteed() || m.isRejectable()) {
                    scratch.m_publisher.sendErrorAck(m, (short)-27, false);
                }
                return;
            }
        }
        DestinationInfo undelDestInfo = null;
        if (m.hasUndeliveredDestination() && (sd = m.getSidebandData()) != null && (props = sd.getProperties()) != null) {
            String undelDest;
            try {
                undelDest = (String)props.get("JMS_SonicMQ_destinationUndelivered");
            }
            catch (ClassCastException e) {
                undelDest = null;
            }
            if (undelDest != null) {
                undelDestInfo = new DestinationInfo(undelDest, Config.ROUTING_NODE_NAME);
            }
        }
        if (undelDestInfo != null && !MgramURLHelper.isValidNodeForURLDestination(undelDestInfo.getISubject(), undelDestInfo.getRouting())) {
            if (m.isGuarenteed() || m.isRejectable()) {
                scratch.m_publisher.sendErrorAck(m, (short)-28, false);
            }
            return;
        }
        if (!Config.ENABLE_SECURITY || this.checkPublishPermission(m, scratch, undelDestInfo)) {
            IAgentQueue target;
            if (!m.getBrokerHandle().isTransactionalPublish()) {
                this.doJMSXUserIDSupport(m, scratch.m_publisher);
            }
            if (m.hasTxn()) {
                if (m.isPTP() && scratch.m_publisher != null && (target = AgentRegistrar.getAgentRegistrar().getQueueProc().resolveQueue(m)) == null) {
                    scratch.m_publisher.sendErrorAck(m, (short)-15, false);
                    return;
                }
                if (scratch.m_publisher != null && scratch.m_publisher.performDbOverflowChecks() && m.isPubSub() && remoteNode == null && !this.m_reg.getBrokerDatabase().hasRoomForMgramNL(m) && (m.isGuarenteed() || m.isRejectable())) {
                    scratch.m_publisher.sendErrorAck(m, (short)-43, false);
                    return;
                }
                if (this.m_txnmgr.handleNewMgram(m)) {
                    return;
                }
            } else if (m.getType() == 27) {
                m.getBrokerHandle().setBatchedPublish(true);
                if (m.getBatchHandle().hasTid()) {
                    this.m_txnmgr.updateLastActiveTime(m.getBatchHandle().getTid());
                }
            }
            if ((m.isPTP() || m.getType() == 11 || m.isPubSub() && remoteNode != null || m.isPubSub() && hasDeliveryDelay) && scratch.m_publisher != null && !m.getBrokerHandle().isTransactionalPublish() && !m.hasTxn() && this.skipLocallyBlockedMessage(m, scratch, target = AgentRegistrar.getAgentRegistrar().getQueueProc().resolveQueue(m))) {
                return;
            }
            if (m.isPTP() || m.getType() == 13 || m.getType() == 11 || m.isPubSub() && remoteNode != null || m.isPubSub() && hasDeliveryDelay) {
                if (m.getType() == 11) {
                    this.addData(this.ptpFrwrdMsgs);
                }
                if (m.isPTP()) {
                    int size = AgentMessageProcessor.retrieveSize(m);
                    if (StatsMetrics.areStatsEnabled(5)) {
                        this.ptpPubMsgs.add(size);
                    }
                    this.addSizeAndNetworkLength(m, size);
                } else if (m.isPubSub()) {
                    this.addRemotePubSub(m);
                }
                this.deliverToQueue(m, scratch);
                if (m.getType() == 13) {
                    if (StatsMetrics.areStatsEnabled(1)) {
                        this.msgsDeliv.add(1L);
                    }
                    this.addData(this.ptpDelivMsgs);
                }
            } else {
                boolean transacted = false;
                int tid = -1;
                if (m.hasTxn()) {
                    transacted = true;
                    tid = m.getTxnId();
                    m.removeTxn();
                }
                if (Config.LG_ENABLE) {
                    if (!m.getBrokerHandle().isTransactionalPublish()) {
                        InterceptorManager.doActionalPubSubReceiveJointPoint(m, scratch.m_publisher);
                    }
                    if (Config.ENABLE_SECURITY && m.isSecure() && InterceptorManager.isMessageLGInstrumented(m)) {
                        try {
                            byte oldAttr = m.getSecurity();
                            byte attr = this.handleQopSecurity(m, true, true);
                            m.setSecurityAttribute(attr);
                        }
                        catch (EIntegrityCompromised oldAttr) {
                            // empty catch block
                        }
                    }
                }
                if (transacted) {
                    IMgram savedMgram = m;
                    boolean needsGuarAck = false;
                    boolean needIBGuarAck = false;
                    boolean needRBGuarAck = false;
                    boolean deliverOnFlush = false;
                    GuarMsgEvt evt = new GuarMsgEvt(savedMgram, null, null, null, null, scratch.m_publisher, false, deliverOnFlush, needIBGuarAck || needRBGuarAck || needsGuarAck, needIBGuarAck, needRBGuarAck, scratch.m_mp, scratch.m_pubLimiter, new AMPHandle(this), null, null, null);
                    evt.setTransacted(tid);
                    if ((this.debugFlags & 0x800) != 0) {
                        this.debug("About to add message to log; tid= " + tid);
                    }
                    try {
                        this.m_txnmgr.addingMsgToLog(tid);
                    }
                    catch (ETxnSequenceError ex) {
                        if ((this.debugFlags & 0x800) != 0) {
                            this.debug("Message discarded for tid; txnSequenceError " + tid, ex);
                        }
                        return;
                    }
                    catch (ETxnNotFound ex) {
                        if ((this.debugFlags & 0x800) != 0) {
                            this.debug("Message discarded for tid; txnNotFound " + tid, ex);
                        }
                        return;
                    }
                    this.m_reg.getLogManager().addEvent(evt, needsGuarAck);
                    evt.createTracker();
                    try {
                        TxMsgPubSub txm = new TxMsgPubSub(tid, evt.getTracker());
                        txm.setOrigTracking(evt.getOrigTracking());
                        this.m_txnmgr.newMsg(txm);
                    }
                    catch (ETxnSequenceError eTxnSequenceError) {
                    }
                    catch (ETxnNotFound eTxnNotFound) {
                        // empty catch block
                    }
                    if (!needsGuarAck && scratch.m_publisher != null && !scratch.m_publisher.isXOnce()) {
                        evt.sendAck();
                    }
                    if ((this.debugFlags & 0x800) != 0) {
                        this.debug("newMgram: incoming transacted mgram; saved to log; trk= " + evt.getTracker().getTracking() + " tid= " + tid + " subj= " + m.getSubject() + " m.isGuaranteed= " + m.isGuarenteed());
                    }
                    return;
                }
                this.addRemotePubSub(m);
                if (m.getType() != 27) {
                    this.deliverNonBatchedMgram(m, scratch, targetClients);
                } else {
                    this.deliverBatchedMgram(m, scratch, targetClients);
                }
            }
        }
        if (this.DEBUG) {
            this.debug("processing complete");
        }
    }

    private void addData(LTotStatsObj lTotStatsObj) {
        if (StatsMetrics.areStatsEnabled(5)) {
            lTotStatsObj.add(1L);
        }
    }

    private void addRemotePubSub(IMgram m) {
        int size = AgentMessageProcessor.retrieveSize(m);
        if (StatsMetrics.areStatsEnabled(4)) {
            this.pubsubPubMsgs.add(size);
        }
        this.addSizeAndNetworkLength(m, size);
    }

    private static int retrieveSize(IMgram m) {
        int size = 1;
        if (m.supportsOperationHandle()) {
            size = m.getOperationHandle().getMgramList().size();
        }
        return size;
    }

    private void addSizeAndNetworkLength(IMgram m, int size) {
        if (StatsMetrics.areStatsEnabled(1)) {
            this.msgsRecd.add(size);
            this.bytesRecd.add(m.networkLength());
        }
    }

    void deliverNonBatchedMgram(IMgram m, AMPScratchPad scratch, HashSet targetClients) {
        ISubject subj;
        AgentRoutingQueue target;
        if (!scratch.m_dmqOverride) {
            this.lookUpSubscribers(m, scratch, targetClients);
        }
        if (scratch.m_ptpClients.m_count > 0 && scratch.m_publisher != null && !m.getBrokerHandle().isTransactionalPublish() && this.skipLocallyBlockedMessage(m, scratch, target = this.m_qproc.getRoutingQueue())) {
            scratch.undoPubDispatch();
            return;
        }
        if (scratch.m_publisher != null && m.isPubSub() && scratch.m_publisher.performDbOverflowChecks() && scratch.m_guarClients.m_count + scratch.m_relClients.m_count > 0 && ((subj = m.getSubject()) == null || !subj.isAnySystem())) {
            if (!m.getBrokerHandle().isTransactionalPublish() && !this.m_reg.getBrokerDatabase().hasRoomForMgramNL(m)) {
                if (m.isGuarenteed() || m.isRejectable()) {
                    scratch.m_publisher.sendErrorAck(m, (short)-43, false);
                    scratch.undoPubDispatch();
                    return;
                }
            } else {
                scratch.m_publisher.stopDbOverflowChecks();
            }
        }
        boolean sendAck = !m.getBrokerHandle().isTransactionalPublish();
        boolean guarMsgEvtLogged = m.getBrokerHandle().isTransactionalPublish() && m.getBrokerHandle().isTxnPublishFromLog();
        this.deliver(m, scratch, sendAck, guarMsgEvtLogged, null);
    }

    void deliverBatchedMgram(IMgram m, AMPScratchPad scratch, HashSet targetClients) {
        ISubject subj;
        this.lookup(m, scratch);
        if (scratch.m_publisher != null && m.isPubSub() && scratch.m_publisher.performDbOverflowChecks() && ((subj = m.getSubject()) == null || !subj.isAnySystem())) {
            if (!m.getBrokerHandle().isTransactionalPublish() && !this.m_reg.getBrokerDatabase().hasRoomForMgramNL(m)) {
                if (m.isGuarenteed() || m.isRejectable()) {
                    scratch.m_publisher.sendErrorAck(m, (short)-43, false);
                    scratch.undoPubDispatch();
                    return;
                }
            } else {
                scratch.m_publisher.stopDbOverflowChecks();
            }
        }
        m.getBatchHandle().setAtomic(scratch.m_isBatchAtomic);
        if (scratch.m_isBatchable) {
            LBSTrackingInfo groupSubscriptionList = scratch.m_groupSubscriptionList;
            boolean groupSubscriptionOnly = scratch.m_groupSubscriptionOnly;
            this.processSubscribers(m, scratch, targetClients, false);
            boolean splitBatch = false;
            AgentGuarMsgTracker batchTracker = null;
            AgentGuarMsgTracker[] subMgramTrackers = null;
            ProcessBatchResult result = this.processBatch(m, scratch.m_persist, groupSubscriptionList, groupSubscriptionOnly, scratch);
            if (result != null) {
                splitBatch = true;
                batchTracker = result.m_batchTracker;
                subMgramTrackers = result.m_subMgramTrackers;
            }
            boolean guarMsgEvtAlreadyLogged = splitBatch || m.getBrokerHandle().isTransactionalPublish() && m.getBrokerHandle().isTxnPublishFromLog();
            this.deliver(m, scratch, false, guarMsgEvtAlreadyLogged, subMgramTrackers);
            if (splitBatch) {
                batchTracker.endSplitting();
                batchTracker.canceled();
            }
        } else {
            this.deliverBatchedSubMgrams(m, scratch, targetClients);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverBatchedSubMgrams(IMgram m, AMPScratchPad scratch, HashSet targetClients) {
        int listCounter;
        Iterator iter;
        boolean mgramPersisted;
        ProcessBatchResult result;
        boolean splitBatch = false;
        AgentGuarMsgTracker batchTracker = null;
        if (scratch.m_publisher != null && m.isGuarenteed() && InterbrokerHook.isSet() && scratch.m_publisher.isInterbroker()) {
            scratch.m_xonce = true;
        }
        if ((result = this.processBatch(m, mgramPersisted = m.isJMSPersistent() || m.getBrokerHandle().isTransactionalPublish() && m.getBrokerHandle().isTxnPublishFromLog(), scratch.m_groupSubscriptionList, scratch.m_groupSubscriptionOnly, scratch)) != null) {
            splitBatch = true;
            batchTracker = result.m_batchTracker;
        }
        int size = m.getBatchHandle().getBatchSize();
        BatchMatchHolder[] matchList = new BatchMatchHolder[size];
        scratch.m_clients = new HashMap();
        if (Config.ENABLE_INTERBROKER) {
            this.startPubDispatch();
        }
        try {
            m.getBatchHandle().syncBatch();
            iter = m.getBatchHandle().getBatchIterator();
            listCounter = 0;
            LBSTrackingInfo groupSubscriptions = scratch.m_groupSubscriptionList;
            boolean groupSubscriptionOnly = scratch.m_groupSubscriptionOnly;
            while (iter.hasNext()) {
                this.processSubscribersInternal((IMgram)iter.next(), scratch, targetClients, true);
                BatchMatchHolder matchHolder = new BatchMatchHolder();
                matchHolder.m_guarClients = (RecipientVector)scratch.m_guarClients.clone();
                matchHolder.m_ptpClients = (RecipientVector)scratch.m_ptpClients.clone();
                matchHolder.m_relClients = (RecipientVector)scratch.m_relClients.clone();
                matchHolder.m_persist = scratch.m_persist;
                matchHolder.m_xonce = scratch.m_xonce;
                if (scratch.m_proxyRecipsTable != null) {
                    matchHolder.m_proxyRecipsTable = (LongHashTable)scratch.m_proxyRecipsTable.clone();
                }
                if (scratch.m_groupSubscriptionsByNeighbor != null) {
                    matchHolder.m_groupSubscriptionsByNeighbor = (LongHashTable)scratch.m_groupSubscriptionsByNeighbor.clone();
                }
                matchList[listCounter++] = matchHolder;
                scratch.m_groupSubscriptionList = groupSubscriptions;
                scratch.m_groupSubscriptionOnly = groupSubscriptionOnly;
            }
        }
        finally {
            if (Config.ENABLE_INTERBROKER) {
                this.finishPubDispatch();
            }
        }
        iter = m.getBatchHandle().getBatchIterator();
        listCounter = 0;
        boolean hasGuarSubs = false;
        while (iter.hasNext()) {
            IMgram subMgram = (IMgram)iter.next();
            subMgram.getBrokerHandle().setBatchId(scratch.m_dispatchId);
            subMgram.getBrokerHandle().setBatchedPublish(true);
            BatchMatchHolder holder = matchList[listCounter];
            scratch.m_guarClients = holder.m_guarClients;
            scratch.m_relClients = holder.m_relClients;
            scratch.m_ptpClients = holder.m_ptpClients;
            scratch.m_persist = holder.m_persist;
            scratch.m_xonce = holder.m_xonce;
            scratch.m_proxyRecipsTable = holder.m_proxyRecipsTable;
            scratch.m_groupSubscriptionsByNeighbor = holder.m_groupSubscriptionsByNeighbor;
            if (scratch.m_guarClients != null && scratch.m_guarClients.m_count > 0) {
                hasGuarSubs = true;
            }
            boolean guarMsgEvtAlreadyLogged = splitBatch || m.getBrokerHandle().isTransactionalPublish() && m.getBrokerHandle().isTxnPublishFromLog();
            this.deliver(subMgram, scratch, false, guarMsgEvtAlreadyLogged, null);
            ++listCounter;
        }
        if (splitBatch) {
            batchTracker.endSplitting();
            batchTracker.canceled();
        }
        boolean needsGuarAck = scratch.m_publisher != null && scratch.m_publisher.needsGuarAck();
        boolean deliverOnFlush = scratch.m_forceDeliverOnFlush || needsGuarAck || Config.REPLICATED && hasGuarSubs;
        deliverOnFlush = this.isDeliverOnFlush(m, deliverOnFlush);
        this.sendBatch(scratch.m_clients, scratch.m_dispatchId, deliverOnFlush, scratch.m_mp, scratch.m_groupSubscriptionsByNeighbor);
    }

    private int doJMSDeliveryDelaySupport(IMgram m, AMPScratchPad scratch) {
        if (scratch.m_publisher != null && scratch.m_publisher.isJMSSession()) {
            boolean moveToDDQ = false;
            if (m.getType() == 27) {
                Iterator it = m.getBatchHandle().getBatchIterator();
                boolean lookupSubscribers = true;
                while (it.hasNext()) {
                    IMgram subMgram = (IMgram)it.next();
                    moveToDDQ = this.checkMoveToDDQ(subMgram, scratch, lookupSubscribers);
                    lookupSubscribers = false;
                    if (!moveToDDQ) continue;
                    this.doJMSDeliveryDelaySupportInternal(subMgram, scratch);
                }
            } else {
                moveToDDQ = this.checkMoveToDDQ(m, scratch, true);
            }
            if (moveToDDQ) {
                if (!BrokerLicenseMgr.getLicenseMgr().isEnterpriseEdition()) {
                    scratch.m_publisher.sendErrorAck(m, (short)-44, false);
                    return -1;
                }
                this.doJMSDeliveryDelaySupportInternal(m, scratch);
                return 1;
            }
        }
        return 0;
    }

    private boolean checkMoveToDDQ(IMgram m, AMPScratchPad scratch, boolean lookupSubscribers) {
        String remoteNode;
        Long deliveryTime = this.getJMSDeliveryTimeFromSideband(m);
        if (deliveryTime == null) {
            return false;
        }
        String string = remoteNode = m.forRemoteNode(Config.ROUTING_NODE_NAME) ? m.getRouting() : null;
        if (m.isPubSub() && lookupSubscribers) {
            this.lookUpSubscribers(m, scratch, null);
            scratch.undoPubDispatch();
        }
        boolean hasSubscribers = scratch.m_relClients.m_count + scratch.m_guarClients.m_count + scratch.m_ptpClients.m_count > 0;
        return m.isPTP() || m.isPubSub() && (hasSubscribers || remoteNode != null);
    }

    private Long getJMSDeliveryTimeFromSideband(IMgram m) {
        ISidebandData sd;
        Hashtable props;
        Long deliveryTime;
        if (!m.isDiscardable() && m.hasSidebandData() && (deliveryTime = (Long)(props = (sd = m.getSidebandData()).getProperties()).get("JMSDeliveryTime")) != null && deliveryTime > 0L) {
            return deliveryTime;
        }
        return null;
    }

    private void addSubscribersToTargetClients(RecipientVector subscribers, StringBuilder targetClients) {
        for (Object relObj : subscribers.m_data) {
            RecipientWrap rw = (RecipientWrap)relObj;
            if (!rw.hasClientContext()) continue;
            if (targetClients.length() > 0) {
                targetClients.append(",");
            }
            targetClients.append(rw.getId());
        }
    }

    void doJMSDeliveryDelaySupportInternal(IMgram m, AMPScratchPad scratch) {
        String remoteNode;
        m.createSidebandDataIfNeeded();
        ISidebandData sd = m.getSidebandData();
        Hashtable props = sd.getProperties();
        if (m.isPubSub() && scratch != null) {
            StringBuilder targetClients = new StringBuilder();
            this.addSubscribersToTargetClients(scratch.m_relClients, targetClients);
            this.addSubscribersToTargetClients(scratch.m_guarClients, targetClients);
            this.addSubscribersToTargetClients(scratch.m_ptpClients, targetClients);
            props.put("JMS_SonicMQ_ultimateDeliverySubscribers", targetClients.toString());
        }
        props.put("JMS_SonicMQ_ultimateDeliveryAddress", m.getSubject().getSubjectString());
        String string = remoteNode = m.forRemoteNode(Config.ROUTING_NODE_NAME) ? m.getRouting() : null;
        if (remoteNode != null) {
            props.put("JMS_SonicMQ_ultimateDeliveryRoutingNode", remoteNode);
            m.getRoutingHandle().setRouting(null);
        }
        String delayedDeliveryQueue = "$Q.SonicMQ.delayedDeliveryQueue";
        Subject newSubject = new Subject("$Q.SonicMQ.delayedDeliveryQueue");
        m.setSubject(newSubject, 5);
    }

    private void doJMSXUserIDSupport(IMgram m, IClientContext publisher) {
        if (publisher == null || !Config.ENABLE_SECURITY || !Config.SET_JMSXUSERID || m.getSubject().isAnySystem() && !m.getSubject().hasTemporary()) {
            return;
        }
        if (publisher.isHTTPDirect()) {
            return;
        }
        m.createSidebandDataIfNeeded();
        Hashtable table = m.getSidebandData().getProperties();
        String existingID = (String)table.get("JMSXUserID");
        if (existingID != null && !"".equals(existingID) && (publisher.isInterbroker() || publisher.isRemoteBroker())) {
            if (this.DEBUG) {
                this.debug("NO need to reset JMSXUserID for subject : " + m.getSubject() + " existing ID = " + existingID + " isRemoteBroker " + publisher.isRemoteBroker() + " isFromNeighbor? " + publisher.isInterbroker());
            }
            return;
        }
        ClientSecurityContext csc = publisher.getCSC();
        if (csc != null && csc.getUid() != null) {
            String uid = csc.getUid();
            if (uid != null && uid.indexOf("$") != -1) {
                uid = uid.replace('$', '.');
            }
            table.put("JMSXUserID", uid);
            m.getSidebandData().setProperties(table);
            if (this.DEBUG) {
                this.debug("<<JMSXID>> set JMSXUserID for subject : " + m.getSubject() + " uid = " + uid + " Previous ID = " + existingID + " isRemoteBroker " + publisher.isRemoteBroker() + " isFromNeighbor? " + publisher.isInterbroker());
            }
            if (m.getType() == 27) {
                Iterator it = m.getBatchHandle().getBatchIterator();
                while (it.hasNext()) {
                    IMgram subMgram = (IMgram)it.next();
                    subMgram.createSidebandDataIfNeeded();
                    table = subMgram.getSidebandData().getProperties();
                    table.put("JMSXUserID", uid);
                    subMgram.getSidebandData().setProperties(table);
                }
            }
        }
    }

    private ProcessBatchResult processBatch(IMgram batchMgram, boolean isBatchPersistent, LBSTrackingInfo groupSubscriptionList, boolean groupSubscriptionOnly, AMPScratchPad scratch) {
        ProcessBatchResult result = null;
        if (isBatchPersistent && !scratch.m_isBatchAtomic) {
            result = this.splitBatch(batchMgram, groupSubscriptionList, groupSubscriptionOnly, scratch);
        } else if (!isBatchPersistent && batchMgram.isGuarenteed() && scratch.m_publisher != null && !batchMgram.getBrokerHandle().isTransactionalPublish()) {
            scratch.m_publisher.sendAck(batchMgram);
        }
        return result;
    }

    private ProcessBatchResult splitBatch(IMgram batchMgram, LBSTrackingInfo groupSubscriptionList, boolean groupSubscriptionOnly, AMPScratchPad scratch) {
        IBatchHandle batchHandle = batchMgram.getBatchHandle();
        int size = batchHandle.getBatchSize();
        AgentGuarMsgTracker[] subMgramTrackers = new AgentGuarMsgTracker[size];
        ProcessBatchResult result = new ProcessBatchResult();
        long subLogSeqNo = -1L;
        boolean needsGuarAck = batchMgram.isGuarenteed() && scratch.m_publisher != null && !batchMgram.getBrokerHandle().isTransactionalPublish() && scratch.m_publisher.needsGuarAck();
        boolean needIBGuarAck = scratch.m_xonce && scratch.m_publisher != null && batchMgram.isGuarenteed() && InterbrokerHook.isSet() && scratch.m_publisher.isInterbroker();
        boolean needRBGuarAck = scratch.m_xonce && scratch.m_publisher != null && batchMgram.isGuarenteed() && scratch.m_publisher.isRemoteBroker();
        boolean deliverOnFlush = false;
        batchHandle.syncBatch();
        if (batchMgram.getBrokerHandle().isTransactionalPublish() && batchMgram.getBrokerHandle().isTxnPublishFromLog()) {
            long batchTracking = batchMgram.getGuarenteedTrackingNum();
            try {
                result.m_batchTracker = AgentGuarMsgTracker.getTracker(batchTracking);
            }
            catch (ETrackingNumNotFound e) {
                throw new EAssertFailure("Transacted message from log; can't find tracker " + batchTracking, e);
            }
            result.m_batchTracker.getEvent().setSplitBatch(true);
            BatchSplitEvt evt = new BatchSplitEvt(batchTracking, true);
            evt.setReplicateOnly(batchMgram.isNonPersistentReplicated());
            this.m_reg.getLogManager().addEvent(evt, false);
        } else {
            GuarMsgEvt evt = new GuarMsgEvt(batchMgram, null, null, null, null, scratch.m_publisher, false, deliverOnFlush, needIBGuarAck || needRBGuarAck || needsGuarAck, needIBGuarAck, needRBGuarAck, scratch.m_mp, scratch.m_pubLimiter, new AMPHandle(this), null, null, null);
            evt.setSplitBatch(true);
            evt.setLBSInfo(groupSubscriptionList, groupSubscriptionOnly);
            this.m_reg.getLogManager().addEvent(evt, true);
            evt.createTracker();
            result.m_batchTracker = evt.getTracker();
            batchMgram.setGuarenteed(result.m_batchTracker.getTracking());
        }
        Iterator iter = batchHandle.getBatchIterator();
        GuarMsgEvt subEvt = null;
        int subjectTrackingCount = 1;
        if (batchMgram.getSubject().isMultiSubject()) {
            subjectTrackingCount += batchMgram.getSubject().getMultiSubjectCount();
        }
        subLogSeqNo = result.m_batchTracker.getTracking() + (long)subjectTrackingCount;
        int ii = 0;
        while (iter.hasNext()) {
            IMgram subMgram = (IMgram)iter.next();
            subMgram.getBrokerHandle().setBatchedPublish(true);
            subEvt = new GuarMsgEvt(subMgram, null, null, null, null, scratch.m_publisher, false, deliverOnFlush, false, false, false, scratch.m_mp, scratch.m_pubLimiter, new AMPHandle(this), null, null, null);
            subEvt.setSeqNo(subLogSeqNo);
            subEvt.createTracker();
            subMgram.setGuarenteed(subEvt.getTracker().getTracking());
            subMgramTrackers[ii] = subEvt.getTracker();
            subMgramTrackers[ii].setSplitBatchMember();
            ++ii;
            subLogSeqNo += (long)subjectTrackingCount;
        }
        result.m_subMgramTrackers = subMgramTrackers;
        return result;
    }

    boolean checkTopicFlowControlForUndelivered(IMgram mgram, RecipientVector subscribers) {
        boolean flowControl = false;
        block5: for (int ii = 0; ii < subscribers.m_count && !flowControl; ++ii) {
            IClientContext cc;
            RecipientWrap rw = (RecipientWrap)subscribers.m_data[ii];
            if (rw == null || !rw.hasClientContext() || (cc = rw.getClient()) == null) continue;
            switch (cc.canBeSent(mgram, rw.m_label, null)) {
                case 5: {
                    flowControl = true;
                    continue block5;
                }
                case 1: 
                case 3: {
                    if (this.m_reg.getBrokerDatabase().hasRoomForMgram(mgram)) continue block5;
                    flowControl = true;
                    continue block5;
                }
                case 4: {
                    if (!this.m_reg.getBrokerDatabase().hasRoomForMgram(mgram)) {
                        flowControl = true;
                        continue block5;
                    }
                    if (FlowToDiskMemoryManager.getFlowToDiskMemoryManager().hasRoomForMgram(mgram)) continue block5;
                    flowControl = true;
                    continue block5;
                }
            }
        }
        return flowControl;
    }

    private boolean skipLocallyBlockedMessage(IMgram mgram, AMPScratchPad scratch, IAgentQueue target) {
        IFlowController flow = scratch.m_publisher.getFlowController();
        if (flow != null && flow.isDestinationLocalBlocked(mgram)) {
            if (mgram.isGuarenteed()) {
                if (mgram.isDiscardable()) {
                    scratch.m_publisher.sendAck(mgram);
                } else {
                    flow.nack(mgram, target);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean prepareToRedeliver(IMgram m, AMPScratchPad scratch, boolean lookupIfNoRecipient, boolean processPtpRecipients) {
        IClientContext cc;
        RecipientWrap rw;
        int i;
        if (this.DEBUG) {
            this.debug("processing recovered message to " + m.getSubject());
        }
        if (!this.checkExpiration(m)) {
            return false;
        }
        GuarMsgEvt evt = (GuarMsgEvt)m.getBrokerHandle().getLogEvent();
        FastVector guarRecips = evt.getGuarRecipients();
        FastVector ptpRecips = evt.getPtpRecipients();
        boolean noGuarRecips = false;
        if (guarRecips == null) {
            if (lookupIfNoRecipient) {
                this.lookUpSubscribers(m, scratch, null);
                if (this.DEBUG) {
                    this.debug("PrepareToRedeliver: Looked up subscribers");
                }
            } else {
                noGuarRecips = true;
            }
        } else if (guarRecips.m_data.length == 0) {
            if (this.DEBUG) {
                this.debug("message recovered from log has already been delivered to all xonce recipient(s)");
            }
            noGuarRecips = true;
        } else {
            if ((this.debugFlags & 0x800) != 0) {
                this.debug("using recipients in log record");
            }
            scratch.m_relClients.m_count = 0;
            scratch.m_guarClients.m_count = 0;
            scratch.m_xonce = true;
            for (i = 0; i < guarRecips.m_count; ++i) {
                if (guarRecips.m_data[i] == null || (rw = (RecipientWrap)guarRecips.m_data[i]) == null || !rw.hasClientContext()) continue;
                if (this.DEBUG) {
                    this.debug("found guar recipient: " + rw.getId());
                }
                if ((cc = rw.getClient()) == null) continue;
                scratch.m_guarClients.addElement(cc, rw.m_label);
            }
            if (scratch.m_guarClients.m_count == 0) {
                if (this.DEBUG) {
                    this.debug("no recipient found for recovered message, ignore it");
                }
                noGuarRecips = true;
            }
        }
        scratch.m_ptpClients.m_count = 0;
        if (processPtpRecipients) {
            for (i = 0; i < ptpRecips.m_count; ++i) {
                if (ptpRecips.m_data[i] == null || (rw = (RecipientWrap)ptpRecips.m_data[i]) == null || !rw.hasClientContext()) continue;
                if (this.DEBUG) {
                    this.debug("found ptp recipient: " + rw.getClient());
                }
                if ((cc = rw.getClient()) == null) continue;
                scratch.m_ptpClients.addElement(cc, rw.m_label);
            }
        }
        if (noGuarRecips && scratch.m_ptpClients.m_count == 0) {
            return false;
        }
        scratch.m_persist = true;
        scratch.m_publisher = null;
        if (evt.needGuarAck()) {
            try {
                scratch.m_publisher = this.m_reg.getClient(evt.getOrigSender());
            }
            catch (EClientNotRegistered ecnr) {
                evt.setGuarAck(false);
            }
        }
        return true;
    }

    void recoveredPostponedMgram(IMgram mgram, AMPScratchPad scratch) {
        if (!this.checkExpiration(mgram)) {
            return;
        }
        GuarMsgEvt evt = (GuarMsgEvt)mgram.getBrokerHandle().getLogEvent();
        try {
            scratch.m_publisher = this.m_reg.getClient(evt.getOrigSender());
        }
        catch (EClientNotRegistered ecnr) {
            scratch.m_publisher = null;
        }
        scratch.m_groupSubscriptionList = evt.getGroupSubscriptionList();
        scratch.m_groupSubscriptionOnly = evt.getGroupSubscriptionOnly();
        this.lookUpSubscribers(mgram, scratch, null);
        evt.createTracker();
        mgram.setGuarenteed(evt.getTracker().getTracking());
        this.deliver(mgram, scratch, false, true, null);
    }

    void recoveredMgram(IMgram m, AMPScratchPad scratch) {
        if (this.prepareToRedeliver(m, scratch, true, false)) {
            boolean guarAck;
            if (Config.ENABLE_QOPSECURITY && m.isSecure() && m.getSecurity() != 0) {
                m.getBrokerHandle().placeMessageKey(scratch.m_mp, scratch.m_tempMessageKeyBuffer);
            }
            GuarMsgEvt evt = (GuarMsgEvt)m.getBrokerHandle().getLogEvent();
            if (m.getType() == 27) {
                m.getBatchHandle().setAtomic(true);
                m.getBrokerHandle().setBatchedPublish(true);
            }
            boolean needsGuarAck = scratch.m_publisher != null && scratch.m_publisher.needsGuarAck() && !m.getBrokerHandle().isTransactionalPublish();
            boolean needIBGuarAck = InterbrokerHook.isSet() && InterbrokerHook.isNeighbor(evt.getOrigSender());
            boolean needRBGuarAck = this.m_reg.getRouterManager().isRemoteBroker(evt.getOrigSender());
            boolean bl = guarAck = needIBGuarAck || needRBGuarAck || needsGuarAck;
            if (this.DEBUG && guarAck) {
                this.debug("msg " + m.getGuarenteedTrackingNum() + " requires guar ack");
            }
            evt.setGuarAck(guarAck);
            evt.setIBGuarAck(needIBGuarAck);
            evt.setRBGuarAck(needRBGuarAck);
            evt.setAMPHandle(new AMPHandle(this));
            evt.setPubLimiter(scratch.m_pubLimiter);
            evt.setMessageProtection(scratch.m_mp);
            try {
                IXOnceHandle xoh;
                for (int i = 0; i < scratch.m_guarClients.m_count; ++i) {
                    ((RecipientWrap)scratch.m_guarClients.m_data[i]).getClient().notifyPubDispatch();
                }
                if ((this.debugFlags & 0x800) != 0) {
                    this.debug("Redelivering message; " + evt + " to " + scratch.m_guarClients.m_count + " guarclients");
                }
                if (needsGuarAck && (xoh = scratch.m_publisher.getXOnceHandle()) != null) {
                    xoh.addGuarUGA(evt.getOrigTracking());
                }
                evt.deliverMsg(scratch.m_guarClients);
            }
            catch (ESecurityGeneralException eSecurityGeneralException) {
                // empty catch block
            }
        }
        if (this.DEBUG) {
            this.debug("processing complete");
        }
    }

    private boolean checkBatchExpiration(IMgram batch) {
        long currTime = EpochClock.getTime();
        if (batch.isTTE() && batch.getTTE() <= currTime) {
            return false;
        }
        if (!batch.getBatchHandle().hasAnyTTE()) {
            return true;
        }
        Iterator iter = batch.getBatchHandle().getBatchIterator();
        while (iter.hasNext()) {
            IMgram m = (IMgram)iter.next();
            if (!m.isTTE() || m.getTTE() > currTime) continue;
            iter.remove();
        }
        return true;
    }

    private boolean checkExpiration(IMgram m) {
        if (m.getType() == 27) {
            return this.checkBatchExpiration(m);
        }
        return !m.isTTE() || m.getTTE() > EpochClock.getTime();
    }

    private boolean checkPublishPermission(IMgram m, AMPScratchPad scratch, DestinationInfo undelDestInfo) {
        String remoteNode;
        String string = remoteNode = m.forRemoteNode(Config.ROUTING_NODE_NAME) ? m.getRouting() : null;
        if (this.checkPublishPermission(m, scratch, true, m.getSubject(), remoteNode)) {
            if (undelDestInfo != null) {
                return this.checkPublishPermission(m, scratch, false, undelDestInfo.getISubject(), undelDestInfo.getRouting());
            }
            return true;
        }
        return false;
    }

    private boolean checkPublishPermission(IMgram m, AMPScratchPad scratch, boolean isMgramSubject, ISubject subject, String remoteNode) {
        if (subject == null || subject.isTemporary()) {
            return true;
        }
        if (scratch.m_publisher == null) {
            return true;
        }
        ClientSecurityContext csc = scratch.m_publisher.getCSC();
        if (csc == null) {
            throw new EAssertFailure("csc is null");
        }
        ISubject lookupSubject = null;
        RoutingSubjectResolver subjectResolver = new RoutingSubjectResolver(m, subject, remoteNode);
        try {
            lookupSubject = subjectResolver.resolve();
        }
        catch (RoutingSubjectResolver.ConflictingHttpOverrides e) {
            Object[] objs = new Object[]{-31, scratch.m_publisher.getUid(), scratch.m_publisher.getAppid(), AgentMessageProcessor.getJmsSubject(subject, remoteNode), Arrays.toString(e.getOverrides())};
            String message = prMessageFormat.format(prAccessor.getString("CONFLICTING_HTTP_OVERRIDE_DESTINATIONS"), objs);
            BrokerComponent.getComponentContext().logMessage(message, (Throwable)e, 2);
            if (m.isGuarenteed() || m.isRejectable()) {
                scratch.m_publisher.sendErrorAck(m, (short)-31, false);
            }
            return false;
        }
        boolean ok = Authorize.checkPermission(csc.getPrincipal(), lookupSubject, 1);
        if (ok && subjectResolver.getOverrideRNN() != null) {
            if (this.DEBUG) {
                System.out.println("DEBUG: after check permission, setting effective routing node " + subjectResolver.getOverrideRNN());
            }
            m.getRoutingHandle().setRouting(subjectResolver.getOverrideRNN());
        }
        if (!ok && isMgramSubject && subject.isMultiSubject() && scratch.m_publisher.isRemoteBroker()) {
            ISubject filtered = subject.protectedClone();
            Iterator<ISubject> subjects = filtered.getMultiSubjects();
            while (subjects.hasNext()) {
                Subject s;
                ISubject lookup = s = (Subject)subjects.next();
                if (remoteNode != null && !"".equals(remoteNode)) {
                    lookup = DraDestUtil.getRemoteSubject(s, remoteNode);
                }
                if (Authorize.checkPermission(csc.getPrincipal(), lookup, 1)) continue;
                subjects.remove();
                String username = AgentMessageProcessor.retrieveUsername(csc);
                String jmsSubject = AgentMessageProcessor.getJmsSubject(s, remoteNode);
                Object[] obj = new Object[]{username.replace('$', '.'), jmsSubject};
                String error = prMessageFormat.format(prAccessor.getString("DESTINATION_AUTH_FAILURE"), obj);
                BrokerComponent.getComponentContext().logMessage(error, 2);
            }
            if (filtered.getMultiSubjectCount() > 0) {
                if (filtered.getMultiSubjectCount() == 1) {
                    filtered = (Subject)filtered.getMultiSubjects().next();
                }
                m.setSubject(filtered, m.getSubjectFormat());
                ok = true;
            }
        }
        if (!ok && isMgramSubject && m.getType() == 13 && !(ok = Authorize.checkPermission(csc.getPrincipal(), subject, 2))) {
            ok = Authorize.checkPermission(csc.getPrincipal(), subject, 8);
        }
        if (ok && isMgramSubject && m.isRequest()) {
            ok = Authorize.checkPermission(csc.getPrincipal(), m.getReplySubject(), 1);
            ok = Authorize.checkPermission(csc.getPrincipal(), m.getReplySubject(), 2);
        }
        if (!ok) {
            String errorSubject = subjectResolver.getACLSubjectForDisplay();
            if (errorSubject == null) {
                errorSubject = AgentMessageProcessor.getJmsSubject(subject, remoteNode);
            }
            if (m.isGuarenteed() || m.isRejectable()) {
                short errorcode = subjectResolver.getNotAuthorizedErrorCode();
                if (!isMgramSubject) {
                    errorcode = -26;
                }
                if (scratch.m_publisher != null) {
                    if (m.isPTP() && InterbrokerHook.isSet() && scratch.m_publisher.isInterbroker() || scratch.m_publisher.isRemoteBroker() && m.getRouting() != null) {
                        scratch.m_publisher.sendErrorAck(m, errorcode, true);
                        if (this.DEBUG) {
                            this.debug("Acknowledging publish permission failure from RemoteBroker: origTracking=" + m.getGuarenteedTrackingNum() + " Sender: " + scratch.m_publisher.getId());
                        }
                    } else {
                        scratch.m_publisher.sendErrorAck(m, errorcode, false);
                    }
                }
            }
            String username = AgentMessageProcessor.retrieveUsername(csc);
            Object[] obj = new Object[]{username.replace('$', '.'), errorSubject};
            String error = prMessageFormat.format(prAccessor.getString("DESTINATION_AUTH_FAILURE"), obj);
            BrokerComponent.getComponentContext().logMessage(error, 2);
            return false;
        }
        return true;
    }

    private static String retrieveUsername(ClientSecurityContext csc) {
        String username = null;
        try {
            username = csc.getPrincipal().getName();
        }
        catch (NullPointerException npe) {
            username = "<undefined>";
        }
        return username;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lookup(IMgram m, AMPScratchPad scratch) {
        BrokerSearchResults bsr = scratch.m_bsr;
        bsr.reset();
        boolean groupSubscriptionOnly = scratch.m_groupSubscriptionOnly;
        LBSTrackingInfo groupSubscriptionList = scratch.m_groupSubscriptionList;
        ArrayList<BrokerSearchResults.SubjectSubscriptionMatches> matches = null;
        AgentMessageProcessor agentMessageProcessor = this;
        synchronized (agentMessageProcessor) {
            scratch.m_dispatchId = this.m_dispatchId++;
        }
        ISubject subject = m.getSubject();
        if (groupSubscriptionOnly) {
            if (this.DEBUG) {
                this.debug("group subscriptions only - look up subscriber(s)");
            }
            GroupSubscriptions.GSLookupResult result = this.m_reg.getGroupSubscriptions().lookUpSubscribers(groupSubscriptionList, !m.isNonPersistentReplicated());
            matches = new ArrayList<BrokerSearchResults.SubjectSubscriptionMatches>(1);
            matches.add(bsr.createSubjectSubscriptionMatches(subject, result.m_matches));
            if (!subject.isMultiSubject()) {
                scratch.m_isBatchable = result.m_isBatchable;
                scratch.m_isBatchAtomic = scratch.m_isBatchable && !Config.LG_ENABLE ? result.m_isBatchAtomic : false;
            } else {
                scratch.m_isBatchable = false;
                scratch.m_isBatchAtomic = false;
            }
        } else {
            this.m_reg.subscribers(subject, bsr);
            BrokerSearchResults.SubscriptionsResult result = bsr.getSubscriptions();
            matches = result.m_subjectMatches;
            if (m.getType() == 27) {
                scratch.m_isBatchable = result.isBatchable();
                scratch.m_isBatchAtomic = scratch.m_isBatchable && !subject.isMultiSubject() && !Config.LG_ENABLE ? result.isBatchAtomic(m.isNonPersistentReplicated()) : false;
            } else {
                scratch.m_isBatchable = false;
                scratch.m_isBatchAtomic = false;
            }
        }
        scratch.m_matches = matches;
    }

    void lookUpSubscribers(IMgram m, AMPScratchPad scratch, HashSet targetClients) {
        this.lookup(m, scratch);
        this.processSubscribers(m, scratch, targetClients, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSubscribers(IMgram m, AMPScratchPad scratch, HashSet targetClients, boolean trackClients) {
        if (!Config.ENABLE_INTERBROKER) {
            this.processSubscribersInternal(m, scratch, targetClients, trackClients);
        } else {
            try {
                this.startPubDispatch();
                this.processSubscribersInternal(m, scratch, targetClients, trackClients);
            }
            finally {
                this.finishPubDispatch();
            }
        }
    }

    private void processSubscribersInternal(IMgram m, AMPScratchPad scratch, HashSet targetClients, boolean trackClients) {
        int hops;
        RecipientVector guarClients = scratch.m_guarClients;
        RecipientVector relClients = scratch.m_relClients;
        RecipientVector ptpClients = scratch.m_ptpClients;
        IClientContext publisher = scratch.m_publisher;
        boolean groupSubscriptionOnly = scratch.m_groupSubscriptionOnly;
        LBSTrackingInfo groupSubscriptionList = scratch.m_groupSubscriptionList;
        scratch.m_groupSubscriptionOnly = false;
        scratch.m_groupSubscriptionList = null;
        scratch.m_proxyRecipsTable = null;
        scratch.m_groupSubscriptionsByNeighbor = null;
        scratch.m_xonce = false;
        scratch.m_persist = false;
        ISubject fullSubject = m.getSubject();
        ArrayList subjectMatches = scratch.m_matches;
        FastVector matchClients = new FastVector(scratch.m_bsr.m_subCount);
        long dispatchId = scratch.m_dispatchId;
        boolean isAdminSubject = SessionConfig.isSystemSubject(fullSubject);
        int n = hops = publisher != null && !publisher.isInterbroker() ? 1 : -1;
        if (!isAdminSubject && this.DEBUG) {
            this.debug("Found " + scratch.m_bsr.m_subCount + " matches for subject " + fullSubject);
        }
        HashMap<GroupSubscription, BrokerSubscription> groupSubSelections = null;
        for (int sm = 0; sm < subjectMatches.size(); ++sm) {
            BrokerSearchResults.SubjectSubscriptionMatches subjectMatch = (BrokerSearchResults.SubjectSubscriptionMatches)subjectMatches.get(sm);
            ISubject matchSubject = subjectMatch.getSubject();
            FastVector matches = subjectMatch.getMatches();
            if (this.DEBUG) {
                System.out.println("Processing " + matches.m_count + " subscribers for " + matchSubject);
            }
            for (int i = 0; i < matches.m_count; ++i) {
                ISubjectMatchObject match = (ISubjectMatchObject)matches.m_data[i];
                BrokerSubscription bs = null;
                IClientContext client = null;
                if (groupSubscriptionOnly && match instanceof BrokerSubscription) {
                    if (!this.DEBUG) continue;
                    this.debug("unexpected broker subscription while a group subscription was expected.");
                    continue;
                }
                boolean selectorCheckAlreadyDoneForCWADSProxy = false;
                if (match instanceof GroupSubscription) {
                    GroupSubscription gsMatch = (GroupSubscription)match;
                    GroupSubscriptionClientContext groupcc = gsMatch.getGroupCC();
                    if (groupcc == null) continue;
                    boolean targeted = false;
                    if (targetClients != null) {
                        bs = gsMatch.getOneSubscription(targetClients);
                        if (groupcc.hasRecoveredInDoubtMembers()) {
                            bs = null;
                        }
                        if (bs != null && bs.hasSelector() && bs.getSelectorAtBroker() && !bs.isMessageForSubscription(m)) {
                            bs = null;
                        }
                        if (bs == null) continue;
                        targeted = true;
                    }
                    if (groupSubSelections == null) {
                        groupSubSelections = new HashMap<GroupSubscription, BrokerSubscription>();
                    }
                    if (groupSubSelections.containsKey(gsMatch)) {
                        bs = (BrokerSubscription)groupSubSelections.get(gsMatch);
                        if (bs == null && gsMatch.needsPersistence(m)) {
                            client = groupcc;
                        }
                    } else {
                        IClientContext activecc;
                        IClientContext cc;
                        boolean remote;
                        if (!targeted) {
                            if (publisher != null && publisher.isInterbroker()) {
                                if (!gsMatch.okToSend(groupSubscriptionList)) continue;
                                if (this.DEBUG) {
                                    this.debug("ok to send, group = " + gsMatch.getSubject());
                                }
                                bs = gsMatch.selectBrokerSubscription(m, groupSubscriptionList, null);
                            } else {
                                bs = gsMatch.selectBrokerSubscription(m, null, null);
                            }
                            if (groupcc.hasRecoveredInDoubtMembers()) {
                                bs = null;
                            }
                        }
                        if (bs != null) {
                            if (publisher != null && publisher.isInterbroker()) {
                                remote = false;
                                cc = bs.getClient();
                                if (cc.isInterbroker()) {
                                    remote = true;
                                } else {
                                    activecc = cc.getCWADSActiveBroker();
                                    if (activecc != null && activecc.isInterbroker()) {
                                        remote = true;
                                        cc = activecc;
                                    }
                                }
                                if (remote && (GroupSubscriptionClientContext.s_limitClusterHops || cc.getId() == publisher.getId())) {
                                    bs = null;
                                }
                            }
                            if (bs != null) {
                                groupSubSelections.put(gsMatch, bs);
                            }
                        }
                        if (bs != null) {
                            remote = false;
                            cc = bs.getClient();
                            if (cc.isInterbroker()) {
                                remote = true;
                            } else {
                                activecc = cc.getCWADSActiveBroker();
                                if (activecc != null && activecc.isInterbroker()) {
                                    remote = true;
                                    cc = activecc;
                                }
                            }
                            if (remote) {
                                String groupSub = gsMatch.getGroupName();
                                LBSTrackingInfo groups = null;
                                if (scratch.m_groupSubscriptionsByNeighbor == null) {
                                    scratch.m_groupSubscriptionsByNeighbor = new LongHashTable();
                                } else {
                                    groups = (LBSTrackingInfo)scratch.m_groupSubscriptionsByNeighbor.get(cc.getId());
                                }
                                if (groups != null) {
                                    if (this.DEBUG) {
                                        this.debug("adding group subscription " + groupSub + " for neighbor " + cc.getId());
                                    }
                                    groups.addTargetGroup(groupSub);
                                } else {
                                    groups = new LBSTrackingInfo();
                                    if (hops == 1 || groupSubscriptionList == null) {
                                        groups.addTransitHistory(this.m_reg.getId());
                                    } else {
                                        groups.copyTransitHistory(groupSubscriptionList.getTransitHistory());
                                        groups.addTransitHistory(this.m_reg.getId());
                                    }
                                    if (this.DEBUG) {
                                        this.debug("Added LBS transit history: " + groups);
                                    }
                                    groups.addTargetGroup(groupSub);
                                    scratch.m_groupSubscriptionsByNeighbor.put(cc.getId(), groups);
                                }
                                client = cc;
                            } else {
                                client = bs.getClient();
                            }
                        } else {
                            if (!gsMatch.checkGroupInterestInMgram(m)) continue;
                            if (gsMatch.needsPersistence(m) && m.isGuarenteed()) {
                                try {
                                    FastVector guarRecips;
                                    AgentGuarMsgTracker tracker = AgentGuarMsgTracker.getTracker(m.getGuarenteedTrackingNum());
                                    if (tracker != null && (guarRecips = tracker.getEvent().getGuarRecipients()) != null) {
                                        long groupid = groupcc.getId();
                                        for (int idx = 0; idx < guarRecips.m_data.length; ++idx) {
                                            RecipientWrap rw = (RecipientWrap)guarRecips.m_data[idx];
                                            if (rw == null || rw.getGroupCCId() != groupid) continue;
                                            if (this.DEBUG) {
                                                this.debug("Replacing " + rw.getClient() + " with group");
                                            }
                                            rw.setClientContext(groupcc);
                                        }
                                    }
                                }
                                catch (ETrackingNumNotFound eTrackingNumNotFound) {
                                    // empty catch block
                                }
                            }
                            client = groupcc;
                            groupSubSelections.put(gsMatch, null);
                        }
                    }
                    if (client == null && bs != null) {
                        client = bs.getClient();
                    }
                } else {
                    IClientContext activeBrokerCC;
                    bs = (BrokerSubscription)matches.m_data[i];
                    if (bs != null) {
                        client = bs.getClient();
                    }
                    if (InterbrokerHook.isSet() && client != null && client.getProxyingHandle() != null && client.getProxyingHandle().redirectToProxy() && (activeBrokerCC = client.getCWADSActiveBroker()) != null && activeBrokerCC.isInterbroker() && client.getState() == 8 && activeBrokerCC.getState() == 8 && (!bs.hasSelectors() || !bs.getSelectorAtBroker() || bs.isMessageForSubscription(m))) {
                        selectorCheckAlreadyDoneForCWADSProxy = true;
                        if (this.DEBUG) {
                            System.out.println("CWADS_DEBUG: lookupSubscribers rerouting message to cwads active broker\n old client = " + client + "\n new client = " + activeBrokerCC);
                        }
                        if (!client.preparedToSend(dispatchId) && !InterbrokerHook.isNeighbor(m.getBrokerHandle().getSenderID())) {
                            FastVector proxied = null;
                            if (scratch.m_proxyRecipsTable == null) {
                                scratch.m_proxyRecipsTable = new LongHashTable();
                            } else {
                                proxied = (FastVector)scratch.m_proxyRecipsTable.get(activeBrokerCC.getId());
                            }
                            if (proxied == null) {
                                proxied = new FastVector();
                                scratch.m_proxyRecipsTable.put(activeBrokerCC.getId(), proxied);
                            }
                            if (proxied.indexOf(client, 0) == -1) {
                                proxied.addElement(client);
                            }
                            client = activeBrokerCC;
                        }
                    }
                    if (targetClients != null && client != null && !targetClients.contains(new Long(client.getId()))) continue;
                }
                if (client == null) continue;
                if (this.DEBUG) {
                    this.debug("matched client " + AgentRegistrar.getAgentRegistrar().getClientFullName(client.getId()));
                }
                if (!isAdminSubject && this.DEBUG) {
                    this.debug("client isRemoteNode? " + client.isRemoteNode() + " appid: " + client.getAppid());
                }
                if (!(!isAdminSubject || bs != null && (SessionConfig.isSystemSubject(bs.getSubject()) || matchSubject.isTemporary() && bs.getSubject().hasTemporary() && bs.getSubject().hasIntersect(matchSubject)))) {
                    if (!this.DEBUG) continue;
                    this.debug("dropping system message for " + client.getId());
                    continue;
                }
                if (client.isRemoteNode()) {
                    if (matchSubject.isSonicMQSubject()) continue;
                    boolean isGSAPublication = false;
                    IRoutingHandle rh = m.getRoutingHandle();
                    if (rh.isGSAPublication()) {
                        isGSAPublication = true;
                    }
                    if (publisher != null && (InterbrokerHook.isSet() && publisher.isInterbroker() || (!publisher.isRemoteBroker() ? publisher.getClientSessionVer() < 25 : isGSAPublication && !this.m_reg.getGSManager().isForwardingEnabled()))) continue;
                    if (isGSAPublication && rh.isNodeInPath(client.getTargetNodeName())) {
                        if (!this.DEBUG) continue;
                        this.debug("LOOP ROUTING detected, stop routing to " + client.getTargetNodeName());
                        continue;
                    }
                }
                if (!isAdminSubject && !selectorCheckAlreadyDoneForCWADSProxy && !(match instanceof GroupSubscription) && bs != null && bs.hasSelectors() && bs.getSelectorAtBroker() && !bs.isMessageForSubscription(m)) continue;
                this.m_reg.getGSManager().onSubjectMatch(bs, m);
                Label matchLabel = null;
                if (bs == null && client.isGroupSubscription()) {
                    matchLabel = ((GroupSubscriptionClientContext)client).getGroupDeliveryLabel();
                } else if (bs == null && client.isGroupSubscriptionMember()) {
                    matchLabel = client.getGroupSubscriptionCC().getGroupDeliveryLabel();
                } else {
                    if (bs == null) {
                        throw new EAssertFailure("bs cannot be null when client is not a group subscription");
                    }
                    matchLabel = bs.getMsgDeliveryLabel(m);
                }
                if (!client.prepareToSend(m, matchLabel, targetClients != null, dispatchId, matchSubject)) {
                    if (!this.DEBUG) continue;
                    this.debug("removing duplicate subscription for " + client.getId());
                    continue;
                }
                matchClients.addElement(client);
            }
        }
        relClients.m_count = 0;
        guarClients.m_count = 0;
        ptpClients.m_count = 0;
        if (fullSubject.isMultiSubject()) {
            m.setSubject(m.getSubject(), 4);
        }
        for (int i = 0; i < matchClients.m_count; ++i) {
            IClientContext cc = (IClientContext)matchClients.m_data[i];
            if (cc == null) continue;
            BaseClientContext.MergeScratchPad msp = cc.getMergeScratchPad(dispatchId);
            Label lab = msp.m_deliveryLabel;
            if (msp.m_subjectFilter != null) {
                if (msp.m_subjectFilter.size() == 0) continue;
                SubjectFilter sf = new SubjectFilter(msp.m_subjectFilter);
                m.getBrokerHandle().addSubjectFilter(cc.getSubjectFilterId(), sf);
            }
            cc.notifyPubDispatch();
            if (this.DEBUG && !m.getSubject().isSystem() && !BrokerComponent.isManagementSubject(m.getSubject().getSubjectString())) {
                System.out.println("Match for message to " + m.getSubject() + " -- " + cc.getUid() + "/" + cc.getAppid());
            }
            LBSTrackingInfo groups = null;
            if (cc.isInterbroker() && scratch.m_groupSubscriptionsByNeighbor != null) {
                groups = (LBSTrackingInfo)scratch.m_groupSubscriptionsByNeighbor.get(cc.getId());
                if (this.DEBUG) {
                    this.debug("adding group subscription info " + groups + " to recipient wrapper for neighbor " + cc);
                }
            }
            if (cc.isRemoteNode()) {
                ptpClients.addElement(cc, lab);
                scratch.m_xonce = true;
                if (m.isJMSPersistent()) {
                    scratch.m_persist = true;
                }
            } else if (m.isDiscardable()) {
                relClients.addElement(cc, lab, groups);
            } else if (lab.isGuaranteed() && isAdminSubject) {
                guarClients.addElement(cc, lab, groups);
                scratch.m_persist = true;
            } else if (lab.isPersistent() || m.isNonPersistentReplicated() && (cc.isXOnce() && cc.getClientSessionVer() >= 28 || lab.isGuaranteed() && !isAdminSubject)) {
                guarClients.addElement(cc, lab, groups);
                scratch.m_xonce = true;
                if (m.isJMSPersistent() && (!m.isNonPersistentReplicated() || Config.REPLICATED)) {
                    scratch.m_persist = true;
                }
            } else {
                relClients.addElement(cc, lab, groups);
            }
            if (!trackClients) continue;
            scratch.m_clients.put(cc, cc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockPubDispatch() {
        boolean interrupted = false;
        Object object = this.m_pubDispatchLock;
        synchronized (object) {
            ++this.m_dispatchLockCount;
            while (this.m_pendingDispatchCount > 0) {
                interrupted = this.tryPubDispatchLockWait(interrupted);
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockPubDispatch() {
        Object object = this.m_pubDispatchLock;
        synchronized (object) {
            --this.m_dispatchLockCount;
            if (this.m_dispatchLockCount < 0) {
                this.m_dispatchLockCount = 0;
                EAssertFailure t = new EAssertFailure(this + ": ERROR negative dispatchLockCount!");
                BrokerComponent.getComponentContext().logMessage((Throwable)t, 1);
            }
            if (this.m_dispatchLockCount == 0) {
                this.m_pubDispatchLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void startPubDispatch() {
        boolean interrupted = false;
        Object object = this.m_pubDispatchLock;
        synchronized (object) {
            while (this.m_dispatchLockCount > 0) {
                interrupted = this.tryPubDispatchLockWait(interrupted);
            }
            ++this.m_pendingDispatchCount;
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    private boolean tryPubDispatchLockWait(boolean interruptedParam) {
        boolean interrupted = interruptedParam;
        try {
            this.m_pubDispatchLock.wait();
        }
        catch (InterruptedException ie) {
            interrupted = true;
        }
        return interrupted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void finishPubDispatch() {
        Object object = this.m_pubDispatchLock;
        synchronized (object) {
            --this.m_pendingDispatchCount;
            if (this.m_pendingDispatchCount < 0) {
                throw new EAssertFailure(this + ": ERROR negative pendingDispatchCount!");
            }
            if (this.m_pendingDispatchCount == 0) {
                this.m_pubDispatchLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDeliveryInfo(AgentGuarMsgTracker tracker, RecipientVector guarClients, RecipientVector ptpClients, long[] ptpTrackingNums, boolean xonce, LongHashTable proxyRecipsTable, PublishLimiter pubLimiter, IMessageProtection mp, boolean cloneProxyRecipsTable, LongHashTable subjectFilters, LongHashTable proxyLBSRecipsTable) {
        AgentGuarMsgTracker agentGuarMsgTracker = tracker;
        synchronized (agentGuarMsgTracker) {
            GuarMsgEvt guarEvt = tracker.getEvent();
            tracker.setHasDeliveryListEvt();
            GuarMsgEvt guarMsgEvt = guarEvt;
            synchronized (guarMsgEvt) {
                guarEvt.setDeliveryInfo(guarClients, ptpClients, ptpTrackingNums, xonce, proxyRecipsTable, cloneProxyRecipsTable, subjectFilters, proxyLBSRecipsTable);
                if (guarEvt.isTransacted()) {
                    guarEvt.setNonTransacted();
                }
                guarEvt.setAMPHandle(new AMPHandle(this));
                guarEvt.setPubLimiter(pubLimiter);
                guarEvt.setMessageProtection(mp);
            }
        }
    }

    private void deliver(IMgram rcvdMgram, AMPScratchPad scratch, boolean sendAck, boolean guarMsgEvtAlreadyLogged, AgentGuarMsgTracker[] subMgramTrackers) {
        RecipientVector guarClients = scratch.m_guarClients;
        RecipientVector relClients = scratch.m_relClients;
        RecipientVector ptpClients = scratch.m_ptpClients;
        PublishLimiter pubLimiter = scratch.m_pubLimiter;
        IClientContext publisher = scratch.m_publisher;
        boolean xonce = scratch.m_xonce;
        boolean persist = scratch.m_persist;
        IMessageProtection mp = scratch.m_mp;
        try {
            boolean needsGuarAck;
            boolean processMultipleTrackers;
            AgentGuarMsgTracker tracker = null;
            if (subMgramTrackers != null && rcvdMgram.getType() != 27) {
                throw new EAssertFailure("Multiple trackers can only be associated with mgrams of BATCH type");
            }
            boolean bl = processMultipleTrackers = subMgramTrackers != null;
            if (guarMsgEvtAlreadyLogged && !scratch.m_dmqOverride && !scratch.m_ddqOverride) {
                long trkno = rcvdMgram.getGuarenteedTrackingNum();
                try {
                    tracker = AgentGuarMsgTracker.getTracker(trkno);
                }
                catch (ETrackingNumNotFound e) {
                    throw new EAssertFailure("Transacted message from log; can't find tracker " + trkno, e);
                }
                if (tracker == null) {
                    throw new EAssertFailure("No tracker for TxnPublish from log; subj= " + rcvdMgram.getSubject());
                }
                if (!persist && tracker != null) {
                    tracker.canceled();
                    AgentMessageProcessor.cancelSubMgramTrackers(processMultipleTrackers, subMgramTrackers);
                    if ((this.debugFlags & 0x800) != 0) {
                        this.debug("newMgram: log-based transactedpublish; persist=false; message removed from log; tid= " + rcvdMgram.getBrokerHandle().getTxnPublishTid() + " trk= " + tracker.getTracking());
                    }
                    tracker = null;
                }
            }
            IMgram ptpMgram = null;
            if (ptpClients.m_count > 0) {
                ptpMgram = (IMgram)rcvdMgram.protectedClone();
            }
            this.placeMessageKey(rcvdMgram, mp, scratch);
            IMgram guarMgram = null;
            IMgram relMgram = null;
            if (rcvdMgram.isGuarenteed()) {
                if (relClients.m_count > 0) {
                    relMgram = (IMgram)rcvdMgram.protectedClone();
                    relMgram.setReliable();
                    if (relMgram.getType() == 27) {
                        Iterator iter = relMgram.getBatchHandle().getBatchIterator();
                        while (iter.hasNext()) {
                            ((IMgram)iter.next()).setReliable();
                        }
                        relMgram.getBatchHandle().syncBatch();
                    }
                    this.handleMessageProtection(relMgram, mp);
                    relMgram.sync();
                }
                guarMgram = rcvdMgram;
            } else {
                if (guarClients.m_count > 0) {
                    guarMgram = (IMgram)rcvdMgram.protectedClone();
                }
                if (relClients.m_count > 0) {
                    relMgram = rcvdMgram;
                    if (relMgram.getType() == 27) {
                        relMgram.getBatchHandle().syncBatch();
                    }
                    this.handleMessageProtection(relMgram, mp);
                    relMgram.sync();
                }
            }
            boolean bl2 = needsGuarAck = rcvdMgram.isGuarenteed() && publisher != null && publisher.needsGuarAck() && !rcvdMgram.getBrokerHandle().isTransactionalPublish();
            if (guarClients.m_count == 0 && ptpClients.m_count == 0) {
                if (rcvdMgram.isGuarenteed() || rcvdMgram.isRejectable()) {
                    if (relClients.m_count == 0 && rcvdMgram.isRequest()) {
                        if (publisher != null && (sendAck || rcvdMgram.isRejectable())) {
                            if (this.DEBUG) {
                                this.debug("No subscribers for subject " + rcvdMgram.getSubject());
                            }
                            publisher.sendErrorAck(rcvdMgram, (short)-14, false);
                        }
                        if (tracker != null && rcvdMgram.isGuarenteed()) {
                            tracker.canceled();
                            AgentMessageProcessor.cancelSubMgramTrackers(processMultipleTrackers, subMgramTrackers);
                            if ((this.debugFlags & 0x800) != 0) {
                                this.debug("newMgram: log-based transactedpublish; No subscribers for subject " + rcvdMgram.getSubject() + " tid= " + rcvdMgram.getBrokerHandle().getTxnPublishTid() + " tracker = " + tracker.getTracking());
                            }
                            tracker = null;
                        }
                        return;
                    }
                    if (publisher != null && sendAck && rcvdMgram.isGuarenteed()) {
                        publisher.sendAck(rcvdMgram.getGuarenteedTrackingNum(), rcvdMgram, rcvdMgram.getBrokerHandle().getRedirectAckTarget());
                    }
                    if (rcvdMgram.isSuccessor() && !scratch.m_gsRedeliveryOk) {
                        if (this.DEBUG) {
                            this.debug("discarding duplicate message");
                        }
                        scratch.undoPubDispatch();
                        return;
                    }
                }
                if (relClients.m_count > 0) {
                    this.checkScratchOverrides(rcvdMgram, scratch);
                    this.sendSecuredToClients(relClients, relMgram, pubLimiter, scratch.m_groupSubscriptionsByNeighbor);
                }
            } else {
                long[] ptpTrackingNums = null;
                if (ptpClients.m_count > 0) {
                    long origTracking = 0L;
                    if (!ptpMgram.isDiscardable()) {
                        boolean needTracking = rcvdMgram.isGuarenteed();
                        if (needTracking) {
                            origTracking = tracker != null ? tracker.getOrigTracking() : rcvdMgram.getGuarenteedTrackingNum();
                        }
                        if (this.DEBUG) {
                            this.debug("Reserving queue space for " + ptpClients.m_count + " queue recipients");
                        }
                        this.preparePtpMgram(ptpMgram, (RecipientWrap)ptpClients.m_data[0], origTracking, needTracking, false);
                        if (!scratch.m_dmqOverride && !this.m_qproc.reserveQSpace(ptpMgram, publisher, ptpClients)) {
                            if (this.DEBUG) {
                                this.debug("Not sufficient queue space");
                            }
                            scratch.undoPubDispatch();
                            return;
                        }
                        ptpTrackingNums = new long[ptpClients.m_count];
                        for (int ii = 0; ii < ptpTrackingNums.length; ++ii) {
                            ptpTrackingNums[ii] = this.m_reg.getLogManager().allocSeqNo() & 0xFFFFFFFFFFFFL;
                        }
                    }
                }
                if (persist) {
                    boolean deliverNow;
                    boolean needIBGuarAck = xonce && scratch.m_publisher != null && rcvdMgram.isGuarenteed() && InterbrokerHook.isSet() && scratch.m_publisher.isInterbroker();
                    boolean needRBGuarAck = xonce && scratch.m_publisher != null && rcvdMgram.isGuarenteed() && scratch.m_publisher.isRemoteBroker();
                    boolean isFTPublisher = rcvdMgram.isGuarenteed() && publisher != null && publisher.needsGuarAck();
                    boolean hasGuarSubs = guarClients != null && guarClients.m_count > 0;
                    boolean isBrokerPublisher = needIBGuarAck || needRBGuarAck;
                    boolean hasAnyFTSubs = false;
                    if (isBrokerPublisher && hasGuarSubs) {
                        for (int i = 0; i < guarClients.m_count; ++i) {
                            IClientContext recipient;
                            RecipientWrap rw = (RecipientWrap)guarClients.m_data[i];
                            IClientContext iClientContext = recipient = rw != null ? rw.getClient() : null;
                            if (recipient == null || !recipient.isXOnce()) continue;
                            hasAnyFTSubs = true;
                            break;
                        }
                    }
                    boolean deliverOnFlush = scratch.m_forceDeliverOnFlush || Config.REPLICATED && hasGuarSubs;
                    deliverOnFlush = deliverOnFlush || Config.XONCE_RECOVERY && hasGuarSubs && (isFTPublisher || isBrokerPublisher && hasAnyFTSubs);
                    deliverOnFlush = this.isDeliverOnFlush(rcvdMgram, deliverOnFlush);
                    boolean bl3 = deliverNow = !deliverOnFlush;
                    if (guarMsgEvtAlreadyLogged && !scratch.m_dmqOverride && !scratch.m_ddqOverride) {
                        DeliveryListEvt delivEvt = new DeliveryListEvt(tracker.getEvent(), tracker.getTracking(), xonce ? guarClients : null, ptpClients, ptpTrackingNums, deliverOnFlush, scratch.m_proxyRecipsTable, rcvdMgram.getBrokerHandle().getSubjectFilters(), scratch.m_groupSubscriptionsByNeighbor);
                        this.setDeliveryInfo(tracker, guarClients, ptpClients, ptpTrackingNums, xonce, scratch.m_proxyRecipsTable, scratch.m_pubLimiter, scratch.m_mp, false, delivEvt.getSubjectFilters(), scratch.m_groupSubscriptionsByNeighbor);
                        if (processMultipleTrackers) {
                            for (int ii = 0; ii < subMgramTrackers.length; ++ii) {
                                if (subMgramTrackers[ii].getEvent().getMessage().isJMSPersistent()) {
                                    this.setDeliveryInfo(subMgramTrackers[ii], guarClients, ptpClients, ptpTrackingNums, xonce, scratch.m_proxyRecipsTable, scratch.m_pubLimiter, scratch.m_mp, true, delivEvt.getSubjectFilters(), scratch.m_groupSubscriptionsByNeighbor);
                                    continue;
                                }
                                subMgramTrackers[ii].canceled();
                            }
                        }
                        this.m_reg.getLogManager().addEvent(delivEvt, deliverOnFlush || !rcvdMgram.getBrokerHandle().isTransactionalPublish());
                        if ((this.debugFlags & 0x800) != 0 && rcvdMgram.getBrokerHandle().isTransactionalPublish()) {
                            this.debug("newMgram: created DeliveryListEvt tid= " + rcvdMgram.getBrokerHandle().getTxnPublishTid() + " trk = " + tracker.getTracking() + " xonce= " + xonce + " numguarClients= " + guarClients.m_count + " numptpClients= " + ptpClients.m_count + " subj= " + rcvdMgram.getSubject());
                        }
                        if (deliverNow) {
                            delivEvt.deliverMsg();
                        }
                    } else {
                        GuarMsgEvt evt = null;
                        evt = new GuarMsgEvt(guarMgram, relMgram, guarClients, ptpClients, ptpTrackingNums, publisher, xonce, deliverOnFlush, needIBGuarAck || needRBGuarAck || needsGuarAck, needIBGuarAck, needRBGuarAck, mp, pubLimiter, new AMPHandle(this), scratch.m_proxyRecipsTable, rcvdMgram.getBrokerHandle().getSubjectFilters(), scratch.m_groupSubscriptionsByNeighbor);
                        if (!scratch.m_dmqOverride && !scratch.m_ddqOverride) {
                            IClientContext cc;
                            RecipientWrap single;
                            if (Config.LOG_FLUSH_DELAY > 0 && guarClients.m_count == 1 && ptpClients.m_count == 0 && (single = (RecipientWrap)guarClients.m_data[0]) != null && (cc = single.getClient()) != null && cc.getPendingGuarCount() <= 0 && cc.isStarted() && !deliverOnFlush) {
                                evt.setCanBeDelayed(true);
                            }
                            this.m_reg.getLogManager().addEvent(evt, deliverOnFlush || !rcvdMgram.getBrokerHandle().isTransactionalPublish());
                        } else {
                            guarMgram.sync();
                            this.m_reg.getQMsgStateMgr().moveMsgToTopic(rcvdMgram, evt, true, true);
                        }
                        evt.createTracker();
                        tracker = evt.getTracker();
                        if (deliverNow && !scratch.m_dmqOverride && !scratch.m_ddqOverride) {
                            evt.deliverMsg();
                        }
                    }
                    if (guarClients.m_count > 0 && relClients.m_count > 0) {
                        if (relMgram.getType() != 27) {
                            this.setDBTrackingInRelMgram(relMgram, tracker.getEvent().getSeqNo());
                        } else {
                            this.setDBTrackingInRelMgram(relMgram, tracker.getEvent().getSeqNo() + 1L);
                        }
                    }
                } else {
                    if (publisher != null && rcvdMgram.isGuarenteed() && sendAck) {
                        publisher.sendAck(rcvdMgram);
                    }
                    this.checkScratchOverrides(rcvdMgram, scratch);
                    if (scratch.m_proxyRecipsTable != null && guarMgram != null) {
                        guarMgram.getBrokerHandle().setProxyRecipsTable(scratch.m_proxyRecipsTable);
                    }
                    if (guarClients.m_count > 0) {
                        long firstLogSeqNo;
                        int subjectTrackingCount = 1;
                        ISubject subject = guarMgram.getSubject();
                        if (subject.isMultiSubject()) {
                            subjectTrackingCount += guarMgram.getSubject().getMultiSubjectCount();
                        }
                        long logSeqNo = -1L;
                        if (guarMgram.getType() == 27) {
                            int batchSize = guarMgram.getBatchHandle().getBatchSize();
                            logSeqNo = guarMgram.getBatchHandle().isAtomic() ? this.m_reg.getLogManager().allocMultipleSeqNos((batchSize + 1) * subjectTrackingCount) : this.m_reg.getLogManager().allocMultipleSeqNos(batchSize * subjectTrackingCount);
                            guarMgram.getBatchHandle().syncBatch();
                            LongHashTable proxyTable = null;
                            if (guarMgram.getBatchHandle().isAtomic()) {
                                AgentMessageProcessor.checkMultiSubject(guarMgram, logSeqNo, subject);
                                logSeqNo += (long)subjectTrackingCount;
                            } else {
                                if (subject.isMultiSubject()) {
                                    guarMgram.getBrokerHandle().assignSubjectTrackingNumbers(0L);
                                }
                                proxyTable = guarMgram.getBrokerHandle().getProxyRecipsTable();
                            }
                            firstLogSeqNo = logSeqNo;
                            Iterator iter = guarMgram.getBatchHandle().getBatchIterator();
                            while (iter.hasNext()) {
                                IMgram subMgram = (IMgram)iter.next();
                                subMgram.getBrokerHandle().setProxyRecipsTable(proxyTable);
                                AgentMessageProcessor.checkMultiSubject(subMgram, logSeqNo, subject);
                                logSeqNo += (long)subjectTrackingCount;
                            }
                        } else {
                            firstLogSeqNo = logSeqNo = this.m_reg.getLogManager().allocMultipleSeqNos(subjectTrackingCount);
                            AgentMessageProcessor.checkMultiSubject(guarMgram, logSeqNo, subject);
                        }
                        this.handleMessageProtection(guarMgram, mp);
                        guarMgram.sync();
                        this.sendSecuredToClients(guarClients, guarMgram, pubLimiter, scratch.m_groupSubscriptionsByNeighbor);
                        if (relClients.m_count > 0) {
                            this.setDBTrackingInRelMgram(relMgram, firstLogSeqNo);
                        }
                    }
                }
                if (relClients.m_count > 0) {
                    if (rcvdMgram.isGuarenteed()) {
                        if (!rcvdMgram.isSuccessor() || scratch.m_gsRedeliveryOk) {
                            this.sendSecuredToClients(relClients, relMgram, pubLimiter, scratch.m_groupSubscriptionsByNeighbor);
                        } else {
                            if (this.DEBUG) {
                                this.debug("Discarding duplicate message for rel subs. (guarClients.m_count > 0)");
                            }
                            AMPScratchPad.undoPubDispatch(relClients);
                        }
                    } else {
                        this.sendSecuredToClients(relClients, relMgram, pubLimiter, scratch.m_groupSubscriptionsByNeighbor);
                    }
                }
                if (ptpClients.m_count > 0) {
                    if (this.DEBUG) {
                        this.debug("Delivering message to " + ptpClients.m_count + " queue recipients");
                    }
                    ptpMgram.getRoutingHandle().setRouting(rcvdMgram.getRoutingHandle().getAllRoutingString());
                    this.deliverToQueues(ptpMgram, publisher, ptpClients, ptpTrackingNums, tracker);
                }
            }
        }
        catch (ESecurityGeneralException e) {
            BrokerComponent.getComponentContext().logMessage(prAccessor.getString("STR011"), (Throwable)e, 2);
        }
        catch (Throwable t) {
            BrokerComponent.getComponentContext().logMessage(t, 2);
        }
    }

    private boolean isDeliverOnFlush(IMgram rcvdMgram, boolean deliverOnFlushParam) {
        boolean deliverOnFlush = deliverOnFlushParam;
        if (!Config.REPLICATED && rcvdMgram.isNonPersistentReplicated()) {
            deliverOnFlush = false;
        }
        return deliverOnFlush;
    }

    private static void cancelSubMgramTrackers(boolean processMultipleTrackers, AgentGuarMsgTracker[] subMgramTrackers) {
        if (processMultipleTrackers) {
            for (int ii = 0; ii < subMgramTrackers.length; ++ii) {
                subMgramTrackers[ii].canceled();
            }
        }
    }

    private static void checkMultiSubject(IMgram guarMgram, long logSeqNo, ISubject subject) {
        guarMgram.setGuarenteed(logSeqNo & 0xFFFFFFFFFFFFL);
        if (subject.isMultiSubject()) {
            guarMgram.getBrokerHandle().assignSubjectTrackingNumbers(logSeqNo & 0xFFFFFFFFFFFFL);
        }
    }

    private void checkScratchOverrides(IMgram rcvdMgram, AMPScratchPad scratch) throws InterruptedException {
        if (scratch.m_dmqOverride || scratch.m_ddqOverride) {
            this.m_reg.getQMsgStateMgr().moveMsgToTopic(rcvdMgram, null, true, true);
        }
    }

    private void setDBTrackingInRelMgram(IMgram relMgram, long logSeqNoParam) {
        long logSeqNo = logSeqNoParam;
        if (relMgram.getType() != 27) {
            relMgram.getBrokerHandle().setDbTracking(logSeqNo & 0xFFFFFFFFFFFFL);
        } else {
            Iterator iter = relMgram.getBatchHandle().getBatchIterator();
            IMgram subMgram = null;
            while (iter.hasNext()) {
                subMgram = (IMgram)iter.next();
                subMgram.getBrokerHandle().setDbTracking(logSeqNo & 0xFFFFFFFFFFFFL);
                ++logSeqNo;
            }
            relMgram.getBatchHandle().syncBatch();
        }
        relMgram.sync();
    }

    private final IMgram preparePtpMgram(IMgram parentMgram, RecipientWrap ptpRecipient, long trackingNum, boolean needTracking, boolean makeClone) {
        String nodeName;
        IMgram returnMgram = null;
        if (makeClone) {
            try {
                returnMgram = (IMgram)parentMgram.protectedClone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {}
        } else {
            returnMgram = parentMgram;
            if (Config.ENABLE_SECURITY && parentMgram.isSecure()) {
                try {
                    parentMgram.setSecurityAttribute(this.handleQopSecurity(parentMgram, true, true));
                }
                catch (EIntegrityCompromised eIntegrityCompromised) {
                    // empty catch block
                }
            }
        }
        if (returnMgram == null) {
            throw new NullPointerException("IMgram returnMgram is null at " + this.getClass().getName() + ".preparePtpMgram(IMgram parentMgram, RecipientWrap ptpRecipient, long trackingNum, boolean needTracking, boolean makeClone)");
        }
        if (needTracking) {
            returnMgram.setGuarenteed(trackingNum);
        }
        if (returnMgram == null) {
            throw new NullPointerException("IMgram returnMgram is null at " + this.getClass().getName() + ".preparePtpMgram(IMgram parentMgram, RecipientWrap ptpRecipient, long trackingNum, boolean needTracking, boolean makeClone)");
        }
        if (returnMgram.isDiscardable() && returnMgram.isGuarenteed()) {
            returnMgram.setReliable();
        }
        if ((nodeName = ptpRecipient.getTargetedNodeName()) != null) {
            if (this.DEBUG) {
                this.debug("setRouting for current and dest node > " + Config.ROUTING_NODE_NAME + " , " + nodeName);
            }
            if (!returnMgram.getRoutingHandle().isNodeInPath(Config.ROUTING_NODE_NAME)) {
                returnMgram.getRoutingHandle().addNodeToPath(Config.ROUTING_NODE_NAME);
            }
            if (!returnMgram.getRoutingHandle().isNodeInPath(nodeName)) {
                returnMgram.getRoutingHandle().addNodeToPath(nodeName);
                if (returnMgram.isPubSub()) {
                    returnMgram.getRoutingHandle().setGSAPublication(true);
                }
            }
        }
        if (parentMgram.getBrokerHandle().getSubjectFilters() != null && returnMgram.isJMSPersistent()) {
            returnMgram.setLimiterSizeIncrement(parentMgram.getSubject().memoryLength());
        }
        return returnMgram;
    }

    private final void deliverToQueues(IMgram parentMgram, IClientContext publisher, FastVector ptpRecipients, long[] ptpTrackingNums, AgentGuarMsgTracker parentTracker) throws InterruptedException {
        int numRecipients = ptpRecipients.m_count;
        String queueName = this.m_qproc.getRoutingQueue().getQueueName();
        IMgram ptpMgram = null;
        RecipientWrap rw = null;
        long tracking = 0L;
        boolean reserveSpace = false;
        parentMgram.getSidebandDataReadOnly();
        for (int ii = 0; ii < numRecipients; ++ii) {
            rw = (RecipientWrap)ptpRecipients.m_data[ii];
            if (ptpTrackingNums != null) {
                tracking = ptpTrackingNums[ii];
            }
            ptpMgram = this.preparePtpMgram(parentMgram, rw, tracking, !parentMgram.isDiscardable(), true);
            ptpMgram.getBrokerHandle().setLogEvent(null);
            long sfId = rw.hasClientContext() ? rw.getClient().getSubjectFilterId() : rw.getId();
            ISubjectFilter sf = ptpMgram.getBrokerHandle().getSubjectFilter(sfId);
            if (sf != null) {
                ISubject filtered = sf.filter(ptpMgram.getSubject());
                if (filtered == null) {
                    SessionConfig.logMessage("Unable to deliver GSA message with no matching subjects!", new EAssertFailure(ptpMgram.getSubject().getJMSName()), SessionConfig.SEVERE);
                }
                ptpMgram.setSubject(filtered, 5);
                ptpMgram.getBrokerHandle().setSubjectFilters(null);
            }
            if (ptpMgram.isJMSPersistent()) {
                tracking = ptpMgram.getGuarenteedTrackingNum();
                try {
                    new AgentQueueMsgTracker(tracking, parentTracker, ptpMgram, queueName);
                }
                catch (EDuplicateKey e) {
                    BrokerComponent.getComponentContext().logMessage(prAccessor.getString("STR010") + tracking, (Throwable)e, 2);
                }
            }
            reserveSpace = parentMgram.isDiscardable();
            this.m_qproc.newMgram(ptpMgram, publisher, reserveSpace, true);
        }
    }

    final byte handleQopSecurity(IMgram m, boolean skipChecks) throws EIntegrityCompromised {
        return this.handleQopSecurity(m, skipChecks, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final byte handleQopSecurity(IMgram m, boolean skipChecks, boolean enforceQueueAttribs) throws EIntegrityCompromised {
        byte attributes = m.getSecurity();
        int qop = 0;
        ISubject subject = m.getSubject();
        try {
            if (m.isReply()) {
                return SecurityLogic.AttribsFromPrivate((byte)2, attributes);
            }
            BrokerSearchResults bsr = new BrokerSearchResults();
            if (Config.USE_DEFAULT_QOP) {
                qop = Config.DEFAULT_QOP;
            } else {
                if (subject.isMultiSubject() && SecurityLogic.isQuery(m.getSecurity())) {
                    bsr.setQOPQuery();
                }
                this.m_reg.subscribers(subject, bsr);
                qop = this.retrieveProtection(bsr);
            }
            if (skipChecks) {
                if (this.DEBUG) {
                    this.debug("remote qop = " + SecurityLogic.getPubAttr(m.getSecurity()));
                }
                if (this.DEBUG) {
                    this.debug("local qop = " + qop);
                }
            } else if (SecurityLogic.isQuery(m.getSecurity())) {
                if (!SecurityLogic.verifyQuery(m.getSecurity())) {
                    throw new EIntegrityCompromised(prAccessor.getString("STR013") + "; attr= " + SecurityLogic.debugStringPrivate(m.getSecurity()) + "; subject is " + m.getSubject().getSubjectString());
                }
                if (!m.getBrokerHandle().isFromLog()) {
                    this.handleQopQuery(bsr, m, qop);
                }
            } else {
                byte RecvQop = SecurityLogic.getPubAttr(m.getSecurity());
                if (RecvQop != qop) {
                    if (RecvQop < qop) {
                        if (!this.isAdminClientId(m.getBrokerHandle().getSenderID())) throw new EIntegrityCompromised(prAccessor.getString("STR014") + "; attr= " + SecurityLogic.debugStringPrivate(m.getSecurity()) + "; subject is " + m.getSubject().getSubjectString());
                        this.m_reg.publishQop(m.getBrokerHandle().getSenderID(), (byte)qop, subject);
                    } else if (!m.getBrokerHandle().isFromLog()) {
                        BrokerSearchResults bsrQuery = new BrokerSearchResults();
                        bsr.setQOPQuery();
                        this.m_reg.subscribers(subject, bsrQuery);
                        int queryQop = 0;
                        queryQop = this.retrieveProtection(bsr);
                        this.handleQopQuery(bsrQuery, m, queryQop);
                    }
                }
            }
            if (enforceQueueAttribs) {
                return SecurityLogic.AttribsFromPublic((byte)4, (byte)qop);
            }
            if (!m.isPTP() && m.getType() != 11 && (!m.isPubSub() || !m.forRemoteNode(Config.ROUTING_NODE_NAME))) return SecurityLogic.AttribsFromPublic((byte)2, (byte)qop);
            return SecurityLogic.AttribsFromPublic((byte)4, (byte)qop);
        }
        catch (ESecurityInvalidLogistics il) {
            throw new EAssertFailure("General Exception in handleQopSecurity: " + il, il);
        }
    }

    private int retrieveProtection(BrokerSearchResults bsr) throws EIntegrityCompromised {
        short qop = 0;
        try {
            qop = bsr.m_qop.getProtection();
        }
        catch (Exception e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 1);
            throw new EIntegrityCompromised(e.getMessage());
        }
        return qop;
    }

    private final void handleQopQuery(BrokerSearchResults bsr, IMgram m, int overallQop) {
        ISubject subject = m.getSubject();
        int qop = overallQop;
        try {
            IClientContext sender = this.m_reg.getClient(m.getBrokerHandle().getSenderID());
            if (sender.getClientSessionVer() < 28) {
                this.m_reg.publishQop(m.getBrokerHandle().getSenderID(), (byte)qop, subject);
            } else {
                IMgram update = MgramFactory.getMgramFactory().buildOperationMgram(26);
                ObjectOutput out = update.getPayloadOutputStreamHandle();
                WrappedDataOutputStream os = new WrappedDataOutputStream(out);
                try {
                    if (subject.isMultiSubject()) {
                        out.writeShort(subject.getMultiSubjectCount());
                        if (this.DEBUG) {
                            this.debug("Sending MULTISUBJECT QOP update for: " + subject);
                        }
                        for (ISubject s : bsr.m_subjectQOPTable.keySet()) {
                            IQop q = (IQop)bsr.m_subjectQOPTable.get(s);
                            if (this.DEBUG) {
                                this.debug("Sending QOP update for: " + s + ", qop: " + q.getProtection());
                            }
                            out.writeByte((byte)q.getProtection());
                            s.writeToStream(os);
                        }
                    } else {
                        out.writeShort(1);
                        out.writeByte((byte)qop);
                        subject.writeToStream(os);
                    }
                    os.close();
                    out.flush();
                    update.setPriority((byte)12);
                    update.setMgramSecure(null);
                    update.setSecurityAttribute(SecurityLogic.AttribsFromPublic((byte)4, (byte)2));
                    sender.sendThrough(update);
                }
                catch (IOException ioe) {
                    BrokerComponent.getBrokerComponent();
                    BrokerComponent.getBrokerComponent();
                    BrokerComponent.logMessage("Error preparing qop update.", ioe, BrokerComponent.getLevelSevere());
                }
            }
        }
        catch (EClientNotRegistered eClientNotRegistered) {
            // empty catch block
        }
    }

    private void placeMessageKey(IMgram rcvdMgram, IMessageProtection mp, AMPScratchPad scratch) {
        if (Config.ENABLE_QOPSECURITY && rcvdMgram.isSecure() && rcvdMgram.getSecurity() != 0) {
            rcvdMgram.getBrokerHandle().placeMessageKey(mp, scratch.m_tempMessageKeyBuffer);
        }
    }

    private void handleMessageProtection(IMgram mgram, IMessageProtection mp) throws ESecurityGeneralException {
        boolean handled = false;
        if (mgram.isSecure()) {
            if (this.DEBUG) {
                this.debug("handleMessageProtection for: " + mgram);
            }
            if (SecurityLogic.isMKeyMacHeader(mgram.getSecurity())) {
                mgram.getBrokerHandle().macHeaderWithMessageKey(mp);
                handled = true;
            } else if (SecurityLogic.isMKeyDigest(mgram.getSecurity())) {
                mgram.getBrokerHandle().macMessageWithMessageKey(mp);
                handled = true;
                if (SecurityLogic.isMKeyEncryption(mgram.getSecurity())) {
                    mgram.getBrokerHandle().encryptMessageWithMessageKey(mp);
                }
            }
        }
    }

    private void sendSecuredToClients(FastVector vector, IMgram m, PublishLimiter pubLimiter, LongHashTable lbsProxyRecips) {
        this.sendSecuredToClients(vector, m, pubLimiter, lbsProxyRecips, null);
    }

    private void sendSecuredToClients(FastVector vector, IMgram m, PublishLimiter pubLimiter, LongHashTable lbsProxyRecips, AgentGuarMsgTracker tracker) {
        if (vector.m_count == 0) {
            return;
        }
        FastVector discClients = new FastVector();
        discClients.m_count = 0;
        FastVector offloadingClients = new FastVector();
        offloadingClients.m_count = 0;
        FastVector discProxyingClients = new FastVector();
        for (int i = 0; i < vector.m_count; ++i) {
            IClientContext cc;
            RecipientWrap rw = (RecipientWrap)vector.m_data[i];
            if (rw == null) continue;
            IMgram msg = m;
            if ((this.debugFlags & 0x800) != 0 && m.getBrokerHandle().isTransactionalPublish()) {
                this.debug("deliverSecuredToClients: delivering message from tid= " + m.getBrokerHandle().getTxnPublishTid() + " to " + rw.getClient() + " subj= " + msg.getSubject());
            }
            if ((cc = rw.getClient()).isGroupSubscription()) {
                cc.undoPubDispatch();
                cc.processGroupMemberMgram(m, pubLimiter, cc, m.isSuccessor(), m.getBrokerHandle().isFromLog(), false);
                continue;
            }
            if (rw.m_groupSubscriptionList != null) {
                msg = LBSTrackingInfo.buildLBSTargetWrapper(m, rw.m_groupSubscriptionList);
            }
            if (!m.getBrokerHandle().isBatchedPublish() || m.getType() == 27 || m.getBrokerHandle().isFromLog()) {
                this.sendSecuredMgramInternal(rw.getClient(), msg, rw.m_label, pubLimiter, discClients, discProxyingClients, offloadingClients, tracker);
                continue;
            }
            this.sendSecuredBatchInternal(rw.getClient(), msg, rw.m_label, pubLimiter, discClients, discProxyingClients, offloadingClients, tracker);
        }
        if (discClients.m_count > 0 || discProxyingClients.m_count > 0) {
            this.debugDiscClients(discClients);
            this.m_reg.getMsgSaver().save(m, pubLimiter, discClients, discProxyingClients, lbsProxyRecips, tracker, m.isSuccessor(), m.getBrokerHandle().isFromLog(), false, false);
        }
        if (offloadingClients.m_count > 0) {
            this.processOffloadingClients(m, pubLimiter, offloadingClients, lbsProxyRecips, tracker);
        }
        this.updatePubStats(vector.m_count, discClients.m_count);
    }

    private void sendSecuredMgramInternal(IClientContext cc, IMgram msg, Label opts, PublishLimiter pubLimiter, FastVector discClients, FastVector discProxyingClients, FastVector offloadingClients, AgentGuarMsgTracker tracker) {
        int sendresult = cc.send(msg, opts, pubLimiter);
        if (this.DEBUG && sendresult != 0 && msg.getType() == 25) {
            this.debug("failed to send a LBS op mgram, result = " + sendresult + " - " + MgramTrace.diagnosticString("", null, msg) + " state: " + cc.getState() + " -- " + cc.getSavesInProgress());
        }
        this.handleSendResult(sendresult, cc, msg, opts, pubLimiter, discClients, discProxyingClients, offloadingClients, tracker);
    }

    private void sendSecuredBatchInternal(IClientContext cc, IMgram msg, Label opts, PublishLimiter pubLimiter, FastVector discClients, FastVector discProxyingClients, FastVector offloadingClients, AgentGuarMsgTracker tracker) {
        int sendresult = cc.batch(msg, opts, pubLimiter);
        this.handleSendResult(sendresult, cc, msg, opts, pubLimiter, discClients, discProxyingClients, offloadingClients, tracker);
    }

    private void processOffloadingClients(IMgram msg, PublishLimiter pubLimiter, FastVector offloadingClients, LongHashTable lbsProxyRecips, AgentGuarMsgTracker tracker) {
        long msgSaverOpIndx = this.m_reg.getMsgSaver().save(msg, pubLimiter, offloadingClients, null, lbsProxyRecips, tracker, true, msg.getBrokerHandle().isFromLog(), true, false);
        int memorySize = 0;
        for (int ii = 0; ii < offloadingClients.m_count; ++ii) {
            IClientContext offloadingCC = (IClientContext)offloadingClients.m_data[ii];
            memorySize += offloadingCC.enqueueOffloaded(msg, msgSaverOpIndx);
        }
        FlowToDiskMemoryManager.getFlowToDiskMemoryManager().updateMemorySize(memorySize, offloadingClients, pubLimiter);
    }

    private final void sendBatch(HashMap ccs, long batchId, boolean deliverOnFlush, IMessageProtection mp, LongHashTable lbsProxyRecips) {
        if (deliverOnFlush) {
            SendBatchEvt evt = new SendBatchEvt(ccs, batchId, mp, lbsProxyRecips);
            this.m_logmgr.addEvent(evt, true);
        } else {
            this.sendBatchInternal(ccs, batchId, mp, lbsProxyRecips);
        }
    }

    void sendBatchInternal(HashMap ccs, long batchId, IMessageProtection mp, LongHashTable lbsProxyRecips) {
        if (!ccs.isEmpty()) {
            for (IClientContext cc : ccs.values()) {
                IClientContext.MsgInfo result = cc.retrieveBatch(batchId);
                if (result == null) continue;
                FastVector discClients = new FastVector();
                FastVector discProxyingClients = new FastVector();
                FastVector offloadingClients = new FastVector();
                IMgram m = result.m_mgram;
                try {
                    m.getBatchHandle().secureHeader(mp);
                }
                catch (ESecurityGeneralException e) {
                    BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                }
                int sendresult = cc.send(m, result.m_opts, result.m_pubLimiter);
                if (sendresult == 2) {
                    Iterator iter = m.getBatchHandle().getBatchIterator();
                    while (iter.hasNext()) {
                        IMgram subMgram = (IMgram)iter.next();
                        if (!subMgram.isGuarenteed()) continue;
                        try {
                            AgentGuarMsgTracker tracker = AgentGuarMsgTracker.getTracker(subMgram.getGuarenteedTrackingNum());
                            tracker.msgAcknowledged(cc, false);
                        }
                        catch (ETrackingNumNotFound eTrackingNumNotFound) {}
                    }
                }
                this.handleSendResult(sendresult, cc, m, result.m_opts, result.m_pubLimiter, discClients, discProxyingClients, offloadingClients, null);
                if (discClients.m_count > 0 || discProxyingClients.m_count > 0) {
                    this.debugDiscClients(discClients);
                    this.m_reg.getMsgSaver().save(m, result.m_pubLimiter, discClients, discProxyingClients, lbsProxyRecips, null, m.isSuccessor(), m.getBrokerHandle().isFromLog(), false, false);
                }
                if (offloadingClients.m_count > 0) {
                    this.processOffloadingClients(m, result.m_pubLimiter, offloadingClients, lbsProxyRecips, null);
                }
                this.updatePubStats(1, discClients.m_count);
            }
        }
    }

    private void debugDiscClients(FastVector discClients) {
        if (this.DEBUG) {
            this.debug("Saving msg for disc " + discClients.m_count + " clients ");
        }
    }

    private void handleSendResult(int sendResult, IClientContext cc, IMgram msg, Label opts, PublishLimiter pubLimiter, FastVector discClients, FastVector discProxyingClients, FastVector offloadingClients, AgentGuarMsgTracker tracker) {
        FastVector recipients;
        switch (sendResult) {
            case 1: {
                AgentMessageProcessor.saveMessageForGuaranteed(cc, discClients, msg, pubLimiter);
                break;
            }
            case 3: {
                AgentMessageProcessor.saveMessageForGuaranteed(cc, discClients, msg, pubLimiter);
                break;
            }
            case 4: {
                if (cc.isGroupSubscriptionMember() && !cc.isDurable()) {
                    cc.getGroupSubscriptionCC().adjustDurableCCTracker(msg, true);
                }
                offloadingClients.addElement(cc);
                break;
            }
            case 2: {
                if (tracker == null) break;
                tracker.msgAcknowledged(cc, false);
                break;
            }
        }
        if ((sendResult == 3 || sendResult == 1) && (opts.isPersistent() || opts.isGuaranteed()) && (recipients = MsgSaver.handleProxySaves(msg, cc, msg.getBrokerHandle().isFromLog(), false)) != null) {
            discProxyingClients.append(recipients);
        }
    }

    private static void saveMessageForGuaranteed(IClientContext cc, FastVector discClients, IMgram msg, PublishLimiter pubLimiter) {
        if (!cc.isGroupSubscriptionMember()) {
            discClients.addElement(cc);
        } else {
            GroupSubscriptionClientContext groupcc = cc.getGroupSubscriptionCC();
            groupcc.processGroupMemberMgram(msg, pubLimiter, cc, msg.isSuccessor(), msg.getBrokerHandle().isFromLog(), false);
        }
    }

    private void updatePubStats(int conClientCount, int discClientCount) {
        if (StatsMetrics.areStatsEnabled(4)) {
            int numLiveSubscribers = conClientCount - discClientCount;
            this.pubsubDelivMsgs.add(numLiveSubscribers);
            this.pubsubDelDiscMsgs.add(discClientCount);
        }
        if (StatsMetrics.areStatsEnabled(1)) {
            this.msgsDeliv.add(conClientCount);
        }
    }

    private final void deliverToQueue(IMgram m, AMPScratchPad scratch) throws InterruptedException {
        this.m_qproc.newMgram(m, scratch.m_publisher);
    }

    private static String getJmsSubject(ISubject subject, String remoteNode) {
        String jmsSubject = subject.getJMSName();
        if (remoteNode != null && !"".equals(remoteNode)) {
            jmsSubject = remoteNode + "::" + jmsSubject;
        }
        return jmsSubject;
    }

    private class AMPHandle
    implements IAMPHandle {
        AgentMessageProcessor m_amp;

        AMPHandle(AgentMessageProcessor amp) {
            this.m_amp = amp;
        }

        @Override
        public void deliverSecuredToClients(FastVector recips, IMgram m, PublishLimiter pubLimiter, LongHashTable lbsProxyRecips, AgentGuarMsgTracker tracker) {
            this.m_amp.sendSecuredToClients(recips, m, pubLimiter, lbsProxyRecips, tracker);
        }

        @Override
        public void updatePubStats(FastVector conClients, FastVector discClients) {
            this.m_amp.updatePubStats(conClients.m_count, discClients.m_count);
        }

        @Override
        public void handleMessageProtection(IMgram m, IMessageProtection mp) throws ESecurityGeneralException {
            this.m_amp.handleMessageProtection(m, mp);
        }

        @Override
        public void deliverToQueues(IMgram parentMgram, IClientContext publisher, FastVector ptpRecipients, long[] ptpTrackingNums, AgentGuarMsgTracker parentTracker) throws InterruptedException {
            this.m_amp.deliverToQueues(parentMgram, publisher, ptpRecipients, ptpTrackingNums, parentTracker);
        }
    }

    private static final class ProcessBatchResult {
        public AgentGuarMsgTracker m_batchTracker;
        public AgentGuarMsgTracker[] m_subMgramTrackers;

        private ProcessBatchResult() {
        }
    }

    private static final class BatchMatchHolder {
        RecipientVector m_guarClients;
        RecipientVector m_relClients;
        RecipientVector m_ptpClients;
        LongHashTable m_proxyRecipsTable;
        LongHashTable m_groupSubscriptionsByNeighbor;
        boolean m_persist;
        boolean m_xonce;

        private BatchMatchHolder() {
        }
    }

    private final class SubjectFilter
    implements ISubjectFilter {
        private HashSet<ISubject> m_validSubjects = null;
        private boolean m_protected = false;

        SubjectFilter(HashSet<ISubject> filter) {
            this.m_validSubjects = filter;
        }

        private SubjectFilter(SubjectFilter filter) {
            this.m_validSubjects = filter.m_validSubjects;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ISubject filter(ISubject s) {
            if (s == null) {
                return null;
            }
            SubjectFilter subjectFilter = this;
            synchronized (subjectFilter) {
                return s.filterBySubject(this.m_validSubjects);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection filterTrackingNums(ISubject s) {
            if (s == null || !s.hasSubjectTracking()) {
                throw new EAssertFailure("Invalid filter subject. Subject must have tracking: " + s);
            }
            SubjectFilter subjectFilter = this;
            synchronized (subjectFilter) {
                if (this.m_validSubjects.isEmpty()) {
                    return this.m_validSubjects;
                }
                return s.filteredTrackingNums(this.m_validSubjects);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeTrackingNum(ISubject s, short tracking) {
            SubjectFilter subjectFilter = this;
            synchronized (subjectFilter) {
                if (this.m_validSubjects.isEmpty()) {
                    return;
                }
                if (!s.hasSubjectTracking()) {
                    throw new EAssertFailure("Can't remove from an untracked subject.");
                }
                ISubject filtered = s;
                if (filtered.isMultiSubject()) {
                    Iterator<ISubject> i = filtered.getMultiSubjects();
                    while (i.hasNext()) {
                        filtered = i.next();
                        if (filtered.getSubjectTracking() != (long)tracking) continue;
                        this.unprotect();
                        this.m_validSubjects.remove(filtered);
                        return;
                    }
                } else if (filtered.getSubjectTracking() == (long)tracking) {
                    this.unprotect();
                    this.m_validSubjects.remove(filtered);
                    return;
                }
            }
        }

        @Override
        public short filterSize() {
            return (short)this.m_validSubjects.size();
        }

        @Override
        public final ISubjectFilter protectedClone() {
            SubjectFilter ret = new SubjectFilter(this);
            ret.m_protected = true;
            this.m_protected = true;
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void unprotect() {
            SubjectFilter subjectFilter = this;
            synchronized (subjectFilter) {
                if (this.m_protected) {
                    this.m_validSubjects = (HashSet)this.m_validSubjects.clone();
                    this.m_protected = false;
                }
            }
        }
    }
}

