/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mf.common.metrics.IMetricIdentity;
import com.sonicsw.mf.common.metrics.IMetricInfo;
import com.sonicsw.mf.common.metrics.MetricsFactory;
import com.sonicsw.mf.common.metrics.manager.IMetricsRegistrar;
import com.sonicsw.mf.common.metrics.manager.IStatistic;
import com.sonicsw.mf.common.metrics.manager.StatisticsFactory;
import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.security.pcs.AbstractCipherSuite;
import com.sonicsw.security.pcs.PluggableSecureOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Vector;
import progress.message.broker.AddrUtil;
import progress.message.broker.AgentConnection;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.BrokerSubscription;
import progress.message.broker.Config;
import progress.message.broker.DispatchListImpl;
import progress.message.broker.IAgentQueue;
import progress.message.broker.IBrokerOutBox;
import progress.message.broker.IClientContext;
import progress.message.broker.IDispatchList;
import progress.message.broker.IReenqueuer;
import progress.message.broker.InDoubtQMsgReenqueueEvt;
import progress.message.broker.LogEvent;
import progress.message.broker.interceptor.InterceptorManager;
import progress.message.broker.prAccessor;
import progress.message.client.ESecurityGeneralException;
import progress.message.client.EUnsupportedMgramException;
import progress.message.crypto.SecureOutputStream;
import progress.message.ft.FailoverConfig;
import progress.message.interbroker.InterbrokerConfig;
import progress.message.msg.IMgram;
import progress.message.msg.IMgramConverter;
import progress.message.msg.IProtocolAdapter;
import progress.message.msg.MgramConstants;
import progress.message.msg.MgramDeliveryContext;
import progress.message.msg.MgramFactory;
import progress.message.net.ISocket;
import progress.message.strm.StreamFactory;
import progress.message.util.AutoVec;
import progress.message.util.DebugState;
import progress.message.util.EAssertFailure;
import progress.message.util.ICompressionFactory;
import progress.message.util.IDumpable;
import progress.message.util.IMetricsListener;
import progress.message.util.LongHashTable;
import progress.message.util.OutputStreamWrapper;
import progress.message.util.capture.CaptureBuffer;
import progress.message.util.capture.CaptureOutputStream;
import progress.message.zclient.ClientSecurityContext;
import progress.message.zclient.DebugObject;
import progress.message.zclient.IMessageProtection;
import progress.message.zclient.ISecureOutputStream;
import progress.message.zclient.ISubject;
import progress.message.zclient.SecurityLogic;
import progress.message.zclient.Sender;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.xonce.IXOnceHandle;
import progress.message.zclient.xonce.MgramTrace;

public class AgentSender
extends Sender
implements IReenqueuer {
    private static final int MAX_CHANNELS_IN_DEF_DISPLIST = 100;
    protected AgentConnection m_connection;
    private boolean m_isAdminConnection;
    private AutoVec m_ccs = new AutoVec();
    private Hashtable m_channels = new Hashtable();
    private LongHashTable m_qSenderState;
    private AutoVec m_outboxes = new AutoVec();
    private IBrokerOutBox m_dummyOutBox;
    private final IMessageProtection m_mp;
    private final IMessageProtection m_decryptMp;
    private boolean m_started = false;
    private volatile boolean m_abort = false;
    private boolean m_senderIsDone = false;
    private byte m_clientMgramVersion = (byte)26;
    private ISecureOutputStream m_sos;
    private IMgramConverter m_converter;
    private Hashtable m_reenqueueTable = new Hashtable();
    private ArrayList m_idmrEvtList = new ArrayList();
    private boolean m_hasReenqueues;
    private final MgramDeliveryContext m_deliveryContext = new MgramDeliveryContext();
    private ASProtocolAdapter m_protocolAdapter = null;
    private ICompressionFactory m_compressionFactory = null;
    private static boolean m_hasEnabledBytesMetrics = false;
    private static boolean m_hasEnabledMsgsMetrics = false;
    public static final IMetricIdentity BROKER_BYTES_DELIVEREDPERSECOND_METRIC = MetricsFactory.createMetricIdentity((String[])new String[]{"broker", "bytes", "DeliveredPerSecond"});
    private static IStatistic m_bytesDeliveredPerSecond;
    public static final IMetricIdentity BROKER_MSGS_DELIVEREDPERSECOND_METRIC;
    private static IStatistic m_msgsDeliveredPerSecond;
    public static final IMetricIdentity BROKER_MSGS_DELIVERED_METRIC;
    private static IStatistic m_msgsDelivered;
    private Object m_initSyncObject = new Object();
    private boolean m_pingTimeoutEnabled = false;
    private int m_pingInterval = 0;
    private IMgram m_pingMgram = MgramFactory.getMgramFactory().buildPingRequest(new byte[0], 0);
    protected boolean m_needExtendedPing = false;
    private IDispatchList m_dispatchList;
    private boolean m_resetDispatchClass = false;
    private boolean m_resetDispatchClassCompleted = false;
    private OutputStream m_socketStream;
    private OutputStreamWrapper m_compressionStreamWrapper = null;
    private final boolean DIAG_MGRAM_HISTORY;
    private CaptureBuffer m_cb;
    private IMetricsListener m_metricsListener = null;
    protected String m_threadNamePrefix;

    protected IMgram getPingMgram() {
        return this.m_pingMgram;
    }

    public void sendPingMgram() throws IOException {
        this.sendThrough(this.getPingMgram());
    }

    public AgentSender(AgentConnection connection) throws IOException {
        this("AgentSender of", connection);
    }

    public AgentSender(String name, AgentConnection connection) throws IOException {
        super(name, connection);
        this.m_connection = connection;
        this.m_isAdminConnection = this.m_connection.isAdminConnection();
        this.m_threadNamePrefix = name;
        this.setThreadNameHelper();
        this.DIAG_MGRAM_HISTORY = SessionConfig.DIAG_MGRAM_HISTORY || this.checkDebugFlags(8192);
        this.m_dispatchList = new DefaultDispatchList();
        class DummyOutBox
        implements IBrokerOutBox {
            DummyOutBox() {
            }

            @Override
            public void sendThrough(IMgram mg) {
                try {
                    AgentSender.this.sendThrough(mg);
                    if ((m_hasEnabledBytesMetrics || AgentSender.this.m_connection.hasEnabledBytesDelvdMetrics()) && !AgentSender.this.m_isAdminConnection) {
                        long mgramLength = mg.networkLength();
                        AgentSender.this.updateStatistic(m_bytesDeliveredPerSecond, mgramLength);
                        if (AgentSender.this.m_metricsListener == null) {
                            AgentSender.this.m_connection.updateBytesDelvdStats(mgramLength);
                        }
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            @Override
            public void setMinSendPriority(int prio) {
            }

            @Override
            public Object getSyncObj() {
                return this;
            }
        }
        this.m_dummyOutBox = new DummyOutBox();
        if (!Config.ENABLE_QOPSECURITY) {
            this.m_mp = null;
            this.m_decryptMp = null;
            return;
        }
        IMessageProtection mp = null;
        try {
            mp = AbstractCipherSuite.getNewMessageProtectionInstance();
        }
        catch (Exception e) {
            throw new EAssertFailure(e);
        }
        finally {
            this.m_mp = mp;
        }
        try {
            mp = AbstractCipherSuite.getNewMessageProtectionInstance();
        }
        catch (Exception e) {
            throw new EAssertFailure(e);
        }
        finally {
            this.m_decryptMp = mp;
        }
    }

    private void setThreadNameHelper() {
        this.setThreadName();
    }

    public void initMessageProtection(byte[] sessionKey) {
        this.m_mp.init(1, sessionKey);
        this.m_decryptMp.init(2, sessionKey);
    }

    @Override
    protected void callback(String text, int method, Object params) {
        super.callback(text, method, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final OutputStream initialize() throws IOException {
        Object object = this.m_initSyncObject;
        synchronized (object) {
            if (this.m_out != null) {
                return this.m_out;
            }
            try {
                this.m_out = this.m_socketStream = StreamFactory.getSenderOutputStream(this.m_connection.getSocket(), this.m_connection.getMaxSendBufferSize(), this.m_connection.getMinSendBufferSize(), this.m_connection.getInitialSendBufferSize(), Config.ENABLE_CHECKSUM && !this.m_isAdminConnection);
                if (this.checkDebugFlags(64)) {
                    this.debug("Created OutputStream " + this.m_out);
                }
                if (Config.ENABLE_COMPRESSION && !this.m_isAdminConnection) {
                    this.m_compressionStreamWrapper = new OutputStreamWrapper(this.m_socketStream);
                    this.m_out = this.m_compressionStreamWrapper;
                }
                if (this.DIAG_MGRAM_HISTORY && !this.m_isAdminConnection) {
                    int captureSize = SessionConfig.SENDER_CAPTURE_BUFFER_SIZE;
                    if (SessionConfig.CAPTURE_BUFFER_FILTER.length() > 0) {
                        captureSize = 4096;
                    }
                    CaptureOutputStream cos = new CaptureOutputStream(this.m_out, SessionConfig.SENDER_CAPTURE_BUFFER_SIZE);
                    this.m_cb = cos.getCaptureBuffer();
                    this.m_out = cos;
                }
            }
            catch (NullPointerException ex) {
                BrokerComponent.getComponentContext().logMessage(prAccessor.getString("PREMATURELY_CLOSED_CONNECTION"), 2);
                this.fatalError();
                throw new IOException(prAccessor.getString("PREMATURELY_CLOSED_CONNECTION"));
            }
            if (Config.ENABLE_QOPSECURITY) {
                this.m_sos = this.m_mp.isSonicCipherSuite() ? new SecureOutputStream(this.m_out, this.m_mp, new byte[SessionConfig.IO_SECURITY_BUFFER_SIZE]) : new PluggableSecureOutputStream(this.m_out, this.m_mp);
            }
            this.initializeConverter();
            return this.m_out;
        }
    }

    private void initializeConverter() {
        try {
            this.m_converter = MgramFactory.getMgramConverter(this.m_clientMgramVersion);
        }
        catch (EUnsupportedMgramException e) {
            this.m_converter = MgramFactory.getMgramConverter(26);
        }
        Hashtable<String, Object> mgramProperties = new Hashtable<String, Object>();
        if (this.m_sos != null) {
            mgramProperties.put(MgramConstants.SECURE_OUTPUT_STREAM, this.m_sos);
        }
        if (this.m_mp != null) {
            mgramProperties.put(MgramConstants.MESSAGE_PROTECTION, this.m_mp);
        }
        if (this.m_decryptMp != null) {
            mgramProperties.put(MgramConstants.DECRYPT_MESSAGE_PROTECTION, this.m_decryptMp);
        }
        mgramProperties.put(MgramConstants.TTE_TTL_CONVERT, new Boolean(true));
        this.m_converter.initializeConverter(mgramProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(IClientContext cc, int channel) {
        Integer Channel2 = new Integer(channel);
        int ct = 0;
        Object object = this;
        synchronized (object) {
            this.m_outboxes.setElementAt(cc, channel);
            this.m_ccs.setElementAt(cc, channel);
            this.m_channels.put(cc, Channel2);
            if (this.m_qSenderState != null) {
                this.m_qSenderState.remove((long)channel);
            }
            ct = this.m_ccs.numElements();
            if (channel == 0) {
                int kat;
                ISocket socket;
                this.setThreadName();
                if (!this.m_isAdminConnection) {
                    int appid = AddrUtil.clientIdToAppid(cc.getId());
                    if (cc.getAppid().endsWith("$CONNECTION$")) {
                        this.m_pingInterval = Config.BROKER_PING_INTERVAL;
                        if (this.m_pingInterval > 0) {
                            this.m_pingTimeoutEnabled = true;
                        }
                    } else if (appid == Config.BROKER_APPID_SCODE || appid == InterbrokerConfig.BROKER_CONNECT_APPID_SCODE) {
                        this.m_pingInterval = Config.CLUSTER_PING_INTERVAL;
                        if (Config.CLUSTER_PING_TIMEOUT > 0) {
                            this.m_pingTimeoutEnabled = true;
                        }
                        if (Config.ENABLE_LOAD_BALANCING && Config.LOAD_BALANCING_WEIGHT > 0) {
                            this.m_pingTimeoutEnabled = true;
                            this.m_needExtendedPing = true;
                        }
                    } else if (appid == FailoverConfig.RM_CONNECT_APPID_SCODE || appid == FailoverConfig.RM_PRIMARY_APPID_SCODE || appid == FailoverConfig.RM_BACKUP_APPID_SCODE) {
                        this.m_pingInterval = (int)Config.FT_PING_INTERVAL;
                        if (Config.FT_PING_TIMEOUT > 0) {
                            this.m_pingTimeoutEnabled = true;
                        }
                    } else {
                        this.m_pingInterval = Config.BROKER_PING_INTERVAL;
                    }
                    if (this.m_pingTimeoutEnabled && this.checkDebugFlags(4)) {
                        this.debug("enabling ping timeout, pingInterval=" + this.m_pingInterval);
                    }
                }
                if ((socket = this.m_connection.getSocket()) != null && (kat = (int)socket.getKeepAliveTimeout()) > 0) {
                    this.m_pingTimeoutEnabled = true;
                    this.m_pingInterval = this.m_pingInterval > 0 ? Math.min(kat, this.m_pingInterval) : kat;
                    if (this.checkDebugFlags(4)) {
                        this.debug("enabling ping keepalive " + this.m_pingInterval + " miliseconds.");
                    }
                }
                if (this.m_connection.getClientSessionVer() < 32) {
                    this.m_protocolAdapter = new ASProtocolAdapter(this.m_connection, this.m_mp, this.m_decryptMp);
                    this.m_deliveryContext.protocolAdapter = this.m_protocolAdapter;
                }
                if (this.m_cb != null && SessionConfig.CAPTURE_BUFFER_FILTER.length() > 0) {
                    String appid = cc.getAppid();
                    String uid = cc.getUid();
                    OutputStream outputStream = this.m_out;
                    synchronized (outputStream) {
                        if (SessionConfig.matchCaptureFilterToUidAppid(uid, appid)) {
                            this.m_cb.resize(SessionConfig.SENDER_CAPTURE_BUFFER_SIZE);
                        } else {
                            this.m_cb.resize(0);
                            this.m_cb = null;
                        }
                    }
                }
            }
        }
        if (ct > 100) {
            object = this.m_enqueuedLock;
            synchronized (object) {
                if (!this.m_resetDispatchClass) {
                    this.m_resetDispatchClass = true;
                    this.notifySender();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(IMgram m) {
        int channel = m.getChannel();
        IBrokerOutBox ob = this.getOutBoxByChannel(channel);
        Object object = ob.getSyncObj();
        synchronized (object) {
            ob.sendThrough(m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendThrough(IMgram mg) throws IOException {
        this.initialize();
        if (this.CALLBACK) {
            this.callback("AgentSender:SENDTHROUGH", 2, new Object[]{this.m_connection, mg});
        }
        OutputStream outputStream = this.m_out;
        synchronized (outputStream) {
            this.m_converter.deliver(mg, this.m_out);
            this.m_out.flush();
            this.diagCollectMgram(mg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void dumpMgramHistory() {
        if (this.m_out instanceof IDumpable) {
            StringBuffer buf = new StringBuffer();
            buf.append("Sender History Dump:\n");
            buf.append("CSC:\n");
            ClientSecurityContext csc = this.m_connection.getSecurityContext(0);
            if (csc != null) {
                csc.dump(buf);
            }
            OutputStream outputStream = this.m_out;
            synchronized (outputStream) {
                ((IDumpable)((Object)this.m_out)).dump(buf);
            }
            BrokerComponent.logMessage(buf.toString(), BrokerComponent.getLevelSevere());
        } else {
            BrokerComponent.logMessage("Sender output not dumpable: " + this.m_out, BrokerComponent.getLevelSevere());
        }
    }

    private final void diagCollectMgram(IMgram mg) {
        if (this.m_cb != null) {
            this.m_cb.annotate(MgramTrace.diagnosticString("", this.m_connection, mg));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill(IClientContext cc, boolean sync) throws InterruptedException {
        int channel;
        Integer Channel2 = (Integer)this.m_channels.get(cc);
        int n = channel = Channel2 != null ? Channel2 : -1;
        if (sync) {
            if (Channel2 != null) {
                Object object = this.m_enqueuedLock;
                synchronized (object) {
                    while (this.m_msgEnqueued && this.isAlive() && !this.m_senderIsDone) {
                        this.m_enqueuedLock.wait(60000L);
                    }
                }
                object = this.m_dequeuedLock;
                synchronized (object) {
                    while (!this.m_allDequeued && this.isAlive() && !this.m_senderIsDone) {
                        this.m_dequeuedLock.wait(60000L);
                    }
                    this.removeChannel(channel);
                    this.stopIfNoChannels();
                }
            }
        } else if (Channel2 != null) {
            this.removeChannel(channel);
            this.stopIfNoChannels();
            Object object = cc.getSyncObj();
            synchronized (object) {
                cc.getSyncObj().notifyAll();
            }
        }
        this.notifySender();
    }

    protected synchronized void removeChannel(int channel) {
        IClientContext cc = (IClientContext)this.m_ccs.elementAt(channel);
        if (cc == null) {
            return;
        }
        this.m_ccs.setElementAt(null, channel);
        this.m_outboxes.setElementAt(null, channel);
        this.m_channels.remove(cc);
    }

    private synchronized void stopIfNoChannels() {
        if (this.m_ccs.numElements() == 0 && Thread.currentThread() != this) {
            if (this.DEBUG) {
                this.debug("thread interrupted by other thread");
            }
            this.setAbort();
        }
        this.flushReenqueues();
    }

    @Override
    public void setMinSendPriority(int prio, int channel) {
        this.getOutBoxByChannel(channel).setMinSendPriority(prio);
    }

    public void setClientMgramVersion(byte version) {
        this.m_clientMgramVersion = version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertStream(byte streamVersion, byte streamFlags, ICompressionFactory cf) throws IOException {
        this.m_compressionFactory = cf;
        if (this.checkDebugFlags(64)) {
            this.debug("Calling convertStream streamVersion= " + streamVersion + " streamFlags= " + streamFlags);
        }
        OutputStream outputStream = this.m_out;
        synchronized (outputStream) {
            StreamFactory.setupSegmentedStream(this.m_socketStream, streamVersion, streamFlags, this.m_connection.getSocket(), this.m_connection.getMaxSendBufferSize(), this.m_connection.getMinSendBufferSize(), this.m_connection.getInitialSendBufferSize());
            if (this.m_compressionFactory != null) {
                if (DebugState.getDiagnosticFlags("IMetricsListener") > 0) {
                    this.m_metricsListener = this.m_connection;
                }
                OutputStream cos = this.m_compressionFactory.getDeflaterOutputStream(this.m_compressionStreamWrapper.getOutputStream(), this.m_metricsListener);
                this.m_compressionStreamWrapper.setOutputStream(cos);
            }
        }
    }

    public byte getClientMgramVersion() {
        return this.m_clientMgramVersion;
    }

    private long pingIfIdle(long lastPingTime, boolean idle, boolean checkOnly) throws IOException {
        long currentTime;
        long newPingTime = lastPingTime;
        if ((idle || this.m_pingTimeoutEnabled) && this.m_pingInterval > 0 && (currentTime = System.currentTimeMillis()) - lastPingTime >= (long)this.m_pingInterval) {
            if (!checkOnly) {
                this.sendThrough(this.getPingMgram());
            }
            newPingTime = currentTime;
            if (!checkOnly && this.checkDebugFlags(4)) {
                this.debug("ping " + (idle ? "idle" : "") + " connection at " + lastPingTime);
            }
        }
        return newPingTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void threadMain() {
        this.m_started = true;
        if (this.m_abort) {
            if (this.DEBUG) {
                this.debug(" aborting...");
            }
            if (this.m_connection != null) {
                this.m_connection.cleanupInstanceStats();
            }
            this.notifyEnqueueDequeueLocks();
            return;
        }
        currentTimeout = 0L;
        idleTimeout = 0L;
        connectionInactiveTime = 0L;
        senderInactiveStart = 0L;
        lastPingTime = 0L;
        sendDisconnect = false;
        doFlush = false;
        try {
            try {
                this.initialize();
                if (this.m_needExtendedPing) {
                    if (this.checkDebugFlags(16384)) {
                        this.debug("send ping to update neighbor with the connection count info");
                    }
                    this.sendPingMgram();
                }
                lastPingTime = System.currentTimeMillis();
                prevCanDelayFlush = false;
                hasUnflushedMessages = false;
                oldestSend = 0L;
                if (this.checkDebugFlags(64)) {
                    this.debug("Starting...");
                }
                doReenqueues = false;
                while (true) lbl-1000:
                // 5 sources

                {
                    doPing = false;
                    newPingTime = 0L;
                    processMsgs = true;
                    idleTimeout = this.m_connection.getIdleTimeout() * 1000;
                    connectionInactiveTime = 0L;
                    senderInactiveStart = 0L;
                    var22_18 = this.m_enqueuedLock;
                    synchronized (var22_18) lbl-1000:
                    // 2 sources

                    {
                        while (!this.m_msgEnqueued && !this.m_abort) {
                            doPing = false;
                            processMsgs = true;
                            doFlush = false;
                            if (this.m_hasReenqueues) {
                                doReenqueues = true;
                                break;
                            }
                            if (hasUnflushedMessages && Config.BROKER_SEND_DELAY > 0L) {
                                this.m_enqueuedLock.wait(Config.BROKER_SEND_DELAY);
                                if (this.m_abort) {
                                    throw new InterruptedException();
                                }
                                if (this.m_msgEnqueued) break;
                                doFlush = true;
                                break;
                            }
                            try {
                                if (idleTimeout == 0L || this.m_connection.hasTimedOut()) {
                                    connectionInactiveTime = 0L;
                                    senderInactiveStart = 0L;
                                    waitTime = this.m_pingInterval;
                                    if (this.m_pingTimeoutEnabled) {
                                        waitTime = (long)this.m_pingInterval - (System.currentTimeMillis() - lastPingTime);
                                        if (waitTime <= 0L) {
                                            waitTime = 1L;
                                        }
                                        if (this.checkDebugFlags(4)) {
                                            this.debug("wait for " + waitTime + " miliseconds.");
                                        }
                                    }
                                    this.m_enqueuedLock.wait(waitTime);
                                    if (this.m_abort) {
                                        throw new InterruptedException();
                                    }
                                    if (this.m_msgEnqueued) break;
                                    idleTimeout = this.m_connection.getIdleTimeout() * 1000;
                                    continue;
                                }
                                currentTimeout = idleTimeout - connectionInactiveTime;
                                if (senderInactiveStart == 0L) {
                                    senderInactiveStart = System.currentTimeMillis();
                                }
                                this.m_enqueuedLock.wait(currentTimeout);
                                if (this.m_abort) {
                                    throw new InterruptedException();
                                }
                                if (this.m_msgEnqueued) break;
                                newIdleTimeout = this.m_connection.getIdleTimeout() * 1000;
                                if ((long)newIdleTimeout != idleTimeout) {
                                    if (this.checkDebugFlags(4)) {
                                        this.debug("Idle Timeout has changed - starting a new timeout interval; new idle timeout = " + newIdleTimeout);
                                    }
                                    idleTimeout = newIdleTimeout;
                                    connectionInactiveTime = 0L;
                                    senderInactiveStart = 0L;
                                    continue;
                                }
                                listenerInactiveStart = this.m_connection.getAgentListener().getInactive();
                                if (listenerInactiveStart == 0L) {
                                    if (this.checkDebugFlags(4)) {
                                        this.debug("Listener is active - no timeout");
                                    }
                                    connectionInactiveTime = 0L;
                                    senderInactiveStart = 0L;
                                    continue;
                                }
                                now = System.currentTimeMillis();
                                connectionInactiveTime = Math.min(now - senderInactiveStart, now - listenerInactiveStart);
                                if (this.checkDebugFlags(4)) {
                                    this.debug("waited " + currentTimeout + "; connectionInactiveTime= " + connectionInactiveTime + "; senderInactive= " + (now - senderInactiveStart) + "; listenerInactive= " + (now - listenerInactiveStart) + " idleTimeout= " + idleTimeout);
                                }
                                if (connectionInactiveTime < idleTimeout) {
                                    lastPingTime = System.currentTimeMillis();
                                    continue;
                                }
                                cc = (IClientContext)this.m_ccs.elementAt(0);
                                if (cc != null && !cc.isMgramQueueEmpty()) {
                                    if (this.checkDebugFlags(4)) {
                                        this.debug("Out queue is not empty - no timeout; inactive= " + connectionInactiveTime);
                                    }
                                    lastPingTime = 0L;
                                    connectionInactiveTime = 0L;
                                    senderInactiveStart = 0L;
                                    continue;
                                }
                                if (this.checkDebugFlags(4)) {
                                    this.debug("Idle connection timeout has expired - closing connection; connectionInactiveTime= " + connectionInactiveTime + " " + cc);
                                }
                                connectionInactiveTime = 0L;
                                senderInactiveStart = 0L;
                                sendDisconnect = true;
                                lastPingTime = System.currentTimeMillis();
                                break;
                            }
                            finally {
                                if (this.m_abort) {
                                    throw new InterruptedException();
                                }
                                newPingTime = this.pingIfIdle(lastPingTime, true, true);
                                if (newPingTime <= lastPingTime) ** GOTO lbl-1000
                                doPing = true;
                                processMsgs = this.m_msgEnqueued;
                            }
                        }
                        if (this.m_abort) {
                            throw new InterruptedException();
                        }
                        prevCanDelayFlush = this.m_canDelayFlush;
                        this.m_canDelayFlush = true;
                        if (doReenqueues) {
                            this.m_hasReenqueues = false;
                        }
                        this.m_msgEnqueued = false;
                        newIdleTimeout = this.m_dequeuedLock;
                        synchronized (newIdleTimeout) {
                            this.m_allDequeued = false;
                        }
                        if (this.m_resetDispatchClass && !this.m_resetDispatchClassCompleted) {
                            this.switchDispatchList();
                            this.m_resetDispatchClassCompleted = true;
                        }
                        this.m_enqueuedLock.notifyAll();
                    }
                    if (doReenqueues) {
                        this.flushReenqueues();
                        doReenqueues = false;
                    }
                    if (doPing) {
                        doPing = false;
                        this.sendThrough(this.getPingMgram());
                        lastPingTime = newPingTime;
                        if (this.checkDebugFlags(4)) {
                            this.debug("ping idle connection at " + lastPingTime);
                        }
                    }
                    if (doFlush) {
                        doFlush = false;
                        var22_18 = this.m_out;
                        synchronized (var22_18) {
                            this.m_out.flush();
                        }
                        hasUnflushedMessages = false;
                        oldestSend = 0L;
                    }
                    if (sendDisconnect) {
                        sendDisconnect = false;
                        var22_18 = this.m_connection;
                        synchronized (var22_18) {
                            if (!this.m_connection.hasTimedOut()) {
                                if (this.checkDebugFlags(4)) {
                                    this.debug("Idle timeout expired - sending disconnect request");
                                }
                                this.m_connection.setTimedOut();
                                this.sendDisconnectAll();
                                hasUnflushedMessages = false;
                                oldestSend = 0L;
                            } else if (this.checkDebugFlags(4)) {
                                this.debug("Connection has already timed out on the remote side");
                            }
                            lastPingTime = System.currentTimeMillis();
                        }
                    }
                    if (this.m_connection.hasTimedOut()) {
                        if (this.checkDebugFlags(4)) {
                            this.debug("Not sending messages because idle timeout has expired");
                        }
                        var22_18 = this.m_dequeuedLock;
                        synchronized (var22_18) {
                            this.m_allDequeued = true;
                            this.m_dequeuedLock.notifyAll();
                        }
                    }
                    if (!processMsgs) {
                        processMsgs = true;
                        continue;
                    }
                    sentOneOrMore = false;
                    dispatchEnum = this.m_dispatchList.getDispatchListEnum();
                    while (dispatchEnum.hasMoreElements()) {
                        cc = null;
                        try {
                            cc = (IClientContext)dispatchEnum.nextElement();
                        }
                        catch (NoSuchElementException ex) {
                            continue;
                        }
                        if (cc == null || (channel = cc.getChannel()) == -1) continue;
                        cloned = false;
                        block59: while (!this.m_abort && (mgram = cc.getNextMgram()) != null) {
                            lastPingTime = this.pingIfIdle(lastPingTime, false, false);
                            if (this.CALLBACK) {
                                this.callback("AgentSender", 0, new Object[]{this.m_connection, mgram});
                            }
                            cloned = false;
                            if (cc.isRemoteBroker() && mgram.supportsRouting() && mgram.getRoutingHandle().isMultiHopRouting()) {
                                try {
                                    if (!cloned) {
                                        mgram = (IMgram)mgram.protectedClone();
                                        cloned = true;
                                    }
                                }
                                catch (CloneNotSupportedException e) {
                                    BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                                }
                                mgram.getRoutingHandle().removeNextRouting(cc.getNodeNameForRemoteBroker());
                            }
                            if (this.CALLBACK) {
                                this.callback("AgentSender 1", 1, new Object[]{mgram, new Boolean(mgram.hasSubject() != false && SessionConfig.isSystemSubject(mgram.getSubject()) == false), this.m_connection});
                            }
                            doingLGIntrumentedMgram = false;
                            if (InterceptorManager.isMessageLGInstrumented(mgram)) {
                                doingLGIntrumentedMgram = true;
                                if (Config.ENABLE_QOPSECURITY && mgram.isSecure() && (SecurityLogic.isMKeyMacHeader(mgram.getSecurity()) || SecurityLogic.isMKeyDigest(mgram.getSecurity()) || SecurityLogic.isMKeyEncryption(mgram.getSecurity()))) {
                                    throw new EAssertFailure("AgentSender.threadMain: incorrect security attributes for LG-instrumented message; " + SecurityLogic.debugStringPrivate(mgram.getSecurity()) + (mgram.hasSubject() != false ? "; topic= " + mgram.getSubject().toString() : ""));
                                }
                                if (!cloned) {
                                    try {
                                        mgram = (IMgram)mgram.protectedClone();
                                        cloned = true;
                                    }
                                    catch (CloneNotSupportedException var29_36) {
                                        // empty catch block
                                    }
                                }
                            }
                            this.m_deliveryContext.guarFormatCorrected = false;
                            this.m_deliveryContext.subjectFilter = mgram.getBrokerHandle().getSubjectFilter(cc.getSubjectFilterId());
                            this.m_deliveryContext.cloned = cloned;
                            if (this.m_protocolAdapter != null) {
                                ASProtocolAdapter.access$502(this.m_protocolAdapter, cc);
                                this.m_deliveryContext.protocolAdapter = this.m_protocolAdapter;
                            }
                            if (doingLGIntrumentedMgram) {
                                if (mgram.isPTP()) {
                                    InterceptorManager.doActionalP2PSendJointPoint(mgram, cc);
                                } else {
                                    InterceptorManager.doActionalPubSubSendJointPoint(mgram, cc);
                                }
                            }
                            if (Config.ENABLE_QOPSECURITY) {
                                this.m_deliveryContext.csc = this.m_connection.getSecurityContext(channel);
                                if (this.m_deliveryContext.csc == null) break;
                                var29_37 = this.m_out;
                                synchronized (var29_37) {
                                    this.m_converter.secureDeliver(mgram, channel, this.m_deliveryContext.csc, this.m_out, this.m_deliveryContext);
                                    sentOneOrMore = true;
                                    this.diagCollectMgram(mgram);
                                }
                            }
                            var29_37 = this.m_out;
                            synchronized (var29_37) {
                                this.m_converter.deliver(mgram, channel, this.m_out, this.m_deliveryContext);
                                sentOneOrMore = true;
                                this.diagCollectMgram(mgram);
                            }
                            if ((AgentSender.m_hasEnabledBytesMetrics || this.m_connection.hasEnabledBytesDelvdMetrics()) && !this.m_isAdminConnection) {
                                mgramLength = mgram.networkLength();
                                this.updateStatistic(AgentSender.m_bytesDeliveredPerSecond, mgramLength);
                                if (this.m_metricsListener == null) {
                                    this.m_connection.updateBytesDelvdStats(mgramLength);
                                }
                            }
                            if (!AgentSender.m_hasEnabledMsgsMetrics && !this.m_connection.hasEnabledMsgsDelvdMetrics() || this.m_isAdminConnection) continue;
                            countMsgs = true;
                            switch (mgram.getType()) {
                                case 12: {
                                    if (cc != null && cc.isQueueBrowser()) {
                                        countMsgs = false;
                                    }
                                }
                                case 2: 
                                case 27: {
                                    if (!mgram.hasSubject() || !countMsgs) break;
                                    subject = mgram.getSubject();
                                    if (SessionConfig.isSystemSubject(subject) || subject.isSonicMQSubject()) continue block59;
                                    size = 1;
                                    if (mgram.supportsOperationHandle()) {
                                        size = mgram.getOperationHandle().getMgramList().size();
                                    }
                                    this.updateStatistic(AgentSender.m_msgsDeliveredPerSecond, size);
                                    this.updateStatistic(AgentSender.m_msgsDelivered, size);
                                    this.m_connection.updateMsgsDelvdStats(size);
                                    break;
                                }
                            }
                        }
                        if (!this.m_abort) continue;
                        throw new InterruptedException();
                    }
                    if (sentOneOrMore && oldestSend == 0L) {
                        oldestSend = System.currentTimeMillis();
                    }
                    doFlushNow = hasUnflushedMessages |= sentOneOrMore;
                    if (Config.BROKER_SEND_DELAY > 0L && hasUnflushedMessages) {
                        if (!sentOneOrMore) {
                            doFlushNow = true;
                        } else if (System.currentTimeMillis() - oldestSend <= Config.BROKER_SEND_DELAY) {
                            var25_26 = this.m_enqueuedLock;
                            synchronized (var25_26) {
                                if (prevCanDelayFlush && this.m_canDelayFlush) {
                                    doFlushNow = false;
                                }
                            }
                        }
                    }
                    if (doFlushNow) {
                        var25_26 = this.m_out;
                        synchronized (var25_26) {
                            this.m_out.flush();
                        }
                        hasUnflushedMessages = false;
                        oldestSend = 0L;
                    }
                    if ((sentOneOrMore || doFlushNow) && !this.m_pingTimeoutEnabled) {
                        lastPingTime = System.currentTimeMillis();
                    }
                    var25_26 = this.m_dequeuedLock;
                    synchronized (var25_26) {
                        this.m_allDequeued = true;
                        this.m_dequeuedLock.notifyAll();
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable var40_52) {
                this.m_senderIsDone = true;
                this.notifyEnqueueDequeueLocks();
                throw var40_52;
            }
            {
                ** while (true)
            }
        }
        catch (IOException e) {
            if (this.DEBUG) {
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
            if (this.DEBUG) {
                this.debug("caught " + e);
            }
            this.fatalError();
        }
        catch (InterruptedException e) {
            if (this.DEBUG) {
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
            if (this.DEBUG) {
                this.debug("interrupted");
            }
            if (this.m_connection != null) {
                this.m_connection.cleanupInstanceStats();
            }
        }
        catch (Exception e) {
            if (this.DEBUG) {
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
            if (this.DEBUG) {
                this.debug("caught " + e);
            }
            e.printStackTrace();
            this.fatalError();
        }
        if (this.checkDebugFlags(64)) {
            this.debug("Exited");
        }
    }

    public void notifyEnqueue(IClientContext cc) {
        this.notifyEnqueue(cc, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyEnqueue(IClientContext cc, boolean okToDelay) {
        Object object = this.m_enqueuedLock;
        synchronized (object) {
            if (!okToDelay) {
                this.m_canDelayFlush = false;
            }
            if (cc != null) {
                this.m_dispatchList.addDispatchable(cc);
            }
            this.m_msgEnqueued = true;
            this.m_enqueuedLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyEnqueueDequeueLocks() {
        Object object = this.m_enqueuedLock;
        synchronized (object) {
            this.m_msgEnqueued = false;
            this.m_enqueuedLock.notifyAll();
        }
        object = this.m_dequeuedLock;
        synchronized (object) {
            this.m_allDequeued = true;
            this.m_dequeuedLock.notifyAll();
        }
    }

    private void sendDisconnectAll() throws IOException {
        Enumeration ccs = this.m_ccs.elements();
        while (ccs.hasMoreElements()) {
            IClientContext cc;
            try {
                cc = (IClientContext)ccs.nextElement();
            }
            catch (NoSuchElementException ex) {
                continue;
            }
            if (cc == null) continue;
            int channel = cc.getChannel();
            IMgram discMgram = MgramFactory.getMgramFactory().buildDisconnectRequest(channel, false);
            this.sendThrough(discMgram);
            if (!m_hasEnabledBytesMetrics && !this.m_connection.hasEnabledBytesDelvdMetrics() || this.m_isAdminConnection) continue;
            long mgramLength = discMgram.networkLength();
            this.updateStatistic(m_bytesDeliveredPerSecond, mgramLength);
            if (this.m_metricsListener != null) continue;
            this.m_connection.updateBytesDelvdStats(mgramLength);
        }
    }

    public boolean isStarted() {
        return this.m_started;
    }

    public void setAbort() {
        this.m_abort = true;
    }

    public void close() {
        this.setAbort();
        this.interrupt();
    }

    protected void setThreadName() {
        ClientSecurityContext csc;
        Object cc;
        StringBuilder threadNameBuf = new StringBuilder(this.m_threadNamePrefix);
        String ccClass = null;
        if (this.m_ccs.size() > 0 && (cc = this.m_ccs.elementAt(0)) != null) {
            ccClass = cc.getClass().getSimpleName();
        }
        if (ccClass == null) {
            ccClass = "ClientContext";
        }
        threadNameBuf.append(" ").append(ccClass);
        if (null != this.m_connection && (csc = this.m_connection.getSecurityContext(0)) != null) {
            threadNameBuf.append(" ").append(csc.getClientId()).append(":").append(csc.getUid()).append(":").append(csc.getAppid());
        }
        this.setThreadName(threadNameBuf.toString());
    }

    protected final void setThreadName(String threadName) {
        if (DebugState.GLOBAL_DEBUG_ON) {
            this.debugName(threadName);
        }
        try {
            this.setName(threadName);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    protected void fatalError() {
        this.m_connection.fatalError();
        this.flushReenqueues();
        if (this.DEBUG) {
            this.debug("thread exiting");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyReenqueue(IAgentQueue q, List msgs, boolean sync, InDoubtQMsgReenqueueEvt idmrEvt) {
        boolean added = false;
        Object object = this.m_reenqueueTable;
        synchronized (object) {
            if (idmrEvt != null) {
                this.m_idmrEvtList.add(idmrEvt);
                if (idmrEvt.getReplOnlyEvt() != null) {
                    this.m_idmrEvtList.add(idmrEvt.getReplOnlyEvt());
                }
                added = true;
            }
            if (msgs != null && !msgs.isEmpty()) {
                Vector prevMsgs = (Vector)this.m_reenqueueTable.get(q);
                if (prevMsgs != null) {
                    msgs.addAll(prevMsgs);
                }
                this.m_reenqueueTable.put(q, msgs);
                added = true;
            }
        }
        if (sync) {
            this.flushReenqueues();
        } else if (added) {
            object = this.m_enqueuedLock;
            synchronized (object) {
                this.m_hasReenqueues = true;
                this.m_enqueuedLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushReenqueues() {
        ArrayList idmrEvtList;
        Hashtable reenqueueTable;
        Hashtable hashtable = this.m_reenqueueTable;
        synchronized (hashtable) {
            reenqueueTable = (Hashtable)this.m_reenqueueTable.clone();
            this.m_reenqueueTable.clear();
            idmrEvtList = this.m_idmrEvtList;
            this.m_idmrEvtList = new ArrayList();
        }
        for (int i = idmrEvtList.size() - 1; i >= 0; --i) {
            LogEvent evt = (LogEvent)idmrEvtList.remove(i);
            AgentRegistrar.getAgentRegistrar().getLogManager().addEvent(evt, true);
        }
        if (reenqueueTable.isEmpty()) {
            return;
        }
        Enumeration queues = reenqueueTable.keys();
        while (queues.hasMoreElements()) {
            IAgentQueue q = (IAgentQueue)queues.nextElement();
            Vector msgs = (Vector)reenqueueTable.remove(q);
            if (this.DEBUG) {
                this.debug(this + ": restoring " + msgs.size() + " msgs to " + q.getQueueName());
            }
            AgentRegistrar.getAgentRegistrar().getQMsgStateMgr().restoreXOnceMsgsToQueue(q, msgs, null);
        }
        reenqueueTable.clear();
        reenqueueTable = null;
    }

    private IBrokerOutBox getOutBoxByChannel(int channel) {
        IBrokerOutBox ob = (IBrokerOutBox)this.m_outboxes.elementAt(channel);
        if (ob != null) {
            return ob;
        }
        return this.m_dummyOutBox;
    }

    @Override
    public String toString() {
        return "AgentSender of " + this.m_connection;
    }

    public static List getMetricsInfo() {
        if (Config.DEBUG) {
            BrokerComponent.getComponentContext().logMessage("AgentSender - getMetricsInfo ", 3);
        }
        ArrayList<IMetricInfo> infos = new ArrayList<IMetricInfo>();
        infos.add(MetricsFactory.createMetricInfo((IMetricIdentity)BROKER_BYTES_DELIVEREDPERSECOND_METRIC, (short)8, (String)"Broker wide bytes delivered per second (includes internal/management messages).", null, (boolean)false, (boolean)true, (boolean)true, (boolean)true, (String)"bytes per second"));
        infos.add(MetricsFactory.createMetricInfo((IMetricIdentity)BROKER_MSGS_DELIVEREDPERSECOND_METRIC, (short)8, (String)"Application messages delivered per second (excludes internal/management messages).", null, (boolean)false, (boolean)true, (boolean)true, (boolean)true, (String)"messages per second"));
        infos.add(MetricsFactory.createMetricInfo((IMetricIdentity)BROKER_MSGS_DELIVERED_METRIC, (short)0, (String)"Application messages delivered since start/reset (excludes internal/management messages).", null, (boolean)false, (boolean)true, (boolean)false, (boolean)false, (String)"messages"));
        return infos;
    }

    public static synchronized void enableMetrics(IMetricsRegistrar metricsRegistrar, IMetricIdentity[] ids) {
        if (Config.DEBUG) {
            String s;
            if (ids == null || ids.length == 0) {
                s = "NONE";
            } else {
                s = "";
                for (int i = 0; i < ids.length; ++i) {
                    s = s + "\n - " + ids[i];
                }
            }
            BrokerComponent.getComponentContext().logMessage("AgentSender - enableMetrics : " + s, 3);
        }
        if (ids == null) {
            throw new NullPointerException("IMetricIdentity ids is null at " + AgentSender.class.getName() + ".enableMetrics(IMetricsRegistrar metricsRegistrar, IMetricIdentity[] ids)");
        }
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i].equals((Object)BROKER_BYTES_DELIVEREDPERSECOND_METRIC) && m_bytesDeliveredPerSecond == null) {
                m_bytesDeliveredPerSecond = StatisticsFactory.createStatistic((short)2, (boolean)true, null, (short)1);
                metricsRegistrar.registerMetric(BROKER_BYTES_DELIVEREDPERSECOND_METRIC, m_bytesDeliveredPerSecond);
            }
            if (ids[i].equals((Object)BROKER_MSGS_DELIVEREDPERSECOND_METRIC) && m_msgsDeliveredPerSecond == null) {
                m_msgsDeliveredPerSecond = StatisticsFactory.createStatistic((short)2, (boolean)true, null, (short)1);
                metricsRegistrar.registerMetric(BROKER_MSGS_DELIVEREDPERSECOND_METRIC, m_msgsDeliveredPerSecond);
            }
            if (!ids[i].equals((Object)BROKER_MSGS_DELIVERED_METRIC) || m_msgsDelivered != null) continue;
            m_msgsDelivered = StatisticsFactory.createStatistic((short)2, (boolean)false, null, (short)0);
            metricsRegistrar.registerMetric(BROKER_MSGS_DELIVERED_METRIC, m_msgsDelivered);
        }
        if (m_bytesDeliveredPerSecond != null) {
            m_hasEnabledBytesMetrics = true;
        }
        if (m_msgsDeliveredPerSecond != null || m_msgsDelivered != null) {
            m_hasEnabledMsgsMetrics = true;
        }
    }

    public static synchronized void disableMetrics(IMetricsRegistrar metricsRegistrar, IMetricIdentity[] ids) {
        if (Config.DEBUG) {
            String s;
            if (ids == null || ids.length == 0) {
                s = "NONE";
            } else {
                s = "";
                for (int i = 0; i < ids.length; ++i) {
                    s = s + "\n - " + ids[i];
                }
            }
            BrokerComponent.getComponentContext().logMessage("AgentSender - disabling metrics = " + s, 3);
        }
        if (ids == null) {
            throw new NullPointerException("IMetricIdentity ids is null at " + AgentSender.class.getName() + ".disableMetrics(IMetricsRegistrar metricsRegistrar, IMetricIdentity[] ids)");
        }
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i].equals((Object)BROKER_BYTES_DELIVEREDPERSECOND_METRIC)) {
                metricsRegistrar.unregisterMetric(ids[i]);
                m_bytesDeliveredPerSecond = null;
            }
            if (ids[i].equals((Object)BROKER_MSGS_DELIVEREDPERSECOND_METRIC)) {
                metricsRegistrar.unregisterMetric(ids[i]);
                m_msgsDeliveredPerSecond = null;
            }
            if (!ids[i].equals((Object)BROKER_MSGS_DELIVERED_METRIC)) continue;
            metricsRegistrar.unregisterMetric(ids[i]);
            m_msgsDelivered = null;
        }
        if (m_bytesDeliveredPerSecond == null) {
            m_hasEnabledBytesMetrics = false;
        }
        if (m_msgsDeliveredPerSecond == null && m_msgsDelivered == null) {
            m_hasEnabledMsgsMetrics = false;
        }
    }

    private void updateStatistic(IStatistic statistic, long value) {
        IStatistic s = statistic;
        if (s != null) {
            s.updateValue(value);
        }
    }

    private void switchDispatchList() throws IOException {
        DispatchListImpl dispatchList = new DispatchListImpl();
        Enumeration enu = this.m_dispatchList.getDispatchListEnum();
        while (enu.hasMoreElements()) {
            Object obj = enu.nextElement();
            dispatchList.addDispatchable(obj);
        }
        this.m_dispatchList = dispatchList;
        if (this.checkDebugFlags(64)) {
            this.debug("Switched DispatchList to " + this.m_dispatchList.getClass().getName());
        }
    }

    public Enumeration getCCs() {
        AutoVec ccs = (AutoVec)this.m_ccs.clone();
        return ccs.elements();
    }

    static {
        BROKER_MSGS_DELIVEREDPERSECOND_METRIC = MetricsFactory.createMetricIdentity((String[])new String[]{"broker", "messages", "DeliveredPerSecond"});
        BROKER_MSGS_DELIVERED_METRIC = MetricsFactory.createMetricIdentity((String[])new String[]{"broker", "messages", "Delivered"});
    }

    private class ASProtocolAdapter
    implements IProtocolAdapter {
        private int m_sessionVersion = 0;
        private IMessageProtection m_mp = null;
        private IMessageProtection m_decryptMp = null;
        private IClientContext m_cc = null;
        private IMgram m_correctedMgram = null;
        private ISubject m_correctedSubject = null;
        private Iterator m_batchIterator = null;
        private Iterator m_subjectIterator = null;
        private IMgram m_batchSubMgram = null;

        public ASProtocolAdapter(AgentConnection conn, IMessageProtection mp, IMessageProtection decryptMp) {
            this.m_sessionVersion = conn.getClientSessionVer();
            this.m_mp = mp;
            this.m_decryptMp = decryptMp;
        }

        @Override
        public final boolean makeProtocolCorrections(IMgram m, MgramDeliveryContext ctx) throws ESecurityGeneralException {
            BrokerSubscription specialBs;
            ISubject subject2;
            boolean correctSubject = false;
            boolean correctReply = false;
            boolean correctGuarFormat = false;
            boolean correctGroupSub = false;
            ISubject groupSub = null;
            if (this.m_sessionVersion < 28) {
                if (m.getSubjectFormat() >= 4) {
                    correctSubject = true;
                }
                if (m.isRequest() && m.getReplyFormat() >= 4) {
                    correctReply = true;
                }
            }
            if (this.m_sessionVersion < 27 && m.getBrokerHandle().isGuarFormatIncorrect()) {
                correctGuarFormat = true;
            }
            if (this.m_sessionVersion < 25 && m.hasSubject() && !SessionConfig.isSystemSubject(subject2 = m.getSubject()) && (specialBs = this.m_cc.getSpecialGroupSubscription()) != null) {
                correctGroupSub = true;
                groupSub = specialBs.getSubject();
            }
            if (!(correctReply || correctSubject || correctGuarFormat || correctGroupSub)) {
                return false;
            }
            if (!ctx.cloned) {
                try {
                    this.m_correctedMgram = (IMgram)m.protectedClone();
                }
                catch (CloneNotSupportedException subject2) {}
            } else {
                this.m_correctedMgram = m;
            }
            if (this.m_correctedMgram.isSecure() && SecurityLogic.isMKeyEncryption(this.m_correctedMgram.getSecurity())) {
                this.m_correctedMgram.getBrokerHandle().decryptMessageWithMessageKey(this.m_decryptMp);
            }
            if (correctSubject) {
                this.m_correctedSubject = this.m_correctedMgram.getSubject();
                if (ctx != null && ctx.subjectFilter != null) {
                    if (AgentSender.this.DEBUG) {
                        AgentSender.this.debug("Making protocol corrections for trk " + m.getGuarenteedTrackingNum() + " subject: " + m.getSubject() + " for " + this.m_cc.getAppid());
                    }
                    this.m_correctedSubject = ctx.subjectFilter.filter(this.m_correctedSubject);
                    if (this.m_correctedSubject == null) {
                        SessionConfig.logMessage(ctx.csc.getAppid() + " Attempt to deliver multitopic message with no subjects: " + m.getSubject(), SessionConfig.WARNING);
                        this.m_correctedMgram = null;
                        return true;
                    }
                    if (!this.m_correctedSubject.isMultiSubject() && this.m_correctedSubject.hasSubjectTracking()) {
                        IXOnceHandle xoh = this.m_cc.getXOnceHandle();
                        if (xoh != null && this.m_correctedMgram.isGuarenteed()) {
                            long sTrk = this.m_correctedSubject.getSubjectTracking();
                            long mTrk = this.m_correctedMgram.getGuarenteedTrackingNum();
                            this.m_correctedMgram.setGuarenteed(mTrk + sTrk);
                            if (xoh.isDNR(m)) {
                                if (AgentSender.this.DEBUG) {
                                    AgentSender.this.debug("Found single DNR message");
                                }
                                this.m_correctedMgram = null;
                                return true;
                            }
                            this.m_correctedMgram.setGuarenteed(mTrk);
                        }
                        this.m_correctedSubject = this.m_correctedSubject.protectedClone().clearSubjectTracking();
                    }
                }
                if (!this.m_correctedSubject.isMultiSubject()) {
                    this.m_correctedMgram.setSubject(this.m_correctedSubject, 3);
                    if (this.m_correctedMgram.getType() == 27) {
                        Iterator i = this.m_correctedMgram.getBatchHandle().getBatchIterator();
                        while (i.hasNext()) {
                            IMgram subMgram = (IMgram)i.next();
                            subMgram.setSubject(this.m_correctedSubject, 3);
                        }
                    }
                }
            }
            if (correctReply) {
                this.m_correctedMgram.setReplyFormat(3);
            }
            if (correctGroupSub) {
                if (AgentSender.this.DEBUG) {
                    AgentSender.this.debug("GroupSubscription special backward compatability handling m_connection.getClientSessionVer()=" + AgentSender.this.m_connection.getClientSessionVer() + "\n  CHANGING elem.getSubject()=" + this.m_correctedMgram.getSubject() + " to " + groupSub);
                }
                this.m_correctedMgram.setSubject(groupSub, 3);
            }
            if (this.m_correctedMgram.getBrokerHandle().isGuarFormatIncorrect()) {
                this.m_correctedMgram.getBrokerHandle().setGuarFormatIncorrect(false);
                if (!this.m_correctedMgram.isGuarenteed()) {
                    this.m_correctedMgram.setGuarenteed(this.m_correctedMgram.getBrokerHandle().getDbTracking());
                } else {
                    this.m_correctedMgram.setReliable();
                }
            }
            if (this.m_correctedSubject != null && this.m_correctedSubject.isMultiSubject()) {
                this.m_subjectIterator = this.m_correctedSubject.getMultiSubjects();
            }
            if (this.m_correctedMgram.getType() == 27 && (this.m_sessionVersion < 26 || this.m_subjectIterator != null)) {
                this.m_batchIterator = this.m_correctedMgram.getBatchHandle().getBatchIterator();
            }
            return true;
        }

        @Override
        public boolean hasCorrected() {
            return this.m_correctedMgram != null;
        }

        @Override
        public IMgram getNextCorrected() throws ESecurityGeneralException {
            IMgram nextCorrected;
            block21: {
                nextCorrected = null;
                if (this.m_batchIterator != null && this.m_batchSubMgram == null) {
                    this.m_batchSubMgram = (IMgram)this.m_batchIterator.next();
                    if (AgentSender.this.DEBUG) {
                        AgentSender.this.debug("Got message from batch mgram trk: " + this.m_batchSubMgram.getGuarenteedTrackingNum() + ", sTrk: " + this.m_batchSubMgram.getSubject().getSubjectTracking());
                    }
                }
                nextCorrected = this.m_batchSubMgram != null ? this.m_batchSubMgram : this.m_correctedMgram;
                if (this.m_subjectIterator != null) {
                    ISubject s = (ISubject)this.m_subjectIterator.next();
                    boolean dnr = false;
                    try {
                        IMgram m = (IMgram)nextCorrected.protectedClone();
                        if (m.isGuarenteed()) {
                            long tracking = m.getGuarenteedTrackingNum();
                            if (AgentSender.this.DEBUG) {
                                AgentSender.this.debug("Splitting mgram with trk: " + m.getGuarenteedTrackingNum() + " and correcting with subject: " + s.getSubjectTracking());
                            }
                            if (!s.hasSubjectTracking()) {
                                throw new EAssertFailure("MultiSubject guaranteed message being delivered to older client with no subject tracking");
                            }
                            m.setGuarenteed(tracking += s.getSubjectTracking());
                            IXOnceHandle xoh = this.m_cc.getXOnceHandle();
                            if (xoh != null && xoh.isDNR(m)) {
                                dnr = true;
                            } else {
                                this.m_cc.addLegacySubjectAckMapping(tracking, nextCorrected.getGuarenteedTrackingNum());
                            }
                        }
                        if (!dnr) {
                            m.setSubject(s.clearSubjectTracking(), 3);
                            nextCorrected = m;
                        }
                        if (!this.m_subjectIterator.hasNext()) {
                            if (this.m_batchIterator != null && this.m_batchIterator.hasNext()) {
                                this.m_batchSubMgram = null;
                                this.m_subjectIterator = this.m_correctedSubject.getMultiSubjects();
                            } else {
                                this.reset();
                            }
                        }
                        if (dnr) {
                            if (AgentSender.this.DEBUG) {
                                AgentSender.this.debug("Found single DNR subject");
                            }
                            return null;
                        }
                        break block21;
                    }
                    catch (CloneNotSupportedException ex) {
                        SessionConfig.logMessage("Error cloning mgram.", ex, SessionConfig.SEVERE);
                        throw new EAssertFailure(ex);
                    }
                }
                nextCorrected = this.m_correctedMgram;
                this.reset();
            }
            if (this.m_sessionVersion >= 26 && nextCorrected.isSecure()) {
                if (SecurityLogic.isMKeyDigest(nextCorrected.getSecurity())) {
                    nextCorrected.getBrokerHandle().macMessageWithMessageKey(this.m_mp);
                    if (SecurityLogic.isMKeyEncryption(nextCorrected.getSecurity())) {
                        nextCorrected.getBrokerHandle().encryptMessageWithMessageKey(this.m_mp);
                    }
                } else if (SecurityLogic.isMKeyMacHeader(nextCorrected.getSecurity())) {
                    nextCorrected.getBrokerHandle().macHeaderWithMessageKey(this.m_mp);
                }
            }
            return nextCorrected;
        }

        public final void reset() {
            this.m_correctedMgram = null;
            this.m_correctedSubject = null;
            this.m_batchIterator = null;
            this.m_subjectIterator = null;
            this.m_batchSubMgram = null;
        }

        static /* synthetic */ IClientContext access$502(ASProtocolAdapter x0, IClientContext x1) {
            x0.m_cc = x1;
            return x0.m_cc;
        }
    }

    class DefaultDispatchList
    extends DebugObject
    implements IDispatchList {
        private int m_itr;

        public DefaultDispatchList(String ident) {
            super(DebugState.GLOBAL_DEBUG_ON ? "DefaultDispatchList " + ident : null);
            if (this.DEBUG && ident == null) {
                this.debugName("DefaultDispatchList " + this.hashCodeHelper());
            }
            if (this.DEBUG) {
                this.debug("Constructed");
            }
        }

        private int hashCodeHelper() {
            return this.hashCode();
        }

        public DefaultDispatchList() {
            this(null);
        }

        @Override
        public final boolean addDispatchable(Object obj) {
            return true;
        }

        @Override
        public final Enumeration getDispatchListEnum() {
            return AgentSender.this.m_ccs.elements();
        }

        final void setIdent(String ident) {
            this.debugName("DefaultDispatchList " + ident);
        }

        @Override
        public final int getPendingSize() {
            return AgentSender.this.m_ccs.size();
        }

        private void itrCtr() {
            ++this.m_itr;
            this.printCounts();
        }

        private void printCounts() {
            if (this.m_itr == 1000) {
                this.debug("Num iterators= " + this.m_itr);
                this.m_itr = 0;
            }
        }
    }
}

