/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.util.Collection;
import java.util.HashSet;
import progress.message.util.EAssertFailure;
import progress.message.zclient.ISubject;
import progress.message.zclient.ISubjectFilter;

public class TrackedSubjectFilter
implements ISubjectFilter {
    HashSet m_validSubjectIds;
    private boolean m_protected = false;

    public TrackedSubjectFilter(HashSet validSubjectIds) {
        this.m_validSubjectIds = validSubjectIds;
    }

    private TrackedSubjectFilter(TrackedSubjectFilter filter) {
        this.m_validSubjectIds = filter.m_validSubjectIds;
    }

    @Override
    public synchronized ISubject filter(ISubject s) {
        if (!s.hasSubjectTracking()) {
            throw new EAssertFailure("Unable to filter untracked subject");
        }
        return s.filterBySubjectTracking(this.m_validSubjectIds);
    }

    @Override
    public synchronized Collection filterTrackingNums(ISubject s) {
        return this.m_validSubjectIds;
    }

    @Override
    public synchronized void removeTrackingNum(ISubject s, short tracking) {
        if (this.m_validSubjectIds != null) {
            this.unprotect();
            this.m_validSubjectIds.remove(new Short(tracking));
        }
    }

    private final void unprotect() {
        if (this.m_protected) {
            this.m_validSubjectIds = (HashSet)this.m_validSubjectIds.clone();
        }
    }

    @Override
    public short filterSize() {
        return (short)this.m_validSubjectIds.size();
    }

    @Override
    public final synchronized ISubjectFilter protectedClone() {
        TrackedSubjectFilter ret = new TrackedSubjectFilter(this);
        ret.m_protected = true;
        ret.m_validSubjectIds = this.m_validSubjectIds;
        this.m_protected = true;
        return ret;
    }
}

