/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.fc;

import com.sonicsw.mq.components.BrokerManagementNotificationsHelper;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Enumeration;
import java.util.HashMap;
import progress.message.broker.AgentConnection;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.broker.Config;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.IClientContext;
import progress.message.broker.INeighbor;
import progress.message.broker.IRemoteBroker;
import progress.message.broker.fc.CCFlowControlTracker;
import progress.message.broker.fc.FCEvent;
import progress.message.client.EGeneralException;
import progress.message.gr.GRFCEvent;
import progress.message.interbroker.IBFCEvent;
import progress.message.interbroker.Interbroker;
import progress.message.msg.IMgram;
import progress.message.msg.MgramFactory;
import progress.message.util.EAssertFailure;
import progress.message.zclient.DebugObject;
import progress.message.zclient.Envelope;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.Message;
import progress.message.zclient.MessageHandler;
import progress.message.zclient.NegotiatedConnectParms;
import progress.message.zclient.Session;
import progress.message.zclient.SessionConfig;

public class FlowControlMonitor
extends DebugObject
implements Runnable {
    public static final String IB_BLOCKED = ".ibblocked";
    public static final String IB_RESUMED = ".ibresumed";
    public static final byte FC_REPORT_IB = 1;
    public static final byte FC_REPORT_GR = 2;
    public static final byte FC_REPORT_TYPE_BLOCK = 1;
    public static final byte FC_REPORT_TYPE_RESUME = 2;
    private long m_pollingInterval;
    private HashMap<Long, CCFlowControlTracker> m_monitoredObjects = new HashMap();
    private boolean m_polling;
    private boolean m_checkAll;
    private Thread m_FCMonitorThread;
    private int m_ctr;
    private volatile boolean m_shutdown;
    private MessageHandler m_mh;

    FlowControlMonitor(int interval) {
        super("FlowControlMonitor");
        this.m_pollingInterval = interval * 1000;
        if (this.DEBUG) {
            this.debug("Constructed; m_pollingInterval= " + this.m_pollingInterval);
        }
    }

    public FlowControlMonitor() {
        this(Config.BROKER_FC_MONITOR_INTERVAL);
    }

    public void init() throws EGeneralException {
        this.m_mh = new MessageHandler();
        this.m_mh.setName("FC admin handler");
        String prefix = Config.getAdminPrefix("*", "*");
        this.m_mh.bind(prefix + IB_BLOCKED, (IMessageHandler)new ReportIBBlocked());
        this.m_mh.bind(prefix + IB_RESUMED, (IMessageHandler)new ReportIBResumed());
        this.m_mh.setGuaranteed(false);
        AgentRegistrar.getAgentRegistrar().getAdminConnection().addMessageHandler(this.m_mh);
        if (this.DEBUG) {
            this.debug("Init; bound handlers");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.checkDebugFlags(64)) {
            this.debug("Shutting down...");
        }
        this.m_shutdown = true;
        try {
            if (this.m_mh != null) {
                AgentRegistrar.getAgentRegistrar().getAdminConnection().removeMessageHandler(this.m_mh);
                this.m_mh = null;
            }
        }
        catch (EGeneralException eGeneralException) {
            // empty catch block
        }
        Thread t = this.m_FCMonitorThread;
        if (t != null) {
            t.interrupt();
        }
        FlowControlMonitor flowControlMonitor = this;
        synchronized (flowControlMonitor) {
            this.m_monitoredObjects = new HashMap();
        }
    }

    public void processFlowControlReport(IClientContext cc, IMgram mg) {
        block6: {
            try {
                ObjectInput in = mg.getPayloadInputStreamHandle();
                byte connectionType = in.readByte();
                byte type = in.readByte();
                if (connectionType == 2) {
                    GRFCEvent evt = new GRFCEvent(type == 2);
                    evt.readEventData(in);
                    if (type == 2) {
                        BrokerManagementNotificationsHelper.sendFlowControlDRAConnectionResumeNotification(Config.BROKER_NAME, evt, evt.priority, evt.destinations[0]);
                    } else {
                        evt.addBlockingCCData(cc);
                        BrokerManagementNotificationsHelper.sendFlowControlDRAConnectionPauseNotification(Config.BROKER_NAME, evt);
                    }
                } else {
                    new EAssertFailure("Unknown connectionType in flow control report " + connectionType);
                }
            }
            catch (Exception ex) {
                if (!this.checkDebugFlags(64)) break block6;
                ex.printStackTrace();
            }
        }
    }

    public void sendFCReport(IClientContext sendingSideCC, IBFCEvent evt) {
        block2: {
            String subject = null;
            Message msg = null;
            subject = evt.isResumedEvt ? SessionConfig.getAdminPrefix(Config.BROKER_UID, "Broker") + IB_RESUMED : SessionConfig.getAdminPrefix(Config.BROKER_UID, "Broker") + IB_BLOCKED;
            msg = new Message(subject);
            try {
                evt.writeEventData(msg);
                Interbroker.getInterbroker().getIBSession().publish(sendingSideCC.getId(), msg);
            }
            catch (IOException ex) {
                if (!this.checkDebugFlags(64)) break block2;
                ex.printStackTrace();
            }
        }
    }

    public void sendFCReport(IClientContext sendingSideCC, GRFCEvent evt) {
        boolean peerSupportsFCEvents = false;
        peerSupportsFCEvents = this.isPeerSupportsFCEvents(peerSupportsFCEvents, sendingSideCC);
        this.sendThroughData(evt, peerSupportsFCEvents, sendingSideCC);
        this.sendFlowControl(evt);
    }

    private void sendThroughData(GRFCEvent evt, boolean peerSupportsFCEventsParam, IClientContext sendingSideCC) {
        block6: {
            boolean peerSupportsFCEvents = peerSupportsFCEventsParam;
            if (sendingSideCC.getClientSessionVer() >= 32) {
                peerSupportsFCEvents = true;
            }
            if (peerSupportsFCEvents) {
                try {
                    IMgram mg = this.buildReportFlowControlMgram();
                    ObjectOutput out = mg.getPayloadOutputStreamHandle();
                    out.writeByte(2);
                    if (evt.isResumedEvt) {
                        out.writeByte(2);
                    } else {
                        out.writeByte(1);
                    }
                    evt.writeEventData(out);
                    sendingSideCC.sendThrough(mg);
                }
                catch (IOException ex) {
                    if (!this.checkDebugFlags(64)) break block6;
                    ex.printStackTrace();
                }
            }
        }
    }

    private void sendFlowControl(GRFCEvent evt) {
        if (evt.isResumedEvt) {
            String qdest = evt.hasPtpData() ? evt.destinations[0] : "";
            BrokerManagementNotificationsHelper.sendFlowControlDRAConnectionSenderResumeNotification(Config.BROKER_NAME, evt, evt.priority, qdest);
        } else {
            if (!evt.hasPtpData() && evt.destinations == null) {
                evt.destinations = new String[0];
            }
            BrokerManagementNotificationsHelper.sendFlowControlDRAConnectionSenderPauseNotification(Config.BROKER_NAME, evt);
        }
    }

    private boolean isPeerSupportsFCEvents(boolean peerSupportsFCEventsParam, IClientContext sendingSideCC) {
        boolean peerSupportsFCEvents = peerSupportsFCEventsParam;
        AgentConnection ac = sendingSideCC.getConnection();
        if (ac != null) {
            NegotiatedConnectParms ncp = null;
            ncp = ac.getNegotiatedConnectParms();
            if (ncp != null) {
                peerSupportsFCEvents = ncp.getSupportsBrokerFCEvents();
            }
        }
        return peerSupportsFCEvents;
    }

    public IMgram buildReportFlowControlMgram() {
        IMgram result = MgramFactory.getMgramFactory().createMgram(true);
        result.setType((byte)38);
        result.setPriority((byte)12);
        result.setRequestReplySend();
        return result;
    }

    public synchronized void startFCMonitor() {
        this.m_FCMonitorThread = new Thread((Runnable)this, "FCMonitor " + ++this.m_ctr);
        this.m_FCMonitorThread.setDaemon(true);
        this.m_FCMonitorThread.start();
    }

    public synchronized void checkStartFCMonitor() {
        if (!(this.m_FCMonitorThread != null || this.m_shutdown || Broker.exiting || Broker.isInShutdown() || this.m_pollingInterval <= 0L || this.m_monitoredObjects.size() <= 0 && !this.m_checkAll)) {
            this.startFCMonitor();
            if (this.checkDebugFlags(64)) {
                this.debug("checkStartFCMonitor: Created FCMonitor Thread " + this.m_FCMonitorThread.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMonitorInterval(int secs) {
        if (secs >= 0) {
            FlowControlMonitor flowControlMonitor = this;
            synchronized (flowControlMonitor) {
                long newValue;
                long oldValue = this.m_pollingInterval;
                if (this.checkDebugFlags(64)) {
                    this.debug("setMonitorInterval: oldValue= " + this.m_pollingInterval / 1000L + " newValue= " + secs);
                }
                if ((newValue = (long)(secs * 1000)) != oldValue) {
                    if (oldValue == 0L) {
                        this.m_checkAll = true;
                    }
                    if (newValue == 0L) {
                        this.m_monitoredObjects = new HashMap();
                    }
                    this.m_pollingInterval = newValue;
                    if (this.m_FCMonitorThread == null) {
                        this.checkStartFCMonitor();
                    } else {
                        this.notifyAll();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(CCFlowControlTracker monitoredObject) {
        boolean added = false;
        FlowControlMonitor flowControlMonitor = this;
        synchronized (flowControlMonitor) {
            if (this.m_pollingInterval <= 0L || this.m_shutdown) {
                return;
            }
            CCFlowControlTracker existingMO = this.retrieveCCFlowControlTracker(monitoredObject);
            added = this.populateMonitoredObjects(added, existingMO, monitoredObject);
        }
        if (added) {
            monitoredObject.reset();
        }
    }

    private boolean populateMonitoredObjects(boolean addedParam, CCFlowControlTracker existingMO, CCFlowControlTracker monitoredObject) {
        boolean added = addedParam;
        if (existingMO == null || existingMO != monitoredObject) {
            if (this.m_polling) {
                this.m_monitoredObjects = (HashMap)this.m_monitoredObjects.clone();
            }
            this.m_monitoredObjects.put(monitoredObject.getCC().getId(), monitoredObject);
            added = true;
            if (this.DEBUG) {
                this.debug("Registered " + monitoredObject + " listsize= " + this.m_monitoredObjects.size());
            }
            this.checkStartFCMonitor();
        } else if (this.DEBUG) {
            this.debug("Register: already registered " + monitoredObject + " listsize= " + this.m_monitoredObjects.size());
        }
        return added;
    }

    private CCFlowControlTracker retrieveCCFlowControlTracker(CCFlowControlTracker monitoredObject) {
        CCFlowControlTracker existingMO = this.m_monitoredObjects.get(monitoredObject.getCC().getId());
        if (existingMO != null && existingMO != monitoredObject && this.checkDebugFlags(64)) {
            this.debug("register: replacing existing CCFlowControlTracker for id " + monitoredObject.getCC().getId());
        }
        return existingMO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(CCFlowControlTracker monitoredObject) {
        FlowControlMonitor flowControlMonitor = this;
        synchronized (flowControlMonitor) {
            CCFlowControlTracker existingMO = this.m_monitoredObjects.get(monitoredObject.getCC().getId());
            if (existingMO != null) {
                if (this.m_polling) {
                    this.m_monitoredObjects = (HashMap)this.m_monitoredObjects.clone();
                }
                this.m_monitoredObjects.remove(monitoredObject.getCC().getId());
                if (this.DEBUG) {
                    this.debug("Unregistered " + monitoredObject + " listsize= " + this.m_monitoredObjects.size());
                }
            } else if (this.DEBUG) {
                this.debug("Unregister: not found " + monitoredObject + " listsize= " + this.m_monitoredObjects.size());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block42: {
            if (this.checkDebugFlags(64)) {
                this.debug(Thread.currentThread().getName() + ": run: Starting; monitor interval= " + this.m_pollingInterval);
            }
            long pollingInterval = -1L;
            boolean check = false;
            FlowControlMonitor flowControlMonitor = this;
            synchronized (flowControlMonitor) {
                check = this.m_checkAll;
                this.m_checkAll = false;
            }
            if (check) {
                this.checkAllBrokerConnections();
            }
            try {
                while (!this.m_shutdown) {
                    Broker.getBroker();
                    if (Broker.isInShutdown() || pollingInterval == 0L) break;
                    HashMap<Long, CCFlowControlTracker> map = null;
                    boolean reset = false;
                    FlowControlMonitor flowControlMonitor2 = this;
                    synchronized (flowControlMonitor2) {
                        block43: {
                            if (pollingInterval == this.m_pollingInterval) {
                                this.wait(pollingInterval);
                            }
                            if (this.m_shutdown) break block42;
                            Broker.getBroker();
                            if (!Broker.isInShutdown()) break block43;
                            break;
                        }
                        map = this.m_monitoredObjects;
                        if (map == null || map.isEmpty()) {
                            break;
                        }
                        if (pollingInterval != this.m_pollingInterval) {
                            if (this.checkDebugFlags(64)) {
                                this.debug(Thread.currentThread().getName() + "; resetting; pollingInterval= " + pollingInterval + " newInterval= " + this.m_pollingInterval + " listSize= " + map.size());
                            }
                            reset = true;
                        }
                        pollingInterval = this.m_pollingInterval;
                        this.m_polling = true;
                    }
                    try {
                        for (CCFlowControlTracker monitoredObject : map.values()) {
                            if (reset) {
                                monitoredObject.reset();
                            }
                            if (pollingInterval == 0L) continue;
                            monitoredObject.onEndInterval();
                        }
                    }
                    finally {
                        flowControlMonitor2 = this;
                        synchronized (flowControlMonitor2) {
                            this.m_polling = false;
                        }
                    }
                }
            }
            catch (InterruptedException ex) {
                if (this.DEBUG) {
                    this.debug(Thread.currentThread().getName() + " was Interrupted");
                }
            }
            finally {
                FlowControlMonitor flowControlMonitor3 = this;
                synchronized (flowControlMonitor3) {
                    this.m_FCMonitorThread = null;
                    if (this.checkDebugFlags(64)) {
                        this.debug("FCMonitor " + Thread.currentThread().getName() + " Exiting; listsize= " + this.m_monitoredObjects.size());
                    }
                }
                this.checkStartFCMonitor();
            }
        }
    }

    private void checkAllBrokerConnections() {
        int numStarted = 0;
        Enumeration rbs = this.retrieveRemoteBrokers();
        numStarted = this.registerAgent(numStarted, rbs);
        if (Config.ENABLE_INTERBROKER) {
            numStarted = 0;
            INeighbor[] narray = this.retrieveNeighor();
            for (int i = 0; i < narray.length; ++i) {
                INeighbor neighbor = narray[i];
                if (!neighbor.isConnected()) {
                    return;
                }
                IClientContext cc = neighbor.getClient();
                if (cc == null || !cc.isConnected()) {
                    return;
                }
                numStarted = this.processTrkStartFCMonitor(cc, numStarted);
            }
        }
    }

    private int registerAgent(int numStartedParam, Enumeration rbs) {
        int numStarted = numStartedParam;
        while (rbs.hasMoreElements()) {
            IRemoteBroker rb = (IRemoteBroker)rbs.nextElement();
            if (rb.isHttp() || rb.isNeighbor()) continue;
            long cid = rb.getClientID();
            IClientContext cc = null;
            try {
                cc = AgentRegistrar.getAgentRegistrar().getClient(cid);
            }
            catch (EClientNotRegistered ecnr) {
                continue;
            }
            if (!cc.isRemoteBroker() || !cc.isConnected()) continue;
            numStarted = this.trkStartFCMonitor(cc, numStarted);
        }
        if (this.checkDebugFlags(64) && numStarted > 0) {
            this.debug("CheckAllBrokerConnections: started fc monitoring for RemoteBrokers, count= " + numStarted);
        }
        return numStarted;
    }

    private int processTrkStartFCMonitor(IClientContext cc, int numStartedParam) {
        int numStarted = numStartedParam;
        numStarted = this.trkStartFCMonitor(cc, numStarted);
        if (this.checkDebugFlags(64) && numStarted > 0) {
            this.debug("CheckAllBrokerConnections: started fc monitoring for Neighbors, count= " + numStarted);
        }
        return numStarted;
    }

    private INeighbor[] retrieveNeighor() {
        INeighbor[] narray = Interbroker.getInterbroker().getActiveNeighbors();
        if (this.DEBUG) {
            this.debug("Checking all active neighbors; count= " + narray.length);
        }
        return narray;
    }

    private Enumeration retrieveRemoteBrokers() {
        if (this.DEBUG) {
            this.debug("Checking all connections...");
        }
        Enumeration rbs = AgentRegistrar.getAgentRegistrar().getRouterManager().getAllRemoteBrokers();
        return rbs;
    }

    private int trkStartFCMonitor(IClientContext cc, int numStartedParam) {
        int numStarted = numStartedParam;
        CCFlowControlTracker trk = cc.getCCFlowControlTracker();
        if (trk != null) {
            trk.startFCMonitor();
            if (this.DEBUG) {
                this.debug("CheckAllBrokerConnections: started fc monitoring: " + trk);
            }
            ++numStarted;
        }
        return numStarted;
    }

    private class ReportIBBlocked
    extends DebugObject
    implements IMessageHandler {
        ReportIBBlocked() {
            super("FlowControlMonitor.ReportIBBlocked");
            if (this.DEBUG) {
                this.debug("FlowControlMonitor.ReportIBBlocked created");
            }
        }

        @Override
        public void handleMessage(Session session, Envelope env) {
            block3: {
                try {
                    Message msg = env.getMessage();
                    IBFCEvent evt = new IBFCEvent(false);
                    ((FCEvent)evt).readEventData(msg);
                    evt.addBlockingCCData();
                    BrokerManagementNotificationsHelper.sendFlowControlIBConnectionPauseNotification(Config.BROKER_NAME, evt);
                }
                catch (EClientNotRegistered msg) {
                }
                catch (IOException ex) {
                    if (!this.checkDebugFlags(64)) break block3;
                    ex.printStackTrace();
                }
            }
        }
    }

    private class ReportIBResumed
    extends DebugObject
    implements IMessageHandler {
        ReportIBResumed() {
            super("FlowControlMonitor.ReportIBResumed");
            if (this.DEBUG) {
                this.debug("FlowControlMonitor.ReportIBResumed created");
            }
        }

        @Override
        public void handleMessage(Session session, Envelope env) {
            block3: {
                try {
                    Message msg = env.getMessage();
                    IBFCEvent evt = new IBFCEvent(true);
                    ((FCEvent)evt).readEventData(msg);
                    BrokerManagementNotificationsHelper.sendFlowControlIBConnectionResumeNotification(Config.BROKER_NAME, evt, evt.priority, evt.destinations[0]);
                }
                catch (EClientNotRegistered msg) {
                }
                catch (IOException ex) {
                    if (!this.checkDebugFlags(64)) break block3;
                    ex.printStackTrace();
                }
            }
        }
    }
}

