/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.mqtt.codec;

import progress.message.broker.mqtt.codec.DemuxEncoder;
import progress.message.broker.mqtt.codec.MqttCodecUtils;
import progress.message.broker.mqtt.proto.MqttException;
import progress.message.broker.mqtt.proto.MqttQoS;
import progress.message.broker.mqtt.proto.MqttSubscription;
import progress.message.broker.mqtt.proto.SubscribeMessage;
import progress.message.util.server.ByteBuffer;
import progress.message.util.server.IByteBuffer;

class SubscribeEncoder
extends DemuxEncoder<SubscribeMessage> {
    SubscribeEncoder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void encode(SubscribeMessage message, IByteBuffer out) {
        if (message.subscriptions().isEmpty()) {
            throw new MqttException("Subscribe with empty subscriptions");
        }
        if (message.getQos() != MqttQoS.AT_LEAST_ONCE) {
            throw new MqttException("Subscribe MUST have QoS 1 (AT_LEAST_ONCE), got QoS = " + (Object)((Object)message.getQos()));
        }
        ByteBuffer variableHeaderBuff = new ByteBuffer(4);
        IByteBuffer buff = null;
        try {
            variableHeaderBuff.writeUnsignedShort(message.getMessageId());
            for (MqttSubscription c : message.subscriptions()) {
                variableHeaderBuff.merge(MqttCodecUtils.encodeString(c.getTopicFilter()));
                variableHeaderBuff.writeByte(c.getQos().value());
            }
            int variableHeaderSize = variableHeaderBuff.countUnread();
            byte flags = MqttCodecUtils.encodeFlags(message);
            buff = new ByteBuffer(2 + variableHeaderSize);
            buff.writeByte(0x80 | flags);
            buff.merge(MqttCodecUtils.encodeRemainingLength(variableHeaderSize));
            buff.merge(variableHeaderBuff);
            out.merge(buff);
        }
        finally {
            variableHeaderBuff.clear();
            buff.clear();
        }
    }
}

