/*
 * Decompiled with CFR 0.152.
 */
package progress.message.dbsc.pse;

import com.odi.ObjectStoreException;
import com.odi.Session;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import progress.message.db.DBFactory;
import progress.message.db.EDatabaseException;
import progress.message.db.pse.PSEBrokerDb;
import progress.message.db.pse.PSEDbContext;
import progress.message.dbsc.pse.DbSchemaCheckGr;
import progress.message.dbsc.pse.DbSchemaCheckPtp;
import progress.message.dbsc.pse.DbSchemaCheckPubSub;
import progress.message.dbsc.pse.DbSchemaCheckReg;
import progress.message.dbsc.pse.ILog;

public class DbSchemaCheck {
    private static String PARM_DBDIR = "DBDIR";
    private static String PARM_BROKER = "BROKER_NAME";
    private static String PARM_CHECK_ALL = "CHECK_ALL";
    private static String PARM_CHECK_PUBSUB = "CHECK_PUBSUB";
    private static String PARM_CHECK_PTP = "CHECK_PTP";
    private static String PARM_CHECK_REG = "CHECK_REG";
    private static String PARM_CHECK_GR = "CHECK_GR";
    String m_dbDir;
    PSEBrokerDb m_pseDb;
    HashMap m_parms;

    public DbSchemaCheck(HashMap parms) {
        this.m_parms = parms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSchemaCheck() throws EDatabaseException {
        Object checker;
        PSEDbContext dbctx;
        Properties props = new Properties();
        props.put("BROKER_NAME", this.m_parms.get(PARM_BROKER));
        props.put("DATABASE_STORE_TYPE", "Embedded");
        props.put("MQSTORE_DB_CONNECT", this.m_parms.get(PARM_DBDIR));
        this.m_pseDb = (PSEBrokerDb)DBFactory.createBrokerDb(props);
        this.m_pseDb.start();
        boolean doPubSub = this.getBooleanValue(PARM_CHECK_PUBSUB);
        boolean doGr = this.getBooleanValue(PARM_CHECK_GR);
        boolean doPtp = this.getBooleanValue(PARM_CHECK_PTP);
        boolean doReg = this.getBooleanValue(PARM_CHECK_REG);
        boolean doAll = this.getBooleanValue(PARM_CHECK_ALL);
        Logger logger = new Logger();
        if (doAll || doPubSub) {
            dbctx = this.m_pseDb.getCtx(3);
            try {
                checker = new DbSchemaCheckPubSub(dbctx.getDatabase(), logger);
                logger.logln("" + new Date());
                logger.logln("Starting pubsub Schema Check; Db= " + dbctx);
                dbctx.getSession().join();
                ((DbSchemaCheckPubSub)checker).checkDb();
            }
            catch (ObjectStoreException ex) {
                ex.printStackTrace();
            }
            finally {
                dbctx.getSession();
                Session.leave();
            }
            this.m_pseDb.close(3);
        }
        if (doGr) {
            dbctx = this.m_pseDb.getCtx(2);
            try {
                checker = new DbSchemaCheckGr(dbctx.getDatabase(), logger);
                logger.logln("" + new Date());
                logger.logln("Starting gr Schema Check; Db= " + dbctx);
                dbctx.getSession().join();
                ((DbSchemaCheckGr)checker).checkDb();
            }
            catch (ObjectStoreException ex) {
                ex.printStackTrace();
            }
            finally {
                dbctx.getSession();
                Session.leave();
            }
            this.m_pseDb.close(2);
        }
        if (doPtp) {
            dbctx = this.m_pseDb.getCtx(4);
            try {
                checker = new DbSchemaCheckPtp(dbctx.getDatabase(), logger);
                logger.logln("" + new Date());
                logger.logln("Starting ptp Schema Check; Db= " + dbctx);
                dbctx.getSession().join();
                ((DbSchemaCheckPtp)checker).checkDb();
            }
            catch (ObjectStoreException ex) {
                ex.printStackTrace();
            }
            finally {
                dbctx.getSession();
                Session.leave();
            }
            this.m_pseDb.close(4);
        }
        if (doReg) {
            dbctx = this.m_pseDb.getCtx(1);
            try {
                checker = new DbSchemaCheckReg(dbctx.getDatabase(), logger);
                logger.logln("" + new Date());
                logger.logln("Starting reg Schema Check; Db= " + dbctx);
                dbctx.getSession().join();
                ((DbSchemaCheckReg)checker).checkDb();
            }
            catch (ObjectStoreException ex) {
                ex.printStackTrace();
            }
            finally {
                dbctx.getSession();
                Session.leave();
            }
            this.m_pseDb.close(1);
        }
        logger.logln("" + new Date() + "Db SchemaCheck exiting");
        DbSchemaCheck dbSchemaCheck = this;
        dbSchemaCheck.m_pseDb.shutdown();
    }

    private boolean getBooleanValue(String parm) {
        boolean bval = false;
        String val = (String)this.m_parms.get(parm);
        if (val != null) {
            bval = Boolean.valueOf(val.trim());
        }
        return bval;
    }

    public static void main(String[] args) {
        String dbDir = null;
        String broker = null;
        HashMap<String, String> parms = new HashMap<String, String>();
        boolean hasCheckParms = false;
        try {
            int i = 0;
            while (i < args.length) {
                if ("-dbDir".equalsIgnoreCase(args[i])) {
                    dbDir = args[i + 1];
                    i += 2;
                    continue;
                }
                if ("-brokerName".equalsIgnoreCase(args[i])) {
                    broker = args[i + 1];
                    i += 2;
                    continue;
                }
                if ("-checkpubsub".equalsIgnoreCase(args[i])) {
                    parms.put(PARM_CHECK_PUBSUB, "true");
                    hasCheckParms = true;
                    ++i;
                    continue;
                }
                if ("-checkgr".equalsIgnoreCase(args[i])) {
                    parms.put(PARM_CHECK_GR, "true");
                    hasCheckParms = true;
                    ++i;
                    continue;
                }
                if ("-checkptp".equalsIgnoreCase(args[i])) {
                    parms.put(PARM_CHECK_PTP, "true");
                    hasCheckParms = true;
                    ++i;
                    continue;
                }
                if ("-checkreg".equalsIgnoreCase(args[i])) {
                    parms.put(PARM_CHECK_REG, "true");
                    hasCheckParms = true;
                    ++i;
                    continue;
                }
                if ("-checkall".equalsIgnoreCase(args[i])) {
                    parms.put(PARM_CHECK_ALL, "true");
                    hasCheckParms = true;
                    ++i;
                    continue;
                }
                throw new Exception("Unrecognized argument " + args[i]);
            }
            if (dbDir == null) {
                throw new Exception("dbDir is null");
            }
            if (broker == null) {
                broker = "Any";
            }
            parms.put(PARM_DBDIR, dbDir);
            parms.put(PARM_BROKER, broker);
            if (!hasCheckParms) {
                parms.put(PARM_CHECK_ALL, "true");
            }
            DbSchemaCheck checker = new DbSchemaCheck(parms);
            checker.doSchemaCheck();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    private class Logger
    implements ILog {
        private Logger() {
        }

        @Override
        public void logln(String s) {
            System.out.println(s);
        }
    }
}

