/*
 * Decompiled with CFR 0.152.
 */
package progress.message.ft;

import com.sonicsw.sonicmq.util.action.ActionProcessor;
import com.sonicsw.sonicmq.util.action.Event;
import com.sonicsw.sonicmq.util.action.PreCondition;
import java.util.Enumeration;
import progress.message.broker.Broker;
import progress.message.broker.BrokerStateManager;
import progress.message.broker.BrokerStatus;
import progress.message.broker.IStateListener;
import progress.message.util.DebugState;
import progress.message.util.EAssertFailure;
import progress.message.util.LongHashTable;
import progress.message.zclient.DebugObject;

public class ActionManager
extends DebugObject
implements IStateListener,
BrokerStatus {
    public static final short LOG_FLUSH_PRECONDITION = 0;
    public static final short REPLICATION_PRECONDITION = 1;
    private LogFlushPrecondition m_logFlushPrecondition = new LogFlushPrecondition();
    private ReplicationPrecondition m_replicationPrecondition = new ReplicationPrecondition();
    private LongHashTable m_events = new LongHashTable();
    private ActionProcessor m_actionProcessor = null;
    private boolean m_isActive = false;

    public ActionManager() {
        super(DebugState.GLOBAL_DEBUG_ON ? "ActionManager" : null);
        try {
            BrokerStateManager.getBrokerStateManager().registerListener(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void stateChanging(int newState) {
    }

    @Override
    public void stateChanged(int newState) throws Exception {
        switch (newState) {
            case 2: 
            case 3: {
                this.startAP();
                break;
            }
            case 1: {
                this.startAP();
                this.fireAllPreconditions((short)1);
                this.m_actionProcessor.waitForFire();
            }
        }
    }

    public boolean reserveRoom(Event evt) {
        ActionProcessor ap = this.m_actionProcessor;
        if (ap != null) {
            return ap.reserveRoom(evt);
        }
        return true;
    }

    public void waitAndReserveRoom(Event evt) throws InterruptedException {
        ActionProcessor ap = this.m_actionProcessor;
        if (ap != null) {
            ap.waitAndReserveRoom(evt);
        }
    }

    public synchronized void start() {
        this.startAP();
    }

    private synchronized void startAP() {
        this.m_isActive = true;
        if (this.m_actionProcessor == null) {
            if (this.DEBUG) {
                this.debug("Action processor started!");
            }
            this.m_actionProcessor = new ActionProcessor();
            this.m_actionProcessor.start();
        }
    }

    public boolean isActionProcessor(Thread t) {
        return t.equals(this.m_actionProcessor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        try {
            ActionManager actionManager = this;
            synchronized (actionManager) {
                this.m_isActive = false;
                if (this.m_actionProcessor == null) {
                    return;
                }
            }
            if (this.DEBUG) {
                this.debug("Action processor shutdown!");
            }
            this.fireAllPreconditions((short)1);
            if (!Broker.exiting) {
                this.m_actionProcessor.waitForFire();
            }
            actionManager = this;
            synchronized (actionManager) {
                this.m_actionProcessor.shutdown();
                this.m_actionProcessor.join();
                this.m_actionProcessor = null;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public synchronized boolean isActive() {
        return this.m_isActive;
    }

    public synchronized boolean addEvent(Event evt, long tracking, boolean isReserved) {
        boolean result = false;
        if (this.isActive()) {
            this.m_events.put(tracking, evt);
            this.m_actionProcessor.addEvent(evt, isReserved);
            result = true;
        }
        return result;
    }

    public synchronized boolean removeEvent(long tracking) {
        if (this.isActive()) {
            Event evt = (Event)this.m_events.remove(tracking);
            if (evt != null) {
                this.m_actionProcessor.removeEvent(evt);
            }
            return true;
        }
        return false;
    }

    boolean onReplicationAck(long tracking) {
        if (this.m_events.get(tracking) == null) {
            return false;
        }
        this.firePrecondition(tracking, (short)1);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireAllPreconditions(short type) {
        Enumeration<Long> keys = null;
        LongHashTable longHashTable = this.m_events;
        synchronized (longHashTable) {
            if (!this.m_events.isEmpty()) {
                keys = ((LongHashTable)this.m_events.clone()).keys();
            }
        }
        if (keys != null) {
            while (keys.hasMoreElements()) {
                Long tracking = keys.nextElement();
                this.firePreconditionInternal(tracking, type, false);
            }
        }
    }

    public void firePrecondition(long tracking, short type) {
        this.firePreconditionInternal(tracking, type, !this.isActive());
    }

    private void firePreconditionInternal(long tracking, short type, boolean syncAction) {
        boolean exec;
        Event evt = (Event)this.m_events.get(tracking);
        if (evt != null && (exec = evt.firePreCondition(this.getPreCondition(type), syncAction))) {
            this.m_events.remove(tracking);
        }
    }

    public PreCondition getPreCondition(short type) {
        switch (type) {
            case 0: {
                return this.m_logFlushPrecondition;
            }
            case 1: {
                return this.m_replicationPrecondition;
            }
        }
        throw new EAssertFailure("Unkown Precondition type: " + type);
    }

    class LogFlushPrecondition
    implements PreCondition {
        LogFlushPrecondition() {
        }

        public boolean equals(Object o) {
            return o == this;
        }

        public int hashCode() {
            return super.hashCode();
        }
    }

    class ReplicationPrecondition
    implements PreCondition {
        ReplicationPrecondition() {
        }

        public boolean equals(Object o) {
            return o == this;
        }

        public int hashCode() {
            return super.hashCode();
        }
    }
}

