/*
 * Decompiled with CFR 0.152.
 */
package progress.message.ft;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.BrokerDatabase;
import progress.message.broker.EBrokerAborted;
import progress.message.broker.prAccessor;
import progress.message.client.EGeneralException;
import progress.message.db.EDatabaseException;
import progress.message.dd.NoDupDetectDb;
import progress.message.msg.IMgram;
import progress.message.msg.MgramFactory;
import progress.message.util.EAssertFailure;

public class FTReflectionOperation {
    public static final int TEST = 0;
    public static final int REGDBQ = 1;
    public static final int QREGDBQ = 2;
    public static final int ROUTINGDBQ = 3;
    public static final int PTPDBQ = 4;
    public static final int PUBSUBDBQ = 5;
    public static final int BROKERDATABASE = 6;
    public static final int DUPDETECTDBQ = 7;
    public static final byte VERSION = 0;
    private ArrayList m_methodList = new ArrayList();

    FTReflectionOperation() {
    }

    FTReflectionOperation(IMgram reflectionMgram) throws IOException, ClassNotFoundException {
        int subType = reflectionMgram.getOperationHandle().getOperationType();
        if (subType != 22) {
            throw new EAssertFailure("Attempt to create reflection op from non-reflection mgram");
        }
        ObjectInput input = reflectionMgram.getPayloadInputStreamHandle();
        input.readByte();
        int methodSize = input.readInt();
        for (int count = 0; count < methodSize; ++count) {
            ReflectionMethod m = new ReflectionMethod(input);
            this.m_methodList.add(m);
        }
    }

    public void addMethod(int component, String method, Class[] paramTypes, Object[] parameters) {
        ReflectionMethod m = new ReflectionMethod(component, method, paramTypes, parameters);
        this.m_methodList.add(m);
    }

    public IMgram createFTReflectionMgram() throws IOException, ClassNotFoundException {
        IMgram result = MgramFactory.getMgramFactory().buildOperationMgram(22);
        ObjectOutput output = result.getPayloadOutputStreamHandle();
        output.writeByte(0);
        int size = this.m_methodList.size();
        output.writeInt(this.m_methodList.size());
        for (ReflectionMethod m : this.m_methodList) {
            m.writeMethod(output);
        }
        return result;
    }

    public void execute() throws NoSuchMethodException, IllegalAccessException {
        this.execute(null);
    }

    public void execute(Object testObject) throws NoSuchMethodException, IllegalAccessException {
        for (ReflectionMethod m : this.m_methodList) {
            if (testObject != null) {
                m.setTestObject(testObject);
            }
            try {
                m.execute();
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
    }

    class ReflectionMethod {
        private int m_component;
        private String m_method;
        private Object[] m_parameters;
        private Class[] m_paramTypes;
        private Object m_testObject;

        ReflectionMethod(int component, String method, Class[] paramTypes, Object[] parameters) {
            this.m_component = component;
            this.m_method = method;
            this.m_paramTypes = paramTypes;
            this.m_parameters = parameters;
        }

        ReflectionMethod(ObjectInput in) throws IOException, ClassNotFoundException {
            this.m_component = in.readInt();
            this.m_method = in.readUTF();
            int paramSize = in.readInt();
            this.m_paramTypes = new Class[paramSize];
            this.m_parameters = new Object[paramSize];
            for (int count = 0; count < paramSize; ++count) {
                this.readParamType(in, count);
                this.m_parameters[count] = in.readObject();
            }
        }

        void setTestObject(Object test) {
            this.m_testObject = test;
        }

        void writeMethod(ObjectOutput output) throws IOException {
            output.writeInt(this.m_component);
            output.writeUTF(this.m_method);
            if (this.m_parameters != null) {
                int paramSize = this.m_parameters.length;
                output.writeInt(paramSize);
                for (int count = 0; count < paramSize; ++count) {
                    Object param = this.m_parameters[count];
                    Class paramType = this.m_paramTypes[count];
                    this.writeParamType(paramType, output);
                    output.writeObject(param);
                }
            } else {
                output.writeInt(0);
            }
        }

        private void readParamType(ObjectInput in, int count) throws IOException, ClassNotFoundException {
            boolean isPrimitive = in.readBoolean();
            String className = in.readUTF();
            if (isPrimitive) {
                if (className.equals(Integer.TYPE.getName())) {
                    this.m_paramTypes[count] = Integer.TYPE;
                } else if (className.equals(Short.TYPE.getName())) {
                    this.m_paramTypes[count] = Short.TYPE;
                } else if (className.equals(Boolean.TYPE.getName())) {
                    this.m_paramTypes[count] = Boolean.TYPE;
                } else if (className.equals(Long.TYPE.getName())) {
                    this.m_paramTypes[count] = Long.TYPE;
                } else if (className.equals(Byte.TYPE.getName())) {
                    this.m_paramTypes[count] = Byte.TYPE;
                } else if (className.equals(Character.TYPE.getName())) {
                    this.m_paramTypes[count] = Character.TYPE;
                } else if (className.equals(Float.TYPE.getName())) {
                    this.m_paramTypes[count] = Float.TYPE;
                } else if (className.equals(Double.TYPE.getName())) {
                    this.m_paramTypes[count] = Double.TYPE;
                }
            } else {
                this.m_paramTypes[count] = Class.forName(className);
            }
        }

        private void writeParamType(Class paramType, ObjectOutput output) throws IOException {
            output.writeBoolean(paramType.isPrimitive());
            output.writeUTF(paramType.getName());
        }

        void execute() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
            Object instance = this.getObjectInstance();
            if (instance == null) {
                throw new NoSuchMethodException("Component does not exist");
            }
            Method m = instance.getClass().getMethod(this.m_method, this.m_paramTypes);
            m.invoke(instance, this.m_parameters);
        }

        private Object getObjectInstance() {
            if (this.m_component == 0) {
                return this.m_testObject;
            }
            BrokerDatabase database = AgentRegistrar.getAgentRegistrar().getBrokerDatabase();
            if (database == null) {
                throw new NullPointerException("'database' is null at " + FTReflectionOperation.class.getName() + ".getObjectInstance()");
            }
            switch (this.m_component) {
                case 1: {
                    return database.getIRegDBQ();
                }
                case 3: {
                    return database.getIRoutingDBQ();
                }
                case 4: {
                    return database.getIPtpDBQ();
                }
                case 5: {
                    return database.getIPubSubDBQ();
                }
                case 6: {
                    return database;
                }
                case 7: {
                    try {
                        return NoDupDetectDb.getConnection().getDupDetectDBQ();
                    }
                    catch (EDatabaseException e) {
                        try {
                            BrokerComponent.getBrokerComponent().abort(prAccessor.getString(prAccessor.getString("DUP_DETECT_ERROR")), e, 0);
                            break;
                        }
                        catch (EBrokerAborted eba) {
                            return null;
                        }
                    }
                    catch (EGeneralException e) {
                        e.printStackTrace();
                        break;
                    }
                }
            }
            return null;
        }
    }
}

