/*
 * Decompiled with CFR 0.152.
 */
package progress.message.interbroker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Objects;
import java.util.Vector;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.FTPairPeerInfoHolder;
import progress.message.broker.RoutingConfiguration;
import progress.message.broker.RoutingConnectionInfo;
import progress.message.client.EGeneralException;
import progress.message.db.EDatabaseException;
import progress.message.interbroker.BrokerAddedEvent;
import progress.message.interbroker.BrokerDeletedEvent;
import progress.message.interbroker.BrokerRemovedEvent;
import progress.message.interbroker.CollectiveDeletedEvent;
import progress.message.interbroker.IBConfigBean;
import progress.message.interbroker.IBConfigEvent;
import progress.message.interbroker.IBConfiguration;
import progress.message.interbroker.IBDBReinitEvent;
import progress.message.interbroker.InterbrokerConfig;
import progress.message.interbroker.NewBrokerEvent;
import progress.message.interbroker.NewCollectiveEvent;
import progress.message.interbroker.RoutingAddedEvent;
import progress.message.interbroker.RoutingDeletedEvent;
import progress.message.interbroker.RoutingUpdatedEvent;
import progress.message.interbroker.UpdateBrokerEvent;
import progress.message.interbroker.admin.EAlreadyInCluster;
import progress.message.interbroker.admin.EBrokerNotIsolated;
import progress.message.interbroker.admin.EClusterNotEmpty;
import progress.message.interbroker.admin.ECycleFormed;
import progress.message.interbroker.admin.EDuplicateClusterName;
import progress.message.interbroker.admin.ENoSuchBroker;
import progress.message.interbroker.admin.ENoSuchCluster;
import progress.message.interbroker.prAccessor;
import progress.message.resources.prMessageFormat;
import progress.message.util.LongHashTable;
import progress.message.zclient.SubjectUtil;

final class IBConfigBeanCache
implements Serializable {
    private LongHashTable m_brokers;
    private LongHashTable m_collectives;
    private transient RoutingConfiguration m_routingConfig = null;
    private transient IBConfigBean m_parent;
    private long m_basic_starttime;
    private long m_starttime;
    private int m_vtime;

    IBConfigBeanCache(IBConfigBean parent, Hashtable peers, String clusterName) throws EDatabaseException {
        this.m_parent = parent;
        this.m_brokers = new LongHashTable();
        this.m_collectives = new LongHashTable();
        this.m_starttime = this.m_basic_starttime = AgentRegistrar.getAgentRegistrar().getLogTime();
        this.m_vtime = 1;
        this.m_routingConfig = AgentRegistrar.getAgentRegistrar().getRoutingConfig();
        AgentRegistrar.getAgentRegistrar().setCollective(clusterName);
        Enumeration enu = peers.keys();
        Vector<String> membs = new Vector<String>();
        while (enu.hasMoreElements()) {
            String brokerName = (String)enu.nextElement();
            FTPairPeerInfoHolder info = (FTPairPeerInfoHolder)peers.get(brokerName);
            membs.addElement(brokerName);
            InnerBroker b = new InnerBroker(brokerName, info);
            this.m_brokers.put(b.getId(), b);
        }
        if (InterbrokerConfig.DEBUG) {
            BrokerComponent.getComponentContext().logMessage("IBConfigBeanCache: initializing cluster " + clusterName, 3);
        }
        InnerCollective c = new InnerCollective(clusterName);
        this.m_collectives.put(c.getId(), c);
        int numMembs = membs.size();
        for (int j = 0; j < numMembs; ++j) {
            InnerBroker b = (InnerBroker)this.m_brokers.get(IBConfigBeanCache.nameToId((String)membs.elementAt(j)));
            if (b == null) {
                BrokerComponent.getComponentContext().logMessage("Unknown broker " + membs.elementAt(j) + " in cluster " + c.getName(), 2);
                continue;
            }
            b.addCollective(c);
            c.addBroker(b);
        }
    }

    RoutingConfiguration getRoutingConfig() {
        return this.m_routingConfig;
    }

    void setRoutingConfig(RoutingConfiguration routingConfig) {
        this.m_routingConfig = routingConfig;
    }

    IBConfiguration getConfiguration(String brokerName) {
        Enumeration<Object> cols;
        InnerBroker broker = null;
        Vector<String> retBroks = new Vector<String>();
        Vector<FTPairPeerInfoHolder> retInfos = new Vector<FTPairPeerInfoHolder>();
        Vector<String> retCols = new Vector<String>();
        Vector retMembs = new Vector();
        boolean wholeNet = false;
        if (brokerName == null || brokerName.equals("")) {
            wholeNet = true;
            cols = this.m_collectives.elements();
            Enumeration broks = this.m_brokers.elements();
            while (broks.hasMoreElements()) {
                InnerBroker b = (InnerBroker)broks.nextElement();
                retBroks.addElement(b.getName());
                retInfos.addElement(b.getPeerInfo());
            }
        } else {
            broker = (InnerBroker)this.m_brokers.get(IBConfigBeanCache.nameToId(brokerName));
            if (broker == null) {
                return new IBConfiguration(new Vector(0), new Vector(0), new Vector(0), new Vector(0));
            }
            cols = broker.getCollectives().elements();
        }
        while (cols.hasMoreElements()) {
            InnerCollective c = (InnerCollective)cols.nextElement();
            retCols.addElement(c.getName());
            Vector broks = c.getMembers();
            int numBroks = broks.size();
            Vector<String> membs = new Vector<String>(numBroks);
            for (int i = 0; i < numBroks; ++i) {
                InnerBroker b = (InnerBroker)broks.elementAt(i);
                if (!b.equals(broker)) {
                    membs.addElement(b.getName());
                }
                if (wholeNet) continue;
                retBroks.addElement(b.getName());
                retInfos.addElement(b.getPeerInfo());
            }
            retMembs.addElement(membs);
        }
        return new IBConfiguration(retBroks, retInfos, retCols, retMembs);
    }

    boolean existsBroker(int brokerUid) {
        return this.m_brokers.containsKey(brokerUid);
    }

    long getBasicStartTime() {
        return this.m_basic_starttime;
    }

    long getStartTime() {
        return this.m_starttime;
    }

    NewCollectiveEvent prepareNewCollectiveEvent(String collectiveName) throws EDuplicateClusterName {
        if (this.m_collectives.containsKey(IBConfigBeanCache.nameToId(collectiveName))) {
            throw new EDuplicateClusterName(prAccessor.getString("STR078") + collectiveName);
        }
        return new NewCollectiveEvent(this.m_parent, this.m_starttime, this.m_vtime + 1, collectiveName);
    }

    void processNewCollectiveEvent(NewCollectiveEvent evt) {
        InnerCollective c = new InnerCollective(evt.getCollective());
        this.m_collectives.put(c.getId(), c);
    }

    CollectiveDeletedEvent prepareCollectiveDeletedEvent(String collectiveName) throws EClusterNotEmpty {
        InnerCollective c = (InnerCollective)this.m_collectives.get(IBConfigBeanCache.nameToId(collectiveName));
        if (c == null) {
            return null;
        }
        if (c.getMembers().size() > 0) {
            throw new EClusterNotEmpty(prMessageFormat.format(prAccessor.getString("STR073"), new Object[]{collectiveName}));
        }
        return new CollectiveDeletedEvent(this.m_parent, this.m_starttime, this.m_vtime + 1, collectiveName);
    }

    void processCollectiveDeletedEvent(CollectiveDeletedEvent evt) {
        this.m_collectives.remove(IBConfigBeanCache.nameToId(evt.getCollective()));
    }

    IBConfigEvent prepareNewBrokerEvent(String brokerName, FTPairPeerInfoHolder info) {
        InnerBroker b = (InnerBroker)this.m_brokers.get(IBConfigBeanCache.nameToId(brokerName));
        if (b == null) {
            return new NewBrokerEvent(this.m_parent, this.m_starttime, this.m_vtime + 1, brokerName, info);
        }
        return new UpdateBrokerEvent(this.m_parent, this.m_starttime, this.m_vtime + 1, brokerName, info);
    }

    void processNewBrokerEvent(NewBrokerEvent evt) {
        InnerBroker b = new InnerBroker(evt.getBroker(), evt.getInfo());
        this.m_brokers.put(b.getId(), b);
    }

    void processUpdateBrokerEvent(UpdateBrokerEvent evt) {
        InnerBroker b = (InnerBroker)this.m_brokers.get(IBConfigBeanCache.nameToId(evt.getBroker()));
        if (b != null) {
            b.setPeerInfo(evt.getInfo());
        }
    }

    BrokerDeletedEvent prepareBrokerDeletedEvent(String brokerName) throws EBrokerNotIsolated {
        InnerBroker b = (InnerBroker)this.m_brokers.get(IBConfigBeanCache.nameToId(brokerName));
        if (b == null) {
            return null;
        }
        if (!b.getCollectives().isEmpty()) {
            throw new EBrokerNotIsolated(prMessageFormat.format(prAccessor.getString("STR079"), new Object[]{brokerName}));
        }
        return new BrokerDeletedEvent(this.m_parent, this.m_starttime, this.m_vtime + 1, brokerName);
    }

    void processBrokerDeletedEvent(BrokerDeletedEvent evt) {
        this.m_brokers.remove(IBConfigBeanCache.nameToId(evt.getBroker()));
    }

    BrokerAddedEvent prepareBrokerAddedEvent(String collective, String broker) throws ENoSuchCluster, ENoSuchBroker, EAlreadyInCluster, ECycleFormed {
        InnerCollective c = (InnerCollective)this.m_collectives.get(IBConfigBeanCache.nameToId(collective));
        if (c == null) {
            throw new ENoSuchCluster(prAccessor.getString("STR080") + collective);
        }
        InnerBroker b = (InnerBroker)this.m_brokers.get(IBConfigBeanCache.nameToId(broker));
        if (b == null) {
            throw new ENoSuchBroker(prAccessor.getString("STR081") + broker);
        }
        if (c.getMembers().contains(b)) {
            throw new EAlreadyInCluster(prAccessor.getString("STR076") + prMessageFormat.format(prAccessor.getString("STR012"), new Object[]{broker, collective}));
        }
        if (this.isReachable(c, b, null)) {
            throw new ECycleFormed(prAccessor.getString("STR077") + prMessageFormat.format(prAccessor.getString("STR012"), new Object[]{broker, collective}));
        }
        Vector membs = c.getMembers();
        int numMembs = membs.size();
        String[] membnames = new String[numMembs + 1];
        FTPairPeerInfoHolder[] membhosts = new FTPairPeerInfoHolder[numMembs + 1];
        for (int i = 0; i < numMembs; ++i) {
            InnerBroker m = (InnerBroker)membs.elementAt(i);
            membnames[i] = m.getName();
            membhosts[i] = m.getPeerInfo();
        }
        membnames[numMembs] = broker;
        membhosts[numMembs] = b.getPeerInfo();
        return new BrokerAddedEvent(this.m_parent, this.m_starttime, this.m_vtime + 1, broker, b.getPeerInfo(), collective, membnames, membhosts);
    }

    void processBrokerAddedEvent(BrokerAddedEvent evt) {
        InnerCollective c = (InnerCollective)this.m_collectives.get(IBConfigBeanCache.nameToId(evt.getCollective()));
        InnerBroker b = (InnerBroker)this.m_brokers.get(IBConfigBeanCache.nameToId(evt.getBroker()));
        if (c != null && b != null) {
            c.addBroker(b);
            b.addCollective(c);
        }
    }

    BrokerRemovedEvent prepareBrokerRemovedEvent(String collective, String broker) {
        InnerCollective c = (InnerCollective)this.m_collectives.get(IBConfigBeanCache.nameToId(collective));
        InnerBroker b = (InnerBroker)this.m_brokers.get(IBConfigBeanCache.nameToId(broker));
        if (c == null || b == null || !c.getMembers().contains(b)) {
            return null;
        }
        return new BrokerRemovedEvent(this.m_parent, this.m_starttime, this.m_vtime + 1, broker, collective);
    }

    void processBrokerRemovedEvent(BrokerRemovedEvent evt) {
        InnerCollective c = (InnerCollective)this.m_collectives.get(IBConfigBeanCache.nameToId(evt.getCollective()));
        InnerBroker b = (InnerBroker)this.m_brokers.get(IBConfigBeanCache.nameToId(evt.getBroker()));
        if (c != null && b != null) {
            c.removeBroker(b);
            b.removeCollective(c);
        }
    }

    IBDBReinitEvent prepareIBDBReinitEvent() {
        return new IBDBReinitEvent(this.m_parent, 0L, 0);
    }

    RoutingAddedEvent prepareRoutingAddedEvent(RoutingConnectionInfo routing) {
        return new RoutingAddedEvent(this.m_parent, this.m_starttime, this.m_vtime + 1, routing);
    }

    void processRoutingAddedEvent(RoutingAddedEvent evt) {
        this.m_routingConfig.setRoutingConnection(evt.getRouting());
    }

    RoutingUpdatedEvent prepareRoutingUpdatedEvent(RoutingConnectionInfo routing, boolean setPassword) {
        return new RoutingUpdatedEvent(this.m_parent, this.m_starttime, this.m_vtime + 1, routing, setPassword);
    }

    void processRoutingUpdatedEvent(RoutingUpdatedEvent evt) {
        this.m_routingConfig.setRoutingConnection(evt.getRouting());
    }

    RoutingDeletedEvent prepareRoutingDeletedEvent(String routingNodeName) throws EGeneralException {
        if (this.m_routingConfig.existsRoutingConnection(routingNodeName)) {
            return new RoutingDeletedEvent(this.m_parent, this.m_starttime, this.m_vtime + 1, routingNodeName);
        }
        EGeneralException e = new EGeneralException(1, prAccessor.getString("STR075"));
        throw e;
    }

    void processRoutingDeletedEvent(RoutingDeletedEvent evt) {
        this.m_routingConfig.deleteRoutingConnection(evt.getRoutingNodeName());
    }

    boolean processEvent(IBConfigEvent evt) {
        if (evt.getStartTime() != this.m_starttime) {
            return false;
        }
        int evttime = evt.getVTime();
        if (evttime <= this.m_vtime) {
            return false;
        }
        if (evttime > this.m_vtime + 1) {
            BrokerComponent.getComponentContext().logMessage("Warning: received interbroker config update out of sequence: " + evttime + " (expected " + (this.m_vtime + 1) + ")", 2);
        }
        this.m_vtime = evttime;
        if (!evt.isRoutingConfigEvent() || this.m_routingConfig != null) {
            evt.callProcessMethod(this);
        }
        return true;
    }

    void setTheBean(IBConfigBean bean) {
        this.m_parent = bean;
    }

    private boolean isReachable(InnerCollective target, InnerBroker start, InnerCollective exclude) {
        Vector cols = start.getCollectives();
        if (cols.contains(target)) {
            return true;
        }
        int numCols = cols.size();
        for (int i = 0; i < numCols; ++i) {
            InnerCollective c = (InnerCollective)cols.elementAt(i);
            if (c == exclude) continue;
            Vector broks = c.getMembers();
            int numBroks = broks.size();
            for (int j = 0; j < numBroks; ++j) {
                InnerBroker b = (InnerBroker)broks.elementAt(j);
                if (b == start || !this.isReachable(target, b, c)) continue;
                return true;
            }
        }
        return false;
    }

    static int nameToId(String name) {
        return SubjectUtil.computeSCode(name, 0, name.length());
    }

    final class InnerBroker
    implements Serializable {
        private int m_id;
        private String m_name;
        private FTPairPeerInfoHolder m_info;
        private Vector m_collectives;

        InnerBroker(String name, FTPairPeerInfoHolder info) {
            this.m_name = name;
            this.m_info = info;
            this.m_collectives = new Vector();
            this.m_id = IBConfigBeanCache.nameToId(name);
        }

        int getId() {
            return this.m_id;
        }

        String getName() {
            return this.m_name;
        }

        FTPairPeerInfoHolder getPeerInfo() {
            return this.m_info;
        }

        Vector getCollectives() {
            return this.m_collectives;
        }

        void setPeerInfo(FTPairPeerInfoHolder info) {
            this.m_info = info;
        }

        void addCollective(InnerCollective col) {
            this.m_collectives.addElement(col);
        }

        void removeCollective(InnerCollective col) {
            this.m_collectives.removeElement(col);
        }

        public boolean equals(Object obj) {
            return obj instanceof InnerBroker && ((InnerBroker)obj).getId() == this.m_id;
        }

        public int hashCode() {
            return Objects.hash(this.m_id);
        }

        public String toString() {
            return this.m_name;
        }
    }

    final class InnerCollective
    implements Serializable {
        private int m_id;
        private String m_name;
        private Vector m_brokers;

        InnerCollective(String name) {
            this.m_name = name;
            this.m_brokers = new Vector();
            this.m_id = IBConfigBeanCache.nameToId(name);
        }

        int getId() {
            return this.m_id;
        }

        String getName() {
            return this.m_name;
        }

        Vector getMembers() {
            return this.m_brokers;
        }

        void addBroker(InnerBroker b) {
            this.m_brokers.addElement(b);
        }

        void removeBroker(InnerBroker b) {
            this.m_brokers.removeElement(b);
        }

        public boolean equals(Object obj) {
            return obj instanceof InnerCollective && ((InnerCollective)obj).getId() == this.m_id;
        }

        public int hashCode() {
            return Objects.hash(this.m_id);
        }

        public String toString() {
            return this.m_name;
        }
    }
}

