/*
 * Decompiled with CFR 0.152.
 */
package progress.message.jimpl;

import java.io.IOException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.Queue;
import progress.message.client.EGeneralException;
import progress.message.client.EInvalidSubjectSyntax;
import progress.message.client.ENetworkFailure;
import progress.message.client.ENotConnected;
import progress.message.client.EParameterIsNull;
import progress.message.client.ESecurityPolicyViolation;
import progress.message.client.EUnusableConnection;
import progress.message.client.prAccessor;
import progress.message.jimpl.Connection;
import progress.message.jimpl.DestUtil;
import progress.message.jimpl.JMSExceptionUtil;
import progress.message.jimpl.Message;
import progress.message.jimpl.Session;
import progress.message.util.QueueUtil;
import progress.message.zclient.Envelope;
import progress.message.zclient.IJobResolver;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.MessageHandler;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.Subscription;

public class QueueBrowser
implements progress.message.jclient.QueueBrowser {
    Session m_jsession = null;
    Queue m_jqueue = null;
    String m_queueName = null;
    private IMessageHandler m_ihandler;
    private IMessageHandler m_EOBhandler;
    BrowseMessagesQueue m_rxQueue = new BrowseMessagesQueue();
    String m_selectorString = null;
    private MessageHandler m_zmessageHandler = null;
    private Subscription m_subscription = null;
    private Subscription m_EOBsubscription = null;
    progress.message.zclient.Connection m_zconnection = null;
    private Connection m_jconnection = null;
    private int m_outstandingRequested = 0;
    private int m_prefetchThreshold = 0;
    private int m_prefetchCount = 1;
    private progress.message.zclient.Message m_getMessage = null;
    private Envelope m_getEnvelope = null;
    boolean m_closing = false;
    boolean m_closedByReconnect = false;
    private boolean m_endOfBrowse = false;
    private String m_appid;
    private String m_uid;

    public QueueBrowser(Session session, Queue queue) throws JMSException {
        this(session, queue, null);
    }

    public QueueBrowser(Session session, Queue queue, String messageSelector) throws JMSException {
        if (queue == null) {
            throw new InvalidDestinationException(prAccessor.getString("DEST_Q_NULL"));
        }
        String routingNodeName = DestUtil.getRoutingName(queue);
        String localRoutingNodeName = session.m_jconnection.getRoutingNodeName();
        if (routingNodeName != null && !routingNodeName.equals(localRoutingNodeName) && !"".equals(routingNodeName)) {
            throw new InvalidDestinationException(prAccessor.getString("QUEUEBROWSER_CANNOT_USE_REMOTE_QUEUE"));
        }
        this.m_jsession = session;
        this.m_jconnection = session.m_jconnection;
        this.m_selectorString = messageSelector;
        try {
            this.m_jqueue = queue;
            this.m_zmessageHandler = new DefaultHandler();
            this.m_zmessageHandler.setGuaranteed(true);
            this.m_zconnection = new progress.message.zclient.Connection("$QB$", null, this.m_zmessageHandler);
            this.m_jconnection.addZConnection(this.m_zconnection);
            long parentID = this.m_jsession.m_zconnection.getClientId();
            this.m_zconnection.connect(this.m_jconnection.m_zconnection, parentID);
            this.m_appid = this.m_zconnection.getApplicationId();
            this.m_uid = this.m_zconnection.getEffectiveUid();
            this.m_zconnection.startDelivery();
            this.m_ihandler = new IHandler();
            this.m_queueName = DestUtil.getDestinationName(this.m_jqueue);
            String subject = this.deliverySubject(this.m_queueName);
            this.m_subscription = this.m_zmessageHandler.getSession().subscribe(subject);
            if (this.m_queueName.equals("SonicMQ.deadMessage") || this.m_queueName.startsWith("SonicMQ.routingQueue") || this.m_queueName.startsWith("SonicMQ.delayedDeliveryQueue")) {
                this.m_zmessageHandler.bind("$Q.#", this.m_ihandler);
            } else {
                this.m_zmessageHandler.bind(subject, this.m_ihandler);
            }
            try {
                this.m_selectorString = messageSelector;
                this.makeOpenRequest(this.m_selectorString);
            }
            catch (JMSException e) {
                this.m_jconnection.removeZConnection(this.m_zconnection);
                this.m_zconnection.disconnect(true);
                throw e;
            }
            session.addBrowser(this);
            String EOBsubject = this.endOfBrowseSubject();
            this.m_EOBhandler = new EOBHandler();
            this.m_EOBsubscription = this.m_zmessageHandler.getSession().subscribe(EOBsubject);
            this.m_zmessageHandler.bind(EOBsubject, this.m_EOBhandler);
            this.prepareGetRequest();
            this.makeGetRequest();
        }
        catch (ESecurityPolicyViolation espv) {
            if (this.m_zconnection != null) {
                this.m_zconnection.cleanUp();
            }
            throw JMSExceptionUtil.createJMSException(espv);
        }
        catch (EParameterIsNull epis) {
            if (this.m_zconnection != null) {
                this.m_zconnection.cleanUp();
            }
            throw JMSExceptionUtil.createJMSException(epis);
        }
        catch (EInvalidSubjectSyntax eiss) {
            if (this.m_zconnection != null) {
                this.m_zconnection.cleanUp();
            }
            throw JMSExceptionUtil.createJMSException(eiss);
        }
        catch (ENetworkFailure enf) {
            if (this.m_zconnection != null) {
                this.m_zconnection.cleanUp();
            }
            throw JMSExceptionUtil.createJMSException(enf);
        }
        catch (EUnusableConnection euc) {
            if (this.m_zconnection != null) {
                this.m_zconnection.cleanUp();
            }
            throw JMSExceptionUtil.createJMSException(euc);
        }
        catch (EGeneralException ege) {
            if (this.m_zconnection != null) {
                this.m_zconnection.cleanUp();
            }
            throw JMSExceptionUtil.createJMSException(ege);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        if (this.m_closing || this.m_closedByReconnect) {
            return;
        }
        this.m_closing = true;
        this.m_jconnection.removeZConnection(this.m_zconnection);
        try {
            try {
                this.makeCloseRequest();
            }
            catch (ENotConnected eNotConnected) {
                // empty catch block
            }
            try {
                this.m_subscription.cancel();
            }
            catch (ENotConnected eNotConnected) {
                // empty catch block
            }
            String subject = this.deliverySubject(this.m_jqueue.getQueueName());
            this.m_zmessageHandler.unbind(subject, this.m_ihandler);
            try {
                if (this.m_EOBsubscription != null) {
                    this.m_EOBsubscription.cancel();
                }
            }
            catch (ENotConnected eNotConnected) {
                // empty catch block
            }
            String EOBSubject = this.endOfBrowseSubject();
            this.m_zmessageHandler.unbind(EOBSubject, this.m_EOBhandler);
            BrowseMessagesQueue browseMessagesQueue = this.m_rxQueue;
            synchronized (browseMessagesQueue) {
                this.m_rxQueue.removeAllMessages();
                this.m_rxQueue.notifyAll();
            }
            try {
                this.m_zconnection.disconnect(false);
            }
            catch (ENotConnected eNotConnected) {
                // empty catch block
            }
            this.m_jsession.removeBrowser(this);
        }
        catch (EParameterIsNull epin) {
            throw JMSExceptionUtil.createJMSException(epin);
        }
        catch (ENetworkFailure enf) {
            throw JMSExceptionUtil.createJMSException(enf);
        }
        catch (ESecurityPolicyViolation espv) {
            throw JMSExceptionUtil.createJMSException(espv);
        }
        catch (EGeneralException ege) {
            throw JMSExceptionUtil.createJMSException(ege);
        }
    }

    void start() throws JMSException {
        try {
            this.m_zconnection.startDelivery();
        }
        catch (EUnusableConnection e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
        catch (ENetworkFailure e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
        catch (ESecurityPolicyViolation e) {
            throw JMSExceptionUtil.createJMSSecurityException(e);
        }
        catch (EGeneralException e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
    }

    void stop() throws JMSException {
        try {
            this.m_zconnection.stopDelivery();
        }
        catch (EUnusableConnection e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
        catch (ENetworkFailure e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
        catch (ESecurityPolicyViolation e) {
            throw JMSExceptionUtil.createJMSSecurityException(e);
        }
        catch (EGeneralException e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanseOnReconnect() {
        this.m_closing = true;
        this.m_closedByReconnect = true;
        this.m_jconnection.removeZConnection(this.m_zconnection);
        BrowseMessagesQueue browseMessagesQueue = this.m_rxQueue;
        synchronized (browseMessagesQueue) {
            this.m_rxQueue.removeAllMessages();
            this.m_rxQueue.notifyAll();
        }
        this.m_jsession.removeBrowser(this);
    }

    public Queue getQueue() throws JMSException {
        return this.m_jqueue;
    }

    public String getMessageSelector() throws JMSException {
        return this.m_selectorString;
    }

    public Enumeration getEnumeration() throws JMSException {
        this.checjIsClosedAndIsClosing();
        this.m_endOfBrowse = false;
        return new QueueEnumeration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPrefetchCount(int count) throws JMSException {
        this.checjIsClosedAndIsClosing();
        if (count < 1 || count < this.m_prefetchThreshold) {
            throw new JMSException(prAccessor.getString("INVALID_PREFETCH_COUNT"));
        }
        BrowseMessagesQueue browseMessagesQueue = this.m_rxQueue;
        synchronized (browseMessagesQueue) {
            this.m_prefetchCount = count;
            this.prepareGetRequest();
        }
    }

    public int getPrefetchCount() {
        return this.m_prefetchCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPrefetchThreshold(int threshold) throws JMSException {
        this.checjIsClosedAndIsClosing();
        if (threshold > this.m_prefetchCount) {
            throw new JMSException(prAccessor.getString("INVALID_PREFETCH_THRESHOLD"));
        }
        BrowseMessagesQueue browseMessagesQueue = this.m_rxQueue;
        synchronized (browseMessagesQueue) {
            this.m_prefetchThreshold = threshold;
        }
    }

    private void checjIsClosedAndIsClosing() throws JMSException {
        if (this.isClosedByReconnect()) {
            throw new IllegalStateException(prAccessor.getString("BROWSER_CLOSED_DURING_RECONNECT"), new Integer(-5000).toString());
        }
        if (this.isClosing() || this.m_jsession.isClosing()) {
            throw this.m_jsession.getJMSObjectClosedException();
        }
    }

    public int getPrefetchThreshold() {
        return this.m_prefetchThreshold;
    }

    void release(Message msg) {
        msg.getEnvelope().handlerDone(this.m_zmessageHandler.isGuaranteed(), false);
    }

    private Message extract(Envelope env) throws JMSException {
        Message message = Message.createMessage(env);
        message.setPropertiesReadOnly(true);
        message.setBodyReadOnly(true);
        return message;
    }

    private void makeOpenRequest(String selector) throws JMSException {
        String openSubject = SessionConfig.getAdminPrefix(this.m_uid, this.m_appid) + ".openBrowser";
        progress.message.zclient.Message openReq = new progress.message.zclient.Message(openSubject);
        try {
            openReq.writeUTF(DestUtil.getDestinationName(this.m_jqueue));
            openReq.writeUTF(selector == null ? "" : selector);
            Envelope openEnvelope = new Envelope(openReq);
            progress.message.zclient.Connection openBrowserResolver = this.m_zmessageHandler.getSession().getConnection();
            progress.message.zclient.Message reply = this.m_zmessageHandler.getSession().request(openEnvelope, -1, (IJobResolver)openBrowserResolver);
            if (!reply.readBoolean()) {
                String errmsg = reply.readUTF();
                int errcode = reply.readInt();
                if (errcode == 1) {
                    throw new InvalidSelectorException(errmsg + " (Queue: " + DestUtil.getDestinationName(this.m_jqueue) + ", Selector: " + (this.m_selectorString == null ? "null" : "\"" + this.m_selectorString + "\"") + ")");
                }
                if (errcode == 3005) {
                    throw new InvalidDestinationException(errmsg);
                }
                throw JMSExceptionUtil.createJMSException(errmsg, null);
            }
        }
        catch (IOException e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
    }

    private void makeCloseRequest() throws JMSException, EGeneralException {
        String closeSubject = SessionConfig.getAdminPrefix(this.m_uid, this.m_appid) + ".closeBrowser";
        progress.message.zclient.Message closeReq = new progress.message.zclient.Message(closeSubject);
        try {
            closeReq.writeUTF(DestUtil.getDestinationName(this.m_jqueue));
        }
        catch (IOException e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
        Envelope closeEnvelope = new Envelope(closeReq);
        progress.message.zclient.Connection closeBrowserResolver = this.m_zmessageHandler.getSession().getConnection();
        this.m_zmessageHandler.getSession().requestEnvelope(closeEnvelope, -1, (IJobResolver)closeBrowserResolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void makeGetRequest() throws EGeneralException {
        boolean requiresAGet = false;
        BrowseMessagesQueue browseMessagesQueue = this.m_rxQueue;
        synchronized (browseMessagesQueue) {
            if (this.m_rxQueue.size() + this.m_outstandingRequested <= this.m_prefetchThreshold) {
                requiresAGet = true;
                this.m_outstandingRequested += this.m_prefetchCount;
            }
        }
        if (requiresAGet) {
            this.m_zmessageHandler.getSession().publish(this.m_getEnvelope, 0, false);
        }
    }

    boolean isClosing() {
        return this.m_closing;
    }

    boolean isClosedByReconnect() {
        return this.m_closedByReconnect;
    }

    final String deliverySubject(String queueName) {
        return "$Q." + queueName;
    }

    String openSubject() {
        return SessionConfig.getAdminPrefix(this.m_uid, this.m_appid) + ".openBrowser";
    }

    String closeSubject() {
        return SessionConfig.getAdminPrefix(this.m_uid, this.m_appid) + ".closeBrowser";
    }

    final String endOfBrowseSubject() {
        return QueueUtil.getQueueClientPrefix(this.m_uid, this.m_appid) + ".endOfBrowse";
    }

    final void prepareGetRequest() {
        String getSubject = null;
        try {
            getSubject = this.deliverySubject(DestUtil.getDestinationName(this.m_jqueue));
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
        this.m_getMessage = new progress.message.zclient.Message(getSubject);
        this.m_getMessage.writeShort(3);
        this.m_getMessage.writeInt(this.m_prefetchCount);
        this.m_getEnvelope = new Envelope(this.m_getMessage);
        this.m_getEnvelope.setPtp((byte)13);
    }

    class BrowseMessagesQueue
    extends progress.message.util.Queue {
        BrowseMessagesQueue() {
        }

        public synchronized void receiveMessage(Message msg) {
            this.enqueue(msg);
            this.notifyAll();
        }

        public synchronized void receiveEndOfBrowse() {
            this.notifyAll();
        }

        public synchronized Message nextMessage() {
            while (this.isEmpty()) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw new InternalError();
                }
                if (QueueBrowser.this.isClosedByReconnect()) {
                    return null;
                }
                if (!QueueBrowser.this.isClosing()) continue;
                return null;
            }
            return (Message)this.dequeue();
        }

        public synchronized Message nextMessage(long timeout) {
            if (this.isEmpty()) {
                try {
                    this.wait(timeout);
                }
                catch (InterruptedException e) {
                    throw new InternalError();
                }
            }
            if (this.isEmpty()) {
                return null;
            }
            return (Message)this.dequeue();
        }

        public synchronized boolean anyMessage(long timeout) {
            if (this.isEmpty()) {
                try {
                    this.wait(timeout);
                }
                catch (InterruptedException e) {
                    throw new InternalError();
                }
            }
            return !this.isEmpty();
        }

        public synchronized Message nextMessageIfAny() {
            if (this.isEmpty()) {
                return null;
            }
            return (Message)this.dequeue();
        }

        public synchronized void removeAllMessages() {
            int length = this.size();
            for (int i = 0; i < length; ++i) {
                this.dequeue();
            }
        }
    }

    private class DefaultHandler
    extends MessageHandler {
        DefaultHandler() {
            super(null, true, true);
        }

        @Override
        public void handleMessage(progress.message.zclient.Session s, Envelope env) {
            String subject = env.getMessage().getSubject().getSubjectString();
            if (!SessionConfig.isSystemSubject(subject)) {
                QueueBrowser.this.m_ihandler.handleMessage(s, env);
                return;
            }
            if ("$SYS.client.brokerConnectionReconnecting".equals(subject)) {
                QueueBrowser.this.cleanseOnReconnect();
            }
            env.handlerDone(QueueBrowser.this.m_zmessageHandler.isGuaranteed(), false);
        }
    }

    private class IHandler
    implements IMessageHandler {
        private IHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(progress.message.zclient.Session session, Envelope env) {
            Message msg = null;
            try {
                msg = QueueBrowser.this.extract(env);
                BrowseMessagesQueue browseMessagesQueue = QueueBrowser.this.m_rxQueue;
                synchronized (browseMessagesQueue) {
                    QueueBrowser.this.m_rxQueue.enqueue(msg);
                    QueueBrowser.this.m_jsession.incrementReceivedMessageCount();
                    QueueBrowser.this.m_outstandingRequested--;
                    QueueBrowser.this.m_rxQueue.notifyAll();
                }
            }
            catch (JMSException jMSException) {
            }
            finally {
                QueueBrowser.this.release(msg);
            }
        }
    }

    private class EOBHandler
    implements IMessageHandler {
        private EOBHandler() {
        }

        @Override
        public void handleMessage(progress.message.zclient.Session session, Envelope env) {
            QueueBrowser.this.m_endOfBrowse = true;
            QueueBrowser.this.m_outstandingRequested--;
            QueueBrowser.this.m_rxQueue.receiveEndOfBrowse();
            env.handlerDone(QueueBrowser.this.m_zmessageHandler.isGuaranteed(), false);
        }
    }

    class QueueEnumeration
    implements Enumeration {
        QueueEnumeration() {
        }

        public synchronized Object nextElement() {
            if (QueueBrowser.this.isClosedByReconnect()) {
                QueueBrowser.this.m_endOfBrowse = true;
                throw new NoSuchElementException(prAccessor.getString("BROWSER_CLOSED_DURING_RECONNECT"));
            }
            Message msg = null;
            this.makeGetRequestCheckingException();
            msg = QueueBrowser.this.m_rxQueue.nextMessage(10000L);
            if (QueueBrowser.this.isClosedByReconnect()) {
                QueueBrowser.this.m_endOfBrowse = true;
                throw new NoSuchElementException(prAccessor.getString("BROWSER_CLOSED_DURING_RECONNECT"));
            }
            if (QueueBrowser.this.isClosing()) {
                return null;
            }
            return msg;
        }

        @Override
        public boolean hasMoreElements() {
            if (!QueueBrowser.this.m_rxQueue.isEmpty()) {
                return true;
            }
            if (QueueBrowser.this.m_endOfBrowse) {
                return false;
            }
            if (QueueBrowser.this.isClosedByReconnect()) {
                return true;
            }
            this.makeGetRequestCheckingException();
            if (QueueBrowser.this.m_rxQueue.anyMessage(5000L)) {
                return true;
            }
            return !QueueBrowser.this.m_endOfBrowse;
        }

        private void makeGetRequestCheckingException() {
            try {
                QueueBrowser.this.makeGetRequest();
            }
            catch (EGeneralException e) {
                e.printStackTrace();
            }
        }
    }
}

