/*
 * Decompiled with CFR 0.152.
 */
package progress.message.jimpl;

import java.io.Serializable;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.naming.Referenceable;
import progress.message.client.prAccessor;
import progress.message.jimpl.Connection;
import progress.message.jimpl.DestUtil;
import progress.message.jimpl.Destination;
import progress.message.jimpl.JMSExceptionUtil;
import progress.message.jimpl.MessageProducer;
import progress.message.jimpl.TemporaryTopic;
import progress.message.jimpl.api.ITopic;
import progress.message.zclient.ISubject;
import progress.message.zclient.Subject;

public class Topic
extends progress.message.jclient.Topic
implements javax.jms.Topic,
Referenceable,
Serializable,
Destination,
ITopic {
    private String subjectString = null;
    protected String m_routingNodeName = null;
    private transient ISubject m_subject = null;
    private transient String m_createdTopicName = null;
    private transient boolean m_validatedForPublish = false;

    public Topic(String topicName) throws JMSException {
        this(topicName, false);
    }

    Topic(String routing, ISubject subject) {
        this.m_subject = (Subject)subject;
        this.m_routingNodeName = routing;
        this.m_createdTopicName = routing == null ? subject.getJMSName() : routing + "::" + subject.getJMSName();
        super.setNameOnly(this.m_createdTopicName);
    }

    public Topic(String topicName, boolean isInternalName) throws InvalidDestinationException {
        this.setTopicNameInternal(topicName, !isInternalName && !DestUtil.isTemporaryTopic(DestUtil.getDestinationName(topicName)));
    }

    @Override
    public void setTopicName(String name) throws JMSException {
        this.setTopicNameInternal(name, true);
    }

    @Override
    public void setName(String name) throws JMSException {
        this.setTopicNameInternal(name, true);
    }

    private final void setTopicNameInternal(String topicName, boolean validate) throws InvalidDestinationException {
        this.m_routingNodeName = DestUtil.getRoutingName(topicName);
        if (this.m_routingNodeName != null) {
            if (validate) {
                DestUtil.validateRoutingName(this.m_routingNodeName);
            }
            if (DestUtil.hasGroupPrefix(topicName, 0)) {
                throw new InvalidDestinationException(prAccessor.getString("TOPIC_INVALID_GROUP_ROUTING_COMBINATION"));
            }
        }
        String topicOnly = DestUtil.getDestinationName(topicName);
        if (validate) {
            DestUtil.validateTopicName(topicOnly);
        }
        this.m_subject = new Subject(topicOnly);
        this.m_createdTopicName = topicName;
        super.setNameOnly(topicName);
    }

    String getRoutingNodeName() {
        return this.m_routingNodeName;
    }

    @Override
    public final String getTopicName() throws JMSException {
        return this.getTopicNameInternal();
    }

    @Override
    public String toString() {
        return this.getTopicNameInternal();
    }

    private final String getTopicNameInternal() {
        if (this.m_createdTopicName != null) {
            return this.m_createdTopicName;
        }
        if (this.m_routingNodeName != null) {
            return this.m_routingNodeName + "::" + this.m_subject.getJMSName();
        }
        return this.m_subject.getJMSName();
    }

    @Override
    public String getFullName() {
        return this.getTopicNameInternal();
    }

    @Override
    public String getDestinationName() throws JMSException {
        return this.getTopicName();
    }

    @Override
    public boolean hasGroup() {
        return this.m_subject.hasGroup();
    }

    @Override
    public String getGroupName() {
        return this.m_subject.getGroupName();
    }

    public void initGroupName(String group) throws InvalidDestinationException {
        if (group != null && this.hasRouting() && group.trim().length() > 0) {
            throw new InvalidDestinationException(prAccessor.getString("TOPIC_INVALID_GROUP_ROUTING_COMBINATION"));
        }
        DestUtil.validateGroupPrefix(group);
        ((Subject)this.m_subject).setGroupName(group);
        this.m_createdTopicName = null;
        this.setNameOnly(this.getTopicNameInternal());
    }

    @Override
    public boolean hasRouting() {
        return this.m_routingNodeName != null;
    }

    public void initRouting(String routing) throws InvalidDestinationException {
        if (routing != null && routing.trim().length() > 0) {
            if (this.m_subject.hasGroup() || DestUtil.hasGroupPrefix(routing, 0)) {
                throw new InvalidDestinationException(prAccessor.getString("TOPIC_INVALID_GROUP_ROUTING_COMBINATION"));
            }
            DestUtil.validateRoutingName(routing);
            this.m_routingNodeName = routing;
            this.m_createdTopicName = null;
            super.setNameOnly(routing + "::" + this.m_subject.getJMSName());
        } else {
            this.m_routingNodeName = null;
            this.m_createdTopicName = null;
            super.setNameOnly(this.m_subject.getJMSName());
        }
    }

    @Override
    public String getRouting() {
        return this.m_routingNodeName;
    }

    @Override
    public final boolean isTemporary() {
        return this.m_subject.isTemporary();
    }

    @Override
    public boolean isDeleted() throws JMSException {
        return false;
    }

    @Override
    public boolean isQueue() throws JMSException {
        return false;
    }

    @Override
    public boolean isTopic() throws JMSException {
        return true;
    }

    @Override
    public boolean isMultiDestination() throws JMSException {
        return false;
    }

    @Override
    public ISubject getSubject() {
        return this.m_subject;
    }

    public String getTopicNameOnly() {
        return this.m_subject.getLookupName();
    }

    @Override
    public int hashCode() {
        int hc = this.m_subject.hashCode();
        if (this.m_routingNodeName != null) {
            hc += this.m_routingNodeName.hashCode();
        }
        return hc;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Topic t = (Topic)obj;
        if (this.m_routingNodeName != t.m_routingNodeName) {
            if (this.m_routingNodeName == null) {
                return false;
            }
            if (!this.m_routingNodeName.equals(t.m_routingNodeName)) {
                return false;
            }
        }
        return this.m_subject.equals(t.m_subject);
    }

    @Override
    public void validateForSend(Message message) throws JMSException {
        if (message != null && MessageProducer.isAmbiguousURLDestination(this.m_subject.getLookupName(), message)) {
            throw new InvalidDestinationException(prAccessor.getString("AMBIGUOUS_URL_DESTINATION"));
        }
        if (this.m_validatedForPublish) {
            return;
        }
        if (this.m_subject.hasGroup()) {
            throw new InvalidDestinationException(prAccessor.getString("TOP_PUB_INVALID_GROUP_PREFIX"));
        }
        String topicName = this.getTopicNameInternal();
        if (topicName != null && (topicName.indexOf("*") != -1 || topicName.indexOf("#") != -1)) {
            throw new InvalidDestinationException(prAccessor.getString("TOP_PUB_INVALID_CHARS"));
        }
        this.m_validatedForPublish = true;
    }

    @Override
    public void validateForConsume(Connection connection) throws JMSException {
        if (this.isTemporary() && !TemporaryTopic.topicExists(this.getDestinationName(), connection)) {
            throw JMSExceptionUtil.createJMSSecurityException(prAccessor.getString("TEMPORARY_TOPIC_INVALID_ACCESS"), null);
        }
    }
}

