/*
 * Decompiled with CFR 0.152.
 */
package progress.message.msg.v24;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import progress.message.msg.IQueueFlowControlHandle;
import progress.message.msg.v24.Mgram;
import progress.message.msg.v24.Payload;
import progress.message.util.EAssertFailure;
import progress.message.util.StreamUtil;
import progress.message.util.StringUtil;
import progress.message.zclient.EMgramFormatError;
import progress.message.zclient.prAccessor;

final class QueueFlowControlPayload
extends Payload
implements IQueueFlowControlHandle {
    private boolean m_isRouting = false;
    private boolean m_isDirty = true;
    private byte[] m_payload = null;
    private byte[] m_utfDestination = null;
    private String m_stringDestination = null;

    public QueueFlowControlPayload(Mgram m) {
        super(m);
    }

    @Override
    void initPayloadFromStream(InputStream is) throws IOException, EMgramFormatError {
        byte type = this.m_mgram.getType();
        switch (type) {
            case 18: 
            case 19: {
                this.m_isRouting = StreamUtil.readByte(is) > 0;
                this.m_utfDestination = StreamUtil.readUTFString(is);
                this.m_stringDestination = StringUtil.UTFToString(this.m_utfDestination, 0);
                this.m_isDirty = true;
                break;
            }
            default: {
                throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
            }
        }
    }

    @Override
    byte[] toByteArray() {
        this.sync();
        byte[] result = new byte[this.m_payload.length];
        System.arraycopy(this.m_payload, 0, result, 0, this.m_payload.length);
        return result;
    }

    @Override
    void sync() {
        if (this.m_isDirty) {
            this.m_payload = new byte[this.m_utfDestination.length + 1];
            this.m_payload[0] = (byte)(this.m_isRouting ? 1 : 0);
            System.arraycopy(this.m_utfDestination, 0, this.m_payload, 1, this.m_utfDestination.length);
            this.m_isDirty = false;
        }
    }

    @Override
    void writeToStream(OutputStream os) throws IOException {
        this.sync();
        os.write(this.m_payload);
    }

    @Override
    public int length() {
        return this.m_utfDestination.length + 1;
    }

    @Override
    public IQueueFlowControlHandle getQueueFlowControlHandle() {
        return this;
    }

    @Override
    public String getFlowDestination() {
        return this.m_stringDestination;
    }

    @Override
    public boolean getFlowRoutingBit() {
        return this.m_isRouting;
    }

    @Override
    public void setFlowDestination(byte[] utf, int utfLength) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public void setFlowRoutingBit(boolean value) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }
}

