/*
 * Decompiled with CFR 0.152.
 */
package progress.message.msg.v26;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import progress.message.msg.v26.DefaultPayload;
import progress.message.util.EAssertFailure;
import progress.message.zclient.SessionConfig;

public class DefaultPayloadInputWrapper
implements ObjectInput {
    private DefaultPayload m_pay;
    private ByteArrayInputStream m_bais;
    private ObjectInputStream m_ois;
    private DataInputStream m_dis;

    public DefaultPayloadInputWrapper(DefaultPayload pay) {
        this.m_pay = pay;
        this.m_bais = new ByteArrayInputStream(this.m_pay.getRawBodyBuffer());
        this.m_dis = new DataInputStream(this.m_bais);
    }

    @Override
    public Object readObject() throws ClassNotFoundException, IOException {
        if (!SessionConfig.IN_BROKER) {
            throw new EAssertFailure("Cannot use mgram object serialization from client");
        }
        if (this.m_ois == null) {
            this.m_ois = new ObjectInputStream(this.m_bais);
        }
        return this.m_ois.readObject();
    }

    @Override
    public int read() throws IOException {
        return this.m_dis.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.m_dis.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.m_dis.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.m_dis.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.m_bais.available();
    }

    @Override
    public void close() throws IOException {
        this.m_dis.close();
        if (this.m_ois != null) {
            this.m_ois.close();
        }
        this.m_bais.close();
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.m_dis.readFully(b);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.m_dis.readFully(b, off, len);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.m_dis.skipBytes(n);
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.m_dis.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        return this.m_dis.readByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.m_dis.readUnsignedByte();
    }

    @Override
    public short readShort() throws IOException {
        return this.m_dis.readShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.m_dis.readUnsignedShort();
    }

    @Override
    public char readChar() throws IOException {
        return this.m_dis.readChar();
    }

    @Override
    public int readInt() throws IOException {
        return this.m_dis.readInt();
    }

    @Override
    public long readLong() throws IOException {
        return this.m_dis.readLong();
    }

    @Override
    public float readFloat() throws IOException {
        return this.m_dis.readFloat();
    }

    @Override
    public double readDouble() throws IOException {
        return this.m_dis.readDouble();
    }

    @Override
    public String readLine() throws IOException {
        return this.m_dis.readLine();
    }

    @Override
    public String readUTF() throws IOException {
        return this.m_dis.readUTF();
    }
}

