/*
 * Decompiled with CFR 0.152.
 */
package progress.message.net.ssl;

import java.io.IOException;
import java.security.Principal;
import java.security.SecureRandom;
import java.text.MessageFormat;
import java.util.Properties;
import progress.message.net.ESocketConfigException;
import progress.message.net.ProgressInetAddress;
import progress.message.net.ProgressServerSocket;
import progress.message.net.ProgressSocket;
import progress.message.net.ProgressSocketFactory;
import progress.message.net.http.client.tunnel.IHttpProxyConfig;
import progress.message.net.ssl.ISSLImpl;
import progress.message.net.ssl.ProgressSslServerSocket;
import progress.message.net.ssl.ProgressSslSocket;
import progress.message.net.ssl.prAccessor;
import progress.message.zclient.SessionConfig;

public final class ProgressSslSocketFactory
extends ProgressSocketFactory {
    public static String SSL_PROVIDER_CLASS = null;
    public static boolean DEBUG = false;
    private static volatile ISSLImpl s_sslImpl = null;
    private static final Object SSLIMPL_LOCK_OBJ = new Object();

    private static final void init() throws ESocketConfigException {
        String providerClassName = SSL_PROVIDER_CLASS;
        if (providerClassName == null && !SessionConfig.IN_BROKER) {
            String debugOn;
            providerClassName = System.getProperty("SSL_PROVIDER_CLASS");
            if (providerClassName == null) {
                providerClassName = "progress.message.net.ssl.jsse.jsseSSLImpl";
            }
            if ((debugOn = System.getProperty("SSL_DEBUG")) != null) {
                DEBUG = debugOn.equalsIgnoreCase("true");
            }
        }
        if (providerClassName == null) {
            throw new NullPointerException("'providerClassName' is null at " + ProgressSslSocketFactory.class.getName() + ".init()");
        }
        try {
            Class<?> sslImplClass = Class.forName(providerClassName);
            s_sslImpl = (ISSLImpl)sslImplClass.newInstance();
            if (!SessionConfig.IN_BROKER && providerClassName.endsWith(".jsseSSLImpl")) {
                long startTime = System.currentTimeMillis();
                SecureRandom r = new SecureRandom();
                r.nextBytes(new byte[8]);
                if (DEBUG) {
                    System.out.println("Elapse time to initialize the seed generator = " + (System.currentTimeMillis() - startTime));
                }
            }
        }
        catch (ClassNotFoundException e) {
            throw new ESocketConfigException(prAccessor.getString("STR002") + providerClassName);
        }
        catch (Exception e) {
            if (DEBUG) {
                String mf50 = prAccessor.getString("STR003");
                Object[] ob50 = new Object[]{e + e.getMessage()};
                System.out.println(MessageFormat.format(mf50, ob50));
            }
            String mf51 = prAccessor.getString("STR004");
            Object[] ob51 = new Object[]{providerClassName};
            throw new ESocketConfigException(MessageFormat.format(mf51, ob51));
        }
        if (DEBUG) {
            String mf54 = prAccessor.getString("STR005");
            Object[] ob54 = new Object[]{providerClassName};
            System.out.println(MessageFormat.format(mf54, ob54));
            s_sslImpl.setDebug(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ISSLImpl getSSLImpl() throws ESocketConfigException {
        if (s_sslImpl == null) {
            Object object = SSLIMPL_LOCK_OBJ;
            synchronized (object) {
                if (s_sslImpl == null) {
                    ProgressSslSocketFactory.init();
                }
            }
        }
        return s_sslImpl;
    }

    @Override
    public ProgressServerSocket createProgressServerSocket(Principal principal, int port, int backlog, ProgressInetAddress bindAddr, Properties properties) throws IOException {
        ProgressSslSocketFactory.getSSLImpl();
        return new ProgressSslServerSocket(principal, port, backlog, bindAddr, properties);
    }

    @Override
    public ProgressSocket createProgressSocket(Principal principal, String Host, int port, Object properties, IHttpProxyConfig pConfig) throws IOException {
        ProgressSslSocketFactory.getSSLImpl();
        if (properties != null) {
            return new ProgressSslSocket(principal, Host, port, properties, pConfig);
        }
        return new ProgressSslSocket(principal, Host, port, null);
    }
}

