/*
 * Decompiled with CFR 0.152.
 */
package progress.message.util;

import java.util.NoSuchElementException;

public class Queue {
    protected Object[] m_array;
    protected int m_head = 0;
    protected int m_tail = 0;
    protected int m_count = 0;
    protected int m_halfArraySize = 0;
    protected boolean m_checkSize = false;

    public Queue() {
        this.m_array = new Object[4];
        this.m_halfArraySize = 2;
    }

    public Queue(int initial_sizeParam) {
        int initial_size = initial_sizeParam;
        if (initial_size < 1) {
            initial_size = 4;
        }
        this.m_array = new Object[initial_size];
        this.m_halfArraySize = 0 * this.m_array.length;
    }

    public boolean isEmpty() {
        return this.m_head == this.m_tail;
    }

    public Object enqueue(Object obj) {
        this.m_array[this.m_tail++] = obj;
        ++this.m_count;
        if (this.m_tail == this.m_array.length) {
            this.m_tail = 0;
        }
        return this.expandArrayAndReturnObj(obj);
    }

    public Object dequeue() throws NoSuchElementException {
        this.checkHeadIsTail();
        Object obj = this.m_array[this.m_head];
        this.m_array[this.m_head++] = null;
        --this.m_count;
        if (this.m_head == this.m_array.length) {
            this.m_head = 0;
        }
        this.contractArrayCheckingSize();
        return obj;
    }

    public Object dequeueFromEnd(Object likeMe) throws NoSuchElementException {
        Object obj;
        this.checkHeadIsTail();
        if (this.m_tail == 0) {
            this.m_tail = this.m_array.length;
        }
        if (!(obj = this.m_array[--this.m_tail]).equals(likeMe)) {
            ++this.m_tail;
            return null;
        }
        this.m_array[this.m_tail] = null;
        --this.m_count;
        this.contractArrayCheckingSize();
        return obj;
    }

    private void checkHeadIsTail() {
        if (this.m_head == this.m_tail) {
            throw new NoSuchElementException("Queue:dequeue");
        }
    }

    private void contractArrayCheckingSize() {
        if (this.m_checkSize) {
            this.contract_array();
        }
    }

    public Object prepend(Object obj) {
        if (--this.m_head < 0) {
            this.m_head = this.m_array.length - 1;
        }
        this.m_array[this.m_head] = obj;
        ++this.m_count;
        return this.expandArrayAndReturnObj(obj);
    }

    private Object expandArrayAndReturnObj(Object obj) {
        if (this.m_head == this.m_tail) {
            this.expand_array();
        }
        return obj;
    }

    public boolean contains(Object obj) {
        int objLoc = this.m_head;
        while (objLoc < this.m_array.length && objLoc != this.m_tail) {
            if (obj.equals(this.m_array[objLoc])) {
                return true;
            }
            if (++objLoc != this.m_array.length) continue;
            objLoc = 0;
        }
        return false;
    }

    public int size() {
        return this.m_head <= this.m_tail ? this.m_tail - this.m_head : this.m_tail + this.m_array.length - this.m_head;
    }

    public String toString() {
        int head = this.m_head;
        int tail = 0;
        int top = this.m_head <= this.m_tail ? this.m_tail : this.m_array.length;
        String rep = "[";
        rep = this.appendRep(head, top, rep);
        if (top == this.m_array.length) {
            rep = this.appendRep(tail, this.m_tail, rep);
        }
        if (this.m_head != this.m_tail) {
            rep = rep + " ";
        }
        return rep + "]";
    }

    private String appendRep(int tail, int m_tail, String repParam) {
        String rep = repParam;
        while (tail < m_tail) {
            rep = rep + " " + this.m_array[tail++].toString();
        }
        return rep;
    }

    private void expand_array() {
        int length = this.m_array.length;
        Object[] m_new = new Object[length * 2];
        System.arraycopy(this.m_array, this.m_head, m_new, this.m_head, length - this.m_head);
        System.arraycopy(this.m_array, 0, m_new, length, this.m_tail);
        this.m_tail += length;
        this.m_array = m_new;
        if (this.m_array.length > 50) {
            this.m_checkSize = true;
        }
        this.m_halfArraySize = (int)(0.5 * (double)this.m_array.length);
    }

    private void contract_array() {
        if (this.m_count >= this.m_halfArraySize) {
            return;
        }
        int newSize = this.m_halfArraySize % 2 > 0 ? this.m_halfArraySize + 5 : this.m_halfArraySize + 4;
        this.m_halfArraySize = (int)(0.5 * (double)newSize);
        Object[] newArr = new Object[newSize];
        int j = 0;
        for (int i = this.m_head; i < this.m_array.length; ++i) {
            j = this.copyNonNullObjectReferences(i, j, newArr);
        }
        int diff = this.m_count - j;
        if (diff > 0) {
            for (int i = 0; i < diff; ++i) {
                j = this.copyNonNullObjectReferences(i, j, newArr);
            }
        }
        this.m_array = newArr;
        this.m_head = 0;
        this.m_tail = j;
        if (this.m_array.length <= 50) {
            this.m_checkSize = false;
        }
    }

    private int copyNonNullObjectReferences(int i, int jParam, Object[] newArr) {
        int j = jParam;
        if (this.m_array[i] != null) {
            newArr[j] = this.m_array[i];
            ++j;
            this.m_array[i] = null;
        }
        return j;
    }
}

