/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mq.components;

import com.sonicsw.mf.common.MFException;
import com.sonicsw.mq.components.prAccessor;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Config;
import progress.message.ft.CannotActivateException;
import progress.message.ft.ReplicationChannel;
import progress.message.ft.ReplicationConnection;
import progress.message.ft.ReplicationManager;
import progress.message.ft.ReplicationState;

class ReplicationOperationsHelper {
    ReplicationOperationsHelper() {
    }

    public static void activateWaitingBroker() throws MFException {
        try {
            if (!Config.REPLICATED) {
                throw new com.sonicsw.mq.common.runtime.CannotActivateException(1);
            }
            AgentRegistrar reg = AgentRegistrar.getAgentRegistrar();
            ReplicationManager replicationMgr = reg.getReplicationManager();
            Config.logMessage(prAccessor.getString("START_ACTIVE_MGMT"), 2);
            replicationMgr.manuallyActivateBroker();
            replicationMgr.waitForReplicationState(2);
        }
        catch (CannotActivateException e) {
            throw new com.sonicsw.mq.common.runtime.CannotActivateException(e.getErrorId());
        }
        catch (InterruptedException e) {
            throw new MFException("Request Thread Interrupted");
        }
    }

    public static Integer getReplicationState() throws MFException {
        if (Config.REPLICATED) {
            AgentRegistrar reg = AgentRegistrar.getAgentRegistrar();
            ReplicationManager replicationMgr = reg.getReplicationManager();
            return new Integer(replicationMgr.getReplicationState());
        }
        return new Integer(2);
    }

    public static String getReplicationStateString() throws MFException {
        if (Config.REPLICATED) {
            AgentRegistrar reg = AgentRegistrar.getAgentRegistrar();
            ReplicationManager replicationMgr = reg.getReplicationManager();
            return replicationMgr.getReplicationStateString();
        }
        return ReplicationState.getReplicationStateString(2);
    }

    public static String[] getReplicationConnections() throws MFException {
        return ReplicationChannel.getChannelNames();
    }

    public static Integer getReplicationConnectionState(String name) throws MFException {
        if (Config.REPLICATED) {
            AgentRegistrar reg = AgentRegistrar.getAgentRegistrar();
            ReplicationConnection conn = reg.getReplicationManager().getReplicationConnection();
            if (conn == null) {
                return new Integer(0);
            }
            return new Integer(conn.getChannelState(name));
        }
        return new Integer(0);
    }

    public static String getReplicationConnectionStateString(String name) throws MFException {
        if (Config.REPLICATED) {
            AgentRegistrar reg = AgentRegistrar.getAgentRegistrar();
            ReplicationConnection conn = reg.getReplicationManager().getReplicationConnection();
            if (conn == null) {
                return "DISCONNECTED";
            }
            return conn.getChannelStateString(name);
        }
        return "DISCONNECTED";
    }

    public static String getReplicationType() throws MFException {
        return Config.PRIMARY ? "PRIMARY" : "BACKUP";
    }
}

