/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.security.pcs;

import com.sonicsw.security.pcs.PluggableMessageProtection;
import java.io.IOException;
import java.io.OutputStream;
import progress.message.zclient.IMessageProtection;
import progress.message.zclient.ISecureOutputStream;

public final class PluggableSecureOutputStream
extends OutputStream
implements ISecureOutputStream {
    private PluggableMessageProtection m_mp;
    private OutputStream m_os;
    private byte[] m_key = null;

    public PluggableSecureOutputStream() {
    }

    public PluggableSecureOutputStream(OutputStream os, IMessageProtection mp) {
        this.initSecureOutputStream(os, mp, null);
    }

    @Override
    public void doFinal() throws IOException {
        byte[] output = this.m_mp.doFinal();
        this.writeOutput(output);
    }

    @Override
    public IMessageProtection getMessageProtection() {
        return this.m_mp;
    }

    @Override
    public OutputStream getOutputStream() {
        return this;
    }

    @Override
    public void initSecureOutputStream(OutputStream os, IMessageProtection mp, byte[] buffer) {
        this.m_os = os;
        this.m_mp = (PluggableMessageProtection)mp;
    }

    @Override
    public void setMessageKey(byte[] key) {
        this.m_key = key;
    }

    @Override
    public void useSessionKey() {
        if (this.m_key != null) {
            this.m_key = null;
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.m_os.close();
    }

    @Override
    public void flush() throws IOException {
        this.m_os.flush();
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        byte[] output = this.m_mp.update(b, off, len);
        this.writeOutput(output);
    }

    private void writeOutput(byte[] output) throws IOException {
        if (output != null) {
            this.m_os.write(output);
        }
    }

    @Override
    public synchronized void write(byte[] parm1) throws IOException {
        this.write(parm1, 0, parm1.length);
    }

    @Override
    public synchronized void write(int b) throws IOException {
        byte[] buf = new byte[]{(byte)b};
        this.write(buf, 0, 1);
    }
}

