/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.security.action;

import com.sonicsw.ws.security.action.MessageParts;
import com.sonicsw.ws.security.action.SP2002;
import com.sonicsw.ws.security.policy.MessagePartWSS4J;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;

public class MessageParts2002
extends SP2002
implements MessageParts {
    List m_parts = new ArrayList();

    @Override
    public void addParts(List parts) {
        if (parts == null || parts.isEmpty()) {
            return;
        }
        Object entry = parts.get(0);
        if (entry instanceof com.sonicsw.ws.security.policy.MessageParts) {
            if (this.m_parts == null) {
                this.m_parts = new ArrayList(parts);
            } else {
                this.m_parts.addAll(parts);
            }
        } else {
            throw new RuntimeException("Invalid message parts type: " + entry.getClass().getName());
        }
    }

    @Override
    public void addPart(Object obj) {
        throw new UnsupportedOperationException("Invalid operation for WS-SecurityPolicy 2002 MessageParts");
    }

    @Override
    public boolean removePart(Object obj) {
        throw new UnsupportedOperationException("Invalid operation for WS-SecurityPolicy 2002 MessageParts");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Invalid operation for WS-SecurityPolicy 2002 MessageParts");
    }

    @Override
    public List getPartList() {
        return this.m_parts;
    }

    @Override
    public String getPartsAsString() {
        StringBuffer parts = new StringBuffer();
        if (this.m_parts != null && !this.m_parts.isEmpty()) {
            int index = 0;
            for (com.sonicsw.ws.security.policy.MessageParts msgParts : this.m_parts) {
                String s = this.getParts(msgParts);
                if (s == null || s.trim().length() <= 0) continue;
                parts.append(s);
                if ((index = (int)((short)(index + 1))) >= this.m_parts.size()) continue;
                parts.append(";");
            }
        }
        return parts.toString();
    }

    private String getParts(com.sonicsw.ws.security.policy.MessageParts parts) {
        if (parts == null) {
            return null;
        }
        MessagePartWSS4J[] wss4jParts = parts.getParts();
        if (wss4jParts == null || wss4jParts.length == 0) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < wss4jParts.length; ++i) {
            MessagePartWSS4J msgPartsQName = wss4jParts[i];
            buffer.append(msgPartsQName.getWss4jPartString());
            if (i + 1 >= wss4jParts.length) continue;
            buffer.append(";");
        }
        String s = buffer.toString();
        if (s != null && s.trim().length() == 0) {
            s = null;
        }
        return s;
    }

    @Override
    public QName[] getPartsAsQNames() {
        QName[] requiredParts = new QName[]{};
        if (this.m_parts != null && !this.m_parts.isEmpty()) {
            Iterator iter = this.m_parts.iterator();
            com.sonicsw.ws.security.policy.MessageParts mp = (com.sonicsw.ws.security.policy.MessageParts)iter.next();
            MessagePartWSS4J[] wss4JParts = mp.getParts();
            ArrayList<QName> aList = new ArrayList<QName>();
            for (int i = 0; i < wss4JParts.length; ++i) {
                MessagePartWSS4J wss4JPart = wss4JParts[i];
                if (wss4JPart == null) continue;
                aList.add(wss4JPart.getQName());
            }
            return aList.toArray(requiredParts);
        }
        return requiredParts;
    }
}

