/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.util.Enumeration;
import java.util.List;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.BaseAgentQueue;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.IAgentQueue;
import progress.message.broker.IClientContext;
import progress.message.broker.parser.ParseException;
import progress.message.broker.parser.TokenMgrError;
import progress.message.client.EGeneralException;
import progress.message.client.ESecurityGeneralException;
import progress.message.msg.IMgram;
import progress.message.util.DebugState;
import progress.message.util.IndexedList;
import progress.message.util.QueueUtil;
import progress.message.zclient.Envelope;
import progress.message.zclient.Label;
import progress.message.zclient.Message;

public class AgentHttpDirectTemporaryQueue
extends BaseAgentQueue
implements IAgentQueue {
    private String m_name;
    private String m_address;
    AgentRegistrar m_reg;
    private Label m_emptyLabel;
    IMgram m_mgrm;
    Object m_dequeueLock;
    private int m_state = 0;
    private boolean m_global = false;
    private boolean m_clustered = false;
    private boolean m_readOnly = false;
    private boolean m_readExclusive = false;
    private boolean m_writeOnly = false;
    private boolean m_writeExclusive = false;
    private int m_nonDelayableReceiverCount = 0;

    public AgentHttpDirectTemporaryQueue(String qName, AgentRegistrar reg) {
        super(DebugState.GLOBAL_DEBUG_ON ? "AgentHttpDirectTemporaryQueue " + qName : null);
        this.initInstance(qName, reg);
    }

    @Override
    public synchronized void clearExpiredMsgs() throws InterruptedException {
    }

    @Override
    public void onOutstandingLocalClientGetRequests() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void get(long cid, short requestType, int count, boolean isRemoteGetRequest) {
        IMgram m = null;
        switch (requestType) {
            case 1: {
                if (this.DEBUG) {
                    this.debug("RCV request from CID:" + cid + ", Count:" + count);
                }
                this.addRequest(cid, count, isRemoteGetRequest);
                break;
            }
            case 2: {
                if (this.DEBUG) {
                    this.debug("RCVNOWAIT request from CID:" + cid + ", Count:" + count);
                }
                boolean sent = false;
                Object object = this.m_dequeueLock;
                synchronized (object) {
                    m = this.m_mgrm;
                    this.m_mgrm = null;
                    try {
                        IClientContext cc = this.m_reg.getClient(cid);
                        String subject = QueueUtil.getQueueClientSubject(cc.getUid(), cc.getAppid(), m == null ? "queueEmpty" : "queueNotEmpty");
                        Envelope env = new Envelope(new Message(subject));
                        this.m_reg.getAdminSession().publish(env, 0, false);
                        if (this.DEBUG) {
                            this.debug("Sent notification to:" + subject);
                        }
                        if (m != null) {
                            sent = this.deliver(m, cid);
                        }
                    }
                    catch (EClientNotRegistered e) {
                        this.m_mgrm = m;
                        return;
                    }
                    catch (ESecurityGeneralException e) {
                        this.m_mgrm = m;
                        return;
                    }
                    catch (EGeneralException e) {
                        this.m_mgrm = m;
                        return;
                    }
                }
            }
            case 3: {
                break;
            }
        }
    }

    @Override
    public String getQueueName() {
        return this.m_name;
    }

    @Override
    public String getQueueAddress() {
        return this.m_address;
    }

    @Override
    public void restore(IndexedList unacked, boolean preserveRedelivery, boolean notifyMsgEnqueued) {
        this.restore(unacked.elements(), preserveRedelivery, notifyMsgEnqueued);
    }

    @Override
    public void restore(Enumeration mgrms, boolean preserveRedelivery, boolean notifyMsgEnqueued) {
        if (!mgrms.hasMoreElements()) {
            return;
        }
        if (mgrms.hasMoreElements()) {
            this.m_mgrm = (IMgram)mgrms.nextElement();
        }
        if (notifyMsgEnqueued) {
            this.initiateDispatching();
        }
    }

    @Override
    public void unreserve(int size) {
    }

    @Override
    public void acknowledge(long tracking, long ackTracking) {
    }

    @Override
    public void clear() throws InterruptedException {
        this.m_mgrm = null;
    }

    @Override
    public synchronized void close() {
        this.m_state = 4;
        this.dispatchShutdown();
        this.m_state = 5;
    }

    @Override
    public boolean closeBrowser(long clientId) {
        return false;
    }

    @Override
    public void closeReceiver(long clientId) {
        this.clearLocalRequests(clientId);
    }

    @Override
    public IMgram dequeue(long clientId) throws InterruptedException {
        if (this.m_mgrm == null) {
            if (this.DEBUG) {
                this.debug("Dequeued NULL for CID:" + clientId + ", from Queue:" + this.getQueueName());
            }
            return null;
        }
        IMgram m = this.m_mgrm;
        this.m_mgrm = null;
        if (this.DEBUG) {
            this.debug("Dequeued TKID:" + m.getGuarenteedTrackingNum() + " for CID:" + clientId + ", from Queue:" + this.getQueueName());
        }
        return m;
    }

    @Override
    public IMgram dequeueByTrackingNum(long trackingNum) {
        IMgram m = this.m_mgrm;
        if (m != null && m.getGuarenteedTrackingNum() == trackingNum) {
            this.m_mgrm = null;
            if (m != null) {
                this.debug("Dequeued TKID:" + m.getGuarenteedTrackingNum() + ", from Queue:" + this.getQueueName());
            } else {
                this.debug("Dequeued NULL, from Queue:" + this.getQueueName());
            }
            return m;
        }
        if (this.DEBUG) {
            this.debug("Dequeued NULL, from Queue:" + this.getQueueName());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int dispatch(long clientId, int count, boolean forRemoteBroker) throws InterruptedException {
        if (this.DEBUG) {
            this.debug("dispatch from queue " + this.getQueueName() + ", for clientId = " + clientId + ", count = " + count);
            if (this.m_mgrm != null) {
                this.debug("queue " + this.getQueueName() + " currently contains a message");
            } else {
                this.debug("queue " + this.getQueueName() + " currently does not contain a message");
            }
        }
        try {
            IClientContext cc = this.m_reg.getClient(clientId);
            if (!cc.isStarted()) {
                return -1;
            }
        }
        catch (EClientNotRegistered cnre) {
            return 0;
        }
        int deliveredCount = 0;
        boolean delivered = false;
        IMgram m = null;
        Object object = this.m_dequeueLock;
        synchronized (object) {
            m = this.m_mgrm;
            if (m != null) {
                this.m_mgrm = null;
                if (this.DEBUG) {
                    this.debug("dequeued mgram " + m.getGuarenteedTrackingNum());
                }
                try {
                    delivered = this.deliver(m, clientId);
                    if (delivered) {
                        ++deliveredCount;
                    }
                }
                catch (EClientNotRegistered e) {
                    if (this.DEBUG) {
                        this.debug("client not registered, restoring to queue");
                    }
                    this.m_mgrm = m;
                }
                catch (ESecurityGeneralException e) {
                    BrokerComponent.getComponentContext().logMessage("Security exception processing mgram: ", (Throwable)e, 1);
                }
            }
        }
        if (this.DEBUG) {
            this.debug("mgram delivered = " + delivered + ", delivery count = " + deliveredCount);
        }
        return deliveredCount;
    }

    @Override
    public void enqueue(IMgram m) {
        this.initMgrm(m);
        this.m_mgrm.getBrokerHandle().setLocalQueueName(this.m_name);
        this.initiateDispatching();
        if (this.DEBUG) {
            this.debug("enqueue: Enqueued TKID:" + m.getGuarenteedTrackingNum());
        }
    }

    @Override
    public boolean forceReserve(IMgram m) {
        return false;
    }

    @Override
    public void forcedSave() {
    }

    @Override
    public Object getDequeueLock() {
        return this.m_dequeueLock;
    }

    @Override
    public synchronized int getNonDelayableReceiverCount() {
        return this.m_nonDelayableReceiverCount;
    }

    @Override
    public int getMaxQueueSizeInKiloBytes() {
        return Integer.MAX_VALUE;
    }

    @Override
    public long getMaxQueueSizeInBytes() {
        return Long.MAX_VALUE;
    }

    @Override
    public int getQueueType() {
        return 5;
    }

    @Override
    public int getReceiverCount() {
        return 0;
    }

    @Override
    public int getTotalEnqueued() {
        if (this.m_mgrm != null) {
            return 1;
        }
        return 0;
    }

    @Override
    public long getTotalSize() {
        if (this.m_mgrm == null) {
            return 0L;
        }
        return this.m_mgrm.getLimiterSize();
    }

    @Override
    public long getOldestEnqueueTime() {
        return 0L;
    }

    @Override
    public boolean isReadExclusive() {
        return this.m_readExclusive;
    }

    @Override
    public boolean isReadOnly() {
        return this.m_readOnly;
    }

    @Override
    public boolean isWriteExclusive() {
        return this.m_writeExclusive;
    }

    @Override
    public boolean isWriteOnly() {
        return this.m_writeOnly;
    }

    @Override
    public boolean isGlobal() {
        return this.m_global;
    }

    @Override
    public boolean isClustered() {
        return this.m_clustered;
    }

    @Override
    public boolean openBrowser(long clientId) throws ParseException, TokenMgrError {
        return false;
    }

    @Override
    public boolean openBrowser(long clientId, String selector) throws ParseException, TokenMgrError {
        return false;
    }

    @Override
    public boolean openReceiver(long clientId) throws ParseException, TokenMgrError {
        return true;
    }

    @Override
    public boolean openReceiver(long clientId, String selector) throws ParseException, TokenMgrError {
        return true;
    }

    @Override
    public void put(IMgram mgrm, long sender_cid) {
        if (this.m_mgrm == null) {
            this.m_mgrm = mgrm;
        }
    }

    @Override
    public boolean reserve(IMgram m) {
        return this.isMgrmAvailable();
    }

    @Override
    public boolean reserve(int size) {
        return this.isMgrmAvailable();
    }

    private boolean isMgrmAvailable() {
        return this.m_mgrm == null;
    }

    @Override
    public synchronized void restore(List elems) {
    }

    @Override
    public void setFlowControl(boolean fc) {
    }

    @Override
    public void setGlobal(boolean global) {
        this.m_global = global;
    }

    @Override
    public void setClustered(boolean clustered) {
        this.m_clustered = false;
    }

    @Override
    public void setMaxQueueSizeInBytes(long max) {
    }

    @Override
    public void setMaxQueueSizeInKiloBytes(int max) {
    }

    @Override
    public void setReadExclusiveMode(boolean mode) {
        this.m_readExclusive = mode;
    }

    @Override
    public void setReadOnlyMode(boolean mode) {
        this.m_readOnly = mode;
    }

    @Override
    public void setWriteExclusiveMode(boolean mode) {
        this.m_writeExclusive = mode;
    }

    @Override
    public void setWriteOnlyMode(boolean mode) {
        this.m_writeOnly = mode;
    }

    @Override
    public synchronized void start() {
        this.dispatchStartup(this.m_reg.getQueueProc().getDispatcher());
        this.m_state = 3;
    }

    private boolean deliver(IMgram m, long clientId) throws EClientNotRegistered, ESecurityGeneralException {
        IClientContext cc = null;
        int sendStatus = 0;
        if (this.DEBUG) {
            this.debug("Message sent as " + (m.isGuarenteed() ? "guaranteed" : "reliable"));
        }
        cc = this.m_reg.getClient(clientId);
        if (this.DEBUG) {
            this.debug("Sending mgram: " + m + " to client " + clientId);
        }
        sendStatus = cc.send(m, this.m_emptyLabel, null);
        if (this.DEBUG) {
            String stat = null;
            switch (sendStatus) {
                case 1: {
                    stat = "REJECTED";
                    break;
                }
                case 2: {
                    stat = "DISCARDED";
                    break;
                }
                case 0: {
                    stat = "ACCEPTED";
                    break;
                }
                default: {
                    stat = "UNKNOWN";
                }
            }
            this.debug("IMgram sent to CID: " + clientId + ", status = " + stat);
        }
        if (sendStatus == 1) {
            this.initMgrm(m);
            return false;
        }
        return true;
    }

    private void initMgrm(IMgram m) {
        if (this.m_mgrm == null) {
            this.m_mgrm = m;
        }
    }

    @Override
    public synchronized void decrementNonDelayableReceiverCount() {
        --this.m_nonDelayableReceiverCount;
    }

    @Override
    public synchronized void incrementNonDelayableReceiverCount() {
        ++this.m_nonDelayableReceiverCount;
    }

    private void initInstance(String qName, AgentRegistrar reg) {
        this.m_name = qName;
        this.m_address = "$Q." + this.m_name;
        this.m_reg = reg;
        this.m_dequeueLock = new Object();
        this.m_emptyLabel = new Label();
    }

    @Override
    public long getPercentageFull() {
        return 0L;
    }
}

