/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import java.util.Vector;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.client.EGeneralException;
import progress.message.gr.RouteInfo;
import progress.message.gr.RouterManager;
import progress.message.zclient.Envelope;
import progress.message.zclient.FastVector;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.Message;
import progress.message.zclient.Session;

public final class GetDynamicRoutes
implements IMessageHandler {
    private AgentRegistrar m_reg;

    GetDynamicRoutes(AgentRegistrar reg) {
        this.m_reg = reg;
    }

    @Override
    public void handleMessage(Session s, Envelope env) {
        block11: {
            try {
                if (!env.isRequest()) {
                    return;
                }
                Message msg = env.getMessage();
                Message rep = new Message();
                try {
                    RouteInfo ri;
                    String prefix = env.getMessage().readUTF();
                    boolean getAll = prefix.length() == 0;
                    RouterManager rm = this.m_reg.getRouterManager();
                    Vector routings = rm.getRouteForwarder().getRouteInfoList();
                    rep.writeBoolean(true);
                    int numMatches = 0;
                    FastVector matches = null;
                    if (getAll) {
                        numMatches = routings.size();
                    } else {
                        matches = new FastVector();
                        int length = routings.size();
                        for (int i = 0; i < length; ++i) {
                            ri = (RouteInfo)routings.elementAt(i);
                            if (!ri.getNodeName().startsWith(prefix)) continue;
                            matches.addElement(ri);
                        }
                        numMatches = matches.m_count;
                    }
                    rep.writeInt(numMatches);
                    for (int i = 0; i < numMatches; ++i) {
                        ri = matches != null ? (RouteInfo)matches.m_data[i] : (RouteInfo)routings.elementAt(i);
                        rep.writeUTF(ri.getNodeName());
                        rep.writeUTF(ri.getGlobalName());
                    }
                }
                catch (Exception e) {
                    BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                    rep = new Message();
                    rep.writeBoolean(false);
                    rep.writeObject(e);
                }
                s.reply(rep, env);
            }
            catch (EGeneralException e) {
                if (!Broker.isInShutdown()) {
                    BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                }
            }
            catch (IOException e) {
                if (Broker.isInShutdown()) break block11;
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
        }
    }
}

