/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.ECannotFlushEvents;
import progress.message.broker.SyncGroupMsgAllocationEvt;

public class GroupXOnceMsgAllocationTracker {
    private final long m_groupId;
    private final HashMap m_inDoubtAllocations = new HashMap();

    GroupXOnceMsgAllocationTracker(long groupId) {
        this.m_groupId = groupId;
    }

    public long getGroupId() {
        return this.m_groupId;
    }

    public synchronized Collection getAllocations() {
        if (this.m_inDoubtAllocations.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        ArrayList ret = new ArrayList(this.m_inDoubtAllocations.size());
        ret.addAll(this.m_inDoubtAllocations.values());
        return ret;
    }

    synchronized void getAllocations(LinkedList allAllocations, LinkedList persistentAllocations) {
        if (this.m_inDoubtAllocations.isEmpty()) {
            return;
        }
        for (GroupMsgAllocation gma : this.m_inDoubtAllocations.values()) {
            allAllocations.add(gma);
            if (gma.replOnly) continue;
            persistentAllocations.add(gma);
        }
    }

    public synchronized void addXOnceAllocation(GroupMsgAllocation gma) {
        this.m_inDoubtAllocations.put(gma.msgTracking, gma);
    }

    public synchronized void addXOnceAllocation(boolean replOnly, long recipientId, long msgTracking, long recipientTracking) {
        GroupMsgAllocation gma = new GroupMsgAllocation(replOnly, recipientId, msgTracking, recipientTracking);
        this.addXOnceAllocation(gma);
    }

    public synchronized boolean removeXOnceAllocation(long msgTracking) {
        return this.m_inDoubtAllocations.remove(new Long(msgTracking)) != null;
    }

    public boolean isAllocated(long msgTracking) {
        return this.m_inDoubtAllocations.containsKey(new Long(msgTracking));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSyncRecords() throws ECannotFlushEvents {
        SyncGroupMsgAllocationEvt evt = null;
        GroupXOnceMsgAllocationTracker groupXOnceMsgAllocationTracker = this;
        synchronized (groupXOnceMsgAllocationTracker) {
            if (this.m_inDoubtAllocations.isEmpty()) {
                return;
            }
            evt = new SyncGroupMsgAllocationEvt(this);
        }
        AgentRegistrar.getAgentRegistrar().getLogManager().tryAddEvent(evt, false);
    }

    public String toString() {
        return "GroupXOnceMsgAllocationTracker: groupCC= " + this.m_groupId + "; m_inDoubtAllocations.size= " + this.m_inDoubtAllocations.size();
    }

    public static class GroupMsgAllocation {
        public final boolean replOnly;
        public final Long msgTracking;
        public final Long recipientTracking;
        public final long recipientId;

        GroupMsgAllocation(boolean replyOnly, long recipientId, long msgTracking, long recipientTracking) {
            this.replOnly = replyOnly;
            this.msgTracking = new Long(msgTracking);
            this.recipientTracking = new Long(recipientTracking);
            this.recipientId = recipientId;
        }
    }
}

