/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import progress.message.msg.IMgram;
import progress.message.util.ExtendedBufferedInputStream;
import progress.message.util.Hex;
import progress.message.zclient.BaseConnection;
import progress.message.zclient.xonce.MgramTrace;

public class HistoryMgramCollector {
    BaseConnection m_connection;
    MgramHistoryEntry[] mgramHistory;
    int mgramHistoryIdx;

    HistoryMgramCollector(int size, BaseConnection conn) {
        this.m_connection = conn;
        this.mgramHistory = new MgramHistoryEntry[size];
        this.mgramHistoryIdx = 0;
    }

    void collectMgramHistory(IMgram m, ExtendedBufferedInputStream eb) {
        MgramHistoryEntry me = new MgramHistoryEntry(m, this.m_connection, eb);
        this.mgramHistory[this.mgramHistoryIdx++] = me;
        if (this.mgramHistoryIdx >= this.mgramHistory.length) {
            this.mgramHistoryIdx = 0;
        }
    }

    public void dump() {
        int i = this.mgramHistoryIdx;
        for (int cnt = 0; cnt < this.mgramHistory.length; ++cnt) {
            if (--i < 0) {
                i = this.mgramHistory.length - 1;
            }
            MgramHistoryEntry h = this.mgramHistory[i];
            BrokerComponent.getComponentContext().logMessage(h.getDescr(), 3);
            BrokerComponent.getComponentContext().logMessage(" pos: " + h.pos + " " + Hex.dumpString(h.lastBytes, 0, h.count), 3);
        }
    }

    public static class MgramHistoryEntry {
        String descr;
        byte[] lastBytes;
        int pos;
        int count;

        public MgramHistoryEntry(IMgram m, BaseConnection c, ExtendedBufferedInputStream eb) {
            if (m == null) {
                this.descr = "null Mgram";
            } else {
                try {
                    this.descr = MgramTrace.diagnosticString("Mgram ", c, m);
                }
                catch (Throwable e) {
                    this.descr = "failed to describe mgram " + e.toString();
                }
            }
            if (eb != null) {
                this.lastBytes = new byte[eb.getBufferSize()];
                this.pos = eb.getPos();
                this.count = eb.getCount();
                System.arraycopy(eb.getBuffer(), 0, this.lastBytes, 0, eb.getBufferSize());
            }
        }

        public String getDescr() {
            return this.descr;
        }
    }
}

