/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import progress.message.broker.SavableQElement;

public class PendingQElement
extends SavableQElement {
    protected String m_node;
    protected String m_dest;

    public PendingQElement(Object payload, long tracking, int prio, long sz, long tte, String node, String dest) {
        super(payload, tracking, prio, sz, tte);
        if (node != null) {
            this.m_node = node.intern();
        }
        if (dest != null) {
            this.m_dest = dest.intern();
        }
    }

    public synchronized void repopulate(Object payload, long tracking, int prio, long sz, long tte, String node, String dest) {
        this.m_payload = payload;
        this.m_tracking = tracking;
        this.m_prio = (byte)prio;
        this.m_size = sz;
        this.m_tte = tte;
        this.m_node = node != null ? node.intern() : null;
        this.m_dest = dest != null ? dest.intern() : null;
    }

    public synchronized void setGlobalDestination(String node, String dest) {
        this.m_node = node;
        this.m_dest = dest;
    }

    public synchronized void unsetGlobalDestination() {
        this.m_node = null;
        this.m_dest = null;
    }

    public synchronized String getGlobalDestination() {
        return this.m_node + "::" + this.m_dest;
    }

    public synchronized String getDestination() {
        return this.m_dest;
    }

    public synchronized String getNode() {
        return this.m_node;
    }

    @Override
    public synchronized void recycle() {
        super.recycle();
        this.m_node = null;
        this.m_dest = null;
    }

    @Override
    public synchronized Object clone() {
        PendingQElement clone = new PendingQElement(this.m_payload, this.m_tracking, this.m_prio, this.m_size, this.m_tte, this.m_node, this.m_dest);
        clone.setReenqueueCount(this.m_reenqueues);
        clone.m_prev = this.m_prev;
        clone.m_next = this.m_next;
        clone.m_flags = this.m_flags;
        clone.m_enqueueTime = this.m_enqueueTime;
        return clone;
    }

    @Override
    public String toString() {
        return "SavableQElement - tracking ID:" + this.m_tracking + ", priority:" + this.m_prio + ", size:" + this.m_size + ", reenqueues:" + this.m_reenqueues + ", tte:" + this.m_tte + ", node:" + this.m_node + ", dest:" + this.m_dest + ", flags:" + this.m_flags;
    }
}

