/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import progress.message.broker.AgentQueueMsgTracker;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.BrowsableBaseQueue;
import progress.message.broker.BrowserElement;
import progress.message.broker.Config;
import progress.message.broker.IExpirable;
import progress.message.broker.IRecycler;
import progress.message.broker.ISavable;
import progress.message.broker.ISavableQueueContext;
import progress.message.broker.LogManager;
import progress.message.broker.PendingQElement;
import progress.message.broker.QElement;
import progress.message.broker.QToken;
import progress.message.broker.QueueMsgAckedEvt;
import progress.message.broker.SavableQElement;
import progress.message.broker.gs.GSOrphanedMessageChecker;
import progress.message.broker.gs.GSRoutingQueueListener;
import progress.message.broker.parser.EvalException;
import progress.message.broker.parser.MessageSelector;
import progress.message.broker.parser.ParseException;
import progress.message.broker.parser.Selector;
import progress.message.msg.IMgram;
import progress.message.util.EAssertFailure;
import progress.message.zclient.Envelope;

public final class PendingQueue
extends BrowsableBaseQueue
implements IExpirable,
IRecycler,
ISavable {
    private long m_saveThreshold = 0x180000L;
    private long m_currentInMemorySize = 0L;
    private QToken[] m_inMemoryListTokens;
    private Vector m_recycledQElements;
    private long m_maxRecycledQElementCount;
    private boolean m_remove = false;
    private LogManager m_logMgr = AgentRegistrar.getAgentRegistrar().getLogManager();
    private GSOrphanedMessageChecker m_gsChecker = AgentRegistrar.getAgentRegistrar().getGSManager().getGSOrphanedMessageChecker();
    private GSRoutingQueueListener m_routingListener = AgentRegistrar.getAgentRegistrar().getGSManager().getRoutingQueueListener();
    private int m_removeMessagesReasonCode;
    private boolean m_removeMessages;
    static final long s_DFLT_SAVE_THRESHOLD = 0x180000L;
    static final long s_DFLT_MAX_QUEUE_SIZE = 0x100000L;
    static final int s_PENDING_QUEUE_ELEMENT_TYPE_CODE = 1;

    public PendingQueue(String qName, int numPriorities, int maxQueueSize, ISavableQueueContext sqc, Hashtable env) {
        super(qName, numPriorities, maxQueueSize, sqc);
        this.m_inMemoryListTokens = new QToken[this.m_numPriorities + 1];
        for (int i = 0; i <= this.m_numPriorities; ++i) {
            this.m_inMemoryListTokens[i] = new QToken();
            if (i <= 0) continue;
            this.m_inMemoryListTokens[i - 1].m_prev = this.m_inMemoryListTokens[i];
            this.m_inMemoryListTokens[i].m_next = this.m_inMemoryListTokens[i - 1];
        }
        this.m_maxRecycledQElementCount = 50L;
        this.m_recycledQElements = new Vector();
    }

    public synchronized void enqueue(IMgram m) {
        String node;
        if (m == null) {
            return;
        }
        String dest = null;
        String fullSubjectName = m.getSubject().getSubjectString();
        if (this.DEBUG) {
            this.debug("resolveQueue: full subject name = " + fullSubjectName);
        }
        if (fullSubjectName != null) {
            dest = fullSubjectName.substring(fullSubjectName.indexOf(".") + 1);
        }
        if ((node = m.getRoutingHandle().getRouting()).equals("")) {
            node = Config.ROUTING_NODE_NAME;
        }
        long tracking = m.getGuarenteedTrackingNum();
        byte prio = m.getPriority();
        long len = m.getEnqueuedSize();
        long tte = m.getTTE();
        long enqTime = m.getBrokerHandle().getPtpEnqueueTime();
        PendingQElement elem = this.createQueueElementForPayload(dest, len, m, node, prio, tracking, tte);
        if (m.getBrokerHandle().isFromDB()) {
            elem.setSaved();
            elem.setInDB();
        }
        if (enqTime == 0L) {
            elem.setEnqueueTime(System.currentTimeMillis());
        } else {
            elem.setEnqueueTime(enqTime);
        }
        super.enqueue(elem, prio, len);
        this.linkInMemory(elem, prio);
        this.notifyEnqueue(m);
        if (this.m_currentInMemorySize > this.m_saveThreshold) {
            this.enforceSaveThreshold();
        }
        this.notifyAll();
    }

    public synchronized void reenqueue(IMgram m, boolean preserveRedelivery) {
        String node;
        if (m == null) {
            return;
        }
        String dest = null;
        String fullSubjectName = m.getSubject().getSubjectString();
        if (this.DEBUG) {
            this.debug("resolveQueue: full subject name = " + fullSubjectName);
        }
        if (fullSubjectName != null) {
            dest = fullSubjectName.substring(fullSubjectName.indexOf(".") + 1);
        }
        if ((node = m.getRoutingHandle().getRouting()).equals("")) {
            node = Config.ROUTING_NODE_NAME;
        }
        long tracking = m.getGuarenteedTrackingNum();
        byte prio = m.getPriority();
        long len = m.getEnqueuedSize();
        long tte = m.getTTE();
        PendingQElement elem = this.createQueueElementForPayload(dest, len, m, node, prio, tracking, tte);
        if (m.getBrokerHandle().isFromDB()) {
            elem.setSaved();
            elem.setInDB();
        } else if (m.getBrokerHandle().isDBSaveRequested()) {
            elem.setSaved();
        }
        long tm = m.getBrokerHandle().getPtpEnqueueTime();
        if (tm > 0L) {
            elem.setEnqueueTime(tm);
            m.getBrokerHandle().setPtpEnqueueTime(0L);
        } else {
            elem.setEnqueueTime(System.currentTimeMillis());
        }
        super.reenqueue(elem, prio, len, preserveRedelivery);
        this.relinkInMemory(elem, prio);
        this.notifyReenqueue(m);
        if (this.m_currentInMemorySize > this.m_saveThreshold) {
            this.enforceSaveThreshold();
        }
        this.notifyAll();
    }

    private PendingQElement createQueueElementForPayload(String dest, long len, IMgram m, String node, int prio, long tracking, long tte) {
        PendingQElement elem = (PendingQElement)this.reuse(1);
        if (elem != null) {
            elem.repopulate(m, tracking, prio, len, tte, node, dest);
        } else {
            elem = new PendingQElement(m, tracking, prio, len, tte, node, dest);
        }
        return elem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object dequeue(int prio) {
        Object object = AgentRegistrar.getAgentRegistrar().getQueueProc().getRoutingQueue().getDequeueLock();
        synchronized (object) {
            return this.internalDequeue(prio);
        }
    }

    private synchronized Object internalDequeue(int prio) {
        IMgram payload;
        PendingQElement elem;
        boolean dequeuedOneOrMore = false;
        while ((elem = (PendingQElement)super.dequeue(prio)) != null) {
            this.cancelPendingSave(elem);
            payload = (IMgram)elem.getPayload();
            if (payload != null) {
                this.delinkInMemory(elem);
            } else {
                payload = this.retrieve(elem);
                elem.setPayload(payload);
            }
            dequeuedOneOrMore = true;
            this.notifyDequeue(payload);
            int reason = 0;
            if (this.hasMsgExpired(elem)) {
                reason = 1;
            } else if (this.isMsgRemoteSubscriptionOrphan(payload)) {
                reason = -1;
            }
            if (reason == 0) break;
            this.m_bqc.getAgentQueueProcessor().getCleanupThread().addMsgForCleanup(payload, reason);
            this.updateBrowsersOnDequeue(elem);
            this.recycle(elem, 1);
        }
        payload = null;
        if (elem != null) {
            byte reenqueues = elem.getReenqueueCount();
            payload = (IMgram)elem.getPayload();
            if (reenqueues > 0) {
                payload.setSuccessor(true);
                payload.setReenqueueCount(reenqueues);
            }
            payload.getBrokerHandle().setPtpEnqueueTime(elem.getEnqueueTime());
            this.updateBrowsersOnDequeue(elem);
            this.recycle(elem, 1);
        }
        if (dequeuedOneOrMore) {
            this.asyncRetrievalCheck();
            this.notifySpaceAvailable();
        }
        this.notifyAll();
        return payload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object dequeue() {
        Object object = AgentRegistrar.getAgentRegistrar().getQueueProc().getRoutingQueue().getDequeueLock();
        synchronized (object) {
            return this.internalDequeue();
        }
    }

    private synchronized Object internalDequeue() {
        if (this.m_totalEnqueuedCount == 0) {
            this.notifyAll();
            return null;
        }
        return this.dequeue(this.m_highestNonEmptyPriority);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object dequeueByTrackingNum(long tracking) {
        Object object = AgentRegistrar.getAgentRegistrar().getQueueProc().getRoutingQueue().getDequeueLock();
        synchronized (object) {
            return this.internalDequeueByTrackingNum(tracking);
        }
    }

    private synchronized Object internalDequeueByTrackingNum(long tracking) {
        PendingQElement elem = (PendingQElement)super.dequeue(tracking);
        if (elem == null) {
            this.notifyAll();
            return null;
        }
        this.cancelPendingSave(elem);
        IMgram payload = (IMgram)elem.getPayload();
        if (payload != null) {
            this.delinkInMemory(elem);
        } else {
            payload = this.retrieve(elem);
            elem.setPayload(payload);
        }
        this.notifyDequeue(payload);
        this.updateBrowsersOnDequeue(elem);
        byte reenqueues = elem.getReenqueueCount();
        if (reenqueues > 0) {
            payload.setSuccessor(true);
            payload.setReenqueueCount(reenqueues);
        }
        payload.getBrokerHandle().setPtpEnqueueTime(elem.getEnqueueTime());
        this.recycle(elem, 1);
        this.checkAndNotify();
        return payload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object dequeue(long receiverID) {
        Object object = AgentRegistrar.getAgentRegistrar().getQueueProc().getRoutingQueue().getDequeueLock();
        synchronized (object) {
            return this.internalDequeue(receiverID);
        }
    }

    private synchronized Object internalDequeue(long receiverID) {
        if (this.m_totalEnqueuedCount == 0) {
            this.notifyAll();
            return null;
        }
        return this.dequeue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() throws InterruptedException {
        QueueMsgAckedEvt lastAckEvt = null;
        PendingQueue pendingQueue = this;
        synchronized (pendingQueue) {
            if (this.m_totalEnqueuedCount == 0) {
                return;
            }
            QElement next = this.m_queuePriorityToken[this.m_highestNonEmptyPriority + 1].getNext();
            while (next != null) {
                if (next instanceof QToken) {
                    next = next.getNext();
                    continue;
                }
                SavableQElement sqe = (SavableQElement)next;
                next = sqe.getNext();
                QueueMsgAckedEvt evt = this.deleteMessage(sqe, false);
                if (evt == null) continue;
                lastAckEvt = evt;
            }
            this.m_totalEnqueuedCount = 0;
            this.setCurrentEnqueuedSize(0L);
            this.m_currentInMemorySize = 0L;
            for (int i = 0; i < this.m_numPriorities; ++i) {
                this.m_elementsEnqueuedCount[i] = 0;
            }
            this.m_highestNonEmptyPriority = -1;
            this.notifySpaceAvailable();
            this.notifyClear();
            this.notifyAll();
        }
        if (lastAckEvt != null) {
            this.m_logMgr.waitForFlush(lastAckEvt);
        }
        ((ISavableQueueContext)this.m_bqc).getQueueMsgSaver().flush();
        if (this.m_browsers != null) {
            Enumeration enumeration = this.m_browsers.elements();
            BrowserElement be = null;
            while (enumeration.hasMoreElements()) {
                be = (BrowserElement)enumeration.nextElement();
                if (be == null) continue;
                be.resetOnClear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(SavableQElement sqe) throws InterruptedException {
        QueueMsgAckedEvt evt = null;
        PendingQueue pendingQueue = this;
        synchronized (pendingQueue) {
            evt = this.deleteMessage(sqe, true);
            this.checkAndNotify();
        }
        if (evt != null) {
            this.m_logMgr.waitForFlush(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int clear(ArrayList<String> jmsMessageIDs) throws InterruptedException {
        int result = 0;
        QueueMsgAckedEvt lastAckEvt = null;
        PendingQueue pendingQueue = this;
        synchronized (pendingQueue) {
            if (this.m_totalEnqueuedCount == 0) {
                return 0;
            }
            for (String messageID : jmsMessageIDs) {
                if (messageID == null || messageID.trim().length() == 0) continue;
                SavableQElement sqe = this.selectByJMSMessageID(messageID);
                if (sqe != null) {
                    QueueMsgAckedEvt evt;
                    if (this.checkDebugFlags(16384)) {
                        this.debug(this + ": deleting message with id = " + messageID);
                    }
                    if ((evt = this.deleteMessage(sqe, true)) != null) {
                        lastAckEvt = evt;
                    }
                    ++result;
                    continue;
                }
                if (!this.checkDebugFlags(16384)) continue;
                this.debug(this + ": message with id = " + messageID + " NOT found.");
            }
            this.checkAndNotify();
        }
        if (lastAckEvt != null) {
            this.m_logMgr.waitForFlush(lastAckEvt);
        }
        ((ISavableQueueContext)this.m_bqc).getQueueMsgSaver().flush();
        return result;
    }

    private void checkAndNotify() {
        this.asyncRetrievalCheck();
        this.notifySpaceAvailable();
        this.notifyAll();
    }

    private QueueMsgAckedEvt deleteMessage(SavableQElement sqe, boolean updateBrowsers) throws InterruptedException {
        if (sqe.getEnqueueTime() == 0L) {
            return null;
        }
        QueueMsgAckedEvt ackEvt = null;
        boolean lastOne = this.m_totalEnqueuedCount == 1;
        this.cancelPendingSave(sqe);
        AgentQueueMsgTracker tracker = AgentQueueMsgTracker.getTracker(sqe.getTracking());
        if (tracker != null) {
            ackEvt = tracker.canceled(lastOne, false);
        } else if (sqe.isSaved()) {
            boolean deleted = ((ISavableQueueContext)this.m_bqc).getQueueMsgSaver().deleteMsg("SonicMQ.routingQueue", sqe.getTracking(), true);
            ackEvt = new QueueMsgAckedEvt(sqe.getTracking(), null, deleted);
            this.m_logMgr.addEvent(ackEvt, lastOne);
        }
        if (updateBrowsers) {
            this.updateBrowsersOnDequeue(sqe);
        }
        super.dequeue(sqe);
        IMgram payload = this.retrieve(sqe);
        this.notifyDequeue(payload);
        this.delinkInMemory(sqe);
        this.recycle(sqe, 1);
        return ackEvt;
    }

    private SavableQElement selectByJMSMessageID(String jmsMessageId) {
        if (this.m_totalEnqueuedCount == 0) {
            return null;
        }
        QElement elem = this.m_queuePriorityToken[this.m_highestNonEmptyPriority + 1];
        elem = elem.getNext();
        String selectorString = "JMSMessageID= 'ID:" + jmsMessageId + "'";
        StringReader sr = new StringReader(selectorString);
        Selector parser = new Selector(sr);
        MessageSelector ms = null;
        try {
            ms = parser.MessageSelector();
        }
        catch (ParseException ex) {
            ex.printStackTrace();
            return null;
        }
        boolean match = false;
        while (!match) {
            while (elem != null && elem instanceof QToken) {
                elem = elem.getNext();
            }
            if (elem == null) break;
            IMgram m = this.retrieve(elem);
            try {
                System.out.println("Inspecting message with id = " + Envelope.getMessageID(m));
                if (ms.match(m)) {
                    return (SavableQElement)elem;
                }
            }
            catch (EvalException ee) {
                ee.printStackTrace();
            }
            elem = elem.getNext();
        }
        return null;
    }

    @Override
    public synchronized void unreserve(int size) {
        super.unreserve(size);
        this.notifySpaceAvailable();
    }

    @Override
    void notifyMaxQueueSizeChanged() {
    }

    @Override
    synchronized void notifySpaceAvailable() {
        AgentRegistrar.getAgentRegistrar().getQueueProc().getRoutingQueue().notifySpaceAvailable();
    }

    @Override
    public boolean hasMsgExpired(QElement elem) {
        SavableQElement selem = (SavableQElement)elem;
        long tte = selem.getTTE();
        if (tte == 0L) {
            return false;
        }
        return System.currentTimeMillis() >= tte;
    }

    boolean isMsgRemoteSubscriptionOrphan(IMgram m) {
        return this.m_gsChecker.isGSAOrphan(m);
    }

    @Override
    public void checkForExpiredMsgs() {
        this.checkForExpiredMsgs(false);
    }

    public synchronized void checkForExpiredMsgs(boolean checkRemoteSubscriptionDeletion) {
        if (this.m_totalEnqueuedCount == 0) {
            this.notifyAll();
            return;
        }
        QElement next = this.m_queuePriorityToken[this.m_highestNonEmptyPriority + 1].getNext();
        while (next != null) {
            if (next instanceof QToken) {
                next = next.getNext();
                continue;
            }
            PendingQElement elem = (PendingQElement)next;
            next = elem.getNext();
            int reason = 0;
            IMgram m = null;
            if (this.hasMsgExpired(elem)) {
                reason = 1;
            } else if (checkRemoteSubscriptionDeletion) {
                m = (IMgram)elem.getPayload();
                if (m == null) {
                    if (this.checkDebugFlags(64)) {
                        this.debug("About to test for GSA. Will incur message retrieval.");
                    }
                    m = this.retrieve(elem);
                }
                if (this.isMsgRemoteSubscriptionOrphan(m)) {
                    reason = -1;
                }
            }
            if (reason == 0) continue;
            if (m == null) {
                m = this.retrieve(elem);
            }
            this.dequeueMsgForCleanup(elem, reason);
            this.notifyDequeue(m);
        }
        this.notifySpaceAvailable();
        this.notifyAll();
    }

    private void dequeueMsgForCleanup(PendingQElement elem, int reason) {
        super.dequeue(elem);
        this.cancelPendingSave(elem);
        IMgram payload = (IMgram)elem.getPayload();
        if (payload != null) {
            this.delinkInMemory(elem);
        }
        if (payload != null) {
            this.m_bqc.getAgentQueueProcessor().getCleanupThread().addMsgForCleanup(payload, reason);
        } else {
            this.m_bqc.getAgentQueueProcessor().getCleanupThread().addMsgForCleanup("SonicMQ.routingQueue", elem.getTracking(), reason);
        }
        this.updateBrowsersOnDequeue(elem);
        this.recycle(elem, 1);
    }

    @Override
    public synchronized void recycle(Object obj, int typeCode) {
        PendingQElement elt;
        if (typeCode == 1 && !(elt = (PendingQElement)obj).isSaved()) {
            elt.recycle();
            if ((long)this.m_recycledQElements.size() < this.m_maxRecycledQElementCount) {
                this.m_recycledQElements.add(elt);
            }
        }
    }

    @Override
    public synchronized Object reuse(int typeCode) {
        Object obj = null;
        if (typeCode == 1 && !this.m_recycledQElements.isEmpty()) {
            obj = this.m_recycledQElements.firstElement();
            this.m_recycledQElements.removeElement(obj);
        }
        return obj;
    }

    @Override
    public synchronized void setSaveThresholdInBytes(int saveThreshold) {
        this.m_saveThreshold = Math.abs((long)saveThreshold);
    }

    @Override
    public synchronized void setSaveThresholdInKiloBytes(int svThreshold) {
        long saveThreshold = Math.abs((long)svThreshold);
        this.m_saveThreshold = saveThreshold > 0x1FFFFFFFFFFFFFL ? Long.MAX_VALUE : saveThreshold * 1024L;
    }

    @Override
    public synchronized long getSaveThresholdInBytes() {
        return this.m_saveThreshold;
    }

    @Override
    public synchronized int getSaveThresholdInKiloBytes() {
        int saveThreshold = (int)(this.m_saveThreshold / 1024L);
        return saveThreshold;
    }

    @Override
    protected IMgram retrieve(QElement elem) {
        IMgram payload = (IMgram)elem.getPayload();
        if (payload == null && (payload = ((ISavableQueueContext)this.m_bqc).getQueueMsgSaver().retrieveMgram("SonicMQ.routingQueue", elem.getTracking())) == null) {
            throw new EAssertFailure("Message to retrieve for queue " + this.m_qName + "(" + "SonicMQ.routingQueue" + ")was not found in db, SavableQElement: " + elem.toString());
        }
        payload.getBrokerHandle().setLocalQueueName("SonicMQ.routingQueue");
        return payload;
    }

    @Override
    public synchronized int restore(List elements) {
        return 0;
    }

    @Override
    public synchronized void forcedSave() {
        QElement elem = this.m_inMemoryListTokens[0].getPrevious();
        while (elem != null) {
            if (elem instanceof QToken) {
                elem = elem.getPrevious();
                continue;
            }
            SavableQElement sqe = (SavableQElement)elem;
            IMgram mg = (IMgram)sqe.getPayload();
            if (mg == null) {
                throw new EAssertFailure("InMemory SavableQElement does not have payload in memory: " + sqe.toString());
            }
            if (!mg.isJMSPersistent()) {
                elem = sqe.getPrevInMemory();
                continue;
            }
            if (sqe.isSaved() && !sqe.isInDB()) {
                sqe.unsetPostProcess();
            } else if (sqe.isInDB() || mg.getBrokerHandle().isFromDB()) {
                sqe.setSaved();
                sqe.setInDB();
                sqe.unsetPostProcess();
            } else {
                sqe.unsetPostProcess();
                ((ISavableQueueContext)this.m_bqc).getQueueMsgSaver().saveMsg("SonicMQ.routingQueue", sqe);
                sqe.setSaved();
            }
            elem = sqe.getPrevInMemory();
        }
    }

    private void cancelPendingSave(SavableQElement elem) {
        elem.unsetPostProcess();
        if (elem.isSaved() && !elem.isInDB()) {
            boolean cancelled = ((ISavableQueueContext)this.m_bqc).getQueueMsgSaver().cancelSave(elem.getTracking());
            if (cancelled) {
                elem.unsetSaved();
            } else {
                IMgram payload = (IMgram)elem.getPayload();
                if (payload != null) {
                    payload.getBrokerHandle().setDBSaveRequested(true);
                }
            }
        }
    }

    private void asyncRetrievalCheck() {
        if (this.m_totalEnqueuedCount == 0) {
            return;
        }
        QElement elem = this.m_queuePriorityToken[this.m_highestNonEmptyPriority + 1].getNext();
        if (elem.getPayload() != null || ((SavableQElement)elem).isAsyncReq()) {
            return;
        }
        if (!((SavableQElement)elem).isAsyncReq()) {
            if (((ISavableQueueContext)this.m_bqc).getQueueMsgSaver().retrieveMgramAsync("SonicMQ.routingQueue", elem.getTracking())) {
                ((SavableQElement)elem).setAsyncReq();
            } else {
                return;
            }
        }
        long totSz = elem.getPayloadSize();
        while ((elem = elem.getNext()) != null) {
            if (elem instanceof QToken) continue;
            if (totSz + elem.getPayloadSize() > this.m_saveThreshold) break;
            if (elem.getPayload() == null && !((SavableQElement)elem).isAsyncReq()) {
                if (((ISavableQueueContext)this.m_bqc).getQueueMsgSaver().retrieveMgramAsync("SonicMQ.routingQueue", elem.getTracking())) {
                    ((SavableQElement)elem).setAsyncReq();
                } else {
                    return;
                }
            }
            totSz += elem.getPayloadSize();
        }
    }

    public synchronized void setRemoveFlag() {
        this.m_remove = true;
    }

    public synchronized void unsetRemoveFlag() {
        this.m_remove = false;
    }

    public synchronized boolean getRemoveFlag() {
        return this.m_remove;
    }

    void notifyClear() {
        if (this.checkDebugFlags(64)) {
            this.debug("PendingQueue:notifyClear(" + this.m_qName + ")");
        }
        this.m_routingListener.clear(this.m_qName);
    }

    void notifyEnqueue(IMgram m) {
        if (this.checkDebugFlags(64)) {
            this.debug("PendingQueue:notifyEnqueue(" + this.m_totalEnqueuedCount + ")" + m);
        }
        this.m_routingListener.messageAdded(m);
    }

    void notifyDequeue(IMgram m) {
        if (this.checkDebugFlags(64)) {
            this.debug("PendingQueue:notifyDequeue(" + this.m_totalEnqueuedCount + ")" + m);
        }
        this.m_routingListener.messageRemoved(m);
    }

    void notifyReenqueue(IMgram m) {
        if (this.checkDebugFlags(64)) {
            this.debug("PendingQueue:notifyReenqueue(" + this.m_totalEnqueuedCount + ")" + m);
        }
        this.m_routingListener.messageAdded(m);
    }

    public synchronized void setRemoveMessages(int reasonCode) {
        this.m_removeMessages = true;
        this.m_removeMessagesReasonCode = reasonCode;
    }

    public synchronized int getRemoveMessagesReasonCode() {
        return this.m_removeMessagesReasonCode;
    }

    public synchronized boolean getRemoveMessagesFlag() {
        return this.m_removeMessages;
    }

    private void linkInMemory(SavableQElement newLast, int prio) {
        QToken token = this.m_inMemoryListTokens[prio];
        QElement oldLast = token.m_prev;
        if (oldLast instanceof QToken) {
            oldLast.m_next = newLast;
        } else {
            ((SavableQElement)oldLast).setNextInMemory(newLast);
        }
        newLast.setPrevInMemory(oldLast);
        newLast.setNextInMemory(token);
        token.m_prev = newLast;
        this.m_currentInMemorySize += newLast.getPayloadSize();
    }

    private void relinkInMemory(SavableQElement newFirst, int prio) {
        QToken token = this.m_inMemoryListTokens[prio + 1];
        QElement oldFirst = token.m_next;
        if (oldFirst instanceof QToken) {
            oldFirst.m_prev = newFirst;
        } else {
            ((SavableQElement)oldFirst).setPrevInMemory(newFirst);
        }
        newFirst.setNextInMemory(oldFirst);
        newFirst.setPrevInMemory(token);
        token.m_next = newFirst;
        this.m_currentInMemorySize += newFirst.getPayloadSize();
    }

    private void delinkInMemory(SavableQElement sqe) {
        QElement prev = sqe.getPrevInMemory();
        QElement next = sqe.getNextInMemory();
        if (prev == null || next == null) {
            return;
        }
        if (prev instanceof QToken) {
            prev.setNext(next);
        } else {
            ((SavableQElement)prev).setNextInMemory(next);
        }
        if (next instanceof QToken) {
            next.setPrevious(prev);
        } else {
            ((SavableQElement)next).setPrevInMemory(prev);
        }
        sqe.setPrevInMemory(null);
        sqe.setNextInMemory(null);
        this.m_currentInMemorySize -= sqe.getPayloadSize();
    }

    private void enforceSaveThreshold() {
        QElement elem = this.m_inMemoryListTokens[0].getPrevious();
        while (elem != null && this.m_currentInMemorySize > this.m_saveThreshold) {
            if (elem instanceof QToken) {
                elem = elem.getPrevious();
                continue;
            }
            SavableQElement sqe = (SavableQElement)elem;
            IMgram mg = (IMgram)sqe.getPayload();
            if (mg == null) {
                throw new EAssertFailure("InMemory SavableQElement does not have payload in memory: " + sqe.toString());
            }
            if (sqe.isSaved() && !sqe.isInDB()) {
                sqe.setPostProcess();
            } else if (sqe.isInDB() || mg.getBrokerHandle().isFromDB()) {
                sqe.setSaved();
                sqe.setInDB();
                sqe.setPostProcess();
                sqe.setPayload(null);
            } else {
                sqe.setPostProcess();
                ((ISavableQueueContext)this.m_bqc).getQueueMsgSaver().saveMsg("SonicMQ.routingQueue", sqe);
                sqe.setSaved();
            }
            sqe.unsetAsyncReq();
            elem = sqe.getPrevInMemory();
            this.delinkInMemory(sqe);
        }
    }

    public synchronized String getDebugInfo() {
        StringBuffer buf = new StringBuffer();
        buf.append("CurrentSize= ");
        buf.append(this.getCurrentEnqueuedSize());
        buf.append(" InMemorySize= ");
        buf.append(this.m_currentInMemorySize);
        return buf.toString();
    }
}

