/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.ws.rm.common.AddressBinder;
import com.sonicsw.ws.rm.common.RMManager;
import com.sonicsw.ws.rm.policy.RMPolicy;
import com.sonicsw.ws.rm.sender.fsm.RMSendSequence;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import javax.jms.Destination;
import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.EndpointReference;
import org.apache.axis.utils.XMLUtils;
import org.w3c.dom.Element;
import progress.message.broker.ELogEventTooLong;
import progress.message.broker.LogEvent;
import progress.message.broker.RecoveryMgr;
import progress.message.util.StreamUtil;
import progress.message.util.StringUtil;

public class RMOutboundEvt
extends LogEvent {
    private EndpointReference m_endpoint;
    private String m_endpointS;
    private Destination m_internalFaultDestination;
    private String m_sequenceIdentifier;
    private String m_rmConstantsURI;
    private String m_soapConstantsURI;
    private Date m_expires;
    private RMPolicy m_policy;
    private short m_type = (short)131;
    private String m_wsaNS = "http://schemas.xmlsoap.org/ws/2004/08/addressing";

    public RMOutboundEvt(RMSendSequence rss) {
        this.m_sequenceIdentifier = rss.getSequenceState().getSequenceIdentifier().getIdentifier().toString();
        this.m_endpoint = rss.getSequenceState().getEndpointReference();
        if (this.m_endpoint != null) {
            this.m_endpointS = this.stringify(this.m_endpoint);
        }
        this.m_internalFaultDestination = rss.getSequenceState().getInternalFaultDestination();
        this.m_rmConstantsURI = rss.getConstants().getNSURI();
        this.m_soapConstantsURI = rss.getSOAPConstants().getEnvelopeURI();
        this.m_expires = rss.getSequenceState().getExpires();
        this.m_policy = rss.getSequenceState().getPolicy();
        this.m_wsaNS = rss.getWSANS();
        this.setTypeValue();
    }

    private void setTypeValue() {
        this.m_type = this.type();
    }

    RMOutboundEvt(short type) {
        this.m_type = type;
    }

    @Override
    public short type() {
        return 131;
    }

    public EndpointReference getEndpointReference() {
        return this.m_endpoint;
    }

    public Destination getInternalFaultDestination() {
        return this.m_internalFaultDestination;
    }

    public String getSequenceIdentifier() {
        return this.m_sequenceIdentifier;
    }

    public String getRMConstantsURI() {
        return this.m_rmConstantsURI;
    }

    public String getSoapConstantsURI() {
        return this.m_soapConstantsURI;
    }

    public Date getExpires() {
        return this.m_expires;
    }

    public String getWSANS() {
        return this.m_wsaNS;
    }

    public RMPolicy getPolicy() {
        return this.m_policy;
    }

    @Override
    public void redo(RecoveryMgr rm) {
        RMManager.getRMManager().redoBegin(this);
    }

    @Override
    protected int memSizeBody() {
        int size = this.memSize(this.m_endpointS) + this.memSize(this.m_internalFaultDestination) + this.memSize(this.m_sequenceIdentifier) + this.memSize(this.m_rmConstantsURI) + this.memSize(this.m_soapConstantsURI) + (this.m_expires != null ? 8 : 0) + (this.m_policy != null ? this.m_policy.memsize() : 0) + this.memSize(this.m_wsaNS);
        return size;
    }

    @Override
    protected void writeBodyToLog(OutputStream out, long maxbytes) throws IOException, ELogEventTooLong {
        if (maxbytes < (long)this.serializedSizeBody()) {
            throw new ELogEventTooLong(this);
        }
        this.writeBody(out);
    }

    private void writeBody(OutputStream os) throws IOException {
        this.writeNullOrUTF(this.m_endpointS, os);
        this.writeNullOrUTF(this.m_internalFaultDestination, os);
        this.writeNullOrUTF(this.m_sequenceIdentifier, os);
        this.writeNullOrUTF(this.m_rmConstantsURI, os);
        this.writeNullOrUTF(this.m_soapConstantsURI, os);
        StreamUtil.writeLong(this.m_expires == null ? 0L : this.m_expires.getTime(), os);
        StreamUtil.writeBoolean(this.m_policy != null, os);
        if (this.m_policy != null) {
            this.m_policy.toLogStream(os);
        }
        this.writeNullOrUTF(this.m_wsaNS, os);
    }

    private int memSize(Destination d) {
        return this.memSize(AddressBinder.destinationToInternalStr(d));
    }

    private int memSize(String s) {
        if (s == null) {
            return 0;
        }
        return s.length();
    }

    private void writeNullOrUTF(Destination d, OutputStream os) throws IOException {
        this.writeNullOrUTF(AddressBinder.destinationToInternalStr(d), os);
    }

    private void writeNullOrUTF(String s, OutputStream os) throws IOException {
        byte[] b = StringUtil.stringToUTF("");
        if (s == null) {
            os.write(b, 0, b.length);
        } else {
            b = StringUtil.stringToUTF(s);
            os.write(b, 0, b.length);
        }
    }

    private int serializedSizeNullOrUTF(String s) {
        try {
            byte[] b = StringUtil.stringToUTF("");
            if (s != null) {
                b = StringUtil.stringToUTF(s);
            }
            return b.length;
        }
        catch (Exception e) {
            return 0;
        }
    }

    private int serializedSizeNullOrUTF(Destination d) {
        return this.serializedSizeNullOrUTF(AddressBinder.destinationToInternalStr(d));
    }

    private String readNullOrUTF(InputStream is) throws IOException {
        String s = StreamUtil.readUTF(is);
        if (s.length() == 0) {
            return null;
        }
        return s;
    }

    @Override
    protected void writeBodyToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        this.writeBody(os);
    }

    @Override
    protected void readBodyFromStream(InputStream in, boolean tteTTLConvert) throws IOException {
        this.m_endpointS = this.readNullOrUTF(in);
        if (this.m_endpointS != null) {
            this.m_endpoint = this.parse(this.m_endpointS);
            if (this.m_type == 124 || this.m_type == 122 || this.m_type == 123) {
                this.m_endpointS = this.stringify(this.m_endpoint);
            }
        }
        this.m_internalFaultDestination = AddressBinder.internalStrToDestination(this.readNullOrUTF(in));
        this.m_sequenceIdentifier = this.readNullOrUTF(in);
        this.m_rmConstantsURI = this.readNullOrUTF(in);
        this.m_soapConstantsURI = this.readNullOrUTF(in);
        long exp = StreamUtil.readLong(in);
        if (exp != 0L) {
            this.m_expires = new Date(exp);
        }
        if (StreamUtil.readBoolean(in)) {
            this.m_policy = new RMPolicy();
            this.m_policy.fromLogStream(in);
        }
        if (this.m_type == 133 || this.m_type == 131 || this.m_type == 132) {
            this.m_wsaNS = this.readNullOrUTF(in);
        }
    }

    public String summary() {
        return this.getSequenceIdentifier() + " dest: " + this.getEndpointReference().getAddress() + (this.m_policy != null ? " policy: " + this.m_policy.toString() : "") + (this.m_expires != null ? " expires:" + this.m_expires.toString() : "");
    }

    @Override
    public String toString() {
        return "RMOutboundEvt: " + this.summary();
    }

    @Override
    protected int streamSizeBody() {
        return this.serializedSizeBody();
    }

    @Override
    protected int serializedSizeBody() {
        int size = this.serializedSizeNullOrUTF(this.m_endpointS) + this.serializedSizeNullOrUTF(this.m_internalFaultDestination) + this.serializedSizeNullOrUTF(this.m_sequenceIdentifier) + this.serializedSizeNullOrUTF(this.m_rmConstantsURI) + this.serializedSizeNullOrUTF(this.m_soapConstantsURI) + 8 + 1 + (this.m_policy != null ? this.m_policy.serSize() : 0) + this.serializedSizeNullOrUTF(this.m_wsaNS);
        return size;
    }

    private String stringify(EndpointReference epr) {
        Element e = epr.toDOM(null);
        return XMLUtils.ElementToString((Element)e);
    }

    private EndpointReference parse(String s) throws IOException {
        if (s == null) {
            return null;
        }
        try {
            if (this.m_type == 124 || this.m_type == 122 || this.m_type == 123) {
                return new EndpointReference(new Address(s));
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(s.getBytes());
            Element el = XMLUtils.newDocument((InputStream)bais).getDocumentElement();
            return new EndpointReference(el);
        }
        catch (IOException ie) {
            throw ie;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }
}

