/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.LinkedList;
import progress.message.broker.ELogEventTooLong;
import progress.message.broker.GroupXOnceMsgAllocationTracker;
import progress.message.broker.LogEvent;
import progress.message.broker.RecoveryMgr;
import progress.message.util.StreamUtil;
import progress.message.zclient.EMgramFormatError;

public class SyncGroupMsgAllocationEvt
extends LogEvent {
    private static final short m_eventType = 184;
    private static final byte REPLICATE_ONLY_FLAG = 1;
    private long m_groupId;
    private final LinkedList m_persistentAllocations = new LinkedList();
    private final LinkedList m_allAllocations = new LinkedList();

    SyncGroupMsgAllocationEvt(GroupXOnceMsgAllocationTracker tracker) {
        this.m_groupId = tracker.getGroupId();
        tracker.getAllocations(this.m_allAllocations, this.m_persistentAllocations);
    }

    SyncGroupMsgAllocationEvt() {
    }

    public long getGroupId() {
        return this.m_groupId;
    }

    public Collection getAllocations() {
        return this.m_allAllocations;
    }

    @Override
    public void redo(RecoveryMgr rm) {
        rm.redoSyncGroupMsgReallocationEvt(this);
    }

    @Override
    protected int memSizeBody() {
        return this.serializedSizeInternal(false);
    }

    @Override
    protected int serializedSizeBody() {
        return this.serializedSizeInternal(true);
    }

    private int serializedSizeInternal(boolean persistentOnly) {
        int numRecords = persistentOnly ? this.m_persistentAllocations.size() : this.m_allAllocations.size();
        return 12 + numRecords * 25;
    }

    @Override
    protected int streamSizeBody() {
        return this.serializedSizeInternal(false);
    }

    @Override
    public short type() {
        return 184;
    }

    private void writeBody(OutputStream os, boolean persistentOnly) throws IOException {
        LinkedList toWrite;
        StreamUtil.writeLong(this.m_groupId, os);
        LinkedList linkedList = toWrite = persistentOnly ? this.m_persistentAllocations : this.m_allAllocations;
        if (toWrite == null || toWrite.isEmpty()) {
            StreamUtil.writeInt(0, os);
            return;
        }
        StreamUtil.writeInt(toWrite.size(), os);
        for (GroupXOnceMsgAllocationTracker.GroupMsgAllocation gma : toWrite) {
            byte flags = 0;
            if (gma.replOnly) {
                flags = (byte)(flags | 1);
            }
            StreamUtil.writeByte(flags, os);
            StreamUtil.writeLong(gma.recipientId, os);
            StreamUtil.writeLong((long)gma.msgTracking, os);
            StreamUtil.writeLong((long)gma.recipientTracking, os);
        }
        if (this.DEBUG) {
            this.debug("Wrote sync allocations: " + this.m_allAllocations.size() + "/" + this.m_persistentAllocations.size() + " persistentOnly: " + persistentOnly);
        }
    }

    @Override
    protected void readBodyFromStream(InputStream in, boolean tteTTLConvert) throws IOException, EMgramFormatError {
        this.m_groupId = StreamUtil.readLong(in);
        int count = StreamUtil.readInt(in);
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                byte flags = StreamUtil.readByte(in);
                long recipientId = StreamUtil.readLong(in);
                long msgTracking = StreamUtil.readLong(in);
                long recipientTracking = StreamUtil.readLong(in);
                boolean replOnly = (1 & flags) > 0;
                GroupXOnceMsgAllocationTracker.GroupMsgAllocation gma = new GroupXOnceMsgAllocationTracker.GroupMsgAllocation(replOnly, recipientId, msgTracking, recipientTracking);
                this.m_allAllocations.add(gma);
                if (replOnly) continue;
                this.m_persistentAllocations.add(gma);
            }
            if (this.DEBUG) {
                this.debug("Read sync allocations: " + this.m_allAllocations.size() + "/" + this.m_persistentAllocations.size());
            }
        }
    }

    @Override
    protected void writeBodyToLog(OutputStream os, long maxbytes) throws IOException, ELogEventTooLong {
        if (maxbytes < (long)this.serializedSizeBody()) {
            throw new ELogEventTooLong(this);
        }
        this.writeBody(os, true);
    }

    @Override
    protected void writeBodyToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        this.writeBody(os, false);
    }
}

