/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import progress.message.broker.AMPScratchPad;
import progress.message.broker.AgentConnection;
import progress.message.broker.AgentListener;
import progress.message.broker.AgentMessageProcessor;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.IClientContext;
import progress.message.broker.Transaction;
import progress.message.client.EIntegrityCompromised;
import progress.message.msg.IMgram;
import progress.message.util.DebugState;
import progress.message.util.EAssertFailure;
import progress.message.zclient.DebugObject;

class TxMsg
extends DebugObject {
    private IMgram m_msg;
    private int m_tid;
    private IClientContext m_owner;
    private long m_ownerCid;
    private long m_orig_tracking = -1L;

    TxMsg(int tid, long ownerCid, IClientContext publisher, IMgram msg) {
        super(DebugState.GLOBAL_DEBUG_ON ? "TxMsg " + tid : null);
        this.m_msg = msg;
        this.m_tid = tid;
        this.m_owner = publisher;
        this.m_ownerCid = ownerCid;
    }

    TxMsg(int tid, long ownerCid, IMgram msg) {
        super(DebugState.GLOBAL_DEBUG_ON ? "TxMsg " + tid : null);
        this.m_msg = msg;
        this.m_tid = tid;
        this.m_ownerCid = ownerCid;
    }

    void setOrigTracking(long tracking) {
        this.m_orig_tracking = tracking;
    }

    long getOrigTracking() {
        return this.m_orig_tracking;
    }

    int getTid() {
        return this.m_tid;
    }

    int memoryLength() {
        return this.m_msg.memoryLength();
    }

    void deliverMsg(int seq, boolean retry, Transaction txn) throws EIntegrityCompromised, InterruptedException {
        AgentListener al;
        block12: {
            if (this.DEBUG) {
                this.debug("deliverMsg seq= " + seq + " ownercid= " + this.m_ownerCid + " owner= " + this.m_owner);
            }
            if (!this.m_msg.isPTP() && !this.m_msg.isPubSub()) {
                EAssertFailure t = new EAssertFailure("Invalid mgram type in transaction: " + this.m_msg.getType());
                BrokerComponent.getComponentContext().logMessage((Throwable)t, 1);
            }
            al = null;
            try {
                if (this.m_owner == null) {
                    this.m_owner = AgentRegistrar.getAgentRegistrar().getClient(this.m_ownerCid);
                }
            }
            catch (EClientNotRegistered e) {
                if (this.m_ownerCid != 0L) break block12;
                this.m_ownerCid = txn.getOwner();
                try {
                    this.m_owner = AgentRegistrar.getAgentRegistrar().getClient(this.m_ownerCid);
                }
                catch (EClientNotRegistered cnre) {
                    BrokerComponent.getComponentContext().logMessage((Throwable)cnre, 2);
                }
            }
        }
        AMPScratchPad scratch = new AMPScratchPad();
        if (this.m_owner != null) {
            scratch.setClientContext(this.m_owner);
            AgentConnection conn = this.m_owner.getConnection();
            if (conn != null) {
                al = (AgentListener)conn.getListener();
            }
        }
        IMgram nonTxMgram = this.m_msg;
        this.prepareForDelivery(nonTxMgram, seq, retry);
        if (this.m_owner != null) {
            nonTxMgram.getBrokerHandle().setSenderID(this.m_owner.getId());
        }
        if (al != null) {
            al.handleNormalTxn(nonTxMgram, scratch);
        } else {
            AgentMessageProcessor msgproc = AgentRegistrar.getAgentRegistrar().getMsgProc();
            msgproc.newMgram(nonTxMgram, scratch);
        }
    }

    IMgram getMsg() {
        return this.m_msg;
    }

    void cancelMsg() throws InterruptedException {
    }

    void forgetTracker() throws InterruptedException {
    }

    void prepareForDelivery(IMgram m, int seq, boolean retry) {
        if (m.hasTxn()) {
            m.removeTxn();
        }
        m.getBrokerHandle().setTxnPublish(this.m_tid, seq);
        if (retry) {
            m.setSuccessor(true);
        }
    }
}

