/*
 * Decompiled with CFR 0.152.
 */
package progress.message.dbq.pse;

import com.odi.ObjectStoreException;
import com.odi.Session;
import progress.message.db.EDatabaseException;
import progress.message.db.pse.PSEDbContext;
import progress.message.db.pse.util.OpContext;
import progress.message.util.EAssertFailure;
import progress.message.zclient.DebugObject;

public class DBQPSEBase
extends DebugObject {
    protected PSEDbContext m_dbCtx;
    protected OpContext m_opCtxUpdate;
    protected OpContext m_opCtxRead;
    protected OpContext m_opCtxDirtyRead;

    public DBQPSEBase(String name) {
        this.updateDebugFlags = true;
        this.debugName(name);
    }

    public void commit() throws EDatabaseException {
        Session sess = Session.getCurrent();
        if (sess == null) {
            throw new EDatabaseException("No active pse session; acquireLock must be called before commit");
        }
        this.m_dbCtx.commit();
    }

    public void rollback() throws EDatabaseException {
        Session sess = Session.getCurrent();
        if (sess == null) {
            throw new EDatabaseException("No active pse session; acquireLock must be called before rollback");
        }
        this.m_dbCtx.rollback();
    }

    public void checkUpdateLock() {
        if (!this.m_dbCtx.getDbLock().hasUpdateLock()) {
            throw new EAssertFailure("Caller does not have updateLock on " + this.m_dbCtx);
        }
    }

    public void acquireLock() throws EDatabaseException {
        this.acquireLock(this.m_opCtxUpdate);
    }

    public void releaseLock() {
        this.releaseLock(this.m_opCtxUpdate);
    }

    protected final boolean isDebugLevel1() {
        return this.checkDebugFlags(64);
    }

    protected void releaseLock(OpContext opctx) {
        Session sess = null;
        sess = Session.getCurrent();
        if (opctx.m_opType == 1 && opctx.m_readType == 1) {
            this.m_dbCtx.getDbLock().releaseReadLock();
        } else {
            this.m_dbCtx.getDbLock().releaseUpdateLock();
        }
        if (sess != null) {
            sess.leave();
        }
    }

    protected void acquireLock(OpContext opctx) throws EDatabaseException {
        try {
            this.acquireLock(opctx, false);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void acquireLock(OpContext opctx, boolean interruptible) throws EDatabaseException, InterruptedException {
        Session sess = Session.getCurrent();
        if (sess != null) {
            throw new EAssertFailure("Session is active in current thread " + sess.getName());
        }
        sess = this.m_dbCtx.getSession();
        try {
            sess.join();
            if (opctx.m_opType == 1 && opctx.m_readType == 1) {
                this.m_dbCtx.getDbLock().acquireReadLock(interruptible);
            } else {
                this.m_dbCtx.getDbLock().acquireUpdateLock(interruptible);
            }
        }
        catch (InterruptedException ie) {
            if (this.checkDebugFlags(64)) {
                this.debug("acquireLock: interrupted;  opctx= " + opctx + " " + Thread.currentThread());
            }
            if ((sess = Session.getCurrent()) != null) {
                sess.leave();
            }
            throw ie;
        }
        catch (ObjectStoreException ex) {
            sess = Session.getCurrent();
            if (sess != null) {
                sess.leave();
            }
            this.m_dbCtx.handlePSEException(ex);
        }
    }
}

